/*
 * Decompiled with CFR 0.152.
 */
package mongodb.conn;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import mongodb.conn.ServerConnection;
import mongodb.jdbc.MongoResultSet;
import mongodb.jdbc.MongoStatement;
import mongodb.query.MongoBuilder;
import mongodb.query.MongoSelectQuery;
import org.bson.types.ObjectId;
import unity.annotation.AnnotatedSourceField;
import unity.annotation.AnnotatedSourceTable;
import unity.annotation.GlobalSchema;
import unity.annotation.SourceDatabase;
import unity.annotation.SourceField;
import unity.annotation.SourceTable;
import unity.engine.Attribute;
import unity.engine.Relation;
import unity.engine.TableData;
import unity.engine.Tuple;
import unity.jdbc.LocalResultSet;
import unity.jdbc.UnityDriver;
import unity.parser.GlobalParser;
import unity.query.GlobalQuery;
import unity.query.LQTree;
import unity.util.StringFunc;

public class MongoExecutor {
    private boolean resultSetComplete;
    private DBCursor cursor;
    private Relation relation;
    private ArrayList<DBObject> cachedObjects;
    private long statementId;
    private DB db;
    private MongoSelectQuery mq;
    private double SAMPLE_FRACTION = 0.001;
    private static final int MIN_SIZE_TO_SAMPLE = 10;

    public MongoExecutor(DB dB, long l) {
        this.db = dB;
        this.statementId = l;
        this.mq = null;
    }

    public ResultSet execute(String string, int n, MongoStatement mongoStatement, GlobalSchema globalSchema, ServerConnection serverConnection, boolean bl) throws Exception {
        string = string + ";";
        GlobalParser globalParser = new GlobalParser(false, bl);
        GlobalQuery globalQuery = globalParser.parse(string, globalSchema);
        return this.execute(globalQuery, n, mongoStatement, globalSchema, serverConnection);
    }

    public ResultSet execute(GlobalQuery globalQuery, int n, MongoStatement mongoStatement, GlobalSchema globalSchema, ServerConnection serverConnection) throws Exception {
        Object object;
        LQTree lQTree = globalQuery.getLogicalQueryTree();
        if (UnityDriver.DEBUG) {
            System.out.println("Logical query tree: \n");
            lQTree.print();
        }
        MongoBuilder mongoBuilder = new MongoBuilder(lQTree.getRoot());
        this.mq = (MongoSelectQuery)mongoBuilder.toMongoQuery();
        mongoStatement.setQuery(this.mq);
        if (UnityDriver.DEBUG) {
            System.out.println(this.mq.toString());
        }
        if ((object = this.mq.run(this.db)) instanceof Integer) {
            int n2 = (Integer)object;
            ArrayList<ArrayList<Object>> arrayList = new ArrayList<ArrayList<Object>>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>(1);
            arrayList2.add(n2);
            arrayList.add(arrayList2);
            ArrayList<SourceField> arrayList3 = new ArrayList<SourceField>(1);
            arrayList3.add(new SourceField(null, null, null, this.mq.fieldNames.get("Count(*)"), 4, "INT", 4, 0, 0, 0, "", null, 0, 1, "YES"));
            return new LocalResultSet(arrayList, new String[]{this.mq.fieldNames.get("Count(*)")}, arrayList3);
        }
        this.cachedObjects = new ArrayList();
        if (object instanceof DBCursor) {
            this.cursor = (DBCursor)object;
            for (int i = 0; i < 3 && this.cursor.hasNext(); ++i) {
                DBObject dBObject = this.cursor.next();
                this.cachedObjects.add(dBObject);
            }
            this.relation = this.buildRelation(this.mq, this.cachedObjects);
        } else if (object instanceof BasicDBList) {
            this.cursor = null;
            for (Object e : (BasicDBList)object) {
                BasicDBObject basicDBObject = new BasicDBObject(this.mq.distinctField.toString(), e);
                this.cachedObjects.add((DBObject)basicDBObject);
            }
            this.relation = this.buildDistinctRelation(this.mq, this.cachedObjects);
        }
        TableData tableData = new TableData(serverConnection, n != 1003, this.statementId);
        tableData.setRelation(this.relation);
        return new MongoResultSet(tableData, this.relation, n, mongoStatement);
    }

    public void close() {
        if (this.cursor != null) {
            this.cursor.close();
        }
    }

    private static DBObject flattenObjectSchema(SourceDatabase sourceDatabase, SourceTable sourceTable, DBObject dBObject, String string, DBObject dBObject2) {
        String string2 = "";
        if (string != null) {
            string2 = string + '.';
        }
        if (dBObject instanceof BasicDBList) {
            BasicDBList basicDBList = (BasicDBList)dBObject;
            for (Object e : basicDBList) {
                if (!(e instanceof DBObject)) continue;
                dBObject2 = MongoExecutor.flattenObjectSchema(sourceDatabase, sourceTable, (DBObject)e, string, dBObject2);
            }
            Object object = null;
            if (basicDBList.size() > 0) {
                object = basicDBList.get(0);
            }
            dBObject2.put(string2 + "[0-" + Integer.MAX_VALUE + "]", object);
        } else {
            Set set = dBObject.keySet();
            for (String string3 : set) {
                Object object = dBObject.get(string3);
                String string4 = string2 + string3;
                dBObject2.put(string4, object);
                if (!(object instanceof DBObject)) continue;
                dBObject2 = MongoExecutor.flattenObjectSchema(sourceDatabase, sourceTable, (DBObject)object, string4, dBObject2);
            }
        }
        return dBObject2;
    }

    public ResultSet execute(String string, int n, MongoStatement mongoStatement, GlobalSchema globalSchema, ServerConnection serverConnection) throws Exception {
        boolean bl = false;
        String string2 = mongoStatement.getConnection().getClientInfo("validation");
        if (string2 != null && string2.equalsIgnoreCase("strict")) {
            bl = true;
        }
        return this.execute(string, n, mongoStatement, globalSchema, serverConnection, bl);
    }

    public Attribute[] getSchema(SourceDatabase sourceDatabase, SourceTable sourceTable, DBCollection dBCollection) {
        Attribute[] attributeArray = null;
        int n = this.numberToSample(dBCollection);
        attributeArray = n != -1 ? MongoExecutor.guessFromRandomRecords(dBCollection, sourceDatabase, sourceTable, this.numberToSample(dBCollection)) : MongoExecutor.guessFromAllRecords(dBCollection, sourceDatabase, sourceTable);
        return attributeArray;
    }

    public void setSampleFraction(double d) {
        this.SAMPLE_FRACTION = d;
        if (this.SAMPLE_FRACTION <= 0.0 || this.SAMPLE_FRACTION > 1.0) {
            this.SAMPLE_FRACTION = 0.001;
        }
    }

    private int numberToSample(DBCollection dBCollection) {
        long l = -1L;
        try {
            l = dBCollection.count();
        }
        catch (Exception exception) {
            System.out.println("Error while sampling collection: " + dBCollection.getName());
        }
        if (l <= 10L) {
            return -1;
        }
        return (int)Math.ceil((double)l * this.SAMPLE_FRACTION);
    }

    private static void buildNestedTable(BasicDBList basicDBList, SourceDatabase sourceDatabase, SourceTable sourceTable, String string) {
        if (UnityDriver.DEBUG) {
            System.out.println("Building schema for list " + basicDBList);
        }
        char c = '_';
        String string2 = StringFunc.undelimitName(sourceTable.getTableName(), '\"');
        String string3 = StringFunc.delimitName(string2 + c + string);
        AnnotatedSourceTable annotatedSourceTable = new AnnotatedSourceTable(null, null, string3, null, null, null);
        annotatedSourceTable.setParentDatabase(sourceDatabase);
        annotatedSourceTable.setCaseSensitive(true);
        annotatedSourceTable.setNumTuples(basicDBList.size());
        sourceDatabase.addTable(annotatedSourceTable);
        HashMap<String, SourceField> hashMap = new HashMap<String, SourceField>();
        AnnotatedSourceField annotatedSourceField = new AnnotatedSourceField();
        annotatedSourceField.setColumnName(StringFunc.delimitName(string2 + c + "_id"));
        annotatedSourceField.setTableName(string3);
        annotatedSourceField.setParentTable(annotatedSourceTable);
        annotatedSourceField.setDataType(12);
        annotatedSourceField.setDataTypeName(Attribute.getTypeName(12));
        SourceField.setSizeByType(annotatedSourceField, 64);
        annotatedSourceField.setOrdinalPosition(1);
        hashMap.put(annotatedSourceField.getColumnName(), annotatedSourceField);
        int n = 12;
        if (basicDBList.size() > 0) {
            n = Attribute.getType(basicDBList.get(0));
        }
        for (Object e : basicDBList) {
            int n2 = Attribute.getType(e);
            if (n != n2) {
                n = 12;
                break;
            }
            if (!(e instanceof DBObject)) continue;
        }
        annotatedSourceField = new AnnotatedSourceField();
        annotatedSourceField.setColumnName(StringFunc.delimitName(string));
        annotatedSourceField.setTableName(string3);
        annotatedSourceField.setParentTable(annotatedSourceTable);
        annotatedSourceField.setDataType(n);
        annotatedSourceField.setDataTypeName(Attribute.getTypeName(n));
        SourceField.setSizeByType(annotatedSourceField, 0x1004000);
        annotatedSourceField.setOrdinalPosition(2);
        hashMap.put(annotatedSourceField.getColumnName(), annotatedSourceField);
        annotatedSourceTable.setSourceFields(hashMap);
    }

    private static Attribute[] guessFromAllRecords(DBCollection dBCollection, SourceDatabase sourceDatabase, SourceTable sourceTable) {
        if (UnityDriver.DEBUG) {
            System.out.println("Building schema for collection " + dBCollection.getName() + " sampling all records.");
        }
        DBCursor dBCursor = dBCollection.find().limit(0);
        Attribute[] attributeArray = null;
        while (dBCursor.hasNext()) {
            BasicDBObject basicDBObject = (BasicDBObject)dBCursor.next();
            basicDBObject = (BasicDBObject)MongoExecutor.flattenObjectSchema(sourceDatabase, sourceTable, (DBObject)basicDBObject, null, (DBObject)new BasicDBObject());
            attributeArray = MongoExecutor.supersetSchema(MongoExecutor.guessSchema(basicDBObject.toMap(), null, null), attributeArray);
        }
        dBCursor.close();
        return attributeArray;
    }

    private static Attribute[] guessFromRandomRecords(DBCollection dBCollection, SourceDatabase sourceDatabase, SourceTable sourceTable, int n) {
        long l = dBCollection.count();
        int n2 = (int)Math.round(Math.random() * (double)(l - (long)n));
        if (n2 < 0) {
            n2 = 0;
        }
        long l2 = n;
        if (l < (long)n) {
            l2 = l;
        }
        if (UnityDriver.DEBUG) {
            System.out.println("Building schema for collection " + dBCollection.getName() + " sampling " + n + " documents in range " + n2 + " to " + ((long)n2 + l2));
        }
        Attribute[] attributeArray = null;
        DBCursor dBCursor = dBCollection.find().skip(n2);
        int n3 = 0;
        while ((long)n3 < l2) {
            BasicDBObject basicDBObject = (BasicDBObject)dBCursor.next();
            basicDBObject = (BasicDBObject)MongoExecutor.flattenObjectSchema(sourceDatabase, sourceTable, (DBObject)basicDBObject, null, (DBObject)new BasicDBObject());
            attributeArray = MongoExecutor.supersetSchema(MongoExecutor.guessSchema(basicDBObject.toMap(), null, null), attributeArray);
            ++n3;
        }
        dBCursor.close();
        return attributeArray;
    }

    public static Attribute[] guessSchema(Map<String, Object> map, String string) {
        return MongoExecutor.guessSchema(map, string, null);
    }

    public static Attribute[] guessSchema(Map<String, Object> map, String string, MongoSelectQuery mongoSelectQuery) {
        int n = 0;
        Attribute[] attributeArray = new Attribute[map.size()];
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String string2 = entry.getKey();
            if (string != null) {
                string2 = string + string2;
            }
            Object object = entry.getValue();
            int n2 = Attribute.getType(object);
            String string3 = string2;
            String string4 = null;
            if (mongoSelectQuery != null) {
                String string5 = mongoSelectQuery.fieldNames.get(string3);
                if (string5 != null) {
                    string4 = string3;
                    string3 = string5;
                }
            } else {
                string3 = StringFunc.delimitName(string3);
            }
            int n3 = 0;
            if (object instanceof ObjectId) {
                n3 = 64;
            } else if (Attribute.isStringType(n2)) {
                n3 = 0x1004000;
            }
            attributeArray[n++] = new Attribute(string3, n2, n3, string4);
        }
        return attributeArray;
    }

    private static int getLeastGeneralType(int n, int n2) {
        return n;
    }

    public static Attribute[] supersetSchema(Attribute[] attributeArray, Attribute[] attributeArray2) {
        if (attributeArray == null) {
            return attributeArray2;
        }
        if (attributeArray2 == null) {
            return attributeArray;
        }
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(Arrays.asList(attributeArray2));
        int n = 0;
        for (Attribute attribute : attributeArray) {
            if (attribute == null) continue;
            boolean bl = false;
            for (Attribute attribute2 : arrayList) {
                if (attribute2 == null || !attribute.getName().equals(attribute2.getName())) continue;
                if (attribute.getType() != attribute2.getType()) {
                    attribute2.setType(MongoExecutor.getLeastGeneralType(attribute.getType(), attribute2.getType()));
                }
                bl = true;
                break;
            }
            if (!bl) {
                arrayList.add(n, attribute);
            }
            ++n;
        }
        return arrayList.toArray(new Attribute[arrayList.size()]);
    }

    public Attribute[] buildAttributeList(MongoSelectQuery mongoSelectQuery, ArrayList<DBObject> arrayList) {
        LinkedHashMap<String, Object> linkedHashMap;
        if (this.mq.fieldNames != null && this.mq.fieldNames.size() > 0) {
            linkedHashMap = new LinkedHashMap<String, Object>();
            DBObject dBObject = null;
            if (arrayList != null && arrayList.size() > 0) {
                dBObject = arrayList.get(0);
            }
            for (String string : mongoSelectQuery.fieldNames.keySet()) {
                if (dBObject != null) {
                    Object object = MongoExecutor.getValue(dBObject, string);
                    linkedHashMap.put(string, object);
                    continue;
                }
                linkedHashMap.put(string, "");
            }
        } else if (arrayList != null && arrayList.size() > 0) {
            linkedHashMap = new LinkedHashMap();
            for (DBObject dBObject : arrayList) {
                linkedHashMap.putAll((LinkedHashMap)dBObject);
            }
        } else {
            Attribute[] attributeArray = new Attribute[]{new Attribute("No_Results_Returned", 12, 50)};
            return attributeArray;
        }
        return MongoExecutor.guessSchema(linkedHashMap, null, mongoSelectQuery);
    }

    public Relation buildRelation(MongoSelectQuery mongoSelectQuery, ArrayList<DBObject> arrayList) {
        return new Relation(this.buildAttributeList(mongoSelectQuery, arrayList));
    }

    public Relation buildDistinctRelation(MongoSelectQuery mongoSelectQuery, ArrayList<DBObject> arrayList) {
        Attribute[] attributeArray = new Attribute[1];
        int n = arrayList.isEmpty() ? Attribute.getType(null) : Attribute.getType(arrayList.get(0));
        attributeArray[0] = new Attribute(this.mq.distinctField, n, -1, this.mq.fieldNames.get(this.mq.distinctField));
        return new Relation(attributeArray);
    }

    public boolean next(Tuple tuple) throws SQLException {
        if (this.resultSetComplete) {
            return false;
        }
        try {
            DBObject dBObject = null;
            if (this.cachedObjects.size() > 0) {
                dBObject = this.cachedObjects.get(0);
                this.cachedObjects.remove(0);
                this.convertToTuple(dBObject, this.relation, tuple);
                return true;
            }
            if (this.cursor != null && this.cursor.hasNext()) {
                DBObject dBObject2 = this.cursor.next();
                this.convertToTuple(dBObject2, this.relation, tuple);
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    private static Object getValue(DBObject dBObject, String string) {
        int n = 0;
        int n2 = string.indexOf(46, n);
        if (n2 <= 0) {
            return dBObject.get(string);
        }
        DBObject dBObject2 = dBObject;
        Object object = null;
        String string2 = string.substring(n, n2);
        boolean bl = false;
        while (true) {
            if (dBObject2 instanceof BasicDBList) {
                try {
                    int n3 = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    BasicDBList basicDBList = new BasicDBList();
                    BasicDBList basicDBList2 = (BasicDBList)dBObject2;
                    String string3 = string.substring(n);
                    for (Object e : basicDBList2) {
                        Object object2;
                        if (!(e instanceof DBObject) || (object2 = MongoExecutor.getValue((DBObject)e, string3)) == null) continue;
                        basicDBList.add(object2);
                    }
                    return basicDBList;
                }
            }
            object = dBObject2.get(string2);
            if (bl) {
                return object;
            }
            if (!(object instanceof DBObject)) {
                return null;
            }
            dBObject2 = (DBObject)object;
            n = n2 + 1;
            if ((n2 = string.indexOf(46, n)) > 0) {
                string2 = string.substring(n, n2);
                continue;
            }
            bl = true;
            string2 = string.substring(n);
        }
    }

    public void convertToTuple(DBObject dBObject, Relation relation, Tuple tuple) throws SQLException {
        int n = relation.getNumAttributes();
        Object[] objectArray = tuple.getValues();
        if (objectArray == null || objectArray.length != n) {
            objectArray = new Object[n];
        }
        for (int i = 0; i < relation.getNumAttributes(); ++i) {
            Object object;
            Attribute attribute = relation.getAttribute(i);
            Object object2 = attribute.getReference();
            objectArray[i] = object2 != null ? MongoExecutor.getValue(dBObject, object2.toString()) : ((object = MongoExecutor.getValue(dBObject, relation.getAttribute(i).getName())) instanceof BasicDBList ? new ArrayList((BasicDBList)object) : (object instanceof BasicDBObject ? (BasicDBObject)object : object));
        }
        tuple.setValues(objectArray);
    }
}

