/*
 * Decompiled with CFR 0.152.
 */
package mongodb.jdbc;

import com.mongodb.DB;
import java.sql.Array;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.ResourceBundle;
import mongodb.conn.ServerConnection;
import mongodb.jdbc.MongoArray;
import mongodb.jdbc.MongoDatabaseMetaData;
import mongodb.jdbc.MongoPreparedStatement;
import mongodb.jdbc.MongoStatement;
import unity.annotation.GlobalSchema;
import unity.engine.Attribute;
import unity.generic.jdbc.ConnectionImpl;
import unity.jdbc.UnityDriver;

public class MongoConnection
extends ConnectionImpl {
    protected static ResourceBundle resources = ResourceBundle.getBundle("resources/mongo/MongoConnection", locale);

    public MongoConnection(String string, ArrayList<String> arrayList, ArrayList<Integer> arrayList2, String string2, Properties properties) throws SQLException {
        this.url = string;
        this.clientInfo = properties;
        if (this.clientInfo == null) {
            this.clientInfo = new Properties();
        }
        String string3 = string2;
        if (this.clientInfo.containsKey("dbname")) {
            string3 = this.clientInfo.getProperty("dbname");
        }
        UnityDriver.debug("Database to connect to:.  URL:  " + string);
        for (int i = 0; i < arrayList.size(); ++i) {
            UnityDriver.debug("  Server:  " + arrayList.get(i) + ":" + arrayList2.get(i));
        }
        this.connection = new ServerConnection(arrayList, arrayList2, string3, this.url, this);
        this.connection.connect(this.clientInfo);
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        if (n == 1005) {
            throw new SQLException(resources.getString("nosupportScrollSensitive"));
        }
        if (n2 == 1008) {
            throw new SQLException(resources.getString("nosupportConcurUpdatable"));
        }
        return new MongoStatement(this, this.connection, n, n2);
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new MongoDatabaseMetaData(this, this.connection);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return new MongoPreparedStatement(this, this.connection, n, n2, string);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        return new MongoPreparedStatement(this, this.connection, n, n2, string);
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        MongoArray mongoArray = null;
        mongoArray = Attribute.getType(string) == 2003 ? new MongoArray(objectArray) : (Attribute.getType(string) == -1 ? new MongoArray(objectArray) : (Attribute.getType(string) == 12 ? new MongoArray(objectArray) : new MongoArray(objectArray)));
        return mongoArray;
    }

    public void rebuildSchema() throws SQLException {
        ((ServerConnection)this.connection).buildSchema();
    }

    public DB getDB() {
        if (this.connection == null) {
            return null;
        }
        return ((ServerConnection)this.connection).getDB();
    }

    public GlobalSchema getGlobalSchema() {
        if (this.connection == null) {
            return null;
        }
        return ((ServerConnection)this.connection).getSchema();
    }
}

