/*
 * Decompiled with CFR 0.152.
 */
package mongodb.jdbc;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import mongodb.conn.ServerConnection;
import mongodb.jdbc.MongoConnection;
import mongodb.jdbc.MongoDriver;
import unity.annotation.SourceField;
import unity.engine.IServerConnection;
import unity.generic.jdbc.DatabaseMetaDataImpl;
import unity.jdbc.LocalResultSet;

public class MongoDatabaseMetaData
extends DatabaseMetaDataImpl {
    public MongoDatabaseMetaData(MongoConnection mongoConnection, IServerConnection iServerConnection) {
        super(mongoConnection, iServerConnection, new MongoDriver());
        this.caseSensitive = true;
        this.CATALOG = null;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "MongoDB";
    }

    @Override
    public String getDriverName() throws SQLException {
        return "Mongo JDBC";
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        String string = ((ServerConnection)this.serverConnection).getVersion();
        return Integer.parseInt(string.substring(0, string.indexOf(".")));
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        String string = ((ServerConnection)this.serverConnection).getVersion();
        string = string.substring(string.indexOf(".") + 1);
        return Integer.parseInt(string.substring(0, string.indexOf(".")));
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return ((ServerConnection)this.serverConnection).getVersion();
    }

    @Override
    public String getURL() throws SQLException {
        return this.serverConnection.getDatabase().getURL();
    }

    @Override
    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        int n = 13;
        String[] stringArray = new String[n];
        ArrayList<SourceField> arrayList = new ArrayList<SourceField>(n);
        arrayList.add(new SourceField(null, null, null, "TABLE_CAT", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 1, "YES"));
        arrayList.add(new SourceField(null, null, null, "TABLE_SCHEM", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 2, "YES"));
        arrayList.add(new SourceField(null, null, null, "TABLE_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 3, "YES"));
        arrayList.add(new SourceField(null, null, null, "NON_UNIQUE", -7, "BOOLEAN", 1, 0, 0, 0, "", null, 0, 4, "YES"));
        arrayList.add(new SourceField(null, null, null, "INDEX_QUALIFIER", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 5, "YES"));
        arrayList.add(new SourceField(null, null, null, "INDEX_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 6, "YES"));
        arrayList.add(new SourceField(null, null, null, "TYPE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 7, "YES"));
        arrayList.add(new SourceField(null, null, null, "ORDINAL_POSITION", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 8, "YES"));
        arrayList.add(new SourceField(null, null, null, "COLUMN_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 9, "YES"));
        arrayList.add(new SourceField(null, null, null, "ASC_OR_DESC", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 10, "YES"));
        arrayList.add(new SourceField(null, null, null, "CARDINALITY", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 11, "YES"));
        arrayList.add(new SourceField(null, null, null, "PAGES", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 12, "YES"));
        arrayList.add(new SourceField(null, null, null, "FILTER_CONDITION", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 13, "YES"));
        for (int i = 0; i < n; ++i) {
            stringArray[i] = ((SourceField)arrayList.get(i)).getColumnName();
        }
        ArrayList<ArrayList<Object>> arrayList2 = new ArrayList<ArrayList<Object>>();
        List<DBObject> list = ((ServerConnection)this.serverConnection).getIndexes(string3);
        String string4 = ((ServerConnection)this.serverConnection).getDatabase().getDatabaseName();
        for (DBObject dBObject : list) {
            Object object = dBObject.get("key");
            if (!(object instanceof BasicDBObject)) continue;
            BasicDBObject basicDBObject = (BasicDBObject)object;
            int n2 = 0;
            for (String string5 : basicDBObject.keySet()) {
                boolean bl3;
                boolean bl4 = bl3 = !dBObject.containsField("unique");
                if (bl && bl3) continue;
                ++n2;
                int n3 = 1;
                String string6 = "A";
                Object object2 = basicDBObject.get(string5);
                if (object2 instanceof Number) {
                    if (((Number)object2).intValue() != 1) {
                        string6 = "D";
                    }
                } else if (object2.toString().equals("hashed")) {
                    n3 = 2;
                    string6 = null;
                }
                ArrayList<Object> arrayList3 = new ArrayList<Object>(13);
                arrayList3.add(null);
                arrayList3.add(string4);
                arrayList3.add(string3);
                arrayList3.add(bl3);
                arrayList3.add(null);
                arrayList3.add(dBObject.get("name"));
                arrayList3.add(n3);
                arrayList3.add(n2);
                arrayList3.add(string5);
                arrayList3.add(string6);
                arrayList3.add(0);
                arrayList3.add(0);
                arrayList3.add(null);
                arrayList2.add(arrayList3);
            }
        }
        Collections.sort(arrayList2, new IndexComparator());
        return new LocalResultSet(arrayList2, stringArray, arrayList);
    }

    private class IndexComparator
    implements Comparator<ArrayList<?>> {
        private IndexComparator() {
        }

        @Override
        public int compare(ArrayList<?> arrayList, ArrayList<?> arrayList2) {
            int n;
            String string;
            int n2;
            boolean bl = (Boolean)arrayList.get(3);
            boolean bl2 = (Boolean)arrayList2.get(3);
            if (!bl && bl2) {
                return -1;
            }
            if (bl && !bl2) {
                return 1;
            }
            int n3 = (Integer)arrayList.get(6);
            if (n3 != (n2 = ((Integer)arrayList2.get(6)).intValue())) {
                return n3 - n2;
            }
            String string2 = (String)arrayList.get(5);
            if (string2 != (string = (String)arrayList2.get(5))) {
                return string2.compareTo(string);
            }
            int n4 = (Integer)arrayList.get(7);
            if (n4 != (n = ((Integer)arrayList2.get(7)).intValue())) {
                return n4 - n;
            }
            return 0;
        }
    }
}

