/*
 * Decompiled with CFR 0.152.
 */
package mongodb.query;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import com.mongodb.util.JSONParseException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.regex.Pattern;
import mongodb.jdbc.MongoDriver;
import mongodb.query.MongoBuilderFatalException;
import mongodb.query.MongoBuilderUpstreamException;
import mongodb.query.MongoCreateIndex;
import mongodb.query.MongoDeleteQuery;
import mongodb.query.MongoDropIndex;
import mongodb.query.MongoDropTable;
import mongodb.query.MongoExpression;
import mongodb.query.MongoInsertQuery;
import mongodb.query.MongoQuery;
import mongodb.query.MongoSelectQuery;
import mongodb.query.MongoUpdateQuery;
import mongodb.query.MongoUpsertQuery;
import org.bson.BSONObject;
import org.bson.types.ObjectId;
import unity.annotation.AnnotatedSourceField;
import unity.annotation.AnnotatedSourceTable;
import unity.annotation.GlobalSchema;
import unity.annotation.SourceField;
import unity.annotation.SourceTable;
import unity.generic.jdbc.Parameter;
import unity.query.GQFieldRef;
import unity.query.GQTableRef;
import unity.query.LQCondNode;
import unity.query.LQCreateIndexNode;
import unity.query.LQDeleteNode;
import unity.query.LQDropIndexNode;
import unity.query.LQDropNode;
import unity.query.LQDupElimNode;
import unity.query.LQExprNode;
import unity.query.LQGroupByNode;
import unity.query.LQInsertNode;
import unity.query.LQLimitNode;
import unity.query.LQNode;
import unity.query.LQOrderByNode;
import unity.query.LQProjNode;
import unity.query.LQSelNode;
import unity.query.LQUpdateNode;
import unity.query.LQUpsertNode;
import unity.util.StringFunc;

public class MongoBuilder {
    private LQNode startNode;
    private boolean distinct = false;
    private static final String OBJECT_ID = "ObjectID";
    private static final String ID_REGEX = "[0-9a-f]{24}";
    private GlobalSchema schema = null;
    private boolean projectionSeen = false;

    public MongoBuilder(LQNode lQNode) {
        this.startNode = lQNode;
    }

    public MongoBuilder(LQNode lQNode, GlobalSchema globalSchema) {
        this.startNode = lQNode;
        this.schema = globalSchema;
    }

    private void buildDelete(LQDeleteNode lQDeleteNode, MongoDeleteQuery mongoDeleteQuery) throws MongoBuilderFatalException, MongoBuilderUpstreamException {
        BasicDBObject basicDBObject = new BasicDBObject();
        if (lQDeleteNode.getCondition() != null) {
            this.buildCondition(lQDeleteNode.getCondition(), basicDBObject, lQDeleteNode);
        }
        mongoDeleteQuery.query = basicDBObject;
        mongoDeleteQuery.collectionName = StringFunc.removeAllQuotes(lQDeleteNode.getSourceTable().getTable().getTableName());
    }

    private void buildUpdate(LQUpdateNode lQUpdateNode, MongoUpdateQuery mongoUpdateQuery) throws MongoBuilderFatalException, MongoBuilderUpstreamException {
        BasicDBObject basicDBObject = new BasicDBObject();
        if (lQUpdateNode.getCondition() != null) {
            this.buildCondition(lQUpdateNode.getCondition(), basicDBObject, lQUpdateNode);
        }
        mongoUpdateQuery.query = basicDBObject;
        mongoUpdateQuery.collectionName = StringFunc.removeAllQuotes(lQUpdateNode.getTable().getTable().getTableName());
        boolean bl = mongoUpdateQuery.collectionName.equals("system.users");
        String string = null;
        if (bl && (string = lQUpdateNode.getCondition().containsEqualAttr("user")) == null) {
            throw new MongoBuilderFatalException("When updating system.users, must specify in the WHERE user = 'username' to select particular user.");
        }
        BasicDBObject basicDBObject2 = new BasicDBObject();
        for (int i = 0; i < lQUpdateNode.getNumFields(); ++i) {
            Object object;
            LQExprNode lQExprNode = (LQExprNode)lQUpdateNode.getField(i);
            Object object2 = lQExprNode.getContent();
            if (!(object2 instanceof GQFieldRef) || object2 == null) {
                throw new MongoBuilderFatalException("Invalid field: " + ((LQNode)lQExprNode).toString());
            }
            String string2 = StringFunc.removeAllQuotes(((GQFieldRef)object2).getField().getColumnName());
            Object object3 = object = lQUpdateNode.getValue(i);
            if (object == null) {
                object3 = "null";
            } else if (object instanceof LQExprNode) {
                if (((LQExprNode)object).getType() == 102 || ((LQExprNode)object).getType() == 120 || ((LQExprNode)object).getContent().toString().equalsIgnoreCase("current_time") || ((LQExprNode)object).getContent().toString().equalsIgnoreCase("current_date") || ((LQExprNode)object).getContent().toString().equalsIgnoreCase("current_timestamp")) {
                    throw new MongoBuilderFatalException("JDBC for MongoDB Driver: Functions and expressions are not supported with INSERT, UPDATE or DELETE statements");
                }
                if (((LQExprNode)object).getType() == 145) {
                    Object object4 = ((LQExprNode)object).getContent();
                    object3 = Parameter.retrieveParameterValue(object4);
                } else {
                    object3 = ((LQExprNode)object).getContent();
                }
            }
            if (object3 instanceof String) {
                object3 = StringFunc.undelimitName((String)object3, '\'');
            }
            if (bl) {
                if (string2.equals("pwd")) {
                    if (string == null) {
                        throw new MongoBuilderFatalException("User name must be supplied.");
                    }
                    object3 = MongoDriver._hash(string, object3.toString());
                } else if (string2.equals("roles") && MongoBuilder.checkIfJSONObject(object3)) {
                    object3 = this.buildBSON(object3);
                }
            }
            basicDBObject2.put(string2, object3);
        }
        BasicDBObject basicDBObject3 = new BasicDBObject();
        basicDBObject3.put("$set", (Object)basicDBObject2);
        mongoUpdateQuery.update = basicDBObject3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void buildInsert(LQInsertNode lQInsertNode, MongoInsertQuery mongoInsertQuery) throws MongoBuilderFatalException, MongoBuilderUpstreamException {
        Object object;
        Cloneable cloneable;
        Serializable serializable;
        Object object2;
        mongoInsertQuery.collectionName = StringFunc.undelimitName(lQInsertNode.getSourceTable().getTable().getTableName(), '\"');
        boolean bl = false;
        boolean bl2 = mongoInsertQuery.collectionName.equals("system.users");
        String string = null;
        ArrayList<GQFieldRef> arrayList = lQInsertNode.getInsertFields();
        ArrayList<Object> arrayList2 = lQInsertNode.getInsertValues();
        if (!(arrayList.size() != 0 || arrayList2.size() == 1 && (bl = MongoBuilder.checkIfJSONObject(arrayList2.get(0))))) {
            object2 = this.schema.findTable(new String[]{lQInsertNode.getSourceTable().getTable().getTableName()});
            if (object2 == null || ((ArrayList)object2).size() != 1) {
                throw new MongoBuilderFatalException("JDBC for MongoDB Driver: Unable to resolve key-value matching as a schema has not been predicted for collection " + lQInsertNode.getSourceTable().getTable().getTableName());
            }
            serializable = (AnnotatedSourceTable)((ArrayList)object2).get(0);
            int n = ((SourceTable)((Object)serializable)).getNumFields() - 1;
            if (n <= 0) {
                throw new MongoBuilderFatalException("JDBC for MongoDB Driver: Cannot insert values into collection " + ((SourceTable)((Object)serializable)).getTableName() + " as it only contains _id.");
            }
            if (n < arrayList2.size()) {
                throw new MongoBuilderFatalException("JDBC for MongoDB Driver: Unable to resolve key-value matching as there are more values than keys for the existing collection.");
            }
            if (n != arrayList2.size()) throw new MongoBuilderFatalException("JDBC for MongoDB Driver: Column names must be specified for values.");
            cloneable = ((SourceTable)((Object)serializable)).getSourceFieldsByPosition();
            Iterator iterator = ((ArrayList)cloneable).iterator();
            while (iterator.hasNext()) {
                object = (SourceField)iterator.next();
                if (((SourceField)object).getColumnName().compareTo("\"_id\"") == 0) continue;
                arrayList.add(new GQFieldRef((AnnotatedSourceField)object, ((SourceField)object).getColumnName(), null));
            }
        }
        if (!bl) {
            if (arrayList.size() < arrayList2.size()) {
                throw new MongoBuilderFatalException("JDBC for MongoDB Driver: Unable to resolve key-value matching as there are more values than keys for the existing collection.");
            }
            if (arrayList.size() > arrayList2.size()) {
                throw new MongoBuilderFatalException("JDBC for MongoDB Driver: Unable to resolve key-value matching as there are more keys (fields) than values for the existing collection.");
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                serializable = arrayList.get(i);
                ((GQFieldRef)serializable).setReferenceName(StringFunc.undelimitName(((GQFieldRef)serializable).getName(), '\"'));
                cloneable = (LQExprNode)arrayList2.get(i);
                int n = ((LQNode)((Object)cloneable)).getType();
                object = ((LQNode)((Object)cloneable)).getContent();
                Object object3 = null;
                if (n == 145) {
                    object3 = Parameter.retrieveParameterValue(object);
                } else if (n == 104) {
                    object3 = Integer.parseInt(object.toString());
                } else if (n == 151) {
                    object3 = object;
                } else if (n == 150) {
                    object3 = Long.parseLong(object.toString());
                } else if (n == 105) {
                    object3 = Double.parseDouble(object.toString());
                } else if (n == 127 || n == 101) {
                    object3 = object.toString();
                    if (StringFunc.isDelimited((String)object3, '\'')) {
                        object3 = StringFunc.undelimitName((String)object3, '\'');
                    }
                    if (MongoBuilder.checkIfJSONObject(object3)) {
                        object3 = this.buildBSON(object3);
                    }
                    if (bl2) {
                        if (((GQFieldRef)serializable).getName().equals("pwd")) {
                            if (string == null) {
                                throw new MongoBuilderFatalException("User name must be supplied.");
                            }
                            object3 = MongoDriver._hash(string, object3.toString());
                        } else if (((GQFieldRef)serializable).getName().equals("user")) {
                            string = object3.toString();
                        }
                    }
                } else if (n == 140 || n == 141 || n == 142) {
                    object3 = object;
                } else if (n == 131) {
                    object3 = null;
                } else {
                    if (n != 102) throw new MongoBuilderFatalException("JDBC for MongoDB Driver: Mongo JDBC Driver only supports INSERT with constant values (no expressions)");
                    if (object.toString().compareToIgnoreCase(OBJECT_ID) != 0) throw new MongoBuilderFatalException("JDBC for MongoDB Driver: Mongo JDBC Driver only supports INSERT with constant values - no expressions or functions allowed.");
                    int n2 = ((LQNode)((Object)cloneable)).getNumChildren();
                    if (n2 > 1) {
                        throw new MongoBuilderFatalException("JDBC for MongoDB Driver: Incorrect number of arguments for Mongo object ObjectID");
                    }
                    if (n2 == 1) {
                        object3 = ((LQNode)((Object)cloneable)).getChild().getContent().toString();
                        if (!Pattern.matches("'[0-9a-f]{24}'", (String)object3)) {
                            throw new MongoBuilderFatalException("JDBC for MongoDB Driver: Incorrectly formated ObjectId value.  Value must be formatted as a singled quoted 3-byte hexidecimal string");
                        }
                        object3 = new ObjectId(StringFunc.removeQuotes((String)object3));
                    } else {
                        object3 = new ObjectId();
                    }
                }
                mongoInsertQuery.insertFields.put(((GQFieldRef)serializable).toString(), object3);
            }
            return;
        } else {
            object2 = (DBObject)this.buildBSON(arrayList2.get(0));
            mongoInsertQuery.insertFields.putAll((BSONObject)object2);
        }
    }

    private void buildDrop(LQDropNode lQDropNode, MongoDropTable mongoDropTable) throws MongoBuilderFatalException, MongoBuilderUpstreamException {
        mongoDropTable.collectionName = StringFunc.undelimitName(lQDropNode.getName(), '\"');
    }

    private void buildDropIndex(LQDropIndexNode lQDropIndexNode, MongoDropIndex mongoDropIndex) throws MongoBuilderFatalException, MongoBuilderUpstreamException {
        mongoDropIndex.collectionName = StringFunc.undelimitName(lQDropIndexNode.getTableName(), '\"');
    }

    private void buildCreateIndex(LQCreateIndexNode lQCreateIndexNode, MongoCreateIndex mongoCreateIndex) throws MongoBuilderFatalException, MongoBuilderUpstreamException {
        BasicDBObject basicDBObject = new BasicDBObject();
        BasicDBObject basicDBObject2 = new BasicDBObject();
        ArrayList<LQExprNode> arrayList = lQCreateIndexNode.getExpressions();
        ArrayList<String> arrayList2 = lQCreateIndexNode.getOrderings();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = lQCreateIndexNode.getIndexType();
            if (string != null && string.toLowerCase().contains("hash")) {
                basicDBObject.put(arrayList.get(i).toString(), (Object)"hashed");
                continue;
            }
            int n = 1;
            if (arrayList2.get(i).equalsIgnoreCase("DESC")) {
                n = 1;
            }
            basicDBObject.put(arrayList.get(i).toString(), (Object)n);
        }
        if (lQCreateIndexNode.isUnique()) {
            basicDBObject2.put("unique", (Object)true);
        }
        basicDBObject2.put("name", (Object)lQCreateIndexNode.getIndexName());
        mongoCreateIndex.setIndex((DBObject)basicDBObject, (DBObject)basicDBObject2);
        mongoCreateIndex.collectionName = StringFunc.undelimitName(lQCreateIndexNode.getTableName(), '\"');
    }

    private Object buildBSON(Object object) throws MongoBuilderFatalException {
        String string = null;
        try {
            string = object instanceof String ? (String)object : ((LQExprNode)object).getContent().toString();
            return JSON.parse((String)StringFunc.removeQuotes(string));
        }
        catch (JSONParseException jSONParseException) {
            throw new MongoBuilderFatalException("JDBC for MongoDB Driver: Incorrectly formed JSON string in value list");
        }
    }

    public static boolean checkIfJSONObject(Object object) {
        try {
            if (object instanceof Integer || object instanceof Double || object instanceof Long || object instanceof Float || object instanceof Short) {
                return false;
            }
            if (object instanceof String) {
                Object object2 = JSON.parse((String)((String)object));
                if (object2 instanceof Integer && !object2.toString().equals(object.toString())) {
                    return false;
                }
                if (object2 == null || object2.toString().equals("")) {
                    return false;
                }
            } else if (object instanceof LQExprNode) {
                Object object3 = ((LQExprNode)object).getContent();
                if (object3 instanceof Integer || object3 instanceof Double || object3 instanceof Long || object3 instanceof Float || object3 instanceof Short) {
                    return false;
                }
                JSON.parse((String)object3.toString());
            }
            return true;
        }
        catch (JSONParseException jSONParseException) {
            return false;
        }
    }

    private void buildDistinct(LQDupElimNode lQDupElimNode, MongoQuery mongoQuery) throws MongoBuilderUpstreamException, MongoBuilderFatalException {
        this.distinct = true;
    }

    private void buildProjection(LQProjNode lQProjNode, MongoSelectQuery mongoSelectQuery) throws MongoBuilderFatalException, MongoBuilderUpstreamException {
        if (this.projectionSeen) {
            return;
        }
        this.projectionSeen = true;
        ArrayList<LQExprNode> arrayList = lQProjNode.getExpressions();
        for (LQExprNode lQExprNode : arrayList) {
            if (mongoSelectQuery.count) {
                throw new MongoBuilderUpstreamException("JDBC for MongoDB Driver: If a COUNT node is specified, only one projection is allowed.");
            }
            if (mongoSelectQuery.distinctField != null) {
                throw new MongoBuilderUpstreamException("JDBC for MongoDB Driver: DISTINCT with multiple projections is not allowed.");
            }
            String string = null;
            if (lQExprNode.getType() == 103) {
                string = lQExprNode.getChild(1).toString();
                lQExprNode = (LQExprNode)lQExprNode.getChild(0);
            }
            if (lQExprNode.getType() == 133) {
                throw new MongoBuilderUpstreamException("JDBC for MongoDB Driver: CASE is not supported.");
            }
            if (lQExprNode.getType() == 102) {
                throw new MongoBuilderUpstreamException("JDBC for MongoDB Driver: Functions in projections are not supported.");
            }
            if (lQExprNode.getType() == 126) {
                throw new MongoBuilderUpstreamException("JDBC for MongoDB Driver: Expressions in projection are not supported.");
            }
            if (lQExprNode.getType() == 120) {
                if ((lQExprNode = (LQExprNode)lQExprNode.getContent()).getContent().equals("COUNT")) {
                    lQExprNode = (LQExprNode)lQExprNode.getChild(0);
                    mongoSelectQuery.count = true;
                    if (string == null) {
                        string = "Count";
                    }
                    mongoSelectQuery.fieldNames.put("Count(*)", string);
                    if (!mongoSelectQuery.hasProjections()) continue;
                    throw new MongoBuilderUpstreamException("JDBC for MongoDB Driver: If a COUNT node is specified, only one projection is allowed at the moment.");
                }
                throw new MongoBuilderUpstreamException("JDBC for MongoDB Driver: We don't know how to handle expressions that aren't COUNT yet.");
            }
            if (lQExprNode.getContent().toString().equalsIgnoreCase("current_timestamp") || lQExprNode.getContent().toString().equalsIgnoreCase("current_time") || lQExprNode.getContent().toString().equalsIgnoreCase("current_date")) {
                throw new MongoBuilderUpstreamException("JDBC for MongoDB Driver: Functions in projections are not supported.");
            }
            String string2 = null;
            Object object = lQExprNode.getContent();
            if (object != null) {
                if (object instanceof GQFieldRef) {
                    string2 = ((GQFieldRef)object).getName();
                    string2 = StringFunc.removeAllQuotes(string2);
                } else {
                    string2 = object.toString();
                }
            } else {
                throw new MongoBuilderUpstreamException("JDBC for MongoDB Driver: Unable to parse field in SELECT: " + lQExprNode);
            }
            if (string2.equals("*")) {
                mongoSelectQuery.clearProjections();
                break;
            }
            if (this.distinct) {
                if (mongoSelectQuery.hasProjections()) {
                    throw new MongoBuilderUpstreamException("JDBC for MongoDB Driver: DISTINCT with multiple projections is not allowed at the moment.");
                }
                mongoSelectQuery.distinctField = string2;
                continue;
            }
            if (mongoSelectQuery.fieldNames.containsKey(string2)) {
                throw new MongoBuilderUpstreamException("JDBC for MongoDB: Projecting the same field more than once is not supported.");
            }
            this.addProjectionField(mongoSelectQuery, string2);
            if (string == null) {
                string = string2;
            }
            mongoSelectQuery.fieldNames.put(string2, string);
        }
        if (!mongoSelectQuery.projections.containsField("_id") && mongoSelectQuery.projections.size() != 0) {
            mongoSelectQuery.projections.put("_id", (Object)0);
        }
    }

    public void addProjectionField(MongoSelectQuery mongoSelectQuery, String string) {
        String string2 = string;
        int n = StringFunc.extractNumber(string2);
        if (n >= 0) {
            string2 = string2.substring(0, n);
        }
        Iterator iterator = mongoSelectQuery.projections.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (string2.startsWith(string3)) {
                return;
            }
            if (!string3.startsWith(string2)) continue;
            iterator.remove();
        }
        mongoSelectQuery.projections.put(string2, (Object)1);
    }

    private void buildCondition(LQCondNode lQCondNode, BasicDBObject basicDBObject, LQNode lQNode) throws MongoBuilderFatalException, MongoBuilderUpstreamException {
        int n = lQCondNode.getType();
        LQNode lQNode2 = lQCondNode.getChild(0);
        LQNode lQNode3 = lQCondNode.getChild(1);
        switch (n) {
            case 118: {
                this.buildXOR(lQCondNode, lQNode2, lQNode3);
                this.buildCondition(lQCondNode, basicDBObject, lQNode);
                break;
            }
            case 121: {
                this.buildXNOR(lQCondNode, lQNode2, lQNode3);
                this.buildCondition(lQCondNode, basicDBObject, lQNode);
                break;
            }
            case 112: {
                int n2 = lQNode2.getType();
                String string = lQNode2.getContent().toString();
                if (n2 == 111 || n2 == 110 || n2 == 118 || lQNode2.getType() == 112 || n2 == 114 && (string.equals("=") || string.equals("!=") || string.equals("LIKE") || string.equals("NOT LIKE"))) {
                    lQCondNode = this.pushDownNOTIntoLogicalOperator(lQNode, lQCondNode, lQNode2);
                    this.buildCondition(lQCondNode, basicDBObject, lQNode);
                    break;
                }
                if (n2 == 114) {
                    BasicDBObject basicDBObject2 = new BasicDBObject();
                    if (lQNode2.getChild(1).getType() == 100 && lQNode2.getChild(0).getType() != 100) {
                        String string2 = (String)lQNode2.getContent();
                        LQNode lQNode4 = lQNode2.getChild(1);
                        lQCondNode.getChild(0).setChild(1, lQNode2.getChild(0));
                        lQCondNode.getChild(0).setChild(0, lQNode4);
                        string2 = this.switchOperator(string2);
                        lQCondNode.getChild(0).setContent(string2);
                        this.buildCondition(lQCondNode, basicDBObject, lQNode);
                        return;
                    }
                    this.pushNOTDownIntoComparisonIOperator(basicDBObject, basicDBObject2, lQNode2);
                    this.buildCondition((LQCondNode)lQNode2, basicDBObject2, lQNode);
                    break;
                }
                throw new MongoBuilderUpstreamException("Invalid condition: " + lQCondNode.toString());
            }
            case 111: {
                BasicDBList basicDBList = this.rebuildBinaryExpression(lQNode, lQNode2, lQNode3);
                this.addAndArray(basicDBList, basicDBObject);
                break;
            }
            case 110: {
                BasicDBList basicDBList = this.rebuildBinaryExpression(lQNode, lQNode2, lQNode3);
                BasicDBList basicDBList2 = (BasicDBList)basicDBObject.get("$or");
                if (basicDBList2 != null) {
                    BasicDBList basicDBList3 = new BasicDBList();
                    BasicDBObject basicDBObject3 = new BasicDBObject();
                    basicDBObject3.put("$or", (Object)basicDBList);
                    BasicDBObject basicDBObject4 = new BasicDBObject();
                    basicDBObject4.put("$or", (Object)basicDBList2);
                    basicDBList3.add((Object)basicDBObject4);
                    basicDBList3.add((Object)basicDBObject3);
                    this.addAndArray(basicDBList3, basicDBObject);
                    basicDBObject.remove((Object)"$or");
                    break;
                }
                basicDBObject.put("$or", (Object)basicDBList);
                break;
            }
            default: {
                this.buildComparison(lQCondNode, (LQExprNode)lQNode2, (LQExprNode)lQNode3, basicDBObject);
            }
        }
    }

    private void addAndArray(BasicDBList basicDBList, BasicDBObject basicDBObject) {
        BasicDBList basicDBList2 = (BasicDBList)basicDBObject.get("$and");
        if (basicDBList2 != null) {
            for (Object e : basicDBList) {
                basicDBList2.add(e);
            }
        } else {
            basicDBObject.put("$and", (Object)basicDBList);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void buildComparison(LQCondNode lQCondNode, LQExprNode lQExprNode, LQExprNode lQExprNode2, BasicDBObject basicDBObject) throws MongoBuilderFatalException, MongoBuilderUpstreamException {
        Object object;
        MongoExpression mongoExpression = this.buildExpression(lQExprNode, null);
        Object object2 = this.buildExpression(lQExprNode2, null);
        boolean bl = mongoExpression.isExpression();
        boolean bl2 = ((MongoExpression)object2).isExpression();
        String string = lQCondNode.getContent().toString();
        if (bl2 && bl) {
            String string2 = mongoExpression.toString(true);
            String string3 = ((MongoExpression)object2).toString(true);
            String string4 = string.equals("=") ? " == " : " " + string + " ";
            String string5 = string2 + string4 + string3;
            basicDBObject.put("$where", (Object)string5);
            return;
        }
        if (bl2 && !bl) {
            string = this.switchOperator(string);
            object = mongoExpression;
            mongoExpression = object2;
            object2 = object;
        }
        object = mongoExpression.toString();
        Object object3 = ((MongoExpression)object2).getValue();
        if (string.equals("=")) {
            this.addToQueryObject(basicDBObject, (String)object, object3);
            return;
        } else if (string.equals(">") || string.equals("<") || string.equals("<=") || string.equals(">=")) {
            BasicDBObject basicDBObject2 = (BasicDBObject)basicDBObject.get((String)object);
            if (basicDBObject2 == null) {
                basicDBObject2 = new BasicDBObject();
                if (((String)object).equalsIgnoreCase("NOT") || ((String)object).equalsIgnoreCase("NOT LIKE")) {
                    basicDBObject.put(this.rebuildOperator((String)object), (Object)basicDBObject2);
                } else {
                    basicDBObject.put((String)object, (Object)basicDBObject2);
                }
            }
            basicDBObject2.put(this.rebuildOperator(string), object3);
            return;
        } else if (string.equals("!=") || string.equals("<>")) {
            BasicDBObject basicDBObject3 = new BasicDBObject();
            basicDBObject.put((String)object, (Object)basicDBObject3);
            basicDBObject3.put(this.rebuildOperator(string), object3);
            return;
        } else if (string.equals("IN")) {
            if (object3 instanceof ArrayList) {
                BasicDBList basicDBList = new BasicDBList();
                ArrayList arrayList = (ArrayList)object3;
                for (LQExprNode lQExprNode3 : arrayList) {
                    BasicDBObject basicDBObject4 = new BasicDBObject();
                    Object object4 = lQExprNode3.getContent();
                    if (object4 instanceof String) {
                        basicDBObject4.put((String)object, (Object)StringFunc.removeQuotes((String)object4));
                    } else {
                        basicDBObject4.put((String)object, object4);
                    }
                    basicDBList.add((Object)basicDBObject4);
                }
                basicDBObject.put("$or", (Object)basicDBList);
                return;
            } else {
                if (!(object3 instanceof String)) throw new MongoBuilderUpstreamException("JDBC for MongoDB Driver: IN is only supported with constant values.  No subqueries or expressions.");
                this.addToQueryObject(basicDBObject, (String)object, Pattern.compile("^" + StringFunc.convertSQLPatternToJavaPattern(object3.toString()) + "$"));
            }
            return;
        } else {
            if (lQCondNode.getType() != 114) return;
            String string6 = object3.toString();
            if (string6.equals("NULL")) {
                this.addToQueryObject(basicDBObject, (String)object, null);
                return;
            } else if (string6.equals("FALSE") || string6.equals("TRUE")) {
                this.addToQueryObject(basicDBObject, (String)object, Boolean.parseBoolean(string6));
                return;
            } else if (string6.equals("NOT NULL")) {
                BasicDBObject basicDBObject5 = new BasicDBObject();
                basicDBObject5.put("$ne", null);
                this.addToQueryObject(basicDBObject, (String)object, basicDBObject5);
                return;
            } else {
                BasicDBObject basicDBObject6 = new BasicDBObject();
                if (string.equalsIgnoreCase("NOT LIKE")) {
                    basicDBObject.put((String)object, (Object)basicDBObject6);
                    basicDBObject6.put(this.rebuildOperator(string), (Object)Pattern.compile("^" + StringFunc.convertSQLPatternToJavaPattern(object3.toString()) + "$"));
                    return;
                } else {
                    this.addToQueryObject(basicDBObject, (String)object, Pattern.compile("^" + StringFunc.convertSQLPatternToJavaPattern(object3.toString()) + "$"));
                }
            }
        }
    }

    private void pushNOTDownIntoComparisonIOperator(BasicDBObject basicDBObject, BasicDBObject basicDBObject2, LQNode lQNode) {
        Object object = lQNode.getChild(0).getContent();
        if (object instanceof String) {
            object = StringFunc.removeQuotes((String)object);
        } else if (object instanceof GQFieldRef) {
            object = StringFunc.undelimitName(((GQFieldRef)object).getName(), '\"');
        }
        basicDBObject.put((String)object, (Object)basicDBObject2);
        if (lQNode.getContent().toString().compareTo("=") == 0) {
            lQNode.setContent("!=");
        } else if (lQNode.getContent().toString().compareToIgnoreCase("NOT LIKE") == 0) {
            lQNode.setContent("LIKE");
            lQNode.setType(114);
        } else if (lQNode.getContent().toString().compareToIgnoreCase("LIKE") == 0) {
            lQNode.setContent("NOT LIKE");
            lQNode.setType(114);
        } else {
            lQNode.getChild(0).setContent("NOT");
            lQNode.getChild(0).setType(101);
        }
    }

    private LQCondNode pushDownNOTIntoLogicalOperator(LQNode lQNode, LQCondNode lQCondNode, LQNode lQNode2) throws MongoBuilderUpstreamException {
        LQCondNode lQCondNode2 = lQCondNode;
        this.complementConditionNode(lQCondNode2, lQNode2);
        Iterator<LQNode> iterator = lQNode2.getChildren().iterator();
        String string = lQNode2.getContent().toString();
        if (string.compareToIgnoreCase("XOR") == 0 || string.compareToIgnoreCase("XNOR") == 0) {
            this.pushNOTDownAndComplementOperator(lQCondNode2, iterator);
        } else if (string.compareToIgnoreCase("NOT") == 0) {
            lQCondNode2 = this.collapseDoubleNOT(lQNode, lQCondNode2, iterator);
        } else if (string.compareToIgnoreCase("AND") == 0 || string.compareToIgnoreCase("OR") == 0) {
            this.pushNOTDownANDandOR(lQCondNode2, iterator);
        } else if (string.compareToIgnoreCase("LIKE") == 0 || string.compareToIgnoreCase("NOT LIKE") == 0 || string.compareToIgnoreCase("=") == 0 || string.compareToIgnoreCase("!=") == 0 || string.compareToIgnoreCase("<>") == 0) {
            this.pushNOTDownAndComplementOperator(lQCondNode2, iterator);
        }
        return lQCondNode2;
    }

    private BasicDBList rebuildBinaryExpression(LQNode lQNode, LQNode lQNode2, LQNode lQNode3) throws MongoBuilderFatalException, MongoBuilderUpstreamException {
        BasicDBList basicDBList = new BasicDBList();
        BasicDBObject basicDBObject = new BasicDBObject();
        BasicDBObject basicDBObject2 = new BasicDBObject();
        this.buildCondition((LQCondNode)lQNode2, basicDBObject, lQNode);
        this.buildCondition((LQCondNode)lQNode3, basicDBObject2, lQNode);
        basicDBList.add((Object)basicDBObject);
        basicDBList.add((Object)basicDBObject2);
        return basicDBList;
    }

    private void complementConditionNode(LQCondNode lQCondNode, LQNode lQNode) throws MongoBuilderUpstreamException {
        String string = lQNode.getContent().toString();
        if (string.compareToIgnoreCase("=") == 0) {
            lQCondNode.setContent("!=");
            lQCondNode.setType(114);
        } else if (string.compareToIgnoreCase("!=") == 0 || string.compareToIgnoreCase("<>") == 0) {
            lQCondNode.setContent("=");
            lQCondNode.setType(114);
        } else if (string.compareToIgnoreCase("LIKE") == 0) {
            lQCondNode.setContent("NOT LIKE");
            lQCondNode.setType(114);
        } else if (string.compareToIgnoreCase("NOT LIKE") == 0) {
            lQCondNode.setContent("LIKE");
            lQCondNode.setType(114);
        } else if (string.compareToIgnoreCase("AND") == 0) {
            lQCondNode.setContent("OR");
            lQCondNode.setType(110);
        } else if (string.compareToIgnoreCase("OR") == 0) {
            lQCondNode.setContent("AND");
            lQCondNode.setType(111);
        } else if (string.compareToIgnoreCase("XOR") == 0) {
            lQCondNode.setContent("XNOR");
            lQCondNode.setType(121);
        } else if (string.compareToIgnoreCase("XNOR") == 0) {
            lQCondNode.setContent("XOR");
            lQCondNode.setType(118);
        } else if (string.compareToIgnoreCase("NOT") != 0) {
            throw new MongoBuilderUpstreamException(string + " can not be negated properly");
        }
    }

    private void pushNOTDownANDandOR(LQCondNode lQCondNode, Iterator<LQNode> iterator) {
        lQCondNode.removeChild(0);
        while (iterator.hasNext()) {
            LQNode lQNode = iterator.next();
            LQCondNode lQCondNode2 = new LQCondNode();
            lQCondNode2.setContent("NOT");
            lQCondNode2.setType(112);
            lQCondNode2.addChild(lQNode);
            lQCondNode2.getChild().setParent(lQCondNode2);
            lQCondNode.addChild(lQCondNode2);
            lQCondNode2.setParent(lQCondNode);
        }
    }

    private LQCondNode collapseDoubleNOT(LQNode lQNode, LQCondNode lQCondNode, Iterator<LQNode> iterator) {
        LQCondNode lQCondNode2 = lQCondNode;
        while (iterator.hasNext()) {
            LQNode lQNode2 = iterator.next();
            if (lQCondNode2.getParent() != null) {
                lQCondNode2.getParent().replaceChild(lQCondNode2, lQNode2);
                lQNode2.setParent(lQCondNode2.getParent());
                lQCondNode2 = (LQCondNode)lQNode2;
                continue;
            }
            if (lQNode instanceof LQSelNode) {
                ((LQSelNode)lQNode).setCondition((LQCondNode)lQNode2);
                lQCondNode2 = ((LQSelNode)lQNode).getCondition();
                continue;
            }
            if (lQNode instanceof LQUpdateNode) {
                ((LQUpdateNode)lQNode).setCondition((LQCondNode)lQNode2);
                lQCondNode2 = ((LQUpdateNode)lQNode).getCondition();
                continue;
            }
            if (!(lQNode instanceof LQDeleteNode)) continue;
            ((LQDeleteNode)lQNode).setCondition((LQCondNode)lQNode2);
            lQCondNode2 = ((LQDeleteNode)lQNode).getCondition();
        }
        return lQCondNode2;
    }

    private void pushNOTDownAndComplementOperator(LQCondNode lQCondNode, Iterator<LQNode> iterator) {
        lQCondNode.removeChild(0);
        while (iterator.hasNext()) {
            LQNode lQNode = iterator.next();
            lQCondNode.addChild(lQNode);
            lQNode.setParent(lQCondNode);
        }
    }

    private void buildXNOR(LQCondNode lQCondNode, LQNode lQNode, LQNode lQNode2) {
        LQNode lQNode3 = (LQNode)lQNode.clone();
        LQNode lQNode4 = (LQNode)lQNode2.clone();
        LQNode lQNode5 = lQNode;
        LQNode lQNode6 = lQNode2;
        LQCondNode lQCondNode2 = new LQCondNode();
        lQCondNode2.setType(111);
        lQCondNode2.setContent("AND");
        LQCondNode lQCondNode3 = new LQCondNode();
        lQCondNode3.setType(111);
        lQCondNode3.setContent("AND");
        LQCondNode lQCondNode4 = new LQCondNode();
        lQCondNode4.setType(112);
        lQCondNode4.setContent("NOT");
        LQCondNode lQCondNode5 = new LQCondNode();
        lQCondNode5.setType(112);
        lQCondNode5.setContent("NOT");
        lQCondNode2.addChild(lQCondNode4);
        lQCondNode4.setParent(lQCondNode2);
        lQCondNode4.addChild(lQNode3);
        lQNode3.setParent(lQCondNode4);
        lQCondNode2.addChild(lQCondNode5);
        lQCondNode5.setParent(lQCondNode2);
        lQCondNode5.addChild(lQNode4);
        lQNode4.setParent(lQCondNode5);
        lQCondNode3.addChild(lQNode5);
        lQNode5.setParent(lQCondNode3);
        lQCondNode3.addChild(lQNode6);
        lQNode6.setParent(lQCondNode3);
        lQCondNode.replaceChild(lQNode, lQCondNode2);
        lQCondNode.replaceChild(lQNode2, lQCondNode3);
        lQCondNode2.setParent(lQCondNode);
        lQCondNode3.setParent(lQCondNode);
        lQCondNode.setContent("OR");
        lQCondNode.setType(110);
    }

    private void buildXOR(LQCondNode lQCondNode, LQNode lQNode, LQNode lQNode2) throws MongoBuilderFatalException, MongoBuilderUpstreamException {
        LQNode lQNode3 = (LQNode)lQNode.clone();
        LQNode lQNode4 = (LQNode)lQNode2.clone();
        LQNode lQNode5 = lQNode;
        LQNode lQNode6 = lQNode2;
        LQCondNode lQCondNode2 = new LQCondNode();
        lQCondNode2.setType(111);
        lQCondNode2.setContent("AND");
        LQCondNode lQCondNode3 = new LQCondNode();
        lQCondNode3.setType(111);
        lQCondNode3.setContent("AND");
        LQCondNode lQCondNode4 = new LQCondNode();
        lQCondNode4.setType(112);
        lQCondNode4.setContent("NOT");
        LQCondNode lQCondNode5 = new LQCondNode();
        lQCondNode5.setType(112);
        lQCondNode5.setContent("NOT");
        lQCondNode2.addChild(lQCondNode4);
        lQCondNode4.setParent(lQCondNode2);
        lQCondNode4.addChild(lQNode3);
        lQNode3.setParent(lQCondNode4);
        lQCondNode2.addChild(lQNode4);
        lQNode4.setParent(lQCondNode2);
        lQCondNode3.addChild(lQCondNode5);
        lQCondNode5.setParent(lQCondNode3);
        lQCondNode5.addChild(lQNode6);
        lQNode6.setParent(lQCondNode5);
        lQCondNode3.addChild(lQNode5);
        lQNode5.setParent(lQCondNode3);
        lQCondNode.replaceChild(lQNode, lQCondNode2);
        lQCondNode.replaceChild(lQNode2, lQCondNode3);
        lQCondNode2.setParent(lQCondNode);
        lQCondNode3.setParent(lQCondNode);
        lQCondNode.setContent("OR");
        lQCondNode.setType(110);
    }

    private String rebuildOperator(String string) throws MongoBuilderFatalException {
        if (string.equals(">")) {
            return "$gt";
        }
        if (string.equals("<")) {
            return "$lt";
        }
        if (string.equals(">=")) {
            return "$gte";
        }
        if (string.equals("<=")) {
            return "$lte";
        }
        if (string.equals("!=") || string.equals("<>")) {
            return "$ne";
        }
        if (string.equals("NOT LIKE") || string.equals("NOT")) {
            return "$not";
        }
        throw new MongoBuilderFatalException("JDBC for MongoDB Driver: Operator " + string + " not supported.");
    }

    private String switchOperator(String string) {
        if (string.equals("<")) {
            return ">";
        }
        if (string.equals("<=")) {
            return ">=";
        }
        if (string.equals(">")) {
            return "<";
        }
        if (string.equals(">=")) {
            return "<=";
        }
        if (string.equals("!<")) {
            return "!<";
        }
        if (string.equals("!<")) {
            return "!>";
        }
        return string;
    }

    private MongoExpression buildExpression(LQExprNode lQExprNode, MongoExpression mongoExpression) throws MongoBuilderFatalException, MongoBuilderUpstreamException {
        int n = lQExprNode.getType();
        if (n == 100 || n == 120) {
            return new MongoExpression(n, mongoExpression, null, StringFunc.undelimitName(lQExprNode.getContent().toString(), '\"'), null, true);
        }
        if (n == 127 || n == 101) {
            return new MongoExpression(n, mongoExpression, null, StringFunc.removeQuotes((String)lQExprNode.getContent()), null, false);
        }
        if (n == 104 || n == 105 || n == 151) {
            return new MongoExpression(n, mongoExpression, null, lQExprNode.getContent(), null, false);
        }
        if (n == 140 || n == 141 || n == 142) {
            Object object = lQExprNode.getContent();
            if (object instanceof String) {
                object = StringFunc.removeQuotes((String)lQExprNode.getContent());
            }
            return new MongoExpression(n, mongoExpression, null, object, null, false);
        }
        if (n == 126) {
            ArrayList<MongoExpression> arrayList = new ArrayList<MongoExpression>(2);
            MongoExpression mongoExpression2 = new MongoExpression(n, mongoExpression, arrayList, lQExprNode.getContent(), null, true);
            MongoExpression mongoExpression3 = this.buildExpression((LQExprNode)lQExprNode.getChild(0), mongoExpression2);
            MongoExpression mongoExpression4 = this.buildExpression((LQExprNode)lQExprNode.getChild(1), mongoExpression2);
            arrayList.add(mongoExpression3);
            arrayList.add(mongoExpression4);
            return mongoExpression2;
        }
        if (n == 102 || n == 125 || n == 124) {
            LQExprNode lQExprNode2;
            if (lQExprNode.getContent().toString().equalsIgnoreCase("STR") && (lQExprNode2 = (LQExprNode)lQExprNode.getChild(0)).getContent() instanceof Date) {
                lQExprNode2.setType(101);
                lQExprNode2.setContent(lQExprNode2.getReference());
                return this.buildExpression(lQExprNode2, mongoExpression);
            }
            throw new MongoBuilderUpstreamException("Function not supported: " + lQExprNode.getContent());
        }
        if (n == 130) {
            return new MongoExpression(n, mongoExpression, null, lQExprNode.getContent().toString(), null, false);
        }
        if (n == 145) {
            Object object = lQExprNode.getContent();
            Object object2 = Parameter.retrieveParameterValue(object);
            if (object2 instanceof String) {
                return new MongoExpression(n, mongoExpression, null, StringFunc.removeQuotes((String)object2), null, false);
            }
            return new MongoExpression(n, mongoExpression, null, object2, null, false);
        }
        if (n == 134) {
            ArrayList arrayList = (ArrayList)lQExprNode.getContent();
            return new MongoExpression(n, mongoExpression, null, arrayList, null, false);
        }
        if (n == 17) {
            throw new MongoBuilderUpstreamException("Subqueries are not supported by MongoDB JDBC driver.");
        }
        throw new MongoBuilderUpstreamException("Invalid expression: " + lQExprNode.getContent());
    }

    private void addToQueryObject(BasicDBObject basicDBObject, String string, Object object) {
        Object object2 = basicDBObject.get(string);
        if (object2 == null) {
            basicDBObject.put(string, object);
        } else {
            BasicDBList basicDBList = new BasicDBList();
            BasicDBObject basicDBObject2 = new BasicDBObject();
            basicDBObject2.put(string, object2);
            basicDBList.add((Object)basicDBObject2);
            basicDBObject2 = new BasicDBObject();
            basicDBObject2.put(string, object);
            basicDBList.add((Object)basicDBObject2);
            basicDBObject.put("$and", (Object)basicDBList);
            basicDBObject.remove((Object)string);
        }
    }

    private void rebuildSelection(LQSelNode lQSelNode, MongoSelectQuery mongoSelectQuery) throws MongoBuilderFatalException, MongoBuilderUpstreamException {
        LQCondNode lQCondNode = lQSelNode.getCondition();
        BasicDBObject basicDBObject = mongoSelectQuery.query;
        this.buildCondition(lQCondNode, basicDBObject, lQSelNode);
    }

    private void rebuildGroupBy(LQGroupByNode lQGroupByNode, MongoSelectQuery mongoSelectQuery) throws MongoBuilderUpstreamException {
        if (lQGroupByNode.getExpressions().size() > 0) {
            throw new MongoBuilderUpstreamException("JDBC for MongoDB Driver: GROUP BY is not supported by the driver.");
        }
        if (lQGroupByNode.getFunctionList().size() > 1) {
            throw new MongoBuilderUpstreamException("JDBC for MongoDB Driver: Only support COUNT(*) or COUNT(attr).");
        }
        LQExprNode lQExprNode = lQGroupByNode.getFunctionList().get(0);
        LQExprNode lQExprNode2 = (LQExprNode)lQExprNode.getChild(0);
        if (lQExprNode2.getType() == 100) {
            mongoSelectQuery.query.put(StringFunc.removeAllQuotes(lQExprNode2.getContent().toString()), (Object)new BasicDBObject("$exists", (Object)true));
        } else if (!lQExprNode.toString().equalsIgnoreCase("count(*)")) {
            throw new MongoBuilderUpstreamException("JDBC for MongoDB Driver: Only support COUNT(*) or COUNT(attr).");
        }
    }

    private void rebuildOrderBy(LQOrderByNode lQOrderByNode, MongoSelectQuery mongoSelectQuery) throws MongoBuilderUpstreamException {
        for (int i = 0; i < lQOrderByNode.getOrderNumChildren(); ++i) {
            Object object = lQOrderByNode.getOrderChild(i).getContent();
            String string = null;
            if (!(object instanceof GQFieldRef)) {
                throw new MongoBuilderUpstreamException("JDBC for MongoDB Driver: ORDER BY with an expression or function is not supported by the driver.");
            }
            string = ((GQFieldRef)object).getName();
            String string2 = lQOrderByNode.getDirection(i);
            int n = string2 == "DESC" ? -1 : 1;
            string = StringFunc.undelimitName(string, '\"');
            mongoSelectQuery.orderBy.put(string, (Object)n);
        }
    }

    private void rebuildFrom(LQNode lQNode, MongoSelectQuery mongoSelectQuery) throws MongoBuilderFatalException, MongoBuilderUpstreamException {
        mongoSelectQuery.collectionName = ((GQTableRef)lQNode.getContent()).getTable().getTableName();
        if (StringFunc.isDelimited(mongoSelectQuery.collectionName, '\"')) {
            mongoSelectQuery.collectionName = StringFunc.undelimitName(mongoSelectQuery.collectionName, '\"');
        }
    }

    private void rebuildLimit(LQLimitNode lQLimitNode, MongoSelectQuery mongoSelectQuery) {
        if (lQLimitNode.hasOffset()) {
            mongoSelectQuery.offset = lQLimitNode.getStart();
        }
        mongoSelectQuery.limit = lQLimitNode.getCount();
    }

    public MongoQuery toMongoQuery() throws MongoBuilderFatalException, MongoBuilderUpstreamException {
        MongoQuery mongoQuery = new MongoSelectQuery();
        for (LQNode lQNode = this.startNode; lQNode != null; lQNode = lQNode.getChild()) {
            switch (lQNode.getType()) {
                case 1: {
                    this.buildProjection((LQProjNode)lQNode, (MongoSelectQuery)mongoQuery);
                    break;
                }
                case 2: {
                    this.rebuildSelection((LQSelNode)lQNode, (MongoSelectQuery)mongoQuery);
                    break;
                }
                case 6: 
                case 100: {
                    this.rebuildFrom(lQNode, (MongoSelectQuery)mongoQuery);
                    break;
                }
                case 18: {
                    this.rebuildLimit((LQLimitNode)lQNode, (MongoSelectQuery)mongoQuery);
                    break;
                }
                case 4: {
                    if (this.distinct) {
                        throw new MongoBuilderUpstreamException("MongoDB does not support ORDER BY and DISTINCT together.");
                    }
                    this.rebuildOrderBy((LQOrderByNode)lQNode, (MongoSelectQuery)mongoQuery);
                    break;
                }
                case 5: {
                    this.rebuildGroupBy((LQGroupByNode)lQNode, (MongoSelectQuery)mongoQuery);
                    break;
                }
                case 16: {
                    this.buildDistinct((LQDupElimNode)lQNode, mongoQuery);
                    break;
                }
                case 22: 
                case 23: {
                    mongoQuery = new MongoInsertQuery();
                    this.buildInsert((LQInsertNode)lQNode, (MongoInsertQuery)mongoQuery);
                    break;
                }
                case 25: {
                    mongoQuery = new MongoUpsertQuery();
                    this.buildInsert((LQUpsertNode)lQNode, (MongoUpsertQuery)mongoQuery);
                    break;
                }
                case 21: {
                    mongoQuery = new MongoUpdateQuery();
                    this.buildUpdate((LQUpdateNode)lQNode, (MongoUpdateQuery)mongoQuery);
                    break;
                }
                case 20: {
                    mongoQuery = new MongoDeleteQuery();
                    this.buildDelete((LQDeleteNode)lQNode, (MongoDeleteQuery)mongoQuery);
                    break;
                }
                case 60: {
                    mongoQuery = new MongoDropTable();
                    this.buildDrop((LQDropNode)lQNode, (MongoDropTable)mongoQuery);
                    break;
                }
                case 51: {
                    mongoQuery = new MongoCreateIndex();
                    this.buildCreateIndex((LQCreateIndexNode)lQNode, (MongoCreateIndex)mongoQuery);
                    break;
                }
                case 61: {
                    mongoQuery = new MongoDropIndex(((LQDropIndexNode)lQNode).getIndexName());
                    this.buildDropIndex((LQDropIndexNode)lQNode, (MongoDropIndex)mongoQuery);
                    break;
                }
                default: {
                    throw new MongoBuilderUpstreamException("JDBC for MongoDB Driver: Got a query element we don't know how to deal with. Type " + lQNode + ".");
                }
            }
            if (lQNode.getNumChildren() <= 1) continue;
            throw new MongoBuilderFatalException("JDBC for MongoDB Driver: Too many children found at node " + lQNode.toString());
        }
        return mongoQuery;
    }

    public String toMongoString() throws MongoBuilderUpstreamException, MongoBuilderFatalException {
        return this.toMongoQuery().toMongoString();
    }

    public String toString() {
        try {
            return this.toMongoString();
        }
        catch (Exception exception) {
            return "";
        }
    }
}

