/*
 * Decompiled with CFR 0.152.
 */
package mongodb.query;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import mongodb.query.MongoBuilderFatalException;
import mongodb.query.MongoQuery;

public class MongoSelectQuery
extends MongoQuery {
    public BasicDBObject orderBy;
    public BasicDBObject query;
    public BasicDBObject projections;
    public LinkedHashMap<String, String> fieldNames = new LinkedHashMap();
    public Integer limit = null;
    public Integer offset = null;
    public boolean count = false;
    public String distinctField = null;

    public MongoSelectQuery() {
        this.orderBy = new BasicDBObject();
        this.query = new BasicDBObject();
        this.projections = new BasicDBObject();
    }

    public boolean hasProjections() {
        return this.projections.size() > 0;
    }

    public void clearProjections() {
        this.projections = new BasicDBObject();
    }

    private Object runDistinct(DBCollection dBCollection) {
        List list = dBCollection.distinct(this.distinctField, (DBObject)this.query);
        if (this.count) {
            return list.size();
        }
        return list;
    }

    private Object runFind(DBCollection dBCollection) {
        DBCursor dBCursor = dBCollection.find((DBObject)this.query, (DBObject)this.projections);
        if (this.orderBy.size() > 0) {
            dBCursor.sort((DBObject)this.orderBy);
        }
        if (this.limit != null) {
            dBCursor.limit(this.limit.intValue());
        }
        if (this.offset != null) {
            dBCursor.skip(this.offset.intValue());
        }
        if (this.count) {
            int n = dBCursor.count();
            dBCursor.close();
            return n;
        }
        Iterator iterator = dBCursor.iterator();
        dBCursor.close();
        return iterator;
    }

    @Override
    public Object run(DB dB) throws Exception {
        DBCollection dBCollection = dB.getCollection(this.collectionName);
        if (this.distinctField != null) {
            return this.runDistinct(dBCollection);
        }
        return this.runFind(dBCollection);
    }

    private String findToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("find(");
        stringBuffer.append(this.query.toString());
        stringBuffer.append(", ");
        stringBuffer.append(this.projections.toString());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private String distinctToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("distinct(\"");
        stringBuffer.append(this.distinctField);
        stringBuffer.append("\", ");
        stringBuffer.append(this.query.toString());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public String toMongoString() throws MongoBuilderFatalException {
        if (this.collectionName == null) {
            throw new MongoBuilderFatalException("We never got a collection name! Did the FROM node go missing?");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("db.");
        stringBuffer.append(this.collectionName);
        stringBuffer.append(".");
        if (this.distinctField != null) {
            stringBuffer.append(this.distinctToString());
        } else {
            stringBuffer.append(this.findToString());
        }
        if (this.orderBy.size() > 0) {
            stringBuffer.append(".sort( ");
            stringBuffer.append(this.orderBy.toString());
            stringBuffer.append(" )");
        }
        if (this.limit != null) {
            stringBuffer.append(".limit( ");
            stringBuffer.append(this.limit);
            stringBuffer.append(" )");
        }
        if (this.offset != null) {
            stringBuffer.append(".skip( ");
            stringBuffer.append(this.offset);
            stringBuffer.append(" )");
        }
        if (this.count) {
            stringBuffer.append(".count()");
        }
        return stringBuffer.toString();
    }
}

