/*
 * Decompiled with CFR 0.152.
 */
package snow.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ResourceBundle;
import snow.conn.ServerConnection;
import snow.jdbc.SNowConnection;
import snow.query.SNowQuery;
import unity.engine.IServerConnection;
import unity.generic.jdbc.StatementImpl;
import unity.query.LimitInfo;
import unity.util.StringFunc;

public class SNowStatement
extends StatementImpl {
    protected static ResourceBundle resources = ResourceBundle.getBundle("resources/snow/SNowStatement", locale);
    private SNowQuery query;

    public SNowStatement(SNowConnection sNowConnection, IServerConnection iServerConnection, int n, int n2) {
        super(sNowConnection, iServerConnection, n, n2);
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        if (this._results != null) {
            this._results.close();
        }
        this.queryActive = false;
        this._results = null;
        this.query = null;
        if (this._maxRows > 0) {
            LimitInfo limitInfo = LimitInfo.parse(string);
            limitInfo.rowCount = limitInfo.hasLimit ? Math.min(limitInfo.rowCount, this._maxRows) : this._maxRows;
            limitInfo.hasLimit = true;
            string = StringFunc.replaceLimit(string, limitInfo);
        }
        this._results = ((ServerConnection)this.con).executeQuery(string, this._resultSetType, this);
        this.queryActive = true;
        return this._results;
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        if (string.toLowerCase().trim().startsWith("select")) {
            throw new SQLException(resources.getString("errorExecuteUpdate") + string);
        }
        throw new SQLException(resources.getString("errorUpdate") + string);
    }

    public String getQueryString() {
        if (this.query == null) {
            return "";
        }
        try {
            return this.query.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void setQuery(SNowQuery sNowQuery) {
        this.query = sNowQuery;
    }
}

