/*
 * Decompiled with CFR 0.152.
 */
package splunk.jdbc;

import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import splunk.conn.ServerConnection;
import splunk.jdbc.SplunkDatabaseMetaData;
import splunk.jdbc.SplunkDriver;
import splunk.jdbc.SplunkStatement;
import unity.generic.jdbc.ConnectionImpl;
import unity.jdbc.UnityDriver;

public class SplunkConnection
extends ConnectionImpl {
    public SplunkConnection(String string, Properties properties) throws SQLException {
        this.url = string;
        this.clientInfo = properties;
        if (this.clientInfo == null) {
            this.clientInfo = new Properties();
        }
        if (UnityDriver.DEBUG) {
            System.out.println("Data set to connect to:.  URL:  " + string);
        }
        this.connection = new ServerConnection(this.url, this);
        this.connection.connect(this.clientInfo);
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        if (n == 1005) {
            throw new SQLException(SplunkDriver.getResources().getString("nosupportScrollSensitive"));
        }
        if (n2 == 1008) {
            throw new SQLException(SplunkDriver.getResources().getString("nosupportConcurUpdatable"));
        }
        return new SplunkStatement(this, this.connection, n, n2);
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new SplunkDatabaseMetaData(this, this.connection);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        return null;
    }
}

