/*
 * Decompiled with CFR 0.152.
 */
package unity.annotation;

import java.util.HashSet;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import unity.annotation.AnnotatedSourceDatabase;
import unity.annotation.AnnotatedSourceField;
import unity.annotation.AnnotatedSourceForeignKey;
import unity.annotation.AnnotatedSourceJoin;
import unity.annotation.AnnotatedSourceKey;
import unity.annotation.AnnotatedSourceTable;
import unity.annotation.CommonMethods;
import unity.annotation.GlobalSchema;
import unity.annotation.SourceField;
import unity.annotation.SourceView;
import unity.jdbc.UnityDriver;
import unity.util.StringFunc;

public class SAXHandler
extends DefaultHandler {
    private AnnotatedSourceDatabase db = new AnnotatedSourceDatabase();
    private String lastElement;
    private int elementType;
    private int parentType;
    private AnnotatedSourceTable ast;
    private AnnotatedSourceField asf;
    private AnnotatedSourceKey key;
    private AnnotatedSourceForeignKey fkey;
    private AnnotatedSourceJoin join;
    private SourceView view;
    private String tableName;
    private GlobalSchema schema;
    private char[] buffer;
    private int bufferLength;
    private HashSet<String> ids;

    public SAXHandler(GlobalSchema globalSchema) {
        this.schema = globalSchema;
        this.buffer = new char[1000];
        this.bufferLength = 0;
    }

    public AnnotatedSourceDatabase getDatabase() {
        return this.db;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.bufferLength = 0;
        this.lastElement = string3;
        if (this.lastElement.equalsIgnoreCase("xspec")) {
            this.elementType = 0;
        } else if (this.lastElement.equalsIgnoreCase("table")) {
            this.elementType = 1;
            this.parentType = 1;
            this.ast = new AnnotatedSourceTable();
        } else if (this.lastElement.equalsIgnoreCase("field")) {
            this.elementType = 2;
            this.asf = new AnnotatedSourceField();
            this.asf.setTableName(this.tableName);
            this.asf.setTableSchema(this.ast.getSchemaName());
            this.asf.setParentTable(this.ast);
        } else if (this.lastElement.equalsIgnoreCase("primarykey")) {
            this.elementType = 3;
            this.parentType = 3;
            this.key = new AnnotatedSourceKey(this.ast);
            this.key.setTable(this.ast);
            this.ast.setPrimaryKey(this.key);
        } else if (this.lastElement.equalsIgnoreCase("foreignkey")) {
            this.elementType = 4;
            this.fkey = new AnnotatedSourceForeignKey(this.ast);
            this.fkey.setTable(this.ast);
            this.ast.addForeignKey(this.fkey);
        } else if (this.lastElement.equalsIgnoreCase("join")) {
            this.elementType = 5;
            this.join = new AnnotatedSourceJoin();
            this.ast.addJoin(this.join);
        } else if (this.lastElement.equalsIgnoreCase("view")) {
            this.elementType = 6;
            this.parentType = 6;
            this.view = new SourceView();
            this.view.setParentDatabase(this.db);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.lastElement == null || this.bufferLength == 0) {
            return;
        }
        String string4 = new String(this.buffer, 0, this.bufferLength);
        if ((string4 = string4.trim()).equals("")) {
            return;
        }
        string4 = CommonMethods.extractXMLParserSafe(string4);
        if (this.elementType == 0) {
            if (this.lastElement.equalsIgnoreCase("semanticDatabaseName")) {
                this.db.setSemanticDatabaseName(string4);
            } else if (this.lastElement.equalsIgnoreCase("databaseName")) {
                this.db.setDatabaseName(string4);
            } else if (this.lastElement.equalsIgnoreCase("databaseSystemName")) {
                this.db.setSystemDatabaseName(string4);
            } else if (this.lastElement.equalsIgnoreCase("databaseSchemaName")) {
                this.db.setSchema(string4);
            } else if (this.lastElement.equalsIgnoreCase("databaseId")) {
                this.db.setDatabaseId(this.getInt(string4));
            } else if (this.lastElement.equalsIgnoreCase("databaseProductName")) {
                this.db.setDatabaseProductName(string4);
            } else if (this.lastElement.equalsIgnoreCase("databaseProductVersion")) {
                this.db.setDatabaseProductVersion(string4);
            } else if (this.lastElement.equalsIgnoreCase("urlJDBC")) {
                this.db.setURL(string4);
            } else if (this.lastElement.equalsIgnoreCase("driverName")) {
                this.db.setDriverName(string4);
            } else if (this.lastElement.equalsIgnoreCase("driverClass")) {
                this.db.setJavaDriverClassName(string4);
            } else if (this.lastElement.equalsIgnoreCase("userid")) {
                this.db.setUserId(string4);
            } else if (this.lastElement.equalsIgnoreCase("password")) {
                this.db.setPassword(string4);
            } else if (this.lastElement.equalsIgnoreCase("delimitId")) {
                this.db.setDelimitChar(string4.charAt(0));
            } else if (this.lastElement.equalsIgnoreCase("tablesIncluded")) {
                this.db.setTableInclude(string4);
            } else if (this.lastElement.equalsIgnoreCase("tablesExcluded")) {
                this.db.setTableExclude(string4);
            } else if (this.lastElement.equalsIgnoreCase("catalogsIncluded")) {
                this.db.setCatalogInclude(string4);
            } else if (this.lastElement.equalsIgnoreCase("properties")) {
                this.db.setProperties(StringFunc.decodeProperties(string4));
            }
        } else if (this.elementType == 1) {
            if (this.lastElement.equalsIgnoreCase("semanticTableName")) {
                this.ast.setSemanticTableName(string4);
            } else if (this.lastElement.equalsIgnoreCase("tableName")) {
                this.ast.setTableName(string4);
                this.tableName = this.ast.getUnitySQLTableName();
                this.ast.setParentDatabase(this.db);
                this.db.addTable(this.ast);
                this.ids = this.schema.addTableIdentifier(this.ast);
            } else if (this.lastElement.equalsIgnoreCase("schemaName")) {
                this.ast.setSchemaName(string4);
            } else if (this.lastElement.equalsIgnoreCase("catalogName")) {
                this.ast.setCatalogName(string4);
            } else if (this.lastElement.equalsIgnoreCase("caseSensitive")) {
                this.ast.setCaseSensitive(string4.equals("true"));
            } else if (this.lastElement.equalsIgnoreCase("numTuples")) {
                this.ast.setNumTuples(this.getInt(string4));
            } else if (this.lastElement.equalsIgnoreCase("properties")) {
                this.ast.setProperties(StringFunc.decodeProperties(string4));
            }
        } else if (this.elementType == 2) {
            if (this.lastElement.equalsIgnoreCase("semanticFieldName")) {
                this.asf.setSemanticFieldName(string4);
            } else if (this.lastElement.equalsIgnoreCase("fieldName")) {
                this.asf.setColumnName(string4);
                if (this.parentType == 1 || this.parentType == 6) {
                    this.schema.addFieldIdentifier(this.asf, this.ids);
                    if (this.parentType == 1) {
                        this.ast.addField(this.asf);
                    } else if (this.parentType == 6) {
                        this.view.addField(this.asf);
                    }
                } else if (this.parentType == 3) {
                    this.key.addField(this.asf);
                }
            } else if (this.lastElement.equalsIgnoreCase("dataType")) {
                this.asf.setDataType(this.getInt(string4));
            } else if (this.lastElement.equalsIgnoreCase("dataTypeName")) {
                this.asf.setDataTypeName(string4);
            } else if (this.lastElement.equalsIgnoreCase("fieldSize")) {
                this.asf.setColumnSize(this.getInt(string4));
            } else if (this.lastElement.equalsIgnoreCase("decimalDigits")) {
                this.asf.setDecimalDigits(this.getInt(string4));
            } else if (this.lastElement.equalsIgnoreCase("numberRadixPrecision")) {
                this.asf.setNumberPrecisionRadix(this.getInt(string4));
            } else if (this.lastElement.equalsIgnoreCase("remarks")) {
                this.asf.setRemarks(string4);
            } else if (this.lastElement.equalsIgnoreCase("defaultValue")) {
                this.asf.setDefaultValue(string4);
            } else if (this.lastElement.equalsIgnoreCase("characterOctetLength")) {
                this.asf.setCharacterOctetLength(this.getInt(string4));
            } else if (this.lastElement.equalsIgnoreCase("ordinalPosition")) {
                this.asf.setOrdinalPosition(this.getInt(string4));
            } else if (this.lastElement.equalsIgnoreCase("isNullable")) {
                this.asf.setIsNullable(string4);
            } else if (this.lastElement.equalsIgnoreCase("numDistinctValues")) {
                this.asf.setNumDistinctValues(this.getInt(string4));
            } else if (this.lastElement.equalsIgnoreCase("properties")) {
                this.asf.setProperties(StringFunc.decodeProperties(string4));
            }
        } else if (this.elementType == 3) {
            SourceField sourceField;
            if (this.lastElement.equalsIgnoreCase("keyName")) {
                this.key.setName(string4);
            } else if (this.lastElement.equalsIgnoreCase("keyType")) {
                this.key.setKeyType(this.getInt(string4));
            } else if (this.lastElement.equalsIgnoreCase("fields")) {
                this.parentType = 3;
            } else if (this.lastElement.equalsIgnoreCase("fieldName") && (sourceField = this.ast.getField(StringFunc.idHashKey(new String[]{string4}))) != null) {
                this.key.addField(sourceField);
            }
        } else if (this.elementType == 4) {
            if (this.lastElement.equalsIgnoreCase("keyName")) {
                this.fkey.setName(string4);
            } else if (this.lastElement.equalsIgnoreCase("keyType")) {
                this.fkey.setKeyType(this.getInt(string4));
            } else if (this.lastElement.equalsIgnoreCase("toTableName")) {
                this.fkey.setToTableName(string4);
            } else if (this.lastElement.equalsIgnoreCase("fields")) {
                this.parentType = 4;
            } else if (this.lastElement.equalsIgnoreCase("fieldName")) {
                SourceField sourceField = this.ast.getField(StringFunc.idHashKey(new String[]{string4}));
                if (sourceField == null) throw new SAXException(UnityDriver.i18n.getString("SAXHandler.fkError") + this.fkey.getName() + UnityDriver.i18n.getString("SAXHandler.errorField") + string4);
                this.fkey.addField(sourceField);
            }
        } else if (this.elementType == 5) {
            if (this.lastElement.equalsIgnoreCase("joinName")) {
                this.join.setJoinName(string4);
            } else if (this.lastElement.equalsIgnoreCase("fromKeyName")) {
                this.join.setFromKeyName(string4);
            } else if (this.lastElement.equalsIgnoreCase("joinType")) {
                this.join.setType(this.getInt(string4));
            } else if (this.lastElement.equalsIgnoreCase("toTableName")) {
                this.join.setToTableName(string4);
            } else if (this.lastElement.equalsIgnoreCase("fromTableName")) {
                this.join.setFromTableName(string4);
            } else if (this.lastElement.equalsIgnoreCase("toKeyName")) {
                this.join.setToKeyName(string4);
            }
        } else if (this.elementType == 6) {
            if (this.lastElement.equalsIgnoreCase("semanticTableName")) {
                this.view.setSemanticTableName(string4);
            } else if (this.lastElement.equalsIgnoreCase("tableName")) {
                this.view.setTableName(string4);
                this.tableName = this.view.getUnitySQLTableName();
                this.ids = this.schema.addTableIdentifier(this.view);
            } else if (this.lastElement.equalsIgnoreCase("schemaName")) {
                this.view.setSchemaName(string4);
            } else if (this.lastElement.equalsIgnoreCase("catalogName")) {
                this.view.setCatalogName(string4);
            } else if (this.lastElement.equalsIgnoreCase("numTuples")) {
                this.view.setNumTuples(this.getInt(string4));
            } else if (this.lastElement.equalsIgnoreCase("query")) {
                this.view.setQuery(string4);
            }
        }
        this.lastElement = null;
    }

    public int getInt(String string) {
        if (string == null || string.equals("")) {
            return 0;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.buffer.length < this.bufferLength + n2) {
            char[] cArray2 = new char[this.bufferLength + n2 + 100];
            System.arraycopy(this.buffer, 0, cArray2, 0, this.bufferLength);
            this.buffer = cArray2;
        }
        System.arraycopy(cArray, n, this.buffer, this.bufferLength, n2);
        this.bufferLength += n2;
    }
}

