/*
 * Decompiled with CFR 0.152.
 */
package unity.annotation;

import java.util.Comparator;
import java.util.LinkedHashMap;
import unity.annotation.CommonMethods;
import unity.annotation.SourceTable;
import unity.engine.Attribute;
import unity.util.StringFunc;

public class SourceField {
    protected String tableCatalog;
    protected String tableSchema;
    protected String tableName;
    protected String columnName;
    protected String dataTypeName;
    protected String remarks;
    protected String defaultValue;
    protected String isNullable;
    protected String scopeCatalog;
    protected String scopeSchema;
    protected String scopeTable;
    protected int dataType;
    protected int columnSize;
    protected int decimalDigits;
    protected int numberPrecisionRadix;
    protected int nullable;
    protected int characterOctetLength;
    protected int ordinalPosition;
    protected int numDistinctValues;
    protected SourceTable parentTable;
    protected LinkedHashMap<String, Object> properties = new LinkedHashMap();
    public static final Comparator<SourceField> SourceFieldNameComparator = new Comparator<SourceField>(){

        @Override
        public int compare(SourceField sourceField, SourceField sourceField2) {
            return sourceField.getColumnName().compareTo(sourceField2.getColumnName());
        }
    };
    public static final Comparator<SourceField> SourceFieldPositionComparator = new Comparator<SourceField>(){

        @Override
        public int compare(SourceField sourceField, SourceField sourceField2) {
            return sourceField.getOrdinalPosition() - sourceField2.getOrdinalPosition();
        }
    };

    public SourceField() {
    }

    public SourceField(String string, String string2, String string3, String string4, int n, String string5, int n2, int n3, int n4, int n5, String string6, String string7, int n6, int n7, String string8) {
        this(string, string2, string3, string4, n, string5, n2, n3, n4, n5, string6, string7, n6, n7, string8, null);
    }

    public SourceField(String string, String string2, String string3, String string4, int n, String string5, int n2, int n3, int n4, int n5, String string6, String string7, int n6, int n7, String string8, SourceTable sourceTable) {
        this.tableCatalog = string;
        this.tableSchema = string2;
        this.tableName = string3;
        this.columnName = string4;
        this.dataType = n;
        this.dataTypeName = string5;
        this.columnSize = n2;
        this.decimalDigits = n3;
        this.numberPrecisionRadix = n4;
        this.nullable = n5;
        this.remarks = string6;
        this.defaultValue = string7;
        this.characterOctetLength = n6;
        this.ordinalPosition = n7;
        this.isNullable = string8;
        this.parentTable = sourceTable;
    }

    public void setParentTable(SourceTable sourceTable) {
        this.parentTable = sourceTable;
    }

    public SourceTable getParentTable() {
        return this.parentTable;
    }

    public void setTableCatalog(String string) {
        this.tableCatalog = string;
    }

    public String getTableCatalog() {
        return this.tableCatalog;
    }

    public void setTableSchema(String string) {
        this.tableSchema = string;
    }

    public String getTableSchema() {
        return this.tableSchema;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setColumnName(String string) {
        this.columnName = string;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getSQLColumnName() {
        char c = '\"';
        if (this.parentTable != null && this.parentTable.parentDatabase != null) {
            c = this.parentTable.parentDatabase.getDelimitChar();
        }
        return StringFunc.delimitName(this.columnName, c);
    }

    public String getUnitySQLColumnName() {
        char c = '\"';
        return StringFunc.delimitName(this.columnName, c);
    }

    public String getUnityFullSQLColumnName() {
        return this.parentTable.getUnityFullSQLTableName() + '.' + this.getUnitySQLColumnName();
    }

    public String getFullSQLColumnName() {
        if (this.parentTable != null) {
            return this.parentTable.getFullSQLTableName() + '.' + this.getSQLColumnName();
        }
        return this.getSQLColumnName();
    }

    public void setDataType(int n) {
        this.dataType = n;
    }

    public void setDataTypeName(String string) {
        this.dataTypeName = string;
    }

    public String getDataTypeName() {
        return this.dataTypeName;
    }

    public void setColumnSize(int n) {
        this.columnSize = n;
    }

    public int getColumnSize() {
        return this.columnSize;
    }

    public int getByteSize() {
        if (this.columnSize == 0) {
            if (this.dataType == 4 || this.dataType == 6) {
                return 4;
            }
            if (this.dataType == 8 || this.dataType == -5 || this.dataType == 93 || this.dataType == 92 || this.dataType == 91) {
                return 8;
            }
            if (this.dataType == 12) {
                return this.columnSize > this.characterOctetLength ? this.columnSize : this.characterOctetLength;
            }
        }
        if (this.columnSize > 1000) {
            return 1000;
        }
        return this.columnSize;
    }

    public void setDecimalDigits(int n) {
        this.decimalDigits = n;
    }

    public int getDecimalDigits() {
        return this.decimalDigits;
    }

    public void setNumberPrecisionRadix(int n) {
        this.numberPrecisionRadix = n;
    }

    public int getNumberPrecisionRadix() {
        return this.numberPrecisionRadix;
    }

    public void setNullable(int n) {
        this.nullable = n;
    }

    public int getNullable() {
        return this.nullable;
    }

    public void setRemarks(String string) {
        this.remarks = string;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setCharacterOctetLength(int n) {
        this.characterOctetLength = n;
    }

    public int getCharacterOctetLength() {
        return this.characterOctetLength;
    }

    public void setOrdinalPosition(int n) {
        this.ordinalPosition = n;
    }

    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public void setIsNullable(String string) {
        this.isNullable = string;
    }

    public String getIsNullable() {
        return this.isNullable;
    }

    public int getNumDistinctValues() {
        return this.numDistinctValues;
    }

    public void setNumDistinctValues(int n) {
        this.numDistinctValues = n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(2000);
        stringBuilder.append("           Field Name: " + this.columnName + "\n");
        stringBuilder.append("            Table Catalog: " + this.tableCatalog + "\n");
        stringBuilder.append("            Table Schema: " + this.tableSchema + "\n");
        stringBuilder.append("            Table Name: " + this.tableName + "\n");
        stringBuilder.append("            Data Type: " + this.dataType + "\n");
        stringBuilder.append("            Data Type: " + this.dataTypeName + "\n");
        stringBuilder.append("            size: " + this.columnSize + "\n");
        stringBuilder.append("            Field Size: " + this.columnSize + "\n");
        stringBuilder.append("            Decimal Digits: " + this.decimalDigits + "\n");
        stringBuilder.append("            Radix Precision: " + this.numberPrecisionRadix + "\n");
        stringBuilder.append("            Nullable: " + this.nullable + "\n");
        stringBuilder.append("            Remarks: " + this.remarks + "\n");
        stringBuilder.append("            Default Value: " + this.defaultValue + "\n");
        stringBuilder.append("            Character Length: " + this.characterOctetLength + "\n");
        stringBuilder.append("            Ordinal Position: " + this.ordinalPosition + "\n");
        stringBuilder.append("            Is Nullable: " + this.isNullable + "\n");
        stringBuilder.append("            # distinct values: " + this.numDistinctValues + "\n");
        return stringBuilder.toString();
    }

    public String toShortString() {
        StringBuilder stringBuilder = new StringBuilder(2000);
        stringBuilder.append(this.columnName);
        stringBuilder.append(" ");
        stringBuilder.append(this.dataTypeName);
        return stringBuilder.toString();
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer(2000);
        stringBuffer.append("        <fieldName>" + CommonMethods.exportString(this.columnName) + "</fieldName>\n");
        stringBuffer.append("        <dataType>" + this.dataType + "</dataType>\n");
        stringBuffer.append("        <dataTypeName>" + CommonMethods.exportString(this.dataTypeName) + "</dataTypeName>\n");
        stringBuffer.append("        <fieldSize>" + this.columnSize + "</fieldSize>\n");
        stringBuffer.append("        <decimalDigits>" + this.decimalDigits + "</decimalDigits>\n");
        stringBuffer.append("        <numberRadixPrecision>" + this.numberPrecisionRadix + "</numberRadixPrecision>\n");
        stringBuffer.append("        <remarks>" + CommonMethods.exportString(this.remarks) + "</remarks>\n");
        stringBuffer.append("        <defaultValue>" + CommonMethods.exportString(this.defaultValue) + "</defaultValue>\n");
        stringBuffer.append("        <characterOctetLength>" + this.characterOctetLength + "</characterOctetLength>\n");
        stringBuffer.append("        <ordinalPosition>" + this.ordinalPosition + "</ordinalPosition>\n");
        stringBuffer.append("        <isNullable>" + CommonMethods.exportString(this.isNullable) + "</isNullable>\n");
        stringBuffer.append("        <numDistinctValues>" + this.numDistinctValues + "</numDistinctValues>");
        if (this.properties != null && this.properties.size() > 0) {
            stringBuffer.append("\n        <properties>" + StringFunc.encodeProperties(this.properties) + "</properties>");
        }
        return stringBuffer.toString();
    }

    public String toXMLKey() {
        return "<fieldName>" + CommonMethods.exportString(this.columnName) + "</fieldName>";
    }

    public int getDataType() {
        return this.dataType;
    }

    public int getJavaDataType() {
        int n = this.dataType;
        if (n == 4 && this.dataTypeName.toLowerCase().indexOf("unsigned") >= 0) {
            return -5;
        }
        return n;
    }

    public boolean isBlob() {
        return this.dataType == 2004 || this.dataType == 2005 || this.dataType == -4 || this.dataType == -1 || this.dataType == 1111;
    }

    public int getColumnDisplaySize() {
        if (Attribute.isNumberType(this.dataType)) {
            return 8;
        }
        int n = this.columnSize;
        if (n == 0) {
            n = this.getByteSize();
        }
        return n > 50 ? 50 : n;
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public void setProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    public void setProperties(LinkedHashMap<String, Object> linkedHashMap) {
        this.properties = linkedHashMap;
    }

    public static void setSizeByType(SourceField sourceField, int n) {
        int n2 = sourceField.getDataType();
        switch (n2) {
            case 4: {
                sourceField.setColumnSize(10);
                sourceField.setCharacterOctetLength(10);
                sourceField.setNumberPrecisionRadix(10);
                sourceField.setDecimalDigits(0);
                break;
            }
            case -5: {
                sourceField.setColumnSize(20);
                sourceField.setCharacterOctetLength(20);
                sourceField.setNumberPrecisionRadix(20);
                sourceField.setDecimalDigits(0);
                break;
            }
            case 8: {
                sourceField.setColumnSize(20);
                sourceField.setCharacterOctetLength(20);
                sourceField.setNumberPrecisionRadix(21);
                sourceField.setDecimalDigits(0);
                break;
            }
            case 91: {
                sourceField.setColumnSize(20);
                sourceField.setCharacterOctetLength(20);
                sourceField.setNumberPrecisionRadix(20);
                sourceField.setDecimalDigits(0);
                break;
            }
            case 93: {
                sourceField.setColumnSize(25);
                sourceField.setCharacterOctetLength(25);
                sourceField.setNumberPrecisionRadix(25);
                sourceField.setDecimalDigits(0);
                break;
            }
            default: {
                sourceField.setColumnSize(n);
                sourceField.setCharacterOctetLength(n);
                sourceField.setNumberPrecisionRadix(n);
                sourceField.setDecimalDigits(0);
            }
        }
    }
}

