/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import java.sql.SQLException;
import unity.engine.Attribute;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.functions.Expression;
import unity.query.LQExprNode;
import unity.query.SubQuery;

public class ExtractAttributeParentQuery
extends Expression {
    private static final long serialVersionUID = 1L;
    private int attrLoc;
    private SubQuery subquery;

    public ExtractAttributeParentQuery(SubQuery subQuery, int n) {
        this.subquery = subQuery;
        this.attrLoc = n;
    }

    @Override
    public Object evaluate(Tuple tuple) throws SQLException {
        Tuple tuple2 = this.subquery.getParentTuple();
        if (tuple2 == null) {
            return null;
        }
        return tuple2.getObject(this.attrLoc);
    }

    public int getAttributeLoc() {
        return this.attrLoc;
    }

    @Override
    public String toString(Relation relation) {
        Attribute attribute = relation.getAttribute(this.attrLoc);
        Object object = attribute.getReference();
        if (object != null && object instanceof LQExprNode) {
            return object.toString() + " " + attribute.getName();
        }
        return relation.getAttribute(this.attrLoc).getName();
    }

    public String toString() {
        return "Parent tuple attribute loc: " + this.attrLoc;
    }
}

