/*
 * Decompiled with CFR 0.152.
 */
package unity.generic.jdbc;

import unity.engine.Attribute;
import unity.query.GQFieldRef;
import unity.query.LQNode;

public class Parameter {
    private GQFieldRef fieldRef;
    private int index;
    private Object value = "?";
    private int SQLtype;

    public Parameter(int n) {
        this.index = n;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object, int n) {
        this.value = object;
        this.SQLtype = n;
        this.updateQueryTree();
    }

    public void updateQueryTree() {
        Object object;
        if (this.fieldRef != null && (object = this.fieldRef.getReference()) != null && object instanceof LQNode) {
            ((LQNode)object).setContent(this);
        }
    }

    public void setNullValue(int n) {
        this.setValue(null, n);
    }

    public int getIndex() {
        return this.index;
    }

    public int getType() {
        return this.SQLtype;
    }

    public void setType(int n) {
        this.SQLtype = n;
    }

    public GQFieldRef getFieldRef() {
        return this.fieldRef;
    }

    public void setFieldRef(GQFieldRef gQFieldRef) {
        this.fieldRef = gQFieldRef;
    }

    public String toString() {
        return "?" + this.index + " Value: " + this.value;
    }

    public String toSQLString() {
        if (this.value == null) {
            return "null";
        }
        if (Attribute.isStringType(this.SQLtype) || Attribute.isDateType(this.SQLtype)) {
            return "'" + this.value + '\'';
        }
        return this.value.toString();
    }

    public static Object retrieveParameterValue(Object object) {
        if (object != null && object instanceof Parameter) {
            return ((Parameter)object).getValue();
        }
        return null;
    }
}

