/*
 * Decompiled with CFR 0.152.
 */
package unity.generic.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.sql.rowset.serial.SerialBlob;
import mongodb.jdbc.MongoArray;
import unity.engine.Relation;
import unity.engine.TableData;
import unity.engine.Tuple;
import unity.generic.jdbc.ResultSetMetaDataImpl;

public class ResultSetImpl
implements ResultSet {
    protected static final Locale locale = Locale.getDefault();
    protected static ResourceBundle resources = ResourceBundle.getBundle("resources/generic/ResultSetImpl", locale);
    protected boolean _closed = false;
    protected int _fetchsize;
    protected int _resultSetConcurrency = 1007;
    protected int _resultSetType = 1003;
    protected SQLWarning _warnings = null;
    protected boolean _wasNull = false;
    protected String[] columnHeaders;
    protected ResultSetMetaDataImpl meta;
    protected Statement stmt;
    protected TableData rows;
    protected int cursor;
    protected int lastIndex;
    protected Relation relation;
    protected Tuple currentRow;

    @Override
    public boolean absolute(int n) throws SQLException {
        if (this._resultSetType == 1003) {
            throw new SQLException(resources.getString("forwardonly"));
        }
        if (n < 0) {
            this.cursor = this.rows.afterLast(this.currentRow);
            this.cursor += n;
            if (this.cursor < 1) {
                this.cursor = 0;
                return false;
            }
            return this.rows.get(this.cursor, this.currentRow);
        }
        if (n > 0) {
            this.cursor = n;
            boolean bl = this.rows.get(this.cursor, this.currentRow);
            if (!bl) {
                this.cursor = this.rows.afterLast(this.currentRow);
            }
            return bl;
        }
        return false;
    }

    @Override
    public void afterLast() throws SQLException {
        if (this._resultSetType == 1003) {
            throw new SQLException(resources.getString("forwardonly"));
        }
        this.cursor = this.rows.afterLast(this.currentRow);
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this._resultSetType == 1003) {
            throw new SQLException(resources.getString("forwardonly"));
        }
        this.cursor = 0;
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void clearWarnings() throws SQLException {
        this._warnings = null;
    }

    @Override
    public void close() throws SQLException {
        if (this._closed) {
            return;
        }
        this.rows.clear();
        this._closed = true;
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public int findColumn(String string) throws SQLException {
        if (string.equals("\"\"")) {
            return 0;
        }
        String string2 = string.trim();
        for (int i = 0; i < this.columnHeaders.length; ++i) {
            if (!string2.equalsIgnoreCase(this.columnHeaders[i])) continue;
            return i + 1;
        }
        throw new SQLException(resources.getString("unknownColumn") + string);
    }

    @Override
    public boolean first() throws SQLException {
        if (this._resultSetType == 1003) {
            throw new SQLException(resources.getString("forwardonly"));
        }
        this.cursor = 1;
        return this.absolute(1);
    }

    @Override
    public Array getArray(int n) throws SQLException {
        this._wasNull = false;
        Object object = this.getObject(n);
        if (object instanceof Array) {
            return (Array)this.getObject(n);
        }
        if (object instanceof List) {
            MongoArray mongoArray = (MongoArray)this.stmt.getConnection().createArrayOf("test", ((ArrayList)object).toArray());
            String string = this.getMetaData().getColumnName(n);
            mongoArray.setName(string);
            return mongoArray;
        }
        return null;
    }

    @Override
    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        return this.getBinaryStream(n);
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            this._wasNull = true;
            return null;
        }
        this._wasNull = false;
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        if (object instanceof Long) {
            return new BigDecimal((Long)object);
        }
        if (object instanceof Integer) {
            return new BigDecimal((Integer)object);
        }
        if (object instanceof Double) {
            return new BigDecimal((Double)object);
        }
        try {
            BigDecimal bigDecimal = new BigDecimal(object.toString());
            return bigDecimal;
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException(resources.getString("bigdecimalError") + numberFormatException);
        }
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.getBigDecimal(n);
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            this._wasNull = true;
            return null;
        }
        this._wasNull = false;
        if (object instanceof InputStream) {
            return (InputStream)object;
        }
        byte[] byArray = this.getBytes(n);
        if (byArray != null) {
            return new ByteArrayInputStream(byArray);
        }
        return null;
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        Object object = this.getObject(n);
        boolean bl = this._wasNull = object == null;
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            SerialBlob serialBlob = new SerialBlob(byArray);
            return serialBlob;
        }
        return null;
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            this._wasNull = true;
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    @Override
    public byte getByte(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            this._wasNull = true;
            return 0;
        }
        this._wasNull = false;
        if (object instanceof Byte) {
            return (Byte)object;
        }
        return 0;
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        Object object = this.getObject(n);
        boolean bl = this._wasNull = object == null;
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        return null;
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            this._wasNull = true;
            return null;
        }
        this._wasNull = false;
        if (object instanceof Reader) {
            return (Reader)object;
        }
        byte[] byArray = this.getBytes(n);
        if (byArray == null) {
            return null;
        }
        return new StringReader(new String(byArray));
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            this._wasNull = true;
            return null;
        }
        this._wasNull = false;
        if (object instanceof Clob) {
            return (Clob)object;
        }
        return null;
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this._resultSetConcurrency;
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLException(resources.getString("cursorError"));
    }

    @Override
    public Date getDate(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            this._wasNull = true;
            return null;
        }
        this._wasNull = false;
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)object;
            return new Date(date.getTime());
        }
        if (object instanceof String) {
            DateFormat dateFormat = DateFormat.getDateInstance();
            try {
                java.util.Date date = dateFormat.parse((String)object);
                return new Date(date.getTime());
            }
            catch (ParseException parseException) {
                throw new SQLException(resources.getString("conversionError") + parseException);
            }
        }
        throw new SQLException(resources.getString("conversionError") + object + " Class: " + object.getClass());
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.getDate(n);
    }

    @Override
    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    @Override
    public double getDouble(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            this._wasNull = true;
            return 0.0;
        }
        this._wasNull = false;
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).doubleValue();
        }
        if (object instanceof Integer) {
            return ((Integer)object).doubleValue();
        }
        return 0.0;
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 0;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this._fetchsize;
    }

    @Override
    public float getFloat(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            this._wasNull = true;
            return 0.0f;
        }
        this._wasNull = false;
        if (object instanceof Float) {
            return ((Float)object).floatValue();
        }
        if (object instanceof Double) {
            return (float)((Double)object).doubleValue();
        }
        if (object instanceof BigDecimal) {
            return (float)((BigDecimal)object).doubleValue();
        }
        if (object instanceof Integer) {
            return (float)((Integer)object).doubleValue();
        }
        return 0.0f;
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    @Override
    public int getHoldability() throws SQLException {
        return 2;
    }

    @Override
    public int getInt(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            this._wasNull = true;
            return 0;
        }
        this._wasNull = false;
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Long) {
            return ((Long)object).intValue();
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).intValue();
        }
        if (object instanceof Float) {
            return ((Float)object).intValue();
        }
        if (object instanceof Double) {
            return ((Double)object).intValue();
        }
        return 0;
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    @Override
    public long getLong(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            this._wasNull = true;
            return 0L;
        }
        this._wasNull = false;
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Integer) {
            return ((Integer)object).longValue();
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).longValue();
        }
        if (object instanceof Float) {
            return ((Float)object).longValue();
        }
        if (object instanceof Double) {
            return ((Double)object).longValue();
        }
        return 0L;
    }

    @Override
    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new ResultSetMetaDataImpl(this.relation);
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        return this.getCharacterStream(n);
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        return this.getNCharacterStream(this.findColumn(string));
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        return this.getNClob(this.findColumn(string));
    }

    @Override
    public String getNString(int n) throws SQLException {
        return this.getString(n);
    }

    @Override
    public String getNString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    @Override
    public Object getObject(int n) throws SQLException {
        Object object = null;
        object = this._resultSetType == 1003 ? this.currentRow.getObject(n - 1) : this.currentRow.getObject(n - 1);
        this._wasNull = object == null;
        return object;
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        return (T)this.getObject(n);
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(n);
    }

    @Override
    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        return this.getObject(this.findColumn(string), clazz);
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        Object object = this.getObject(n);
        boolean bl = this._wasNull = object == null;
        if (object instanceof Ref) {
            return (Ref)object;
        }
        return null;
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    @Override
    public int getRow() throws SQLException {
        return this.cursor;
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public short getShort(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            this._wasNull = true;
            return 0;
        }
        this._wasNull = false;
        if (object instanceof Short) {
            return (Short)object;
        }
        if (object instanceof Integer) {
            return ((Integer)object).shortValue();
        }
        if (object instanceof Long) {
            return ((Long)object).shortValue();
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).shortValue();
        }
        if (object instanceof Float) {
            return ((Float)object).shortValue();
        }
        if (object instanceof Double) {
            return ((Double)object).shortValue();
        }
        return 0;
    }

    @Override
    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        return this.getSQLXML(this.findColumn(string));
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.stmt;
    }

    @Override
    public String getString(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            this._wasNull = true;
            return null;
        }
        this._wasNull = false;
        if (object instanceof String) {
            return (String)object;
        }
        return object.toString();
    }

    @Override
    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    @Override
    public Time getTime(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            this._wasNull = true;
            return null;
        }
        this._wasNull = false;
        return (Time)object;
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.getTime(n);
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            this._wasNull = true;
            return null;
        }
        this._wasNull = false;
        return (Timestamp)object;
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.getTimestamp(n);
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    @Override
    public int getType() throws SQLException {
        return this._resultSetType;
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int n) throws SQLException {
        return this.getBinaryStream(n);
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    @Override
    public URL getURL(int n) throws SQLException {
        Object object = this.getObject(n);
        boolean bl = this._wasNull = object == null;
        if (object instanceof URL) {
            return (URL)object;
        }
        throw new SQLException(resources.getString("convertError"));
    }

    @Override
    public URL getURL(String string) throws SQLException {
        return this.getURL(this.findColumn(string));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this._warnings;
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.cursor > this.lastIndex;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.cursor < 0 && this.lastIndex > 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._closed;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.cursor == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.cursor == this.lastIndex;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public boolean last() throws SQLException {
        if (this._resultSetType == 1003) {
            throw new SQLException(resources.getString("forwardonly"));
        }
        return this.absolute(-1);
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public boolean next() throws SQLException {
        ++this.cursor;
        if (this._resultSetType == 1003) {
            return this.rows.next(this.currentRow);
        }
        return this.rows.get(this.cursor, this.currentRow);
    }

    @Override
    public boolean previous() throws SQLException {
        if (this._resultSetType == 1003) {
            throw new SQLException(resources.getString("forwardonly"));
        }
        if (this.cursor > 0) {
            --this.cursor;
            return this.rows.get(this.cursor, this.currentRow);
        }
        return false;
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public boolean relative(int n) throws SQLException {
        if (this._resultSetType == 1003) {
            throw new SQLException(resources.getString("forwardonly"));
        }
        return this.absolute(this.cursor + n);
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        this.stmt.setFetchSize(this._fetchsize);
        this._fetchsize = this.stmt.getFetchSize();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        this.updateArray(this.findColumn(string), array);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, l);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        this.updateBlob(this.findColumn(string), inputStream);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        this.updateBlob(this.findColumn(string), inputStream, l);
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        this.updateBlob(this.findColumn(string), blob);
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, l);
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        this.updateClob(this.findColumn(string), clob);
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        this.updateClob(this.findColumn(string), reader);
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        this.updateClob(this.findColumn(string), reader);
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        this.updateNCharacterStream(this.findColumn(string), reader);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.updateNCharacterStream(this.findColumn(string), reader, l);
    }

    @Override
    public void updateNClob(int n, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        this.updateNClob(this.findColumn(string), nClob);
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        this.updateNClob(this.findColumn(string), reader);
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        this.updateNClob(this.findColumn(string), reader, l);
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        this.updateNString(this.findColumn(string), string2);
    }

    @Override
    public void updateNull(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        this.updateRef(this.findColumn(string), ref);
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        this.updateRowId(this.findColumn(string), rowId);
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        this.updateSQLXML(this.findColumn(string), sQLXML);
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this._wasNull;
    }
}

