/*
 * Decompiled with CFR 0.152.
 */
package unity.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import unity.annotation.GlobalSchema;
import unity.engine.Attribute;
import unity.jdbc.UnityConnection;
import unity.jdbc.UnityDriver;
import unity.jdbc.UnityStatement;
import unity.util.Convert;

public class UnityPreparedStatement
extends UnityStatement
implements PreparedStatement {
    private String originalQueryString;
    private ArrayList<Parameter> parameters;
    private boolean hasBlob = false;
    private ArrayList<Object> streams;

    public UnityPreparedStatement(UnityConnection unityConnection, int n, int n2, GlobalSchema globalSchema, String string, long l, long l2) {
        super(unityConnection, n, n2, globalSchema, l, l2);
        this.originalQueryString = string;
        this.parameters = new ArrayList();
        this.streams = new ArrayList();
        this.parseQueryParameters(this.originalQueryString);
    }

    private void parseQueryParameters(String string) {
        int n;
        String string2 = string;
        int n2 = -1;
        while ((n = string2.indexOf(63)) != -1) {
            this.parameters.add(new Parameter(n2 += n + 1));
            string2 = string2.substring(n + 1);
        }
    }

    public ArrayList<Object> getStreams() {
        return this.streams;
    }

    private String combineString() {
        String string = this.originalQueryString;
        for (int i = this.parameters.size() - 1; i >= 0; --i) {
            Parameter parameter = this.parameters.get(i);
            int n = parameter.getIndex();
            int n2 = parameter.getType();
            string = n2 == -3 || n2 == 2004 || n2 == 2005 || n2 == 2011 || n2 == -16 || n2 == -4 || n2 == -1 ? string.substring(0, n) + "'!!BLOB!!'" + string.substring(n + 1) : string.substring(0, n) + parameter.getValue() + string.substring(n + 1);
        }
        return string;
    }

    private void setParameter(int n, String string, int n2) throws SQLException {
        if (n < 1 || n > this.parameters.size()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        this.parameters.get(n - 1).setValue(string, n2);
    }

    private void setParameter(int n, byte[] byArray, int n2) {
        if (n < 1 || n > this.parameters.size()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        this.parameters.get(n - 1).setValue(byArray, n2);
    }

    private void setParameter(int n, Object object, int n2) {
        if (n < 1 || n > this.parameters.size()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        this.parameters.get(n - 1).setObjValue(object);
        this.parameters.get(n - 1).setType(n2);
    }

    private void setParameterNull(int n, int n2) throws SQLException {
        if (n < 1 || n > this.parameters.size()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        this.parameters.get(n - 1).setNullValue(n2);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return super.executeQuery(this.combineString());
    }

    @Override
    public int executeUpdate() throws SQLException {
        return super.executeUpdate(this.combineString());
    }

    @Override
    public boolean execute() throws SQLException {
        return super.execute(this.combineString());
    }

    @Override
    public void setNull(int n, int n2) throws SQLException {
        this.setParameterNull(n, n2);
    }

    @Override
    public void setBoolean(int n, boolean bl) throws SQLException {
        this.setParameter(n, bl ? "1" : "0", 16);
    }

    @Override
    public void setByte(int n, byte by) throws SQLException {
        this.setParameter(n, Byte.toString(by), 1);
    }

    @Override
    public void setShort(int n, short s) throws SQLException {
        this.setParameter(n, Short.toString(s), 5);
    }

    @Override
    public void setInt(int n, int n2) throws SQLException {
        this.setParameter(n, Integer.toString(n2), 4);
    }

    @Override
    public void setLong(int n, long l) throws SQLException {
        this.setParameter(n, Long.toString(l), -5);
    }

    @Override
    public void setFloat(int n, float f) throws SQLException {
        this.setParameter(n, Float.toString(f), 6);
    }

    @Override
    public void setDouble(int n, double d) throws SQLException {
        this.setParameter(n, Double.toString(d), 8);
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.setParameter(n, bigDecimal.toString(), 3);
    }

    public void setStringNQ(int n, String string) throws SQLException {
        if (string == null) {
            this.setNull(n, 12);
            return;
        }
        this.setParameter(n, string, 12);
    }

    @Override
    public void setString(int n, String string) throws SQLException {
        if (string == null) {
            this.setNull(n, 12);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder((int)((double)string.length() * 1.1 + 2.0));
        stringBuilder.append('\'');
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\u0000': {
                    stringBuilder.append('\\');
                    stringBuilder.append('0');
                    continue block7;
                }
                case '\\': {
                    stringBuilder.append('\\');
                    stringBuilder.append('\\');
                    continue block7;
                }
                case '\n': {
                    stringBuilder.append('\\');
                    stringBuilder.append('n');
                    continue block7;
                }
                case '\r': {
                    stringBuilder.append('\\');
                    stringBuilder.append('r');
                    continue block7;
                }
                case '\'': {
                    stringBuilder.append('\'');
                    stringBuilder.append('\'');
                    continue block7;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        stringBuilder.append('\'');
        this.setParameter(n, stringBuilder.toString(), 12);
    }

    @Override
    public void setBytes(int n, byte[] byArray) throws SQLException {
        if (byArray == null) {
            this.setNull(n, -2);
            return;
        }
        this.setParameter(n, byArray, -2);
    }

    @Override
    public void setDate(int n, Date date) throws SQLException {
        if (date == null) {
            this.setNull(n, 91);
            return;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("''yyyy-MM-dd''");
        this.setParameter(n, simpleDateFormat.format(date), 91);
    }

    @Override
    public void setTime(int n, Time time) throws SQLException {
        if (time == null) {
            this.setNull(n, 92);
            return;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("''HH:mm:ss''");
        this.setParameter(n, simpleDateFormat.format(time), 92);
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (timestamp == null) {
            this.setNull(n, 93);
            return;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("''yyyy-MM-dd HH:mm:ss.S''");
        this.setParameter(n, simpleDateFormat.format(timestamp), 93);
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (inputStream == null) {
            this.setNull(n, -3);
            return;
        }
        this.setParameter(n, inputStream, -3);
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (inputStream == null) {
            this.setNull(n, -3);
            return;
        }
        this.setParameter(n, inputStream, -3);
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (inputStream == null) {
            this.setNull(n, -3);
            return;
        }
        this.hasBlob = true;
        this.setParameter(n, inputStream, -3);
    }

    @Override
    public void clearParameters() throws SQLException {
        for (Parameter parameter : this.parameters) {
            parameter.setValue("?", 0);
        }
    }

    @Override
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.setObject(n, object, n2);
    }

    @Override
    public void setObject(int n, Object object, int n2) throws SQLException {
        if (object == null) {
            this.setNull(n, n2);
            return;
        }
        int n3 = Attribute.getType(object);
        if (n3 == n2) {
            this.setObject(n, object);
        } else {
            try {
                Object object2 = Convert.convertObject(object, n2);
                this.setObject(n, object2);
            }
            catch (Exception exception) {
                throw new SQLException("Type conversion error. Exception: " + exception);
            }
        }
    }

    @Override
    public void setObject(int n, Object object) throws SQLException {
        if (object == null) {
            this.setNull(n, 1111);
            return;
        }
        if (object instanceof Boolean) {
            this.setBoolean(n, (Boolean)object);
        } else if (object instanceof Byte) {
            this.setByte(n, (Byte)object);
        } else if (object instanceof Short) {
            this.setShort(n, (Short)object);
        } else if (object instanceof Integer) {
            this.setInt(n, (Integer)object);
        } else if (object instanceof Long) {
            this.setLong(n, (Long)object);
        } else if (object instanceof Float) {
            this.setFloat(n, ((Float)object).floatValue());
        } else if (object instanceof Double) {
            this.setDouble(n, (Double)object);
        } else if (object instanceof BigDecimal) {
            this.setBigDecimal(n, (BigDecimal)object);
        } else if (object instanceof String) {
            this.setString(n, (String)object);
        } else if (object instanceof byte[]) {
            this.setBytes(n, (byte[])object);
        } else if (object instanceof Date) {
            this.setDate(n, (Date)object);
        } else if (object instanceof Time) {
            this.setTime(n, (Time)object);
        } else if (object instanceof Timestamp) {
            this.setTimestamp(n, (Timestamp)object);
        } else if (object instanceof java.util.Date) {
            this.setDate(n, new Date(((java.util.Date)object).getTime()));
        } else if (object instanceof Serializable) {
            this.setSerializableObject(n, object);
        }
    }

    private void setSerializableObject(int n, Object object) throws SQLException {
        throw new SQLException(UnityDriver.i18n.getString("UnityPreparedStatement.CannotSerialize"));
    }

    @Override
    public void addBatch() throws SQLException {
    }

    @Override
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new SQLException();
    }

    @Override
    public void setRef(int n, Ref ref) throws SQLException {
        throw new SQLException();
    }

    @Override
    public void setBlob(int n, Blob blob) throws SQLException {
        throw new SQLException();
    }

    @Override
    public void setClob(int n, Clob clob) throws SQLException {
        throw new SQLException();
    }

    @Override
    public void setArray(int n, Array array) throws SQLException {
        throw new SQLException();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return null;
    }

    @Override
    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.setDate(n, date);
    }

    @Override
    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.setTime(n, time);
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestamp(n, timestamp);
    }

    @Override
    public void setNull(int n, int n2, String string) throws SQLException {
        this.setNull(n, n2);
    }

    @Override
    public void setURL(int n, URL uRL) throws SQLException {
        this.setString(n, uRL.toString());
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return null;
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        throw new SQLException();
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLException();
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.setHasBlob(true);
        if (inputStream == null) {
            this.setNull(n, -3);
            return;
        }
        this.setParameter(n, inputStream, -3);
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLException();
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        throw new SQLException();
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLException();
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException {
        throw new SQLException();
    }

    @Override
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new SQLException();
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException {
        throw new SQLException();
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException {
        throw new SQLException();
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        throw new SQLException();
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new SQLException();
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException {
        throw new SQLException();
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException {
        throw new SQLException();
    }

    @Override
    public void setNString(int n, String string) throws SQLException {
        throw new SQLException();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return null;
    }

    public String getSQLStatement() throws SQLException {
        return this.combineString();
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException {
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException {
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
    }

    public void setHasBlob(boolean bl) {
        this.hasBlob = bl;
    }

    public boolean isHasBlob() {
        return this.hasBlob;
    }

    public ArrayList<Parameter> getParameters() {
        return this.parameters;
    }

    public class Parameter {
        private int index;
        private String value = "?";
        private int SQLtype;
        private byte[] byteValue = null;
        private Object objValue;
        private long length;

        public Parameter(int n) {
            this.index = n;
        }

        public String getValue() {
            if (this.byteValue != null) {
                return "byte value goes here";
            }
            return this.value;
        }

        public void setValue(String string, int n) {
            this.value = string;
            this.SQLtype = n;
        }

        public void setValue(byte[] byArray, int n) {
            this.byteValue = byArray;
            this.SQLtype = n;
        }

        public int getIndex() {
            return this.index;
        }

        public int getType() {
            return this.SQLtype;
        }

        public void setType(int n) {
            this.SQLtype = n;
        }

        public void setObjValue(Object object) {
            this.objValue = object;
        }

        public void setNullValue(int n) {
            this.value = null;
            this.SQLtype = n;
        }

        public Object getObjValue() {
            return this.objValue;
        }

        public void setLength(long l) {
            this.length = l;
        }

        public long getLength() {
            return this.length;
        }
    }
}

