/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import unity.engine.Attribute;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.jdbc.UnityConnection;
import unity.jdbc.UnityDriver;
import unity.operators.DistributedJoin;
import unity.operators.Operator;
import unity.operators.ResultSetScan;
import unity.predicates.JoinPredicate;
import unity.query.GQDatabaseRef;
import unity.query.GQFieldRef;
import unity.query.GQTableRef;
import unity.query.GlobalQuery;
import unity.query.LQExprNode;
import unity.query.LQJoinNode;
import unity.query.LQNode;
import unity.query.LQProjNode;
import unity.query.LQTree;
import unity.query.Optimizer;
import unity.util.StringFunc;

public class DistributedJoinSQL
extends DistributedJoin {
    private static final long serialVersionUID = 1L;
    private Tuple leftTuple;
    private boolean hasLeft;
    private String temporaryTableName;
    private Connection con;
    private GQDatabaseRef dbref;

    public DistributedJoinSQL(Operator[] operatorArray, JoinPredicate joinPredicate, boolean bl, GlobalQuery globalQuery, GQDatabaseRef gQDatabaseRef) {
        super(operatorArray, joinPredicate, bl, globalQuery);
        this.dbref = gQDatabaseRef;
    }

    @Override
    public void init() throws SQLException {
        Serializable serializable;
        LQNode lQNode;
        int n = 0;
        int n2 = 1;
        this.input[n].init();
        this.leftTuple = new Tuple(this.firstRelation);
        this.hasLeft = true;
        if (!this.input[n].next(this.leftTuple)) {
            this.hasLeft = false;
            return;
        }
        UnityConnection unityConnection = this.gq.getConnection();
        String string = this.input[n2].getQueryNode().getDatabase().getName();
        this.con = unityConnection.getConnection(string);
        this.con.setAutoCommit(false);
        this.temporaryTableName = "TEMP_TABLE";
        int n3 = this.swap ? 1 : 0;
        GQFieldRef gQFieldRef = (GQFieldRef)this.pred.getQueryNode().getChild(n3).getContent();
        GQTableRef gQTableRef = gQFieldRef.getTable();
        String string2 = gQTableRef.getAliasName();
        this.temporaryTableName = this.temporaryTableName + '_' + string2;
        this.temporaryTableName = this.temporaryTableName + new Date().getTime();
        gQTableRef.setAliasName(this.temporaryTableName);
        GQTableRef gQTableRef2 = this.createTemporary(this.temporaryTableName);
        this.writeTuples(n);
        ResultSetScan resultSetScan = (ResultSetScan)this.input[n2];
        LQNode lQNode2 = resultSetScan.getQueryNode();
        LQProjNode lQProjNode = (LQProjNode)lQNode2;
        for (int i = 0; i < this.firstRelation.getNumAttributes(); ++i) {
            lQNode = new LQExprNode();
            lQNode.setType(100);
            serializable = this.firstRelation.getAttribute(i);
            lQNode.setContent(((Attribute)serializable).getReference());
            lQProjNode.addNoDupExpression((LQExprNode)lQNode);
        }
        LQExprNode lQExprNode = new LQExprNode();
        lQExprNode.setType(6);
        lQExprNode.setContent(gQTableRef2);
        lQNode = new LQJoinNode();
        ((LQJoinNode)lQNode).setCondition(this.pred.getQueryNode());
        serializable = lQNode2.getChild();
        lQNode.addChild(lQExprNode);
        lQNode.addChild((LQNode)serializable);
        ((LQNode)serializable).setParent(lQNode);
        lQNode2.setChild(0, lQNode);
        lQNode.setParent(lQNode2);
        LQTree.printTree(lQNode2, 0);
        Statement statement = this.con.createStatement();
        this.rs = new ResultSetScan(statement.executeQuery(Optimizer.buildSQL(lQNode2)));
        this.rs.init();
    }

    @Override
    public boolean next(Tuple tuple) throws SQLException {
        return this.rs.next(tuple);
    }

    @Override
    public void close() throws SQLException {
        super.close();
        if (!this.hasLeft) {
            return;
        }
        this.con = null;
        UnityConnection unityConnection = this.gq.getConnection();
        String string = this.input[1].getQueryNode().getDatabase().getName();
        this.con = unityConnection.getConnection(string);
        Statement statement = this.con.createStatement();
        this.con.setAutoCommit(true);
        this.con.commit();
        try {
            statement.executeUpdate("DROP TABLE " + this.temporaryTableName);
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException);
        }
    }

    protected void writeTuples(int n) throws SQLException {
        Statement statement = this.con.createStatement();
        do {
            int n2;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("INSERT INTO " + this.temporaryTableName + " VALUES (");
            stringBuilder.append(StringFunc.formatSQLValue(this.leftTuple.getObject(0)));
            for (n2 = 1; n2 < this.firstRelation.getNumAttributes(); ++n2) {
                stringBuilder.append(", ");
                stringBuilder.append(StringFunc.formatSQLValue(this.leftTuple.getObject(n2)));
            }
            stringBuilder.append(")");
            n2 = statement.executeUpdate(stringBuilder.toString());
        } while (this.input[n].next(this.leftTuple));
        statement = this.con.createStatement();
        this.con.commit();
    }

    private GQTableRef createTemporary(String string) throws SQLException {
        String string2 = Relation.createTableDDL(this.firstRelation, string, false, false, this.dbref);
        Statement statement = this.con.createStatement();
        if (UnityDriver.DEBUG) {
            System.out.println(string2);
        }
        statement.executeUpdate(string2);
        return GQTableRef.createTemporaryTableRef(string, string);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("DISTRIBUTED JOIN (temp. table): ");
        if (this.swap) {
            stringBuffer.append(this.pred.toString(this.secondRelation, this.firstRelation));
        } else {
            stringBuffer.append(this.pred.toString(this.firstRelation, this.secondRelation));
        }
        return stringBuffer.toString();
    }

    @Override
    public String getName() {
        return "DISTRIBUTED JOIN (with temp. table)";
    }

    @Override
    public String getDescription() {
        return "";
    }
}

