/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ListIterator;
import unity.engine.Page;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.io.FileManager;
import unity.operators.HashBuffer;
import unity.operators.Operator;
import unity.predicates.JoinPredicate;
import unity.util.HashFunc;

public class PageHashTable {
    protected HashPartition[] partitions;
    private int numPartitions;
    protected Relation relation;
    private long memorySizeInBytes;
    private long memoryUsedInBytes;
    public static final int IS_EMPTY = 0;
    public static final int IS_EXPANDING = 1;
    public static final int IS_FROZEN = 2;
    private int[] offsets;
    private byte[][] dataEncodings;
    protected Operator operator;
    protected String tableName;

    public PageHashTable(int n, long l, Relation relation, Operator operator, String string) {
        this.partitions = new HashPartition[n];
        this.relation = relation;
        this.numPartitions = n;
        this.memoryUsedInBytes = 0L;
        this.memorySizeInBytes = l;
        this.offsets = new int[relation.getNumAttributes()];
        this.dataEncodings = new byte[relation.getNumAttributes()][];
        this.operator = operator;
        this.tableName = string;
        for (int i = 0; i < n; ++i) {
            this.partitions[i] = new HashPartition(i);
        }
    }

    public void clear() {
        for (int i = 0; i < this.numPartitions; ++i) {
            this.partitions[i].clear();
        }
    }

    public void close(int n) throws SQLException {
        for (int i = 0; i < this.numPartitions; ++i) {
            if (this.partitions[i].getState() != n) continue;
            this.partitions[i].close();
        }
    }

    public void purge(int n) throws SQLException {
        this.partitions[n].purge();
    }

    public boolean insert(int n, Tuple tuple) throws SQLException {
        int n2 = HashFunc.getPartition(n, this.numPartitions);
        tuple.convertToBytes(this.offsets, this.dataEncodings);
        tuple.setId(n);
        this.partitions[n2].add(n, tuple);
        return this.memoryUsedInBytes <= this.memorySizeInBytes;
    }

    public int getTuples(int n) {
        return this.partitions[n].getTuples();
    }

    public String getFileName(int n) {
        return this.partitions[n].getFileName();
    }

    public void initPartition(int n, int n2) throws SQLException {
        this.partitions[n].init(n2);
    }

    public void probeHashTable(int n, int n2, Tuple tuple, ArrayList<byte[]> arrayList) throws SQLException {
        this.partitions[n].probeHashTable(n2, tuple, arrayList);
    }

    public void buildHashTable(int n, JoinPredicate joinPredicate) {
        this.partitions[n].buildHashTable(joinPredicate);
    }

    public HashBuffer getHashTable(int n) {
        return this.partitions[n].hashTable;
    }

    private class HashPartition {
        private LinkedList<Page> pages = new LinkedList();
        private int state = 0;
        private int tupCnt = 0;
        private String fileName = "";
        private BufferedOutputStream outFile = null;
        private int num;
        private int memUsedInBytes;
        protected HashBuffer hashTable;
        private static final int PAGE_SIZE_IN_TUPLES = 100;

        public HashPartition(int n) {
            this.num = n;
            this.hashTable = null;
            this.memUsedInBytes = 0;
        }

        public int getState() {
            return this.state;
        }

        public int getTuples() {
            return this.tupCnt;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void clear() {
            this.pages.clear();
            if (this.hashTable != null) {
                this.hashTable.clear();
            }
            this.tupCnt = 0;
            this.state = 0;
            if (!this.fileName.equals("")) {
                FileManager.deleteFile(this.fileName);
            }
        }

        public void flush() throws SQLException {
            ListIterator<Page> listIterator = this.pages.listIterator(0);
            while (listIterator.hasNext()) {
                Page page = listIterator.next();
                PageHashTable.this.operator.incrementIOBytes(page.write(this.outFile));
            }
            this.pages.clear();
        }

        public void close() throws SQLException {
            try {
                FileManager.closeFile(this.outFile);
            }
            catch (Exception exception) {
                throw new SQLException(exception);
            }
        }

        public void purge() throws SQLException {
            try {
                this.fileName = FileManager.createTempFileName("bucket_" + PageHashTable.this.tableName + "_" + this.num);
                this.outFile = FileManager.openOutputFile(this.fileName);
                if (this.pages.size() >= 1) {
                    this.flush();
                }
                this.state = 2;
                PageHashTable.this.memoryUsedInBytes -= this.memUsedInBytes;
                this.memUsedInBytes = 0;
            }
            catch (Exception exception) {
                throw new SQLException(exception);
            }
        }

        public void init(int n) throws SQLException {
            try {
                this.fileName = FileManager.createTempFileName("bucket_" + PageHashTable.this.tableName + "_" + this.num);
                this.outFile = FileManager.openOutputFile(this.fileName);
            }
            catch (IOException iOException) {
                throw new SQLException(iOException);
            }
            this.state = n;
            if (this.state == 2) {
                Page page = new Page(100, PageHashTable.this.relation);
                this.pages.addLast(page);
            }
        }

        public boolean add(int n, Tuple tuple) throws SQLException {
            Page page = null;
            boolean bl = false;
            ++this.tupCnt;
            if (this.state == 0) {
                page = new Page(100, PageHashTable.this.relation);
                this.pages.addLast(page);
                this.state = 1;
            } else {
                if (this.state == 2) {
                    tuple.write(this.outFile);
                    PageHashTable.this.operator.incrementIOBytes(tuple.getSize());
                    return false;
                }
                if (this.state == 1 && !(page = this.pages.getLast()).hasSpace()) {
                    page = new Page(100, PageHashTable.this.relation);
                    this.pages.addLast(page);
                }
            }
            int n2 = page.addTuple(n, tuple);
            this.memUsedInBytes += n2;
            PageHashTable.this.memoryUsedInBytes += n2;
            return bl;
        }

        public void buildHashTable(JoinPredicate joinPredicate) {
            if (this.state == 0) {
                return;
            }
            this.hashTable = new HashBuffer(this.tupCnt, joinPredicate, PageHashTable.this.relation);
            ListIterator<Page> listIterator = this.pages.listIterator(0);
            while (listIterator.hasNext()) {
                Page page = listIterator.next();
                for (int i = 0; i < page.getCount(); ++i) {
                    byte[] byArray = page.getTuple(i);
                    this.hashTable.insert(Tuple.getId(byArray), byArray);
                }
            }
            this.pages.clear();
        }

        public void probeHashTable(int n, Tuple tuple, ArrayList<byte[]> arrayList) throws SQLException {
            if (this.hashTable == null) {
                return;
            }
            this.hashTable.find(n, tuple, arrayList);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(500);
            int n = 0;
            ListIterator<Page> listIterator = this.pages.listIterator(0);
            while (listIterator.hasNext()) {
                Page page = listIterator.next();
                stringBuilder.append("Page " + n + ":\n" + page.toString() + "\n");
                ++n;
            }
            return stringBuilder.toString();
        }
    }
}

