/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import unity.annotation.AnnotatedSourceDatabase;
import unity.annotation.AnnotatedSourceTable;
import unity.annotation.SourceDatabase;
import unity.annotation.SourceField;
import unity.mapping.DatabaseMapping;
import unity.query.GQDatabaseRef;
import unity.query.GQFieldRef;
import unity.query.HGNode;
import unity.query.LQNode;
import unity.query.SubQuery;
import unity.util.StringFunc;

public class GQTableRef
implements Serializable {
    private static final long serialVersionUID = 1L;
    private AnnotatedSourceTable sourceTable;
    private String name;
    private String aliasName;
    private GQDatabaseRef dbReference;
    private LQNode node;
    private ArrayList<GQFieldRef> fieldRefs;
    private HGNode hgNode;
    private int position;
    private Object reference;
    private SubQuery definingSubquery;
    private int numComponents;

    public GQTableRef(AnnotatedSourceTable annotatedSourceTable, String string, String string2, GQDatabaseRef gQDatabaseRef) {
        this.sourceTable = annotatedSourceTable;
        this.name = string;
        this.aliasName = string2;
        this.dbReference = gQDatabaseRef;
        this.fieldRefs = new ArrayList();
    }

    public static GQTableRef createTemporaryTableRef(String string, String string2) {
        AnnotatedSourceTable annotatedSourceTable = new AnnotatedSourceTable(null, null, string, null, new HashMap<String, SourceField>(), null);
        return new GQTableRef(annotatedSourceTable, string, string2, null);
    }

    public Object getReference() {
        return this.reference;
    }

    public void setReference(Object object) {
        this.reference = object;
    }

    public boolean isSubquery() {
        if (this.reference == null) {
            return false;
        }
        return this.reference instanceof SubQuery;
    }

    public ArrayList<GQFieldRef> getFieldRefs() {
        return this.fieldRefs;
    }

    public void addFieldRef(GQFieldRef gQFieldRef) {
        this.fieldRefs.add(gQFieldRef);
    }

    public GQFieldRef getFieldRef(SourceField sourceField) {
        for (GQFieldRef gQFieldRef : this.fieldRefs) {
            if (sourceField != gQFieldRef.getField()) continue;
            return gQFieldRef;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setNode(LQNode lQNode) {
        this.node = lQNode;
    }

    public LQNode getNode() {
        return this.node;
    }

    public GQDatabaseRef getParentDB() {
        return this.dbReference;
    }

    public AnnotatedSourceTable getTable() {
        return this.sourceTable;
    }

    public String getTableNameOptionalSchema() {
        Object object;
        AnnotatedSourceDatabase annotatedSourceDatabase;
        if (this.dbReference != null && (annotatedSourceDatabase = this.dbReference.getDatabase()) != null && (object = annotatedSourceDatabase.getProperty("useschema")) != null && object.equals("false")) {
            return this.sourceTable.getSQLTableName();
        }
        return this.sourceTable.getSQLTableNameWithSchema();
    }

    public String getLocalName() {
        if (this.aliasName != null) {
            Object object;
            String string = DatabaseMapping.getMappingText("#AS#", this.dbReference, null);
            if (string.equals("")) {
                string = " ";
            }
            char c = '\"';
            SourceDatabase sourceDatabase = null;
            if (this.dbReference != null && this.dbReference.getDatabase() != null) {
                sourceDatabase = this.dbReference.getDatabase();
            }
            if (sourceDatabase != null) {
                c = sourceDatabase.getDelimitChar();
            }
            this.aliasName = StringFunc.delimitName(this.aliasName, c);
            boolean bl = true;
            if (sourceDatabase != null && (object = sourceDatabase.getProperty("usetablealias")) != null && object.toString().equalsIgnoreCase("false")) {
                bl = false;
            }
            if (bl) {
                return this.getTableNameOptionalSchema() + string + this.aliasName;
            }
            return this.getTableNameOptionalSchema();
        }
        return this.getTableNameOptionalSchema();
    }

    public String getLocalFieldName() {
        if (this.aliasName != null) {
            if (StringFunc.isDelimited(this.aliasName, '\"')) {
                char c = '\"';
                if (this.dbReference != null && this.dbReference.getDatabase() != null) {
                    c = this.dbReference.getDatabase().getDelimitChar();
                }
                return StringFunc.delimitName(this.aliasName, c);
            }
            return this.aliasName;
        }
        return this.getTableNameOptionalSchema();
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public void setAliasName(String string) {
        this.aliasName = string;
    }

    public void setHGNode(HGNode hGNode) {
        this.hgNode = hGNode;
    }

    public HGNode getHGNode() {
        return this.hgNode;
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public int getPosition() {
        return this.position;
    }

    public SubQuery getDefiningSubquery() {
        return this.definingSubquery;
    }

    public void setDefiningSubquery(SubQuery subQuery) {
        this.definingSubquery = subQuery;
    }

    public int getNumComponents() {
        return this.numComponents;
    }

    public void setNumComponents(int n) {
        this.numComponents = n;
    }
}

