/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.sql.SQLException;
import java.util.ArrayList;
import unity.annotation.AnnotatedSourceDatabase;
import unity.engine.Attribute;
import unity.query.GQDatabaseRef;
import unity.query.GQFieldRef;
import unity.query.GlobalCommand;
import unity.query.GlobalQuery;
import unity.query.LQDeleteNode;
import unity.query.LQNode;
import unity.query.LQUpdateNode;
import unity.query.SubQuery;

public class GlobalUpdate
extends GlobalCommand {
    private static final long serialVersionUID = 1L;
    private AnnotatedSourceDatabase targetDB;
    private SubQuery queryPlan;
    private boolean hasGlobalSubQuery = false;
    private ArrayList<GlobalQuery> subqueries = null;
    private int type;
    private String statement;

    public void setPlan(SubQuery subQuery) {
        this.queryPlan = subQuery;
    }

    public SubQuery getPlan() {
        return this.queryPlan;
    }

    public String generateBaseSQL() {
        return this.queryPlan.getLogicalQueryTree().getRoot().generateSQL();
    }

    public String generateConditionSQL() {
        LQNode lQNode = this.queryPlan.getLogicalQueryTree().getRoot();
        if (lQNode instanceof LQDeleteNode) {
            return ((LQDeleteNode)lQNode).generateSubQuerySQL();
        }
        if (lQNode instanceof LQUpdateNode) {
            return ((LQUpdateNode)lQNode).getCondition().generateSQL();
        }
        return "";
    }

    public void setDatabase(AnnotatedSourceDatabase annotatedSourceDatabase) {
        this.targetDB = annotatedSourceDatabase;
    }

    public AnnotatedSourceDatabase getDatabase() {
        return this.targetDB;
    }

    public GlobalQuery getSubQuery() {
        return this.subqueries.get(0);
    }

    public String getSqlStmt() {
        if (this.queryPlan == null) {
            return "";
        }
        return this.queryPlan.getLogicalQueryTree().getRoot().generateSQL();
    }

    public boolean hasGlobalSubQuery() {
        return this.hasGlobalSubQuery;
    }

    public void setHasGlobalSubQuery(boolean bl) {
        this.hasGlobalSubQuery = bl;
    }

    public void addSubQuery(GlobalQuery globalQuery) {
        if (this.subqueries == null) {
            this.subqueries = new ArrayList();
        }
        this.subqueries.add(globalQuery);
    }

    public void checkGlobalQuery() {
        if (this.subqueries == null || this.subqueries.size() == 0) {
            this.hasGlobalSubQuery = false;
        } else {
            GlobalQuery globalQuery = this.subqueries.get(0);
            ArrayList<GQDatabaseRef> arrayList = globalQuery.getAllDBRefs();
            if (arrayList.size() > 1 || arrayList.get(0).getDatabase() != this.targetDB) {
                this.hasGlobalSubQuery = true;
            }
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public String getStatement() {
        return this.statement;
    }

    public void setStatement(String string) {
        this.statement = string;
    }

    public void setParameter(int n, int n2, Object object) throws SQLException {
        GQFieldRef gQFieldRef = this.getParameter(n).getFieldRef();
        LQNode lQNode = (LQNode)gQFieldRef.getReference();
        if (object == null) {
            lQNode.setContent(null);
        } else if (Attribute.isNumberType(n2)) {
            if (n2 == 4) {
                lQNode.setContent(Integer.parseInt(object.toString()));
            } else if (n2 == -5) {
                lQNode.setContent(Long.parseLong(object.toString()));
            } else if (n2 == 6 || n2 == 8) {
                lQNode.setContent(Double.parseDouble(object.toString()));
            }
        } else {
            lQNode.setContent(object);
        }
    }
}

