/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Stack;
import unity.annotation.AnnotatedSourceField;
import unity.annotation.SourceField;
import unity.engine.Attribute;
import unity.engine.Relation;
import unity.functions.ConstantValue;
import unity.functions.Expression;
import unity.functions.ExtractAttribute;
import unity.functions.F_Cast;
import unity.jdbc.UnityDriver;
import unity.mapping.DatabaseMapping;
import unity.operators.Operator;
import unity.predicates.All;
import unity.predicates.And;
import unity.predicates.Any;
import unity.predicates.AttrJoinPredicate;
import unity.predicates.Equal;
import unity.predicates.Exists;
import unity.predicates.ExprJoinPredicate;
import unity.predicates.Greater;
import unity.predicates.GreaterEqual;
import unity.predicates.In;
import unity.predicates.IntJoinPredicate;
import unity.predicates.Is;
import unity.predicates.JoinPredicate;
import unity.predicates.Less;
import unity.predicates.LessEqual;
import unity.predicates.Like;
import unity.predicates.Not;
import unity.predicates.NotEqual;
import unity.predicates.Or;
import unity.predicates.Predicate;
import unity.predicates.SelectionExprPredicate;
import unity.predicates.SelectionPredicate;
import unity.predicates.XOr;
import unity.query.GQDatabaseRef;
import unity.query.GQFieldRef;
import unity.query.GQTableRef;
import unity.query.GlobalQuery;
import unity.query.LQExprNode;
import unity.query.LQJoinNode;
import unity.query.LQNode;
import unity.query.Optimizer;
import unity.query.SubQuery;

public class LQCondNode
extends LQNode
implements Cloneable {
    private static final long serialVersionUID = 1L;

    @Override
    public String generateSQL() {
        String string = "";
        if (this.getType() == 129) {
            String string2 = this.getChild(1).getContent().toString();
            return string2.substring(1, string2.length() - 1);
        }
        boolean bl = false;
        if (this.type == 112) {
            return "NOT (" + this.getChild(0).generateSQL() + ')';
        }
        if (this.type == 135) {
            return "EXISTS " + this.getChild(0).generateSQL();
        }
        if (this.type == 111 || this.type == 110) {
            LQNode lQNode = this.getParent();
            boolean bl2 = bl = lQNode != null && lQNode.getType() != this.type;
            if (bl) {
                string = string + '(';
            }
        }
        if (this.getChild(0) != null) {
            string = string + this.getChild(0).generateSQL();
        }
        string = string + " " + (this.type == 100 ? ((GQFieldRef)this.getContent()).getLocalName() : this.getContent());
        if (this.getChild(1) != null) {
            string = string + ' ' + this.getChild(1).generateSQL();
        }
        if (bl) {
            string = string + ')';
        }
        return string;
    }

    @Override
    public String generatePig(Relation relation) {
        String string;
        String string2 = "";
        if (this.getType() == 129) {
            String string3 = this.getChild(1).getContent().toString();
            return string3.substring(1, string3.length() - 1);
        }
        boolean bl = false;
        if (this.type == 112) {
            return "NOT " + this.getChild(0).generatePig(relation);
        }
        if (this.type == 111 || this.type == 110) {
            bl = true;
            string2 = string2 + '(';
        }
        if (this.getChild(0) != null) {
            string2 = string2 + this.getChild(0).generatePig(relation);
        }
        string2 = this.type == 100 ? string2 + ((GQFieldRef)this.getContent()).getLocalName() : ((string = this.getContent().toString()).equals("=") ? string2 + " ==" : string2 + " " + string);
        if (this.getChild(1) != null) {
            string2 = string2 + " " + this.getChild(1).generatePig(relation);
        }
        if (bl) {
            string2 = string2 + ')';
        }
        return string2;
    }

    @Override
    public String toString() {
        return "CONDITION: " + this.generateSQL();
    }

    @Override
    public Operator buildOperator(Operator[] operatorArray, GlobalQuery globalQuery, SubQuery subQuery) {
        return null;
    }

    public boolean hasOR() {
        if (this.getType() == 110) {
            return true;
        }
        for (int i = 0; i < this.getNumChildren(); ++i) {
            boolean bl;
            LQNode lQNode = this.getChild(i);
            if (!(lQNode instanceof LQCondNode) || !(bl = ((LQCondNode)lQNode).hasOR())) continue;
            return true;
        }
        return false;
    }

    public SelectionPredicate buildSelectionPredicate(Relation relation, GlobalQuery globalQuery, SubQuery subQuery, Operator operator) throws SQLException {
        return this.buildSelPredicate(this, relation, globalQuery, subQuery, operator);
    }

    public Predicate buildPredicate(String string, LQCondNode lQCondNode) {
        Predicate predicate = null;
        if (string.equals("=")) {
            predicate = new Equal();
        } else if (string.equals("<=")) {
            predicate = new LessEqual();
        } else if (string.equals(">=")) {
            predicate = new GreaterEqual();
        } else if (string.equals(">")) {
            predicate = new Greater();
        } else if (string.equals("<")) {
            predicate = new Less();
        } else if (string.equals("!=") || string.equals("<>")) {
            predicate = new NotEqual();
        } else if (string.equalsIgnoreCase("LIKE")) {
            predicate = new Like(false);
        } else if (string.equalsIgnoreCase("NOT LIKE")) {
            predicate = new Like(true);
        } else if (string.equalsIgnoreCase("IN")) {
            predicate = new In(false);
        } else if (string.equalsIgnoreCase("NOT IN")) {
            predicate = new In(true);
        } else if (string.equalsIgnoreCase("IS")) {
            boolean bl;
            String string2 = lQCondNode.getChild(1).toString().toUpperCase();
            boolean bl2 = bl = string2.indexOf("NOT") >= 0;
            if (string2.indexOf("NULL") >= 0) {
                predicate = new Is(bl);
            } else {
                predicate = new Equal();
                boolean bl3 = string2.indexOf("TRUE") >= 0;
                boolean bl4 = bl3 ^ bl;
                if (bl4) {
                    this.getChild(1).setContent(new Integer(1));
                } else {
                    this.getChild(1).setContent(new Integer(0));
                }
                this.getChild(1).setType(104);
            }
        }
        return predicate;
    }

    private SelectionPredicate buildSelPredicate(LQCondNode lQCondNode, Relation relation, GlobalQuery globalQuery, SubQuery subQuery, Operator operator) throws SQLException {
        SelectionPredicate selectionPredicate = null;
        if (lQCondNode == null) {
            return null;
        }
        int n = lQCondNode.getType();
        String string = (String)lQCondNode.getContent();
        if (n == 114) {
            Predicate predicate = null;
            if (string.contains("ANY")) {
                string = string.substring(0, string.indexOf("ANY") - 1);
                predicate = this.buildPredicate(string, lQCondNode);
                predicate = new Any(predicate);
            } else if (string.contains("SOME")) {
                string = string.substring(0, string.indexOf("SOME") - 1);
                predicate = this.buildPredicate(string, lQCondNode);
                predicate = new Any(predicate);
            } else if (string.contains("ALL")) {
                string = string.substring(0, string.indexOf("ALL") - 1);
                predicate = this.buildPredicate(string, lQCondNode);
                predicate = new All(predicate);
            } else {
                predicate = this.buildPredicate(string, lQCondNode);
            }
            Attribute attribute = new Attribute();
            Attribute attribute2 = new Attribute();
            Expression expression = ((LQExprNode)lQCondNode.getChild(0)).buildExpression(relation, attribute, globalQuery, subQuery, operator);
            Expression expression2 = ((LQExprNode)lQCondNode.getChild(1)).buildExpression(relation, attribute2, globalQuery, subQuery, operator);
            if (!string.equalsIgnoreCase("IS") && (expression instanceof ConstantValue || expression2 instanceof ConstantValue)) {
                if (expression instanceof ConstantValue) {
                    ((ConstantValue)expression).changeType(expression2.getReturnType());
                }
                if (expression2 instanceof ConstantValue) {
                    ((ConstantValue)expression2).changeType(expression.getReturnType());
                }
            }
            SelectionExprPredicate selectionExprPredicate = new SelectionExprPredicate(expression, expression2, predicate);
            return selectionExprPredicate;
        }
        if (n == 112) {
            return new Not(this.buildSelPredicate((LQCondNode)lQCondNode.getChild(0), relation, globalQuery, subQuery, operator));
        }
        if (n == 110) {
            return new Or(this.buildSelPredicate((LQCondNode)lQCondNode.getChild(0), relation, globalQuery, subQuery, operator), this.buildSelPredicate((LQCondNode)lQCondNode.getChild(1), relation, globalQuery, subQuery, operator));
        }
        if (n == 111) {
            return new And(this.buildSelPredicate((LQCondNode)lQCondNode.getChild(0), relation, globalQuery, subQuery, operator), this.buildSelPredicate((LQCondNode)lQCondNode.getChild(1), relation, globalQuery, subQuery, operator));
        }
        if (n == 118) {
            return new XOr(this.buildSelPredicate((LQCondNode)lQCondNode.getChild(0), relation, globalQuery, subQuery, operator), this.buildSelPredicate((LQCondNode)lQCondNode.getChild(1), relation, globalQuery, subQuery, operator));
        }
        if (n == 135) {
            Attribute attribute = new Attribute();
            Expression expression = ((LQExprNode)lQCondNode.getChild(0)).buildExpression(relation, attribute, globalQuery, subQuery, operator);
            return new Exists(expression);
        }
        return selectionPredicate;
    }

    public boolean hasExpression() {
        Stack<LQNode> stack = new Stack<LQNode>();
        stack.push(this);
        while (!stack.isEmpty()) {
            LQNode lQNode = (LQNode)stack.pop();
            int n = lQNode.getType();
            if (n == 120 || n == 126) {
                return true;
            }
            for (int i = 0; i < lQNode.getNumChildren(); ++i) {
                stack.push(lQNode.getChild(i));
            }
        }
        return false;
    }

    private static boolean getJoinFields(LQCondNode lQCondNode, ArrayList<GQFieldRef> arrayList, ArrayList<GQFieldRef> arrayList2, Relation relation, Relation relation2) throws SQLException {
        int n = lQCondNode.getType();
        boolean bl = false;
        if (n == 114 && ((String)lQCondNode.content).equals("=")) {
            Object object = lQCondNode.getChild(0).getContent();
            if (object == null) {
                if (lQCondNode.getChild(0).getReference() == relation) {
                    arrayList.add(null);
                    arrayList2.add((GQFieldRef)lQCondNode.getChild(1).getContent());
                } else {
                    arrayList2.add(null);
                    arrayList.add((GQFieldRef)lQCondNode.getChild(1).getContent());
                }
            } else {
                bl = LQCondNode.getExpJoinFields((LQExprNode)lQCondNode.getChild(0), arrayList, arrayList2, relation, relation2) || bl;
                bl = LQCondNode.getExpJoinFields((LQExprNode)lQCondNode.getChild(1), arrayList, arrayList2, relation, relation2) || bl;
            }
        } else if (n == 111) {
            boolean bl2 = LQCondNode.getJoinFields((LQCondNode)lQCondNode.getChild(0), arrayList, arrayList2, relation, relation2);
            bl = bl || bl2;
            bl2 = LQCondNode.getJoinFields((LQCondNode)lQCondNode.getChild(1), arrayList, arrayList2, relation, relation2);
            bl = bl || bl2;
        }
        return bl;
    }

    private static boolean getExpJoinFields(LQExprNode lQExprNode, ArrayList<GQFieldRef> arrayList, ArrayList<GQFieldRef> arrayList2, Relation relation, Relation relation2) throws SQLException {
        Object object = lQExprNode.getContent();
        if (object instanceof GQFieldRef) {
            GQFieldRef gQFieldRef = (GQFieldRef)object;
            if (relation.getAttributeIndex(gQFieldRef) != -1) {
                arrayList.add(gQFieldRef);
            } else if (relation2.getAttributeIndex(gQFieldRef) != -1) {
                arrayList2.add(gQFieldRef);
            } else {
                throw new SQLException(UnityDriver.i18n.getString("LQCondNode.ErrorCannotFindField") + gQFieldRef.getLocalName());
            }
            return false;
        }
        if (lQExprNode.getChild(0) != null) {
            LQCondNode.getExpJoinFields((LQExprNode)lQExprNode.getChild(0), arrayList, arrayList2, relation, relation2);
        }
        if (lQExprNode.getChild(1) != null) {
            LQCondNode.getExpJoinFields((LQExprNode)lQExprNode.getChild(1), arrayList, arrayList2, relation, relation2);
        }
        return true;
    }

    public JoinPredicate buildJoinPredicate(Operator[] operatorArray, LQJoinNode lQJoinNode, GlobalQuery globalQuery, SubQuery subQuery) throws SQLException {
        JoinPredicate joinPredicate = null;
        ArrayList<GQFieldRef> arrayList = new ArrayList<GQFieldRef>();
        ArrayList<GQFieldRef> arrayList2 = new ArrayList<GQFieldRef>();
        Relation relation = lQJoinNode.getChild(0).getOutputRelation();
        Relation relation2 = lQJoinNode.getChild(1).getOutputRelation();
        boolean bl = LQCondNode.getJoinFields(this, arrayList, arrayList2, relation, relation2);
        if (arrayList.size() == 0 || arrayList2.size() == 0) {
            joinPredicate = new JoinPredicate();
        } else {
            Expression[] expressionArray;
            Serializable serializable;
            Object object;
            Object object2;
            if (arrayList.size() == 1 && arrayList2.size() == 1 && !bl) {
                object2 = arrayList.get(0);
                object = arrayList2.get(0);
                GQFieldRef gQFieldRef = (GQFieldRef)object2;
                serializable = (GQFieldRef)object;
                if (gQFieldRef != null && serializable != null) {
                    expressionArray = gQFieldRef.getField();
                    AnnotatedSourceField annotatedSourceField = ((GQFieldRef)serializable).getField();
                    if (expressionArray != null && annotatedSourceField != null && expressionArray.getDataType() == 4 && annotatedSourceField.getDataType() == 4) {
                        joinPredicate = new IntJoinPredicate(relation.getAttributeIndex(arrayList.get(0)), relation2.getAttributeIndex(arrayList2.get(0)), null);
                    } else if (expressionArray != null && annotatedSourceField != null && expressionArray.getDataType() == 12 && annotatedSourceField.getDataType() == 12) {
                        joinPredicate = new AttrJoinPredicate(new int[]{relation.getAttributeIndex(arrayList.get(0))}, new int[]{relation2.getAttributeIndex(arrayList2.get(0))}, null);
                    } else if (expressionArray != null && annotatedSourceField != null && (expressionArray.getDataType() == 12 || annotatedSourceField.getDataType() == 12)) {
                        Expression[] expressionArray2 = new Expression[]{new F_Cast((Expression)new ExtractAttribute(relation.getAttributeIndex(arrayList.get(0))), 0, 12)};
                        Expression[] expressionArray3 = new Expression[]{new F_Cast((Expression)new ExtractAttribute(relation2.getAttributeIndex(arrayList2.get(0))), 0, 12)};
                        joinPredicate = new ExprJoinPredicate(expressionArray2, expressionArray3, null);
                    }
                }
            }
            if (joinPredicate == null) {
                int n;
                object2 = new int[arrayList.size()];
                object = new int[arrayList2.size()];
                lQJoinNode.setLeftFields(arrayList);
                lQJoinNode.setRightFields(arrayList2);
                for (n = 0; n < arrayList.size(); ++n) {
                    object2[n] = relation.getAttributeIndex(arrayList.get(n));
                }
                for (n = 0; n < arrayList2.size(); ++n) {
                    object[n] = relation2.getAttributeIndex(arrayList2.get(n));
                }
                if (lQJoinNode.isComplexJoin || bl) {
                    ArrayList<Expression> arrayList3 = new ArrayList<Expression>();
                    serializable = new ArrayList();
                    this.buildComplexJoinPred(lQJoinNode.getCondition(), arrayList3, (ArrayList<Expression>)serializable, relation, relation2, globalQuery, arrayList, subQuery, this.op);
                    expressionArray = new Expression[arrayList3.size()];
                    for (int i = 0; i < expressionArray.length; ++i) {
                        expressionArray[i] = arrayList3.get(i);
                    }
                    Expression[] expressionArray4 = new Expression[((ArrayList)serializable).size()];
                    for (int i = 0; i < expressionArray4.length; ++i) {
                        expressionArray4[i] = (Expression)((ArrayList)serializable).get(i);
                    }
                    joinPredicate = new ExprJoinPredicate(expressionArray, expressionArray4, null);
                } else {
                    joinPredicate = new AttrJoinPredicate((int[])object2, (int[])object, null);
                }
            }
        }
        joinPredicate.setQueryNode(this);
        return joinPredicate;
    }

    public void buildComplexJoinPred(LQCondNode lQCondNode, ArrayList<Expression> arrayList, ArrayList<Expression> arrayList2, Relation relation, Relation relation2, GlobalQuery globalQuery, ArrayList<GQFieldRef> arrayList3, SubQuery subQuery, Operator operator) throws SQLException {
        if (lQCondNode.getType() == 111) {
            this.buildComplexJoinPred((LQCondNode)lQCondNode.getChild(0), arrayList, arrayList2, relation, relation2, globalQuery, arrayList3, subQuery, operator);
            this.buildComplexJoinPred((LQCondNode)lQCondNode.getChild(1), arrayList, arrayList2, relation, relation2, globalQuery, arrayList3, subQuery, operator);
        } else {
            Expression expression;
            Expression expression2;
            Attribute attribute = new Attribute();
            Attribute attribute2 = new Attribute();
            if (this.isLeftExpr(lQCondNode.getChild(0), arrayList3)) {
                expression2 = ((LQExprNode)lQCondNode.getChild(0)).buildExpression(relation, attribute, globalQuery, subQuery, operator);
                expression = ((LQExprNode)lQCondNode.getChild(1)).buildExpression(relation2, attribute2, globalQuery, subQuery, operator);
            } else {
                expression2 = ((LQExprNode)lQCondNode.getChild(1)).buildExpression(relation, attribute, globalQuery, subQuery, operator);
                expression = ((LQExprNode)lQCondNode.getChild(0)).buildExpression(relation2, attribute2, globalQuery, subQuery, operator);
            }
            if (expression2 instanceof ConstantValue || expression instanceof ConstantValue) {
                if (expression2 instanceof ConstantValue) {
                    ((ConstantValue)expression2).changeType(expression.getReturnType());
                }
                if (expression instanceof ConstantValue) {
                    ((ConstantValue)expression).changeType(expression2.getReturnType());
                }
            }
            arrayList.add(expression2);
            arrayList2.add(expression);
        }
    }

    private boolean isLeftExpr(LQNode lQNode, ArrayList<GQFieldRef> arrayList) {
        Stack<LQNode> stack = new Stack<LQNode>();
        stack.push(lQNode);
        while (!stack.isEmpty()) {
            LQNode lQNode2 = (LQNode)stack.pop();
            if (lQNode2.getContent() instanceof GQFieldRef) {
                return arrayList.contains(lQNode2.getContent());
            }
            for (int i = 0; i < lQNode2.getNumChildren(); ++i) {
                stack.push(lQNode2.getChild(i));
            }
        }
        return false;
    }

    public double getSelectivity() {
        double d;
        block15: {
            d = 1.0;
            if (this.type == 114) {
                LQNode lQNode = (LQNode)this.children.get(0);
                if (lQNode.getType() != 100) {
                    return d;
                }
                GQFieldRef gQFieldRef = (GQFieldRef)((LQNode)this.children.get(0)).getContent();
                int n = 0;
                if (gQFieldRef.getField() != null) {
                    n = gQFieldRef.getField().getNumDistinctValues();
                }
                if (n == 0) {
                    d = 1.0;
                } else if (this.content.equals("=")) {
                    d = 1.0 / (double)n;
                } else if (this.content.equals("!=")) {
                    d = 1.0 - 1.0 / (double)n;
                } else if (this.content.equals("<") || this.content.equals("<=") || this.content.equals(">") || this.content.equals(">=")) {
                    try {
                        Object object = ((LQNode)this.children.get(1)).getContent();
                        if (object == null || !(object instanceof Integer)) break block15;
                        int n2 = (Integer)object;
                        d = n > 0 ? (this.content.equals("<") || this.content.equals("<=") ? 1.0 * (double)n2 / (double)n : 1.0 - 1.0 * (double)n2 / (double)n) : (this.content.equals("<") || this.content.equals("<=") ? 1.0 * (double)n2 / 100.0 : 1.0 - 1.0 * (double)n2 / 100.0);
                        if (d < 0.0) {
                            d = 0.0;
                        }
                        if (d > 1.0) {
                            d = 1.0;
                        }
                    }
                    catch (Exception exception) {
                        d = 0.33;
                    }
                } else {
                    d = 0.33;
                }
            }
        }
        return d;
    }

    @Override
    public Object clone() {
        try {
            LQCondNode lQCondNode = (LQCondNode)super.clone();
            if (this.children != null) {
                lQCondNode.children = new ArrayList(this.children.size());
                for (int i = 0; i < this.children.size(); ++i) {
                    lQCondNode.children.add((LQNode)((LQNode)this.children.get(i)).clone());
                }
            } else {
                lQCondNode.children = null;
            }
            lQCondNode.type = this.type;
            lQCondNode.content = this.content;
            lQCondNode.reference = this.reference;
            lQCondNode.parent = this.parent;
            return lQCondNode;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isJoinCondition() throws SQLException {
        if (this.type == 114 && this.content.equals("=")) {
            LQNode lQNode = this.getChild(0);
            LQNode lQNode2 = this.getChild(1);
            if (lQNode instanceof LQExprNode && lQNode.getContent() instanceof GQFieldRef && lQNode2 instanceof LQExprNode && lQNode2.getContent() instanceof GQFieldRef) {
                return true;
            }
            if (lQNode instanceof LQExprNode && lQNode2 instanceof LQExprNode) {
                LQExprNode lQExprNode = (LQExprNode)lQNode;
                LQExprNode lQExprNode2 = (LQExprNode)lQNode2;
                boolean bl = lQNode.getContent() instanceof GQFieldRef;
                boolean bl2 = lQNode2.getContent() instanceof GQFieldRef;
                boolean bl3 = lQExprNode.isConstant();
                boolean bl4 = lQExprNode2.isConstant();
                if (bl3 || bl4) {
                    return false;
                }
                if (bl && bl2) {
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    public boolean containsOr() {
        return this.contains(110);
    }

    public boolean containsNot() {
        return this.contains(112);
    }

    @Override
    public void computeCost() {
        long l = this.getChild(0).getRows();
        this.cost = 1.0 * (double)l;
        this.rows = (long)((double)l * this.getSelectivity());
    }

    @Override
    public HashSet<GQDatabaseRef> getDatabaseRefs(GQDatabaseRef gQDatabaseRef, boolean bl) {
        Serializable serializable;
        int n = this.getType();
        String string = (String)this.getContent();
        if (n == 110 || n == 111 || n == 112 || n == 118) {
            int n2 = DatabaseMapping.isSupported("#" + string + "#", this.database, null);
            if (n2 == 2) {
                this.database = GQDatabaseRef.UNITYJDBC_DBREF;
            }
        } else if (n == 114) {
            LQNode lQNode;
            int n3;
            if (string.equals("IN")) {
                string = "#IN#";
            }
            if (this.database == null) {
                this.database = gQDatabaseRef;
            }
            if ((n3 = DatabaseMapping.isSupported(string, this.database, null)) != 0 && n3 != 1) {
                this.database = GQDatabaseRef.UNITYJDBC_DBREF;
                n3 = DatabaseMapping.isSupported(string = string + "K", this.database, null);
                if (n3 == 2) {
                    Object object;
                    serializable = this.getChild(0);
                    lQNode = this.getChild(1);
                    int n4 = lQNode.getType();
                    if (((LQNode)serializable).getType() == 100 && (n4 == 127 || n4 == 104 || n4 == 101) && (object = ((LQNode)serializable).getContent()) instanceof GQFieldRef) {
                        GQFieldRef gQFieldRef = (GQFieldRef)object;
                        ArrayList<SourceField> arrayList = new ArrayList<SourceField>();
                        AnnotatedSourceField annotatedSourceField = gQFieldRef.getField();
                        arrayList.add(annotatedSourceField);
                        if (annotatedSourceField.getParentTable().isSubsetOfPrimaryKey(arrayList)) {
                            this.database = gQDatabaseRef;
                        }
                    }
                }
            }
            serializable = this.getChild(0);
            lQNode = this.getChild(1);
            if (((LQNode)serializable).getType() == 100 && lQNode.getType() == 100 && (n3 = DatabaseMapping.isSupported("#ATTR_OP_ATTR#", this.database, null)) == 2) {
                this.database = GQDatabaseRef.UNITYJDBC_DBREF;
            }
            ArrayList<GQTableRef> arrayList = new ArrayList<GQTableRef>();
            Optimizer.findTables(this, arrayList);
            if (arrayList.size() > 1 && DatabaseMapping.isSupported("#NONEQUIJOIN#", this.database, null) != 1) {
                this.database = GQDatabaseRef.UNITYJDBC_DBREF;
            }
        }
        serializable = new HashSet<GQDatabaseRef>(1);
        ((HashSet)serializable).add(this.database);
        return serializable;
    }
}

