/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import unity.engine.Relation;
import unity.mapping.DatabaseMapping;
import unity.operators.DistributedJoin;
import unity.operators.DistributedJoinHDFS;
import unity.operators.DistributedJoinSQL;
import unity.operators.DynamicHashJoin;
import unity.operators.NestedLoopJoin;
import unity.operators.Operator;
import unity.operators.ResultSetScan;
import unity.predicates.JoinPredicate;
import unity.query.GQDatabaseRef;
import unity.query.GQFieldRef;
import unity.query.GlobalQuery;
import unity.query.LQCondNode;
import unity.query.LQNode;
import unity.query.LQSelNode;
import unity.query.SubQuery;

public class LQJoinNode
extends LQNode {
    private static final long serialVersionUID = 1L;
    protected LQCondNode conditionRoot;
    protected int numTuples;
    protected int tupleSize;
    protected static double penaltyFactor = 1.0;
    protected int joinType;
    protected boolean swapChildren = false;
    protected boolean noDistributedJoin = false;
    protected int oneSideRelation;
    protected ArrayList<GQFieldRef> leftFields;
    protected ArrayList<GQFieldRef> rightFields;
    protected boolean isRightOuterJoin;
    protected boolean isLeftOuterJoin;
    protected BitSet tes;
    protected BitSet requiredTables;
    protected ArrayList<LQJoinNode> splitJoins;
    protected BitSet leftTables;
    protected BitSet rightTables;
    protected BitSet lCondTables;
    protected BitSet rCondTables;
    protected boolean isComplexJoin;
    protected LQSelNode selNode;
    protected BitSet belowTables;
    protected boolean mayConflict;
    protected LQCondNode filterCondition;

    public LQJoinNode() {
        this.type = 207;
        this.joinType = 301;
        this.isComplexJoin = false;
        this.mayConflict = false;
    }

    public void setLeftFields(ArrayList<GQFieldRef> arrayList) {
        this.leftFields = arrayList;
    }

    public void setRightFields(ArrayList<GQFieldRef> arrayList) {
        this.rightFields = arrayList;
    }

    public ArrayList<GQFieldRef> getLeftFields() {
        return this.leftFields;
    }

    public ArrayList<GQFieldRef> getRightFields() {
        return this.rightFields;
    }

    public void setNoDistributedJoin(boolean bl) {
        this.noDistributedJoin = bl;
    }

    public boolean getNoDistributedJoin() {
        return this.noDistributedJoin;
    }

    public void setSwap() {
        this.swapChildren = true;
    }

    public void setJoinType(int n) {
        this.joinType = n;
    }

    public void setCondition(LQCondNode lQCondNode) {
        this.conditionRoot = lQCondNode;
    }

    public void setFilterCondition(LQCondNode lQCondNode) {
        this.filterCondition = lQCondNode;
    }

    public LQCondNode getFilterCondition() {
        return this.filterCondition;
    }

    public LQCondNode getCondition() {
        return this.conditionRoot;
    }

    @Override
    public String generateSQL() {
        String string = this.conditionRoot.generateSQL();
        if (this.filterCondition != null) {
            string = string + " AND " + this.filterCondition.generateSQL();
        }
        return string;
    }

    public String generateJoinSQL() {
        String string = " JOIN ";
        if (this.isLeftOuterJoin && this.isRightOuterJoin) {
            string = " FULL OUTER JOIN ";
        } else if (this.isLeftOuterJoin) {
            string = " LEFT OUTER JOIN ";
        } else if (this.isRightOuterJoin) {
            string = " RIGHT OUTER JOIN ";
        }
        return string;
    }

    public boolean isComplex() {
        LQCondNode lQCondNode = this.conditionRoot;
        return lQCondNode.hasExpression();
    }

    @Override
    public Operator buildOperator(Operator[] operatorArray, GlobalQuery globalQuery, SubQuery subQuery) throws SQLException {
        this.outputRelation = new Relation(((LQNode)this.children.get(0)).getOutputRelation());
        this.outputRelation.mergeRelation(((LQNode)this.children.get(1)).getOutputRelation());
        JoinPredicate joinPredicate = null;
        if (this.conditionRoot != null) {
            joinPredicate = this.conditionRoot.buildJoinPredicate(operatorArray, this, globalQuery, subQuery);
            if (joinPredicate == null) {
                joinPredicate = new JoinPredicate(this.conditionRoot.buildSelectionPredicate(this.outputRelation, globalQuery, subQuery, null));
                this.joinType = 305;
            }
            if (this.filterCondition != null) {
                joinPredicate.setFilterPredicate(this.filterCondition.buildSelectionPredicate(this.outputRelation, globalQuery, subQuery, null));
            }
        } else {
            joinPredicate = new JoinPredicate();
        }
        if (this.joinType == 301) {
            DynamicHashJoin dynamicHashJoin = new DynamicHashJoin(operatorArray, joinPredicate, this.getMemorySize(), this.isLeftOuterJoin, this.isRightOuterJoin, this);
            this.setOperator(dynamicHashJoin);
            return dynamicHashJoin;
        }
        if (this.joinType == 302 || this.joinType == 306) {
            ResultSetScan resultSetScan = this.swapChildren ? (ResultSetScan)operatorArray[0] : (ResultSetScan)operatorArray[1];
            if (this.joinType == 306 && resultSetScan.getQuery().getDatabase().getDatabaseProductName().contains("Pig")) {
                DistributedJoinHDFS distributedJoinHDFS = new DistributedJoinHDFS(operatorArray, joinPredicate, this.swapChildren, globalQuery);
                this.setOperator(distributedJoinHDFS);
                return distributedJoinHDFS;
            }
            resultSetScan.setDelayedExecution(true);
            DistributedJoin distributedJoin = this.joinType == 306 ? new DistributedJoinSQL(operatorArray, joinPredicate, this.swapChildren, globalQuery, this.database) : new DistributedJoin(operatorArray, joinPredicate, this.swapChildren, globalQuery);
            this.setOperator(distributedJoin);
            return distributedJoin;
        }
        if (this.joinType == 305) {
            int n = 50001;
            NestedLoopJoin nestedLoopJoin = new NestedLoopJoin(operatorArray, joinPredicate, n, this);
            nestedLoopJoin.setOutputRelation(this.outputRelation);
            return nestedLoopJoin;
        }
        return null;
    }

    @Override
    public String toString() {
        String string = "";
        if (this.joinType == 301) {
            string = "Dynamic Hash";
        } else if (this.joinType == 302) {
            string = "Distributed";
        } else if (this.joinType == 303) {
            string = "Early Hash";
        } else if (this.joinType == 304) {
            string = "Early Hash (not buffered)";
        } else if (this.joinType == 305) {
            string = "Nested Loop Join";
        }
        String string2 = "";
        if (this.conditionRoot != null) {
            string2 = this.conditionRoot.generateSQL();
        }
        if (this.filterCondition != null) {
            string2 = string2 + " AND " + this.filterCondition.generateSQL();
        }
        String string3 = "";
        if (this.isRightOuterJoin && this.isLeftOuterJoin) {
            string3 = "FULL OUTER";
        } else if (this.isRightOuterJoin) {
            string3 = "RIGHT OUTER";
        } else if (this.isLeftOuterJoin) {
            string3 = "LEFT OUTER";
        }
        return string3 + " JOIN:    " + string2 + " type: " + string + super.toString();
    }

    @Override
    public ArrayList<Object> getRequiredFields() {
        return this.conditionRoot.getRequiredFields();
    }

    @Override
    public double getCost() {
        return this.cost;
    }

    @Override
    public void computeCost() {
        int n = ((LQNode)this.children.get(0)).numTuples();
        int n2 = ((LQNode)this.children.get(1)).numTuples();
        int n3 = ((LQNode)this.children.get(0)).tupleSize();
        int n4 = ((LQNode)this.children.get(1)).tupleSize();
        this.tupleSize = n3 + n4;
        this.numTuples = this.numTuples();
        int n5 = 5;
        this.cost = penaltyFactor == 1.0 ? (double)(n * n5 + n2) : penaltyFactor * (double)(n * n5 * n3 + n2 * n4);
        this.rows = this.numTuples;
        this.cost += this.getChild(0).getCost() + this.getChild(1).getCost();
    }

    public int getNumTuples() {
        return this.numTuples;
    }

    public int getTupleSize() {
        return this.tupleSize;
    }

    @Override
    public int numTuples() {
        int n = ((LQNode)this.children.get(0)).numTuples();
        int n2 = ((LQNode)this.children.get(1)).numTuples();
        if (this.conditionRoot == null) {
            return n * n2;
        }
        if (this.isLeftOuterJoin && this.isRightOuterJoin) {
            return n + n2;
        }
        if (this.isLeftOuterJoin) {
            return n;
        }
        if (this.isRightOuterJoin) {
            return n2;
        }
        return n > n2 ? n : n2;
    }

    @Override
    public int tupleSize() {
        return ((LQNode)this.children.get(0)).tupleSize() + ((LQNode)this.children.get(1)).tupleSize();
    }

    public boolean isOuterJoin() {
        return this.isRightOuterJoin || this.isLeftOuterJoin;
    }

    public boolean isRightOuterJoin() {
        return this.isRightOuterJoin;
    }

    public void setRightOuterJoin(boolean bl) {
        this.isRightOuterJoin = bl;
    }

    public boolean isLeftOuterJoin() {
        return this.isLeftOuterJoin;
    }

    public void setLeftOuterJoin(boolean bl) {
        this.isLeftOuterJoin = bl;
    }

    public BitSet getTES() {
        return this.tes;
    }

    public BitSet getRequiredTables() {
        return this.requiredTables;
    }

    public void setLRTablesTES(BitSet bitSet, BitSet bitSet2) {
        this.lCondTables = bitSet;
        this.rCondTables = bitSet2;
        this.tes = (BitSet)bitSet.clone();
        this.tes.or(bitSet2);
        this.requiredTables = (BitSet)this.tes.clone();
    }

    public void setReqTablesTES(BitSet bitSet) {
        this.tes = bitSet;
        this.requiredTables = (BitSet)bitSet.clone();
    }

    public void addTES(BitSet bitSet) {
        this.tes.or(bitSet);
    }

    public ArrayList<LQJoinNode> getSplitJoins() {
        return this.splitJoins;
    }

    public void setSplitJoins(ArrayList<LQJoinNode> arrayList) {
        this.splitJoins = arrayList;
    }

    public BitSet getLeftTables() {
        return this.leftTables;
    }

    public BitSet getRightTables() {
        return this.rightTables;
    }

    public void setLeftTables(BitSet bitSet) {
        this.leftTables = bitSet;
    }

    public void setRightTables(BitSet bitSet) {
        this.rightTables = bitSet;
    }

    public void setComplex() {
        this.isComplexJoin = true;
    }

    public LQSelNode getSelNode() {
        return this.selNode;
    }

    public void setSelNode(LQSelNode lQSelNode) {
        this.selNode = lQSelNode;
    }

    public BitSet getLCondTables() {
        return this.lCondTables;
    }

    public BitSet getRCondTables() {
        return this.rCondTables;
    }

    public void setMayConflict(boolean bl) {
        this.mayConflict = bl;
    }

    public BitSet getBelowTables() {
        if (this.belowTables == null) {
            this.belowTables = (BitSet)this.leftTables.clone();
            this.belowTables.or(this.rightTables);
        }
        return this.belowTables;
    }

    @Override
    public LQJoinNode clone() {
        LQJoinNode lQJoinNode = new LQJoinNode();
        if (this.children != null) {
            lQJoinNode.children = (ArrayList)this.children.clone();
        } else {
            lQJoinNode.children = new ArrayList();
            for (int i = 0; i < 2; ++i) {
                lQJoinNode.children.add(null);
            }
        }
        lQJoinNode.conditionRoot = this.conditionRoot;
        lQJoinNode.filterCondition = this.filterCondition;
        lQJoinNode.content = this.content;
        lQJoinNode.cost = this.cost;
        lQJoinNode.isLeftOuterJoin = this.isLeftOuterJoin;
        lQJoinNode.isRightOuterJoin = this.isRightOuterJoin;
        lQJoinNode.joinType = this.joinType;
        lQJoinNode.leftFields = this.leftFields;
        lQJoinNode.memorySize = this.memorySize;
        lQJoinNode.noDistributedJoin = this.noDistributedJoin;
        lQJoinNode.numTuples = this.numTuples;
        lQJoinNode.oneSideRelation = this.oneSideRelation;
        lQJoinNode.op = this.op;
        lQJoinNode.outputRelation = this.outputRelation;
        lQJoinNode.parent = this.parent;
        lQJoinNode.reference = this.reference;
        lQJoinNode.rightFields = this.rightFields;
        lQJoinNode.swapChildren = this.swapChildren;
        lQJoinNode.tupleSize = this.tupleSize;
        lQJoinNode.type = this.type;
        lQJoinNode.isComplexJoin = this.isComplexJoin;
        lQJoinNode.leftTables = this.leftTables;
        lQJoinNode.rightTables = this.rightTables;
        return lQJoinNode;
    }

    @Override
    public HashSet<GQDatabaseRef> getDatabaseRefs(GQDatabaseRef gQDatabaseRef, boolean bl) {
        HashSet<GQDatabaseRef> hashSet = new HashSet<GQDatabaseRef>(2);
        if (!this.joinSupported()) {
            this.database = GQDatabaseRef.UNITYJDBC_DBREF;
            hashSet.add(this.database);
            return hashSet;
        }
        return hashSet;
    }

    private boolean joinSupported() {
        if (this.isComplexJoin && DatabaseMapping.isSupported("#NONEQUIJOIN#", this.database, null) != 1) {
            return false;
        }
        String string = "-1#";
        string = "-N#";
        if (this.isLeftOuterJoin && this.isRightOuterJoin) {
            return DatabaseMapping.isSupported("#FULLOUTERJOIN" + string, this.database, null) == 1;
        }
        if (this.isLeftOuterJoin) {
            return DatabaseMapping.isSupported("#LEFTOUTERJOIN" + string, this.database, null) == 1;
        }
        if (this.isRightOuterJoin) {
            return DatabaseMapping.isSupported("#RIGHTOUTERJOIN" + string, this.database, null) == 1;
        }
        return DatabaseMapping.isSupported("#EQUIJOIN" + string, this.database, null) == 1;
    }
}

