/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import unity.annotation.AnnotatedSourceDatabase;
import unity.generic.jdbc.StatementImpl;
import unity.jdbc.UnityConnection;
import unity.jdbc.UnityDriver;
import unity.operators.ResultSetScan;
import unity.query.GQDatabaseRef;
import unity.query.GlobalQuery;

public class LocalQuery
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String SQLQueryString;
    private AnnotatedSourceDatabase database;
    private Connection con;
    private ResultSet rs = null;
    private Statement stmt = null;
    private ResultSetScan resultSetScanOp;
    private int _resultSetType;
    private int _resultSetConcurrency;
    private String errorMessage;
    private boolean cancelled;
    private Thread executionThread;

    public LocalQuery(AnnotatedSourceDatabase annotatedSourceDatabase) {
        this.database = annotatedSourceDatabase;
        this._resultSetType = 1003;
        this._resultSetConcurrency = 1007;
        this.errorMessage = null;
        this.cancelled = false;
    }

    public LocalQuery(GQDatabaseRef gQDatabaseRef, GlobalQuery globalQuery) {
        this.SQLQueryString = "";
        if (gQDatabaseRef != null) {
            this.database = gQDatabaseRef.getDatabase();
        }
        this._resultSetType = 1003;
        this._resultSetConcurrency = 1007;
        this.errorMessage = null;
        this.cancelled = false;
    }

    public ResultSetScan getResultSetScan() {
        return this.resultSetScanOp;
    }

    public String getDatabaseName() {
        return this.database.getDatabaseName();
    }

    public void setResultSetType(int n) {
        this._resultSetType = n;
    }

    public void setResultSetConcurrency(int n) {
        this._resultSetConcurrency = n;
    }

    public void execute(UnityConnection unityConnection) throws SQLException {
        this.con = unityConnection.getConnection(this.database.getDatabaseName());
        if (this.stmt != null) {
            try {
                System.out.println("Closing pervious statement");
                this.stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.cancelled) {
            throw new SQLException("Statement cancelled");
        }
        if (this.resultSetScanOp == null) {
            this.stmt = this.con.createStatement(this._resultSetType, this._resultSetConcurrency);
            this.rs = this.stmt.executeQuery(this.SQLQueryString);
        } else {
            this.stmt = this.con.createStatement(1003, this._resultSetConcurrency);
            if (this.stmt instanceof StatementImpl) {
                ((StatementImpl)this.stmt).setStatus(StatementImpl.UNITY_PROMOTED_QUERY);
            }
            this.resultSetScanOp.setSQLString(this.SQLQueryString);
            if (!this.resultSetScanOp.getDelayedExecution()) {
                if (UnityDriver.DEBUG) {
                    System.out.println("Executing query: " + this.SQLQueryString);
                }
                if (this.cancelled) {
                    throw new SQLException("Statement cancelled");
                }
                this.rs = this.stmt.executeQuery(this.SQLQueryString);
                this.resultSetScanOp.setResultSet(this.rs);
                if (UnityDriver.DEBUG) {
                    System.out.println("Query execution complete.");
                }
            } else if (UnityDriver.DEBUG) {
                System.out.println("Delaying execution due to distributed join.");
            }
        }
    }

    public ResultSet getResultSet() {
        return this.rs;
    }

    public String getSQLQueryString() {
        return this.SQLQueryString;
    }

    public void setSQLQueryString(String string) {
        this.SQLQueryString = string;
    }

    public void setResultSetScanOp(ResultSetScan resultSetScan) {
        this.resultSetScanOp = resultSetScan;
    }

    public boolean hasErrorMessage() {
        return this.errorMessage != null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public AnnotatedSourceDatabase getDatabase() {
        return this.database;
    }

    public void setDatabase(AnnotatedSourceDatabase annotatedSourceDatabase) {
        this.database = annotatedSourceDatabase;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void cancel() {
        this.cancelled = true;
        System.out.println("HERE: " + this.stmt);
        if (this.stmt != null) {
            try {
                System.out.println("Cancelleing in local query: " + this.stmt);
                this.stmt.cancel();
                System.out.println("Cancel done.");
            }
            catch (SQLException sQLException) {
                System.out.println(sQLException);
            }
        }
    }

    public Thread getExecutionThread() {
        return this.executionThread;
    }

    public void setExecutionThread(Thread thread) {
        this.executionThread = thread;
    }
}

