/*
 * Decompiled with CFR 0.152.
 */
package pig.conn;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import pig.jdbc.PigResultSet;
import pig.jdbc.PigStatement;
import pig.query.PigBuilder;
import pig.query.PigQuery;
import unity.annotation.GlobalSchema;
import unity.annotation.SourceDatabase;
import unity.annotation.SourceField;
import unity.engine.IServerConnection;
import unity.engine.Relation;
import unity.engine.TableData;
import unity.engine.Tuple;
import unity.jdbc.LocalResultSet;
import unity.jdbc.UnityConnection;
import unity.jdbc.UnityStatement;
import unity.parser.GlobalParser;
import unity.query.GlobalCommand;
import unity.query.GlobalQuery;
import unity.query.LQTree;
import unity.util.Convert;

public class ServerConnection
implements IServerConnection {
    private boolean resultSetComplete;
    private String userName;
    private Properties properties;
    private PigQuery pigQuery;
    private Relation relation;
    private UnityConnection uconn = null;
    private SourceDatabase database;
    private GlobalSchema schema;
    private String validation;
    private String schemaLocation;
    private FileSystem fileSystem;
    private boolean dataComplete;
    private FSDataInputStream is;
    private BufferedReader br;
    private FileStatus[] files;
    private int fileLoc;

    @Override
    public void connect(Properties properties) throws SQLException {
        try {
            this.properties = properties;
            this.schema = new GlobalSchema();
            Object object = this.properties.get("rebuildschema");
            this.schemaLocation = (String)this.properties.get("schema");
            if (object != null && object.toString().equalsIgnoreCase("true")) {
                this.buildSchema();
                this.saveSchema(this.schemaLocation);
            }
            Object object2 = this.properties.get("validation");
            this.validation = (String)object2;
            if (object2 != null) {
                if (object2.toString().equalsIgnoreCase("strict")) {
                    if (!this.loadSchema(this.schemaLocation)) {
                        this.buildSchema();
                        this.saveSchema(this.schemaLocation);
                    }
                } else if (object2.toString().equalsIgnoreCase("flex")) {
                    this.loadSchema(this.schemaLocation);
                }
            }
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    public void saveSchema(String string) throws SQLException {
    }

    public boolean loadSchema(String string) {
        this.database = this.schema.loadDatabaseIntoSchema(string);
        return this.database != null;
    }

    public ResultSet getMoreResults(int n, Statement statement) throws SQLException {
        try {
            return null;
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    private ResultSet processPigWithUnity(String string, GlobalSchema globalSchema) throws SQLException {
        Object object;
        System.out.println("Processing query in UnityJDBC not handled by Apache Pig.");
        if (this.uconn == null) {
            try {
                Class.forName("unity.jdbc.UnityDriver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SQLException(classNotFoundException);
            }
            object = new Properties();
            this.uconn = (UnityConnection)DriverManager.getConnection("jdbc:unity://virtual", (Properties)object);
            if (globalSchema == null) {
                globalSchema = this.uconn.getGlobalSchema();
            }
        }
        this.uconn.setGlobalSchema(globalSchema);
        object = (UnityStatement)this.uconn.createStatement();
        GlobalQuery globalQuery = ((UnityStatement)object).parseQuery(string, true);
        return ((UnityStatement)object).executeQuery(globalQuery);
    }

    public ResultSet executeQuery(String string, int n, PigStatement pigStatement) throws SQLException {
        try {
            if (string.contains("SELECT 1")) {
                ArrayList<ArrayList<Object>> arrayList = new ArrayList<ArrayList<Object>>();
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>(1);
                arrayList2.add(1);
                arrayList.add(arrayList2);
                ArrayList<SourceField> arrayList3 = new ArrayList<SourceField>(1);
                arrayList3.add(new SourceField(null, null, null, "Field1", 4, "INT", 4, 0, 0, 0, "", null, 0, 1, "YES"));
                return new LocalResultSet(arrayList, new String[]{"Field1"}, arrayList3);
            }
            System.out.println("QUERY: " + string);
            string = string + ";";
            GlobalParser globalParser = new GlobalParser(false, true);
            GlobalQuery globalQuery = globalParser.parse(string, this.schema);
            System.out.println("Logical query tree: \n");
            LQTree lQTree = globalQuery.getLogicalQueryTree();
            lQTree.print();
            PigBuilder pigBuilder = new PigBuilder(lQTree.getRoot());
            this.pigQuery = null;
            try {
                this.pigQuery = pigBuilder.buildQuery();
            }
            catch (Exception exception) {
                System.out.println(exception);
                return this.processPigWithUnity(string, this.schema);
            }
            pigStatement.setQuery(this.pigQuery);
            System.out.println(this.pigQuery.toString());
            System.out.println("Executing query...");
            this.pigQuery.execute();
            this.fileLoc = 0;
            this.dataComplete = false;
            try {
                this.fileSystem = FileSystem.get((Configuration)new Configuration());
                this.files = this.fileSystem.listStatus(new Path(this.pigQuery.getOutputPath()));
                this.getNextFile();
            }
            catch (IOException iOException) {
                throw new SQLException(iOException);
            }
            this.relation = lQTree.getRoot().getOutputRelation();
            TableData tableData = new TableData(this, n != 1003, 0L);
            tableData.setRelation(this.relation);
            return new PigResultSet(tableData, this.relation, n, pigStatement);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SQLException(exception);
        }
    }

    @Override
    public boolean next(long l, Tuple tuple) throws SQLException {
        if (this.resultSetComplete) {
            return false;
        }
        try {
            return this.readRow(tuple);
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    @Override
    public boolean get(long l, int n, Tuple tuple) throws SQLException {
        try {
            return false;
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    @Override
    public int getLast(long l) throws SQLException {
        try {
            return 0;
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    @Override
    public void setFetchSize(int n, int n2) {
    }

    @Override
    public void close() throws SQLException {
        try {
            this.pigQuery.close();
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    @Override
    public void closeStatement(long l) throws SQLException {
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public SourceDatabase getDatabase() {
        if (this.database == null) {
            this.buildSchema();
        }
        return this.database;
    }

    public GlobalSchema getSchema() {
        if (this.database == null) {
            this.buildSchema();
        }
        return this.schema;
    }

    public void buildSchema() {
        System.out.println("Building schema");
        this.database = this.buildSourceDatabase();
        this.schema.addDatabase(this.database);
        if (this.validation != null && this.validation.equalsIgnoreCase("flex")) {
            try {
                this.saveSchema(this.schemaLocation);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public SourceDatabase buildSourceDatabase() {
        return null;
    }

    private void getNextFile() throws IOException {
        this.is = null;
        while (this.files != null && this.fileLoc < this.files.length) {
            FileStatus fileStatus;
            if ((fileStatus = this.files[this.fileLoc++]).isDir() || fileStatus.getPath().toString().contains("_SUCCESS")) continue;
            this.is = this.fileSystem.open(fileStatus.getPath());
            this.br = new BufferedReader(new InputStreamReader((InputStream)this.is));
            break;
        }
        if (this.is == null) {
            this.dataComplete = true;
        }
    }

    private boolean readRow(Tuple tuple) throws Exception {
        while (!this.dataComplete) {
            String string = this.br.readLine();
            if (string == null) {
                this.getNextFile();
                this.dataComplete = this.is == null;
                continue;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|\t");
            ArrayList<String> arrayList = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            Object[] objectArray = new Object[this.relation.getNumAttributes()];
            for (int i = 0; i < this.relation.getNumAttributes(); ++i) {
                objectArray[i] = Convert.convertStringToObject((String)arrayList.get(i), this.relation.getAttributeType(i), "yyyy-MM-dd", "HH:mm:ss", "yyyy-MM-dd HH:mm:ss");
            }
            tuple.setValues(objectArray);
            return true;
        }
        return false;
    }

    public String getOutputPath() {
        if (this.pigQuery != null) {
            return this.pigQuery.getOutputPath();
        }
        return "";
    }

    @Override
    public GlobalCommand getCommand(long l) throws SQLException {
        return null;
    }
}

