/*
 * Decompiled with CFR 0.152.
 */
package splunk.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import splunk.jdbc.SplunkConnection;
import unity.generic.jdbc.DriverImpl;
import unity.jdbc.UnityDriver;

public class SplunkDriver
extends DriverImpl {
    public static final String URL_PREFIX = "jdbc:splunk://";
    public static final int STRING_MAX_FIELD_SIZE = 10000000;

    protected static ResourceBundle getResources() {
        return resources;
    }

    public SplunkDriver() {
        this._MAJORVERSION = 0;
        this._MINORVERSION = 1;
    }

    @Override
    public boolean acceptsURL(String string) throws SQLException {
        int n = string.toLowerCase().indexOf(URL_PREFIX);
        return n >= 0;
    }

    @Override
    public Connection connect(String string, Properties properties) throws SQLException {
        Object object;
        Object object2;
        String string2;
        if (!this.acceptsURL(string)) {
            return null;
        }
        Properties properties2 = properties;
        if (properties == null) {
            properties2 = new Properties();
        }
        int n = string.toLowerCase().indexOf(URL_PREFIX);
        String string3 = string = string.substring(n + 12);
        int n2 = string.indexOf("?");
        if (n2 > 0) {
            string2 = string.substring(n2 + 1);
            object2 = new StringTokenizer(string2, "=&;");
            while (((StringTokenizer)object2).hasMoreTokens()) {
                object = ((StringTokenizer)object2).nextToken();
                if (!((StringTokenizer)object2).hasMoreTokens()) continue;
                String string4 = ((StringTokenizer)object2).nextToken();
                properties2.put(object, string4);
                if (((String)object).equals("debug")) {
                    if (!string4.equals("1") && !string4.equalsIgnoreCase("true")) continue;
                    UnityDriver.DEBUG = true;
                    continue;
                }
                if (!string4.equalsIgnoreCase("log") || !((StringTokenizer)object2).hasMoreTokens()) continue;
                string4 = ((StringTokenizer)object2).nextToken();
                properties.setProperty("log", string4);
            }
            string3 = string.substring(0, n2);
        }
        if ((string2 = properties.getProperty("log")) != null && !string2.equals("")) {
            UnityDriver.initializeLog(string2);
        }
        if (!properties2.containsKey("rebuildschema")) {
            properties2.put("rebuildschema", "false");
        }
        if ((object2 = properties2.getProperty("schema")) == null) {
            object2 = "splunk_schema.xml";
            properties2.put("schema", object2);
        }
        object = new SplunkConnection(string3, properties2);
        return object;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        String[] stringArray = new String[]{"debug", "user", "password", "cursor", "encoding", "schema", "rebuildschema"};
        String[] stringArray2 = new String[]{"false", "", "", "client", "utf-8", "", "false"};
        String[][] stringArrayArray = new String[][]{{"true", "false"}, new String[0], new String[0], {"client", "server"}, {"utf-8"}, new String[0], {"true", "false"}};
        String[] stringArray3 = new String[]{"The debug property will cause the driver to print out debug information to the console during its operation.", "User name for connection.", "Password for connection.", "For scrollable ResultSets, should the cursor be on the client or server.", "Character encoding used.", "Location of schema as a URI.", "If true, rebuilds schema for connection.  If false, uses existing cached schema if available.  Uses location provided in schema property."};
        boolean[] blArray = new boolean[]{false, true, false, false, false, false, false};
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            driverPropertyInfoArray[i] = new DriverPropertyInfo(stringArray[i], stringArray2[i]);
            if (properties != null && properties.containsKey(stringArray[i])) {
                driverPropertyInfoArray[i].value = properties.getProperty(stringArray[i]);
            }
            driverPropertyInfoArray[i].description = stringArray3[i];
            driverPropertyInfoArray[i].choices = stringArrayArray[i];
            driverPropertyInfoArray[i].required = blArray[i];
        }
        return driverPropertyInfoArray;
    }

    static {
        resources = ResourceBundle.getBundle("resources/splunk", locale);
        try {
            DriverManager.registerDriver(new SplunkDriver());
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(resources.getString("registerError") + sQLException);
        }
    }
}

