/*
 * Decompiled with CFR 0.152.
 */
package unity.annotation;

import com.unityjdbc.sourcebuilder.ExtractStatus;
import com.unityjdbc.sourcebuilder.ExtractThread;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;
import unity.annotation.AnnotatedSourceDatabase;
import unity.annotation.AnnotatedSourceField;
import unity.annotation.AnnotatedSourceForeignKey;
import unity.annotation.AnnotatedSourceJoin;
import unity.annotation.AnnotatedSourceTable;
import unity.annotation.CommonMethods;
import unity.annotation.SAXHandler;
import unity.annotation.SourceDatabase;
import unity.annotation.SourceField;
import unity.annotation.SourceForeignKey;
import unity.annotation.SourceJoin;
import unity.annotation.SourceKey;
import unity.annotation.SourceTable;
import unity.io.FileManager;
import unity.jdbc.UnityDriver;
import unity.util.EncryptDecrypt;
import unity.util.StringFunc;

public class GlobalSchema {
    protected ArrayList<SourceDatabase> annotatedDatabases = new ArrayList();
    protected HashMap<String, String> catalogIdentifiers = new HashMap();
    protected HashMap<String, String> schemaIdentifiers = new HashMap();
    protected HashMap<String, ArrayList<AnnotatedSourceTable>> tableIdentifiers = new HashMap();
    protected HashMap<String, ArrayList<AnnotatedSourceField>> fieldIdentifiers = new HashMap();
    protected String sourcesURL;
    protected Document doc;
    protected boolean isVirtual = false;

    public ArrayList<SourceDatabase> getAnnotatedDatabases() {
        return this.annotatedDatabases;
    }

    public ArrayList<SourceDatabase> getAnnotatedDatabasesByName() {
        Collections.sort(this.annotatedDatabases, SourceDatabase.SourceDatabaseNameComparator);
        return this.annotatedDatabases;
    }

    public AnnotatedSourceDatabase getDB(String string) {
        String string2 = StringFunc.idHashKey(new String[]{StringFunc.undelimitName(string, '\"')});
        for (int i = 0; i < this.annotatedDatabases.size(); ++i) {
            AnnotatedSourceDatabase annotatedSourceDatabase = (AnnotatedSourceDatabase)this.annotatedDatabases.get(i);
            String string3 = StringFunc.idHashKey(new String[]{StringFunc.undelimitName(annotatedSourceDatabase.getDatabaseName(), '\"')});
            if (!string2.equals(string3)) continue;
            return annotatedSourceDatabase;
        }
        return null;
    }

    public void updateSchemaFile(String string) throws IOException {
        AnnotatedSourceDatabase annotatedSourceDatabase = this.getDB(string);
        if (annotatedSourceDatabase == null) {
            return;
        }
        annotatedSourceDatabase.updateSchemaFile();
    }

    public void parseSources(String string, Properties properties) throws SQLException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            if (string == null) {
                return;
            }
            InputSource inputSource = new InputSource(new StringReader(string));
            this.doc = documentBuilder.parse(inputSource);
            this.isVirtual = true;
            this.createAnnotatedSources(null, properties);
        }
        catch (Exception exception) {
            throw new SQLException(UnityDriver.i18n.getString("GlobalSchema.parseErrorSourceFile") + exception.toString());
        }
    }

    public void parseSourcesFile(BufferedReader bufferedReader, String string, Properties properties) throws SQLException {
        this.sourcesURL = string;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource(bufferedReader);
            this.doc = documentBuilder.parse(inputSource);
            this.createAnnotatedSources(string.substring(13), properties);
        }
        catch (Exception exception) {
            if (exception.toString().contains("Content is not allowed in prolog")) {
                throw new SQLException(UnityDriver.i18n.getString("GlobalSchema.parseErrorSourceFileFormat") + " System default character encoding: " + Charset.defaultCharset());
            }
            throw new SQLException(UnityDriver.i18n.getString("GlobalSchema.parseErrorSourceFile") + exception.toString());
        }
    }

    private void createAnnotatedSources(String string, Properties properties) throws SQLException {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = null;
        String string6 = "";
        String string7 = "";
        String string8 = null;
        Node node = this.doc.getDocumentElement();
        for (node = node.getFirstChild(); node != null && !node.getNodeName().equals("DATABASE"); node = node.getNextSibling()) {
        }
        while (node != null) {
            if (node.getNodeName().equals("DATABASE")) {
                AnnotatedSourceDatabase annotatedSourceDatabase;
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    if (node2.getNodeName().equals("URL")) {
                        string2 = CommonMethods.getName(node2);
                        continue;
                    }
                    if (node2.getNodeName().equals("DRIVER")) {
                        string3 = CommonMethods.getName(node2);
                        continue;
                    }
                    if (node2.getNodeName().equals("XSPEC") || node2.getNodeName().equals("SCHEMA")) {
                        string4 = CommonMethods.getName(node2);
                        continue;
                    }
                    if (node2.getNodeName().equals("SCHEMAPASSWORD")) {
                        string5 = CommonMethods.getName(node2);
                        continue;
                    }
                    if (node2.getNodeName().equals("SYSTEM_SCHEMA")) {
                        string8 = CommonMethods.getName(node2);
                        continue;
                    }
                    if (node2.getNodeName().equals("USER")) {
                        string6 = CommonMethods.getName(node2);
                        continue;
                    }
                    if (!node2.getNodeName().equals("PASSWORD")) continue;
                    string7 = CommonMethods.getName(node2);
                }
                if (properties.containsKey("password")) {
                    string5 = properties.getProperty("password");
                }
                if (!this.isVirtual) {
                    annotatedSourceDatabase = this.importXML(string, string4, string5, properties);
                } else {
                    String string9 = properties.getProperty(string4);
                    if (string9 == null) {
                        System.out.println("WARNING: Did not find schema information for database " + string4 + " in properties passed as connection information.");
                        node = node.getNextSibling();
                        continue;
                    }
                    annotatedSourceDatabase = this.importSchema(new ByteArrayInputStream(string9.getBytes()));
                    annotatedSourceDatabase.setSchemaFile(string4);
                }
                annotatedSourceDatabase.setURL(string2);
                annotatedSourceDatabase.setJavaDriverClassName(string3);
                annotatedSourceDatabase.setSchema(string8);
                if (!string6.equals("")) {
                    annotatedSourceDatabase.setUserId(string6);
                }
                if (!string7.equals("")) {
                    annotatedSourceDatabase.setPassword(string7);
                }
                this.annotatedDatabases.add(annotatedSourceDatabase);
            }
            node = node.getNextSibling();
            string6 = "";
            string7 = "";
        }
        this.linkForeignKeysAndJoinsAll();
    }

    public void export(OutputStream outputStream, String string) throws IOException {
        String string2 = this.exportSources();
        OutputStream outputStream2 = outputStream;
        if (string != null) {
            try {
                EncryptDecrypt encryptDecrypt = new EncryptDecrypt(string);
                outputStream2 = encryptDecrypt.getEncryptStream(outputStream2);
            }
            catch (Exception exception) {
                throw new IOException("Failed to encrypt sources file.");
            }
        }
        outputStream2.write(string2.getBytes(Charset.forName("UTF-8")));
        outputStream2.close();
    }

    public void exportSources(String string) throws IOException {
        FileWriter fileWriter = new FileWriter(string);
        fileWriter.write(this.exportSources());
        fileWriter.close();
    }

    public AnnotatedSourceDatabase updateSource(String string) throws SQLException {
        AnnotatedSourceDatabase annotatedSourceDatabase = this.getDB(string);
        if (annotatedSourceDatabase == null) {
            return null;
        }
        ExtractStatus extractStatus = new ExtractStatus();
        ExtractThread extractThread = new ExtractThread(extractStatus, annotatedSourceDatabase.getJavaDriverClassName(), annotatedSourceDatabase.getURL(), annotatedSourceDatabase.getUserId(), annotatedSourceDatabase.getPassword(), string, annotatedSourceDatabase.getSchema(), annotatedSourceDatabase.getTableInclude(), annotatedSourceDatabase.getTableExclude(), annotatedSourceDatabase.getCatalogInclude(), 1);
        extractThread.start();
        while (!extractStatus.isComplete()) {
            Thread.yield();
        }
        AnnotatedSourceDatabase annotatedSourceDatabase2 = extractThread.getDatabase();
        annotatedSourceDatabase2.setSchemaFile(annotatedSourceDatabase.getSchemaFile());
        this.removeDatabase(string);
        this.addDatabase(annotatedSourceDatabase2);
        return annotatedSourceDatabase2;
    }

    public String exportSources() {
        StringBuffer stringBuffer = new StringBuffer(2000);
        stringBuffer.append("<SOURCES>\n");
        for (int i = 0; i < this.annotatedDatabases.size(); ++i) {
            SourceDatabase sourceDatabase = this.annotatedDatabases.get(i);
            stringBuffer.append(sourceDatabase.exportSourceXML());
        }
        stringBuffer.append("</SOURCES>\n");
        return stringBuffer.toString();
    }

    public String exportSource(String string) {
        StringBuffer stringBuffer = new StringBuffer(2000);
        stringBuffer.append("<SOURCES>\n");
        AnnotatedSourceDatabase annotatedSourceDatabase = this.getDB(string);
        if (annotatedSourceDatabase != null) {
            stringBuffer.append(annotatedSourceDatabase.exportSourceXML());
        }
        stringBuffer.append("</SOURCES>\n");
        return stringBuffer.toString();
    }

    public String exportSchema(String string) throws SQLException {
        AnnotatedSourceDatabase annotatedSourceDatabase = this.getDB(string);
        if (annotatedSourceDatabase == null) {
            throw new SQLException(UnityDriver.i18n.getString("GlobalSchema.DBNotFound") + string);
        }
        return annotatedSourceDatabase.exportXML();
    }

    private void addTableIdentifier(String string, AnnotatedSourceTable annotatedSourceTable) {
        if (this.tableIdentifiers.containsKey(string)) {
            ArrayList<AnnotatedSourceTable> arrayList = this.tableIdentifiers.get(string);
            if (!arrayList.contains(annotatedSourceTable)) {
                arrayList.add(annotatedSourceTable);
            }
        } else {
            ArrayList<AnnotatedSourceTable> arrayList = new ArrayList<AnnotatedSourceTable>();
            arrayList.add(annotatedSourceTable);
            this.tableIdentifiers.put(string, arrayList);
        }
    }

    public void removeTableIdentifier(String string, SourceTable sourceTable) {
        if (this.tableIdentifiers.containsKey(string)) {
            ArrayList<AnnotatedSourceTable> arrayList = this.tableIdentifiers.get(string);
            arrayList.remove(sourceTable);
        }
    }

    public void removeFieldIdentifier(String string, SourceField sourceField) {
        if (this.fieldIdentifiers.containsKey(string)) {
            ArrayList<AnnotatedSourceField> arrayList = this.fieldIdentifiers.get(string);
            arrayList.remove(sourceField);
        }
    }

    private void addFieldIdentifier(String string, AnnotatedSourceField annotatedSourceField) {
        if (this.fieldIdentifiers.containsKey(string)) {
            ArrayList<AnnotatedSourceField> arrayList = this.fieldIdentifiers.get(string);
            if (!arrayList.contains(annotatedSourceField)) {
                arrayList.add(annotatedSourceField);
            }
        } else {
            ArrayList<AnnotatedSourceField> arrayList = new ArrayList<AnnotatedSourceField>();
            arrayList.add(annotatedSourceField);
            this.fieldIdentifiers.put(string, arrayList);
        }
    }

    public ArrayList<AnnotatedSourceTable> findTable(String string) {
        return this.tableIdentifiers.get(string);
    }

    public boolean tableExists(String string, String string2) {
        ArrayList<AnnotatedSourceTable> arrayList = this.findTable(string, string2);
        return arrayList != null && arrayList.size() >= 1;
    }

    public ArrayList<AnnotatedSourceTable> findTable(String[] stringArray) {
        ArrayList<AnnotatedSourceTable> arrayList = this.tableIdentifiers.get(StringFunc.idHashKey(stringArray));
        if (arrayList != null) {
            return arrayList;
        }
        int n = stringArray.length - 1;
        String string = stringArray[n];
        if (StringFunc.isDelimited(string, '\"')) {
            arrayList = this.tableIdentifiers.get(StringFunc.idHashKey(new String[]{string}));
            if (arrayList != null) {
                if (n == 0) {
                    return arrayList;
                }
                if ((arrayList = this.filterTables(stringArray, arrayList)).size() > 0) {
                    return arrayList;
                }
            }
            String string2 = StringFunc.undelimitName(string, '\"');
            arrayList = this.tableIdentifiers.get(StringFunc.idHashKey(new String[]{string2}));
            if (arrayList != null) {
                if (n == 0) {
                    return arrayList;
                }
                if ((arrayList = this.filterTables(stringArray, arrayList)).size() > 0) {
                    return arrayList;
                }
            }
        } else {
            arrayList = this.tableIdentifiers.get(StringFunc.idHashKey(new String[]{string}));
            if (arrayList != null) {
                if (n == 0) {
                    return arrayList;
                }
                if ((arrayList = this.filterTables(stringArray, arrayList)).size() > 0) {
                    return arrayList;
                }
            }
            String string3 = StringFunc.delimitName(string);
            arrayList = this.tableIdentifiers.get(StringFunc.idHashKey(new String[]{string3}));
            if (arrayList != null) {
                if (n == 0) {
                    return arrayList;
                }
                if ((arrayList = this.filterTables(stringArray, arrayList)).size() > 0) {
                    return arrayList;
                }
            }
        }
        return null;
    }

    protected ArrayList<AnnotatedSourceTable> filterTables(String[] stringArray, ArrayList<AnnotatedSourceTable> arrayList) {
        ArrayList<AnnotatedSourceTable> arrayList2 = new ArrayList<AnnotatedSourceTable>(arrayList.size());
        for (AnnotatedSourceTable annotatedSourceTable : arrayList) {
            String string;
            String string2;
            String string3 = annotatedSourceTable.getParentDatabase().getDatabaseName();
            String string4 = annotatedSourceTable.getSchemaName();
            String string5 = annotatedSourceTable.getCatalogName();
            if (stringArray.length == 2) {
                string2 = stringArray[0];
                if (!StringFunc.equalIds(string3, string2) && !StringFunc.equalIds(string5, string2) && !StringFunc.equalIds(string4, string2)) continue;
                arrayList2.add(annotatedSourceTable);
                continue;
            }
            if (stringArray.length == 3) {
                string2 = stringArray[0];
                string = stringArray[1];
                if (!(StringFunc.equalIds(string3, string2) && StringFunc.equalIds(string5, string) || StringFunc.equalIds(string5, string2) && StringFunc.equalIds(string4, string) || StringFunc.equalIds(string3, string2)) && !StringFunc.equalIds(string4, string)) continue;
                arrayList2.add(annotatedSourceTable);
                continue;
            }
            if (stringArray.length != 4) continue;
            string2 = stringArray[0];
            string = stringArray[1];
            String string6 = stringArray[2];
            if (!StringFunc.equalIds(string3, string2) || !StringFunc.equalIds(string5, string) || !StringFunc.equalIds(string4, string6)) continue;
            arrayList2.add(annotatedSourceTable);
        }
        return arrayList2;
    }

    public ArrayList<AnnotatedSourceTable> findTable(String string, String string2) {
        boolean bl = string != null && !string.equals("");
        String[] stringArray = bl ? new String[]{string, string2} : new String[]{string2};
        ArrayList<AnnotatedSourceTable> arrayList = this.tableIdentifiers.get(StringFunc.idHashKey(stringArray));
        if (arrayList != null) {
            return arrayList;
        }
        String[] stringArray2 = StringFunc.generateDelimitedNames(stringArray, 0, stringArray.length);
        for (int i = 0; i < stringArray2.length; ++i) {
            arrayList = this.tableIdentifiers.get(stringArray2[i]);
            if (arrayList == null) continue;
            return arrayList;
        }
        return null;
    }

    public ArrayList<AnnotatedSourceField> findField(String string) {
        ArrayList<AnnotatedSourceField> arrayList = this.fieldIdentifiers.get(string);
        if (arrayList == null) {
            int n;
            String string2 = "";
            if (StringFunc.isDelimited(string, '\"')) {
                string2 = StringFunc.undelimitName(string, '\"');
                arrayList = this.fieldIdentifiers.get(string2);
            }
            if (arrayList == null && (arrayList = this.fieldIdentifiers.get(StringFunc.idHashKey(new String[]{string2}))) == null && (n = StringFunc.extractNumber(string2)) >= 0) {
                String string3 = string2.substring(0, n);
                arrayList = this.findField(StringFunc.delimitName(string3));
                ArrayList<AnnotatedSourceField> arrayList2 = new ArrayList<AnnotatedSourceField>();
                for (AnnotatedSourceField annotatedSourceField : arrayList) {
                    SourceTable sourceTable = annotatedSourceField.getParentTable();
                    SourceField sourceField = sourceTable.getFieldByPattern(string);
                    if (sourceField == null) continue;
                    AnnotatedSourceField annotatedSourceField2 = new AnnotatedSourceField(sourceField);
                    annotatedSourceField2.setColumnName(string);
                    arrayList2.add(annotatedSourceField2);
                }
                return arrayList2;
            }
        }
        return arrayList;
    }

    public String getSourcesURL() {
        return this.sourcesURL;
    }

    private AnnotatedSourceDatabase importXML(String string, String string2, String string3, Properties properties) throws SQLException {
        Object object;
        InputStream inputStream = null;
        String string4 = "";
        if (string.contains("unityjdbc.jar")) {
            try {
                object = FileManager.getPathNoCorrect(string);
                object = string2.contains("UnityDemoPart.xml") ? (String)object + "/UnityDemoPart.xml" : (String)object + "/UnityDemoOrder.xml";
                inputStream = FileManager.getStream((String)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (inputStream == null && !((File)(object = new File(string2))).isAbsolute()) {
            String string5 = FileManager.getPath(string);
            String string6 = string5 + File.separator + string2;
            string4 = string2;
            if (UnityDriver.DEBUG) {
                System.out.println("Trying source file location: " + string6);
            }
            try {
                inputStream = string3 == null || string3.equals("") ? FileManager.getStream(string6) : FileManager.getDecryptedStream(string6, string3, properties);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (inputStream == null) {
            string4 = string2;
            if (UnityDriver.DEBUG) {
                System.out.println("Trying source file location: " + string2);
            }
            try {
                inputStream = string3 == null ? FileManager.getStream(string2) : FileManager.getDecryptedStream(string2, string3, properties);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new SQLException(UnityDriver.i18n.getString("GlobalSchema.parseErrorSchemaFile") + fileNotFoundException.toString());
            }
            catch (IOException iOException) {
                throw new SQLException(UnityDriver.i18n.getString("GlobalSchema.parseErrorSchemaFile") + iOException.toString());
            }
        }
        object = this.importSchema(inputStream);
        ((SourceDatabase)object).setSchemaFile(string4);
        FileManager.closeStream(inputStream);
        return object;
    }

    public AnnotatedSourceDatabase importSchema(InputStream inputStream) throws SQLException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            SAXHandler sAXHandler = new SAXHandler(this);
            sAXParser.parse(inputStream, (DefaultHandler)sAXHandler);
            return sAXHandler.getDatabase();
        }
        catch (Exception exception) {
            throw new SQLException(UnityDriver.i18n.getString("GlobalSchema.parseErrorSourceFile") + StringFunc.stackTrace(exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnnotatedSourceDatabase loadDatabaseIntoSchema(String string) {
        BufferedInputStream bufferedInputStream = null;
        AnnotatedSourceDatabase annotatedSourceDatabase = null;
        try {
            bufferedInputStream = FileManager.openInputFile(string);
            annotatedSourceDatabase = this.importSchema(bufferedInputStream);
            this.addDatabase(annotatedSourceDatabase);
        }
        catch (Exception exception) {
        }
        finally {
            FileManager.closeStream(bufferedInputStream);
        }
        return annotatedSourceDatabase;
    }

    public HashSet<String> generateTableIdentifiers(SourceTable sourceTable) {
        String string;
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = sourceTable.getTableName();
        hashSet.add(StringFunc.idHashKey(new String[]{string2}));
        if (sourceTable instanceof AnnotatedSourceTable && (string = ((AnnotatedSourceTable)sourceTable).getSemanticTableName()) != null && !string.equals("")) {
            hashSet.add(StringFunc.idHashKey(new String[]{string}));
        }
        return hashSet;
    }

    public HashSet<String> addTableIdentifier(AnnotatedSourceTable annotatedSourceTable) {
        HashSet<String> hashSet = this.generateTableIdentifiers(annotatedSourceTable);
        for (String string : hashSet) {
            this.addTableIdentifier(string, annotatedSourceTable);
        }
        return hashSet;
    }

    public void addFieldIdentifier(AnnotatedSourceField annotatedSourceField, HashSet<String> hashSet) {
        String string = StringFunc.idHashKey(new String[]{annotatedSourceField.getUnitySQLColumnName()});
        String string2 = StringFunc.idHashKey(new String[]{annotatedSourceField.getSemanticFieldName()});
        this.addFieldIdentifier(string, annotatedSourceField);
        if (string2 != null && !string2.equals("")) {
            this.addFieldIdentifier(string2, annotatedSourceField);
            for (String string3 : hashSet) {
                this.addFieldIdentifier(string3 + '.' + string, annotatedSourceField);
                this.addFieldIdentifier(string3 + '.' + string2, annotatedSourceField);
            }
        } else {
            for (String string4 : hashSet) {
                this.addFieldIdentifier(string4 + '.' + string, annotatedSourceField);
            }
        }
    }

    public void addTableIdentifiers(AnnotatedSourceTable annotatedSourceTable) {
        HashSet<String> hashSet = this.addTableIdentifier(annotatedSourceTable);
        for (Map.Entry<String, SourceField> entry : annotatedSourceTable.getSourceFields().entrySet()) {
            SourceField sourceField = entry.getValue();
            this.addFieldIdentifier((AnnotatedSourceField)sourceField, hashSet);
        }
    }

    public void linkForeignKeysAndJoinsAll() {
        ArrayList<SourceDatabase> arrayList = this.getAnnotatedDatabases();
        for (int i = 0; i < arrayList.size(); ++i) {
            AnnotatedSourceDatabase annotatedSourceDatabase = (AnnotatedSourceDatabase)arrayList.get(i);
            HashMap<String, SourceTable> hashMap = annotatedSourceDatabase.getSourceTables();
            this.linkForeignKeysAndJoins(hashMap);
        }
    }

    private void linkForeignKeysAndJoins(HashMap<String, SourceTable> hashMap) {
        for (AnnotatedSourceTable annotatedSourceTable : hashMap.values()) {
            Object object;
            ArrayList<SourceForeignKey> arrayList = annotatedSourceTable.getForeignKeys();
            for (int i = 0; i < arrayList.size(); ++i) {
                object = (AnnotatedSourceForeignKey)arrayList.get(i);
                String string = ((SourceForeignKey)object).getToTableName();
                if (string == null) continue;
                AnnotatedSourceTable annotatedSourceTable2 = (AnnotatedSourceTable)hashMap.get(StringFunc.idHashKey(new String[]{string}));
                if (annotatedSourceTable2 != null) {
                    ((SourceForeignKey)object).setToSourceTable(annotatedSourceTable2);
                    ((SourceForeignKey)object).setToKey(annotatedSourceTable2.getPrimaryKey());
                    continue;
                }
                ArrayList<AnnotatedSourceTable> arrayList2 = this.findTable(new String[]{string});
                if (arrayList2 == null || arrayList2.size() > 1) continue;
                annotatedSourceTable2 = arrayList2.get(0);
                ((SourceForeignKey)object).setToSourceTable(annotatedSourceTable2);
                ((SourceForeignKey)object).setToKey(annotatedSourceTable2.getPrimaryKey());
            }
            ArrayList<SourceJoin> arrayList3 = annotatedSourceTable.getJoins();
            object = annotatedSourceTable.getTableName();
            block2: for (int i = 0; i < arrayList3.size(); ++i) {
                Serializable serializable;
                String string;
                Object object2;
                AnnotatedSourceJoin annotatedSourceJoin = (AnnotatedSourceJoin)arrayList3.get(i);
                String string2 = annotatedSourceJoin.getFromTableName();
                if (string2.equals(object)) {
                    object2 = annotatedSourceTable.getPrimaryKey();
                    if (object2 == null) continue;
                    if (annotatedSourceJoin.getFromKeyName().equals(annotatedSourceTable.getPrimaryKey().getName())) {
                        annotatedSourceJoin.setFromKey(annotatedSourceTable.getPrimaryKey());
                        string = annotatedSourceJoin.getToKeyName();
                        serializable = (AnnotatedSourceTable)hashMap.get(StringFunc.idHashKey(new String[]{annotatedSourceJoin.getToTableName()}));
                        if (serializable == null) continue;
                        ArrayList<SourceForeignKey> arrayList4 = ((SourceTable)((Object)serializable)).getForeignKeys();
                        for (int j = 0; j < arrayList4.size(); ++j) {
                            AnnotatedSourceForeignKey annotatedSourceForeignKey = (AnnotatedSourceForeignKey)arrayList4.get(j);
                            if (!annotatedSourceForeignKey.getName().equals(string)) continue;
                            annotatedSourceJoin.setToKey(annotatedSourceForeignKey);
                            continue block2;
                        }
                        continue;
                    }
                    string = annotatedSourceJoin.getFromKeyName();
                    serializable = (AnnotatedSourceTable)hashMap.get(StringFunc.idHashKey(new String[]{annotatedSourceJoin.getToTableName()}));
                    for (int j = 0; j < arrayList.size(); ++j) {
                        AnnotatedSourceForeignKey annotatedSourceForeignKey = (AnnotatedSourceForeignKey)arrayList.get(j);
                        if (!annotatedSourceForeignKey.getName().equals(string)) continue;
                        annotatedSourceJoin.setFromKey(annotatedSourceForeignKey);
                        break;
                    }
                    if (serializable == null) continue;
                    annotatedSourceJoin.setToKey(((SourceTable)((Object)serializable)).getPrimaryKey());
                    continue;
                }
                annotatedSourceJoin.setToKey(annotatedSourceTable.getPrimaryKey());
                object2 = (AnnotatedSourceTable)hashMap.get(StringFunc.idHashKey(new String[]{annotatedSourceJoin.getFromTableName()}));
                string = annotatedSourceJoin.getFromKeyName();
                serializable = ((SourceTable)object2).getForeignKeys();
                for (int j = 0; j < ((ArrayList)serializable).size(); ++j) {
                    AnnotatedSourceForeignKey annotatedSourceForeignKey = (AnnotatedSourceForeignKey)((ArrayList)serializable).get(j);
                    if (!annotatedSourceForeignKey.getName().equals(string)) continue;
                    annotatedSourceJoin.setFromKey(annotatedSourceForeignKey);
                    continue block2;
                }
            }
        }
    }

    public void removeDatabase(String string) {
        AnnotatedSourceDatabase annotatedSourceDatabase = this.getDB(string);
        if (annotatedSourceDatabase != null) {
            this.annotatedDatabases.remove(annotatedSourceDatabase);
            Iterator<Map.Entry<String, SourceTable>> iterator = annotatedSourceDatabase.getSourceTables().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, SourceTable> entry = iterator.next();
                SourceTable sourceTable = entry.getValue();
                String string2 = entry.getKey();
                iterator.remove();
                this.removeTable(string2, string, annotatedSourceDatabase, sourceTable);
            }
        }
    }

    public void removeTable(String string, String string2) {
        SourceTable sourceTable;
        AnnotatedSourceDatabase annotatedSourceDatabase = this.getDB(string);
        if (annotatedSourceDatabase != null && (sourceTable = annotatedSourceDatabase.getTable(string2)) != null) {
            this.removeTable(string2, string, annotatedSourceDatabase, sourceTable);
        }
    }

    private void removeTable(String string, String string2, SourceDatabase sourceDatabase, SourceTable sourceTable) {
        Object i;
        Map.Entry<String, SourceField> entry2;
        Iterator<Map.Entry<String, SourceField>> iterator;
        sourceDatabase.removeTable(string);
        for (Map.Entry<String, SourceTable> object22 : sourceDatabase.getSourceTables().entrySet()) {
            iterator = object22.getValue();
            entry2 = ((SourceTable)((Object)iterator)).getForeignKeys();
            for (int j = 0; j < ((ArrayList)((Object)entry2)).size(); ++j) {
                if (((SourceForeignKey)((ArrayList)((Object)entry2)).get(j)).getToSourceTable() != sourceTable) continue;
                ((ArrayList)((Object)entry2)).remove(j);
                --j;
            }
            i = ((SourceTable)((Object)iterator)).getJoins();
            for (int j = 0; j < ((ArrayList)i).size(); ++j) {
                if (!((SourceJoin)((ArrayList)i).get(j)).getToTableName().equalsIgnoreCase(string)) continue;
                ((ArrayList)i).remove(j);
                --j;
            }
        }
        HashSet<String> hashSet = this.generateTableIdentifiers(sourceTable);
        for (Map.Entry<String, SourceField> entry2 : hashSet) {
            this.removeTableIdentifier((String)((Object)entry2), sourceTable);
        }
        iterator = sourceTable.getSourceFields().entrySet().iterator();
        while (iterator.hasNext()) {
            entry2 = iterator.next();
            i = entry2.getValue();
            String string3 = entry2.getKey();
            iterator.remove();
            this.removeFieldIdentifier(string3, (SourceField)i);
            for (String string4 : hashSet) {
                this.removeFieldIdentifier(string4 + '.' + string3, (SourceField)i);
            }
        }
    }

    public void removeField(String string, String string2, String string3) {
        SourceField sourceField;
        SourceTable sourceTable;
        AnnotatedSourceDatabase annotatedSourceDatabase = this.getDB(string);
        if (annotatedSourceDatabase != null && (sourceTable = annotatedSourceDatabase.getTable(string2)) != null && (sourceField = sourceTable.getField(string3)) != null) {
            this.removeField(string, string2, string3, annotatedSourceDatabase, sourceTable, sourceField);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void removeField(String string, String string2, String string3, SourceDatabase sourceDatabase, SourceTable sourceTable, SourceField sourceField) {
        void var11_22;
        void var11_19;
        void var11_16;
        ArrayList<SourceForeignKey> arrayList;
        SourceTable sourceTable2;
        Object object4;
        sourceTable.removeField(string3);
        SourceKey sourceKey = sourceTable.getPrimaryKey();
        boolean bl = false;
        if (sourceKey.containsField(sourceField)) {
            sourceTable.setPrimaryKey(null);
            bl = true;
        }
        Iterator<SourceKey> iterator = sourceTable.getCandidateKeys().iterator();
        while (iterator.hasNext()) {
            object4 = iterator.next();
            if (!((SourceKey)object4).containsField(sourceField)) continue;
            iterator.remove();
        }
        if (bl) {
            for (Map.Entry<String, SourceTable> object32 : sourceDatabase.getSourceTables().entrySet()) {
                sourceTable2 = object32.getValue();
                arrayList = sourceTable2.getForeignKeys();
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (arrayList.get(i).getToSourceTable() != sourceTable) continue;
                    arrayList.remove(i);
                    --i;
                }
                ArrayList<SourceJoin> arrayList2 = sourceTable2.getJoins();
                for (int i = 0; i < arrayList2.size(); ++i) {
                    if (!arrayList2.get(i).getToTableName().equalsIgnoreCase(string2)) continue;
                    arrayList2.remove(i);
                    --i;
                }
            }
        }
        object4 = sourceTable.getForeignKeys().iterator();
        while (object4.hasNext()) {
            SourceForeignKey sourceForeignKey = (SourceForeignKey)((Object)object4.next());
            if (!sourceForeignKey.containsField(sourceField)) continue;
            object4.remove();
            sourceTable.removeJoins(sourceForeignKey);
        }
        String string4 = sourceTable.getSQLTableNameWithSchema();
        if (string4.indexOf("\"") < 0) {
            String string5 = string4.toLowerCase();
        }
        sourceTable2 = var11_16;
        String string6 = sourceTable.getFullSQLTableName();
        if (string6.indexOf("\"") < 0) {
            String string7 = string6.toLowerCase();
        }
        arrayList = var11_19;
        this.removeFieldIdentifier(string3, sourceField);
        this.removeFieldIdentifier(string2 + '.' + string3, sourceField);
        this.removeFieldIdentifier(string + '.' + string2 + '.' + string3, sourceField);
        this.removeFieldIdentifier((String)((Object)sourceTable2) + '.' + string3, sourceField);
        this.removeFieldIdentifier(arrayList + '.' + string3, sourceField);
        String string8 = sourceField.getFullSQLColumnName();
        if (string8.indexOf("\"") < 0) {
            String string9 = string8.toLowerCase();
        }
        this.removeFieldIdentifier((String)var11_22, sourceField);
        String string10 = ((AnnotatedSourceField)sourceField).getSemanticFieldName().toLowerCase();
        this.removeFieldIdentifier(string10, sourceField);
    }

    public void addDatabase(String string, String string2, String string3) throws SQLException {
        Properties properties = new Properties();
        properties.put(string, string3);
        this.parseSources(string2, properties);
    }

    public void addDatabase(AnnotatedSourceDatabase annotatedSourceDatabase) {
        this.addDatabase((SourceDatabase)annotatedSourceDatabase);
    }

    public void addDatabase(SourceDatabase sourceDatabase) {
        this.annotatedDatabases.add(sourceDatabase);
        for (Map.Entry<String, SourceTable> entry : sourceDatabase.getSourceTables().entrySet()) {
            SourceTable sourceTable = entry.getValue();
            HashSet<String> hashSet = this.addTableIdentifier((AnnotatedSourceTable)sourceTable);
            for (Map.Entry<String, SourceField> entry2 : sourceTable.getSourceFields().entrySet()) {
                SourceField sourceField = entry2.getValue();
                this.addFieldIdentifier((AnnotatedSourceField)sourceField, hashSet);
            }
        }
    }

    public void addDatabase(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        Properties properties = new Properties();
        if (string6 == null) {
            throw new SQLException(UnityDriver.i18n.getString("GlobalSchema.AddDatabaseError"));
        }
        properties.put(string, string6);
        AnnotatedSourceDatabase annotatedSourceDatabase = this.importSchema(new ByteArrayInputStream(string6.getBytes()));
        annotatedSourceDatabase.setURL(string5);
        annotatedSourceDatabase.setJavaDriverClassName(string4);
        annotatedSourceDatabase.setSchemaFile(string);
        if (string2 == null || !string2.equals("")) {
            annotatedSourceDatabase.setUserId(string2);
        }
        if (string3 == null || !string3.equals("")) {
            annotatedSourceDatabase.setPassword(string3);
        }
        this.annotatedDatabases.add(annotatedSourceDatabase);
    }

    public String toString() {
        int n = this.annotatedDatabases.size();
        StringBuilder stringBuilder = new StringBuilder(1000 * (1 + n));
        stringBuilder.append("Global Schema - Databases: " + n + "\n");
        for (int i = 0; i < this.annotatedDatabases.size(); ++i) {
            SourceDatabase sourceDatabase = this.annotatedDatabases.get(i);
            stringBuilder.append(sourceDatabase.toString());
            stringBuilder.append("\n\n");
        }
        return stringBuilder.toString();
    }

    public void removeAllDatabases() {
        if (this.annotatedDatabases != null) {
            for (int i = this.annotatedDatabases.size() - 1; i >= 0; --i) {
                this.removeDatabase(this.annotatedDatabases.get(i).getDatabaseName());
            }
        }
    }
}

