/*
 * Decompiled with CFR 0.152.
 */
package unity.annotation;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import unity.annotation.AnnotatedSourceField;
import unity.annotation.AnnotatedSourceForeignKey;
import unity.annotation.AnnotatedSourceJoin;
import unity.annotation.AnnotatedSourceKey;
import unity.annotation.AnnotatedSourceTable;
import unity.annotation.CommonMethods;
import unity.annotation.SourceField;
import unity.annotation.SourceForeignKey;
import unity.annotation.SourceJoin;
import unity.annotation.SourceTable;
import unity.util.EncryptDecrypt;
import unity.util.StringFunc;

public class SourceDatabase
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String databaseName;
    protected String systemDatabaseName;
    protected HashMap<String, SourceTable> sourceTables = new HashMap();
    protected int databaseId;
    protected String databaseProductName;
    protected String databaseProductVersion;
    protected String url;
    protected String driverName;
    protected char delimitChar;
    protected String javaDriverClassName;
    protected String userId;
    protected String password;
    protected String schemaFile;
    protected String encryptionPassword;
    protected String schema;
    protected String tableInc;
    protected String tableExc;
    protected String catalogInc;
    protected LinkedHashMap<String, Object> properties = new LinkedHashMap();
    public static final Comparator<SourceDatabase> SourceDatabaseNameComparator = new Comparator<SourceDatabase>(){

        @Override
        public int compare(SourceDatabase sourceDatabase, SourceDatabase sourceDatabase2) {
            return sourceDatabase.getDatabaseName().compareTo(sourceDatabase2.getDatabaseName());
        }
    };

    public SourceDatabase(String string, String string2, String string3, String string4, String string5, String string6, char c) {
        this.databaseName = string;
        this.systemDatabaseName = string2;
        this.databaseProductName = string3;
        this.databaseProductVersion = string4;
        this.url = string5;
        this.driverName = string6;
        this.databaseId = 1000;
        this.delimitChar = c;
    }

    public void setDatabaseName(String string) {
        this.databaseName = string;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void updateSchemaFile() throws IOException {
        if (this.schemaFile != null) {
            PrintWriter printWriter = new PrintWriter(this.schemaFile);
            this.exportXML(printWriter);
            printWriter.close();
        }
    }

    public void setUserId(String string) {
        this.userId = string;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setSourceTables(HashMap<String, SourceTable> hashMap) {
        this.sourceTables = hashMap;
    }

    public HashMap<String, SourceTable> getSourceTables() {
        return this.sourceTables;
    }

    public ArrayList<SourceTable> getSourceTablesByName() {
        ArrayList<SourceTable> arrayList = new ArrayList<SourceTable>(this.sourceTables.size());
        for (Map.Entry<String, SourceTable> entry : this.sourceTables.entrySet()) {
            arrayList.add(entry.getValue());
        }
        Collections.sort(arrayList, SourceTable.SourceTableNameComparator);
        return arrayList;
    }

    public void setDatabaseProductName(String string) {
        this.databaseProductName = string;
    }

    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    public void setDatabaseProductVersion(String string) {
        this.databaseProductVersion = string;
    }

    public String getDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String string) {
        this.url = string;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String string) {
        this.driverName = string;
    }

    public String getJavaDriverClassName() {
        return this.javaDriverClassName;
    }

    public void setJavaDriverClassName(String string) {
        this.javaDriverClassName = string;
    }

    public void addTable(SourceTable sourceTable) {
        this.sourceTables.put(StringFunc.idHashKey(new String[]{sourceTable.getTableName()}), sourceTable);
    }

    public void removeTable(String string) {
        this.sourceTables.remove(StringFunc.idHashKey(new String[]{string}));
    }

    public SourceTable getTable(String string) {
        SourceTable sourceTable = this.sourceTables.get(StringFunc.idHashKey(new String[]{string}));
        if (sourceTable != null) {
            return sourceTable;
        }
        return this.sourceTables.get(StringFunc.idHashKey(new String[]{StringFunc.delimitName(string)}));
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("    <databaseName>" + CommonMethods.exportString(this.databaseName) + "</databaseName>\n");
        stringBuffer.append("    <databaseSystemName>" + CommonMethods.exportString(this.systemDatabaseName) + "</databaseSystemName>\n");
        stringBuffer.append("    <databaseSchemaName>" + CommonMethods.exportString(this.schema) + "</databaseSchemaName>\n");
        stringBuffer.append("    <databaseId>" + this.databaseId + "</databaseId>\n");
        stringBuffer.append("    <databaseProductName>" + CommonMethods.exportString(this.databaseProductName) + "</databaseProductName>\n");
        stringBuffer.append("    <databaseProductVersion>" + CommonMethods.exportString(this.databaseProductVersion) + "</databaseProductVersion>\n");
        stringBuffer.append("    <urlJDBC>" + CommonMethods.exportString(this.url) + "</urlJDBC>\n");
        if (this.userId != null) {
            stringBuffer.append("    <userid>" + CommonMethods.exportString(this.userId) + "</userid>\n");
        }
        if (this.password != null) {
            stringBuffer.append("    <password>" + CommonMethods.exportString(this.password) + "</password>\n");
        }
        stringBuffer.append("    <driverName>" + CommonMethods.exportString(this.driverName) + "</driverName>\n");
        stringBuffer.append("    <driverClass>" + CommonMethods.exportString(this.javaDriverClassName) + "</driverClass>\n");
        stringBuffer.append("    <delimitId>" + this.delimitChar + "</delimitId>\n");
        stringBuffer.append("    <catalogsIncluded>" + CommonMethods.exportString(this.catalogInc) + "</catalogsIncluded>\n");
        stringBuffer.append("    <tablesIncluded>" + CommonMethods.exportString(this.tableInc) + "</tablesIncluded>\n");
        stringBuffer.append("    <tablesExcluded>" + CommonMethods.exportString(this.tableExc) + "</tablesExcluded>\n");
        if (this.properties != null && this.properties.size() > 0) {
            stringBuffer.append("    <properties>" + StringFunc.encodeProperties(this.properties) + "</properties>");
        }
        return stringBuffer.toString();
    }

    public String exportXML() {
        CharArrayWriter charArrayWriter = new CharArrayWriter(this.sourceTables.size() * 500);
        try {
            this.export(charArrayWriter);
        }
        catch (IOException iOException) {
            if (charArrayWriter != null) {
                charArrayWriter.close();
            }
            return "Error on export database schema.";
        }
        String string = charArrayWriter.toString();
        charArrayWriter.close();
        return string;
    }

    public void exportXML(File file) throws IOException {
        FileOutputStream fileOutputStream = null;
        PrintWriter printWriter = null;
        fileOutputStream = new FileOutputStream(file);
        printWriter = new PrintWriter(fileOutputStream, true);
        this.exportXML(printWriter);
        printWriter.close();
        fileOutputStream.close();
    }

    public void exportXML(OutputStream outputStream, String string) throws IOException {
        PrintWriter printWriter = null;
        BufferedWriter bufferedWriter = null;
        bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(outputStream), string));
        printWriter = new PrintWriter((Writer)bufferedWriter, true);
        this.exportXML(printWriter);
        printWriter.close();
        outputStream.close();
    }

    public void export(OutputStream outputStream, String string) throws IOException {
        OutputStream outputStream2 = outputStream;
        EncryptDecrypt encryptDecrypt = null;
        if (string != null) {
            encryptDecrypt = new EncryptDecrypt(string);
            try {
                outputStream2 = encryptDecrypt.getEncryptStream(outputStream2);
            }
            catch (Exception exception) {
                throw new IOException("Failed to encrypt schema file.");
            }
        }
        this.exportXML(outputStream2, "UTF-8");
    }

    public void exportXML(OutputStream outputStream) throws IOException {
        PrintWriter printWriter = null;
        printWriter = new PrintWriter((Writer)new OutputStreamWriter(outputStream, Charset.forName("UTF-8").newEncoder()), true);
        this.exportXML(printWriter);
        printWriter.close();
        outputStream.close();
    }

    private void export(Writer writer) throws IOException {
        writer.write("<?xml version = \"1.0\"?>\n");
        writer.write(10);
        writer.write("<XSPEC xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"xspec.xsd\">\n");
        writer.write(this.toXML() + "\n");
        TreeMap<String, SourceTable> treeMap = new TreeMap<String, SourceTable>(this.getSourceTables());
        Iterator<String> iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            writer.write("   <TABLE>\n");
            AnnotatedSourceTable annotatedSourceTable = (AnnotatedSourceTable)treeMap.get(iterator.next());
            writer.write(annotatedSourceTable.toXML() + "\n");
            TreeMap<String, SourceField> treeMap2 = new TreeMap<String, SourceField>(annotatedSourceTable.getSourceFields());
            Iterator<String> iterator2 = treeMap2.keySet().iterator();
            while (iterator2.hasNext()) {
                writer.write("     <FIELD>\n");
                AnnotatedSourceField annotatedSourceField = (AnnotatedSourceField)treeMap2.get(iterator2.next());
                writer.write(annotatedSourceField.toXML() + "\n");
                writer.write("     </FIELD>\n");
                writer.write(10);
            }
            AnnotatedSourceKey annotatedSourceKey = (AnnotatedSourceKey)annotatedSourceTable.getPrimaryKey();
            if (annotatedSourceKey != null) {
                writer.write(annotatedSourceKey.toXML() + "\n\n");
            }
            ArrayList<SourceForeignKey> arrayList = annotatedSourceTable.getForeignKeys();
            for (int i = 0; i < arrayList.size(); ++i) {
                writer.write(((AnnotatedSourceForeignKey)arrayList.get(i)).toXML() + "\n");
                writer.write(10);
            }
            ArrayList<SourceJoin> arrayList2 = annotatedSourceTable.getJoins();
            for (int i = 0; i < arrayList2.size(); ++i) {
                writer.write("     <JOIN>\n");
                writer.write(((AnnotatedSourceJoin)arrayList2.get(i)).toXML() + "\n");
                writer.write("     </JOIN>\n\n");
            }
            writer.write("   </TABLE>\n\n");
        }
        writer.write("</XSPEC>\n");
    }

    public void exportXML(PrintWriter printWriter) throws IOException {
        this.export(printWriter);
        printWriter.close();
    }

    public String exportSourceXML() {
        StringBuilder stringBuilder = new StringBuilder(1000);
        stringBuilder.append("\t<DATABASE>\n");
        stringBuilder.append("\t\t<URL>" + CommonMethods.exportString(this.url) + "</URL>\n");
        if (this.userId != null && !this.userId.equals("")) {
            stringBuilder.append("\t\t<USER>" + CommonMethods.exportString(this.userId) + "</USER>\n");
            stringBuilder.append("\t\t<PASSWORD>" + CommonMethods.exportString(this.password) + "</PASSWORD>\n");
        }
        stringBuilder.append("\t\t<DRIVER>" + CommonMethods.exportString(this.javaDriverClassName) + "</DRIVER>\n");
        if (this.schema != null) {
            stringBuilder.append("\t\t<SYSTEM_SCHEMA>" + CommonMethods.exportString(this.schema) + "</SYSTEM_SCHEMA>\n");
        }
        if (this.encryptionPassword != null && !this.encryptionPassword.equals("")) {
            stringBuilder.append("\t\t<SCHEMAPASSWORD>" + CommonMethods.exportString(this.userId) + "</SCHEMAPASSWORD>\n");
        }
        stringBuilder.append("\t\t<SCHEMA>" + CommonMethods.exportString(this.schemaFile) + "</SCHEMA>\n");
        stringBuilder.append("\t</DATABASE>\n");
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(10000);
        stringBuilder.append("Database:        " + this.databaseName + "\n");
        stringBuilder.append("System DB name:  " + this.systemDatabaseName + "\n");
        stringBuilder.append("Database System: " + this.databaseProductName + " " + this.databaseProductVersion + "\n");
        stringBuilder.append("URL:             " + this.url + "\n");
        stringBuilder.append("Driver:          " + this.driverName + "\n");
        stringBuilder.append("Database id:     " + this.databaseId + "\n");
        stringBuilder.append("Schema:          " + this.schema + "\n");
        stringBuilder.append("Tables included: " + this.tableInc + "\n");
        stringBuilder.append("Tables excluded: " + this.tableExc + "\n");
        if (this.sourceTables != null) {
            stringBuilder.append("# of tables: " + this.sourceTables.size() + "\n");
            stringBuilder.append("Tables:\n");
            Iterator<SourceTable> iterator = this.sourceTables.values().iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(iterator.next().toString() + "\n");
            }
        }
        return stringBuilder.toString();
    }

    public int getDatabaseId() {
        return this.databaseId;
    }

    public void setDatabaseId(int n) {
        this.databaseId = n;
    }

    public String getSchemaFile() {
        return this.schemaFile;
    }

    public void setSchemaFile(String string) {
        this.schemaFile = string;
    }

    public String getEncryptionPassword() {
        return this.encryptionPassword;
    }

    public void setEncryptionPassword(String string) {
        this.encryptionPassword = string;
    }

    public String getSystemDatabaseName() {
        return this.systemDatabaseName;
    }

    public void setSystemDatabaseName(String string) {
        this.systemDatabaseName = string;
    }

    public char getDelimitChar() {
        return this.delimitChar;
    }

    public void setDelimitChar(char c) {
        this.delimitChar = c;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String string) {
        this.schema = string;
    }

    public String getTableInclude() {
        return this.tableInc;
    }

    public void setTableInclude(String string) {
        this.tableInc = string;
    }

    public String getTableExclude() {
        return this.tableExc;
    }

    public void setTableExclude(String string) {
        this.tableExc = string;
    }

    public String getCatalogInclude() {
        return this.catalogInc;
    }

    public void setCatalogInclude(String string) {
        this.catalogInc = string;
    }

    public Object getProperty(String string) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(string);
    }

    public void setProperty(String string, Object object) {
        if (this.properties == null) {
            return;
        }
        this.properties.put(string, object);
    }

    public void setProperties(LinkedHashMap<String, Object> linkedHashMap) {
        this.properties = linkedHashMap;
    }
}

