/*
 * Decompiled with CFR 0.152.
 */
package unity.engine;

import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import unity.annotation.SourceField;
import unity.engine.Attribute;
import unity.functions.Expression;
import unity.functions.ExtractAttribute;
import unity.mapping.DatabaseMapping;
import unity.mapping.TypeInfo;
import unity.query.GQDatabaseRef;
import unity.query.LQExprNode;
import unity.util.Convert;
import unity.util.StringFunc;

public class Relation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Attribute[] attributes;
    private HashMap<String, String> properties;

    public Relation() {
        this.attributes = null;
    }

    public Relation(Attribute[] attributeArray) {
        this.attributes = attributeArray;
    }

    public Relation(byte[] byArray) {
        AtomicInteger atomicInteger = new AtomicInteger();
        String string = Convert.toStringWithLen(byArray, atomicInteger);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=,");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) continue;
            String string3 = stringTokenizer.nextToken();
            this.setProperty(string2, string3);
        }
        int n = Convert.toInt(byArray, atomicInteger.get());
        int n2 = 4 + atomicInteger.get();
        this.attributes = new Attribute[n];
        for (int i = 0; i < this.attributes.length; ++i) {
            this.attributes[i] = new Attribute();
            n2 = Attribute.convertAttribute(this.attributes[i], byArray, n2);
        }
    }

    public Relation(ResultSetMetaData resultSetMetaData) throws SQLException {
        int n = resultSetMetaData.getColumnCount();
        this.attributes = new Attribute[n];
        for (int i = 0; i < n; ++i) {
            this.attributes[i] = new Attribute(resultSetMetaData.getColumnLabel(i + 1), resultSetMetaData.getColumnType(i + 1), resultSetMetaData.getColumnDisplaySize(i + 1));
        }
    }

    public Relation(HashMap<String, SourceField> hashMap) throws SQLException {
        int n = hashMap.size();
        this.attributes = new Attribute[n];
        Iterator<SourceField> iterator = hashMap.values().iterator();
        for (int i = 0; i < n && iterator.hasNext(); ++i) {
            SourceField sourceField = iterator.next();
            this.attributes[i] = new Attribute(sourceField.getColumnName(), sourceField.getDataType(), sourceField.getColumnDisplaySize(), sourceField);
        }
    }

    public Relation(Relation relation) {
        this.attributes = new Attribute[relation.attributes.length];
        for (int i = 0; i < this.attributes.length; ++i) {
            this.attributes[i] = new Attribute(relation.attributes[i]);
        }
    }

    public int getAttributeType(int n) {
        return this.attributes[n].getType();
    }

    public void setAttributeType(int n, int n2) {
        this.attributes[n].setType(n2);
    }

    public int getNumAttributes() {
        if (this.attributes == null) {
            return 0;
        }
        return this.attributes.length;
    }

    public Attribute getAttribute(int n) {
        return this.attributes[n];
    }

    public void setAttribute(int n, Attribute attribute) {
        this.attributes[n] = attribute;
    }

    public int getAttributeIndexByName(String string) {
        for (int i = 0; i < this.attributes.length; ++i) {
            if (!StringFunc.equalIds(this.attributes[i].getName(), string)) continue;
            return i;
        }
        return -1;
    }

    public int getAttributeIndex(Object object) {
        for (int i = 0; i < this.attributes.length; ++i) {
            if (this.attributes[i].getReference() != object) continue;
            return i;
        }
        return -1;
    }

    public int getAttributeIndexByReferenceString(String string) {
        if (this.attributes == null) {
            return -1;
        }
        for (int i = 0; i < this.attributes.length; ++i) {
            Object object = this.attributes[i].getReference();
            if (object == null || !(object instanceof LQExprNode) || ((LQExprNode)object).generateSQL().indexOf(string) < 0) continue;
            return i;
        }
        return -1;
    }

    public void mergeRelation(Relation relation) {
        if (this.attributes == null) {
            this.attributes = new Attribute[relation.attributes.length];
            System.arraycopy(relation.attributes, 0, this.attributes, 0, relation.attributes.length);
        } else {
            int n = this.attributes.length + relation.attributes.length;
            Attribute[] attributeArray = new Attribute[n];
            System.arraycopy(this.attributes, 0, attributeArray, 0, this.attributes.length);
            System.arraycopy(relation.attributes, 0, attributeArray, this.attributes.length, relation.attributes.length);
            this.attributes = attributeArray;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.attributes.length; ++i) {
            stringBuffer.append(this.attributes[i]);
            stringBuffer.append(' ');
        }
        if (this.properties != null) {
            stringBuffer.append("Properties: ");
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                stringBuffer.append(entry.getKey() + ':' + entry.getValue() + ' ');
            }
        }
        return stringBuffer.toString();
    }

    public static Relation unionCompatible(Relation relation, Relation relation2, Expression[] expressionArray, Expression[] expressionArray2, boolean[] blArray) throws SQLException {
        if (relation.getNumAttributes() != relation2.getNumAttributes()) {
            throw new SQLException("Relations are not union-compatible because they do not have the same number of attributes.");
        }
        blArray[0] = false;
        blArray[1] = false;
        Expression[] expressionArray3 = new Expression[2];
        boolean[] blArray2 = new boolean[2];
        Relation relation3 = new Relation(relation);
        for (int i = 0; i < relation.getNumAttributes(); ++i) {
            int n;
            Attribute attribute = relation.getAttribute(i);
            Attribute attribute2 = relation2.getAttribute(i);
            Attribute attribute3 = Attribute.unionCompatible(attribute, attribute2, blArray2, expressionArray3, i);
            if (blArray[0] || blArray2[0]) {
                if (!blArray[0]) {
                    blArray[0] = true;
                    for (n = 0; n < i; ++n) {
                        expressionArray[n] = new ExtractAttribute(n, attribute3.getType());
                    }
                }
                if (blArray2[0]) {
                    relation.setAttributeType(i, attribute3.getType());
                    expressionArray[i] = expressionArray3[0];
                } else {
                    expressionArray[i] = new ExtractAttribute(i, attribute3.getType());
                }
            }
            if (blArray[1] || blArray2[1]) {
                if (!blArray[1]) {
                    blArray[1] = true;
                    for (n = 0; n < i; ++n) {
                        expressionArray2[n] = new ExtractAttribute(n, attribute3.getType());
                    }
                }
                if (blArray2[1]) {
                    relation2.setAttributeType(i, attribute3.getType());
                    expressionArray2[i] = expressionArray3[1];
                } else {
                    expressionArray2[i] = new ExtractAttribute(i, attribute3.getType());
                }
            }
            relation3.setAttribute(i, attribute3);
        }
        return relation3;
    }

    public int calculateSize() {
        int n = 0;
        for (int i = 0; i < this.getNumAttributes(); ++i) {
            int n2 = this.attributes[i].getByteSize();
            if (n2 == 0) {
                n2 = 10;
            }
            if (n2 > 10000) {
                n2 = 10000;
            }
            n += n2;
        }
        return n;
    }

    public static Relation generateRandomRelation(Random random, int n, int n2) {
        int n3 = random.nextInt(n2 - n + 1) + n;
        Attribute[] attributeArray = new Attribute[n3];
        for (int i = 0; i < n3; ++i) {
            attributeArray[i] = Attribute.generateRandom(random, "A" + i);
        }
        return new Relation(attributeArray);
    }

    public static byte[] convertToBytes(Relation relation) {
        Object object;
        Object object2;
        StringBuilder stringBuilder = new StringBuilder();
        if (relation.properties != null) {
            object2 = relation.properties.entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                stringBuilder.append((String)object.getKey());
                stringBuilder.append("=");
                stringBuilder.append((String)object.getValue());
                stringBuilder.append(",");
            }
        }
        object2 = Convert.toByteWithLen(stringBuilder.toString());
        object = new byte[relation.getNumAttributes()][];
        int n = 4;
        for (int i = 0; i < relation.getNumAttributes(); ++i) {
            object[i] = Attribute.convertToBytes(relation.getAttribute(i));
            n += ((Object)object[i]).length;
        }
        byte[] byArray = new byte[n + ((Object)object2).length];
        System.arraycopy(object2, 0, byArray, 0, ((Object)object2).length);
        int n2 = ((Object)object2).length;
        Convert.toByte(relation.getNumAttributes(), byArray, n2);
        n2 += 4;
        for (int i = 0; i < relation.getNumAttributes(); ++i) {
            System.arraycopy(object[i], 0, byArray, n2, ((Object)object[i]).length);
            n2 += ((Object)object[i]).length;
        }
        return byArray;
    }

    public static String createTableDDL(Relation relation, String string, boolean bl, boolean bl2, GQDatabaseRef gQDatabaseRef) {
        StringBuilder stringBuilder = new StringBuilder(200);
        String string2 = null;
        if (bl && bl2) {
            string2 = DatabaseMapping.getMappingText("#CREATE_TEMP_EXTERNAL_TABLE#", gQDatabaseRef, null);
        }
        if (bl && string2 == null) {
            string2 = DatabaseMapping.getMappingText("#CREATE_TEMP_TABLE#", gQDatabaseRef, null);
        }
        if (bl2 && string2 == null) {
            string2 = DatabaseMapping.getMappingText("#CREATE_EXTERNAL_TABLE#", gQDatabaseRef, null);
        }
        if (string2 == null) {
            string2 = DatabaseMapping.getMappingText("#CREATE_TABLE#", gQDatabaseRef, null);
        }
        stringBuilder.append(string2);
        stringBuilder.append(' ');
        stringBuilder.append(string);
        stringBuilder.append(" (\n");
        int n = 99;
        if (gQDatabaseRef != null && gQDatabaseRef.getDatabase() != null) {
            gQDatabaseRef.getDatabase().getDatabaseId();
        }
        for (int i = 0; i < relation.getNumAttributes(); ++i) {
            Attribute attribute = relation.getAttribute(i);
            stringBuilder.append("   ");
            stringBuilder.append(attribute.getName());
            stringBuilder.append(' ');
            int n2 = attribute.getType();
            TypeInfo typeInfo = DatabaseMapping.getDatabaseType(n2, n);
            if (typeInfo != null) {
                stringBuilder.append(typeInfo.getSqlName());
            } else {
                stringBuilder.append(Attribute.getTypeName(n2));
            }
            if (attribute.getType() == 12) {
                if (attribute.getLength() != 0) {
                    stringBuilder.append("(" + attribute.getLength() + ")");
                } else {
                    stringBuilder.append("(255)");
                }
            }
            if (i < relation.getNumAttributes() - 1) {
                stringBuilder.append(",");
            }
            stringBuilder.append("\n");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public String getProperty(String string) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(string);
    }

    public void setProperty(String string, String string2) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(string, string2);
    }
}

