/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import java.sql.SQLException;
import java.util.ArrayList;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.functions.Expression;

public class CaseExpr
extends Expression {
    private static final long serialVersionUID = 1L;
    private Expression switchExpr;
    private ArrayList<Expression> cases;
    private ArrayList<Expression> values;
    private Expression elseExpr;

    public CaseExpr(Expression expression, ArrayList<Expression> arrayList, ArrayList<Expression> arrayList2, Expression expression2) {
        this.switchExpr = expression;
        this.cases = arrayList;
        this.values = arrayList2;
        this.elseExpr = expression2;
        this.setReturnType();
    }

    @Override
    public Object evaluate(Tuple tuple) throws SQLException {
        Object object = this.switchExpr.evaluate(tuple);
        for (int i = 0; i < this.cases.size(); ++i) {
            Object object2 = this.cases.get(i).evaluate(tuple);
            if (!object2.equals(object)) continue;
            return this.values.get(i).evaluate(tuple);
        }
        if (this.elseExpr != null) {
            return this.elseExpr.evaluate(tuple);
        }
        return null;
    }

    @Override
    public String toString(Relation relation) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("CASE");
        stringBuffer.append(" " + this.switchExpr.toString(relation));
        for (int i = 0; i < this.cases.size(); ++i) {
            stringBuffer.append(" WHEN ");
            stringBuffer.append(this.cases.get(i).toString(relation));
            stringBuffer.append(" THEN ");
            stringBuffer.append(this.values.get(i).toString(relation));
        }
        if (this.elseExpr != null) {
            stringBuffer.append(" ELSE ");
            stringBuffer.append(this.elseExpr.toString(relation));
        }
        stringBuffer.append(" END");
        return stringBuffer.toString();
    }

    public void setReturnType() {
        this.returnType = this.values.get(0).getReturnType();
        for (int i = 1; i < this.values.size(); ++i) {
            if (this.returnType == this.values.get(0).getReturnType()) continue;
            this.returnType = 12;
            break;
        }
        if (this.elseExpr != null && this.returnType != this.elseExpr.getReturnType()) {
            this.returnType = 12;
        }
    }
}

