/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import java.sql.SQLException;
import java.util.ArrayList;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.functions.Expression;
import unity.predicates.SelectionPredicate;

public class CaseIfExpr
extends Expression {
    private static final long serialVersionUID = 1L;
    private ArrayList<SelectionPredicate> cases;
    private ArrayList<Expression> values;
    private Expression elseExpr;

    public CaseIfExpr(ArrayList<SelectionPredicate> arrayList, ArrayList<Expression> arrayList2, Expression expression) {
        this.cases = arrayList;
        this.values = arrayList2;
        this.elseExpr = expression;
    }

    @Override
    public Object evaluate(Tuple tuple) throws SQLException {
        for (int i = 0; i < this.cases.size(); ++i) {
            SelectionPredicate selectionPredicate = this.cases.get(i);
            if (!selectionPredicate.evaluate(tuple)) continue;
            return this.values.get(i).evaluate(tuple);
        }
        if (this.elseExpr != null) {
            return this.elseExpr.evaluate(tuple);
        }
        return null;
    }

    @Override
    public String toString(Relation relation) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("CASE");
        for (int i = 0; i < this.cases.size(); ++i) {
            stringBuffer.append(" WHEN ");
            stringBuffer.append(this.cases.get(i).toString(relation));
            stringBuffer.append(" THEN ");
            stringBuffer.append(this.values.get(i).toString(relation));
        }
        if (this.elseExpr != null) {
            stringBuffer.append(" ELSE ");
            stringBuffer.append(this.elseExpr.toString(relation));
        }
        stringBuffer.append(" END");
        return stringBuffer.toString();
    }
}

