/*
 * Decompiled with CFR 0.152.
 */
package unity.generic.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicLong;
import unity.engine.IServerConnection;
import unity.query.GlobalCommand;

public class StatementImpl
implements Statement {
    public static int UNITY_PROMOTED_QUERY = 1;
    protected static final Locale locale = Locale.getDefault();
    protected static ResourceBundle resources = ResourceBundle.getBundle("resources/generic/StatementImpl", locale);
    protected static AtomicLong LAST_ID = new AtomicLong(0L);
    protected Connection _conn = null;
    protected int _resultSetType = 0;
    protected int _resultSetConcurrency = 0;
    protected ResultSet _results = null;
    protected ResultSet _nextResults = null;
    protected SQLWarning _warnings = null;
    protected int _timeout = 0;
    protected int _maxFieldSize = 0;
    protected int _maxRows = 0;
    protected long _updateCount = -1L;
    private static int DEFAULT_FETCH_SIZE = 100;
    protected int _fetchSize = DEFAULT_FETCH_SIZE;
    protected boolean _closed = false;
    protected IServerConnection con;
    protected long statementId = LAST_ID.incrementAndGet();
    protected boolean queryActive = false;
    protected int status;
    protected String cursorName;
    protected int fetchDirection;

    public StatementImpl(Connection connection, IServerConnection iServerConnection, int n, int n2) {
        this._conn = connection;
        this._resultSetType = n;
        this._resultSetConcurrency = n2;
        this.con = iServerConnection;
    }

    @Override
    public void addBatch(String string) throws SQLException {
        throw new SQLException(resources.getString("featureError"));
    }

    @Override
    public void cancel() throws SQLException {
        throw new SQLException(resources.getString("featureError"));
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void clearWarnings() throws SQLException {
        this._warnings = null;
    }

    @Override
    public void close() throws SQLException {
        if (!this._closed) {
            if (this._results != null) {
                this._results.close();
            }
            this.con.closeStatement(this.statementId);
            this._closed = true;
        }
    }

    @Override
    public boolean execute(String string) throws SQLException {
        if (string.toLowerCase().trim().startsWith("select")) {
            this._results = this.executeQuery(string);
            return true;
        }
        this._updateCount = this.executeUpdate(string);
        return false;
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        return null;
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        if (string.toLowerCase().trim().startsWith("select")) {
            throw new SQLException(resources.getString("errorExecuteUpdate") + string);
        }
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this._conn;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 0;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this._fetchSize;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this._maxFieldSize;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this._maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public boolean getMoreResults(int n) throws SQLException {
        return false;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this._timeout;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this._results;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this._resultSetConcurrency;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this._resultSetType;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        int n = (int)this._updateCount;
        this._updateCount = -1L;
        return n;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this._warnings;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._closed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        this.cursorName = string;
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        this.fetchDirection = n;
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        if (n == 0) {
            n = DEFAULT_FETCH_SIZE;
        }
        if (n < 0) {
            throw new SQLException(resources.getString("invalidFetchSize") + n);
        }
        this._fetchSize = n;
        this.con.setFetchSize(this._fetchSize, this._resultSetType);
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        this._maxFieldSize = n;
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        this._maxRows = n;
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        this._timeout = n;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString("featureError"));
    }

    public long getStatementId() {
        return this.statementId;
    }

    public void setStatementId(long l) {
        this.statementId = l;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public GlobalCommand getCommand() throws SQLException {
        if (this.con == null) {
            return null;
        }
        return this.con.getCommand(this.statementId);
    }
}

