/*
 * Decompiled with CFR 0.152.
 */
package unity.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import unity.annotation.SourceField;
import unity.jdbc.UnityDriver;

public class LocalResultSetMetaData
implements ResultSetMetaData {
    private String[] columnHeaders;
    private ArrayList<SourceField> metadata;

    public LocalResultSetMetaData(String[] stringArray, ArrayList<SourceField> arrayList) {
        this.metadata = arrayList;
        this.columnHeaders = stringArray;
    }

    @Override
    public String getCatalogName(int n) throws SQLException {
        SourceField sourceField = this.metadata.get(n - 1);
        return sourceField.getTableCatalog();
    }

    @Override
    public String getColumnClassName(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnHeaders.length;
    }

    @Override
    public int getColumnDisplaySize(int n) throws SQLException {
        SourceField sourceField = this.metadata.get(n - 1);
        return sourceField.getColumnDisplaySize();
    }

    @Override
    public String getColumnLabel(int n) throws SQLException {
        return this.columnHeaders[n - 1];
    }

    @Override
    public String getColumnName(int n) throws SQLException {
        return this.columnHeaders[n - 1];
    }

    @Override
    public int getColumnType(int n) throws SQLException {
        SourceField sourceField = this.metadata.get(n - 1);
        return sourceField.getDataType();
    }

    @Override
    public String getColumnTypeName(int n) throws SQLException {
        SourceField sourceField = this.metadata.get(n - 1);
        return sourceField.getDataTypeName();
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        SourceField sourceField = this.metadata.get(n - 1);
        return sourceField.getDecimalDigits();
    }

    @Override
    public int getScale(int n) throws SQLException {
        return 0;
    }

    @Override
    public String getSchemaName(int n) throws SQLException {
        SourceField sourceField = this.metadata.get(n - 1);
        return sourceField.getTableSchema();
    }

    @Override
    public String getTableName(int n) throws SQLException {
        SourceField sourceField = this.metadata.get(n - 1);
        return sourceField.getTableName();
    }

    @Override
    public boolean isAutoIncrement(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    @Override
    public boolean isCurrency(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int n) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int n) throws SQLException {
        SourceField sourceField = this.metadata.get(n - 1);
        return sourceField.getNullable();
    }

    @Override
    public boolean isReadOnly(int n) throws SQLException {
        return true;
    }

    @Override
    public boolean isSearchable(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int n) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return null;
    }
}

