/*
 * Decompiled with CFR 0.152.
 */
package unity.jdbc;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import unity.jdbc.UnityDriver;
import unity.jdbc.UnityPooledConnection;

public class UnityDataSource
implements DataSource,
Referenceable,
Serializable,
ConnectionPoolDataSource {
    protected static UnityDriver unityDriver = null;
    private static final long serialVersionUID = 1L;
    protected PrintWriter logWriter = null;
    protected String encoding = null;
    protected boolean pooled = true;
    protected int logintimeout = 0;
    protected Properties props = new Properties();

    public UnityDataSource() {
        this.props.setProperty("password", "");
        this.props.setProperty("loginTimeout", String.valueOf(this.getLoginTimeout()));
    }

    public String getUrl() {
        return this.props.getProperty("url");
    }

    public void setUrl(String string) {
        this.props.setProperty("url", string);
    }

    public String getUser() {
        return this.props.getProperty("user");
    }

    public void setUser(String string) {
        this.props.setProperty("user", string);
    }

    public String getPassword() {
        return this.props.getProperty("password");
    }

    public void setPassword(String string) {
        this.props.setProperty("password", string);
    }

    public String getProperty(String string) {
        return this.props.getProperty(string);
    }

    public void setProperty(String string, String string2) {
        this.props.setProperty(string, string2);
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) {
        this.logWriter = printWriter;
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), "unity.jdbc.UnityDataSourceFactory", null);
        return reference;
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        this.props.setProperty("user", string);
        this.props.setProperty("password", string2);
        return this.getConnection(this.props);
    }

    public Connection getConnection(Properties properties) throws SQLException {
        return unityDriver.connect(properties.getProperty("url"), properties);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return unityDriver.connect(this.props.getProperty("url"), this.props);
    }

    @Override
    public void setLoginTimeout(int n) throws SQLException {
        this.logintimeout = n;
    }

    @Override
    public int getLoginTimeout() {
        return this.logintimeout;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    public PooledConnection getPooledConnection(Properties properties) throws SQLException {
        return new UnityPooledConnection(unityDriver.connect(properties.getProperty("url"), properties));
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        return new UnityPooledConnection(unityDriver.connect(this.props.getProperty("url"), this.props));
    }

    @Override
    public PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        this.props.put("user", string);
        this.props.put("password", string2);
        return new UnityPooledConnection(unityDriver.connect(this.props.getProperty("url"), this.props));
    }

    static {
        try {
            unityDriver = (UnityDriver)Class.forName("unity.jdbc.UnityDriver").newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(UnityDriver.i18n.getString("UnityDataSource.ErrorCannotLoadDriver"));
        }
    }
}

