/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import unity.engine.Attribute;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.jdbc.UnityDriver;
import unity.operators.Operator;
import unity.query.LQNode;
import unity.query.LocalQuery;
import unity.util.StringFunc;

public class ResultSetScan
extends Operator {
    private static final long serialVersionUID = 1L;
    protected ResultSet rs;
    protected ResultSetMetaData metadata;
    protected int numCols;
    protected Object[] obj;
    protected String sqlQueryString;
    protected boolean delayedExecution = false;
    protected LocalQuery query;
    private int count = 0;

    public ResultSetScan(LocalQuery localQuery, LQNode lQNode) {
        this.rs = null;
        this.query = localQuery;
        this.sqlQueryString = this.query.getSQLQueryString();
        this.queryNode = lQNode;
    }

    public ResultSetScan(ResultSet resultSet) {
        this.rs = resultSet;
        this.outputRelation = this.buildOutputRelation();
    }

    public Relation buildOutputRelation() {
        try {
            this.metadata = this.rs.getMetaData();
            this.numCols = this.metadata.getColumnCount();
            this.obj = new Object[this.numCols];
            Attribute[] attributeArray = new Attribute[this.numCols];
            for (int i = 1; i <= this.numCols; ++i) {
                attributeArray[i - 1] = new Attribute(this.metadata.getColumnName(i), this.metadata.getColumnType(i), this.metadata.getColumnDisplaySize(i));
                attributeArray[i - 1].setScale(this.metadata.getScale(i));
            }
            this.outputRelation = new Relation(attributeArray);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return this.outputRelation;
    }

    public Relation updateOutputRelation(Relation relation) {
        try {
            this.metadata = this.rs.getMetaData();
            this.numCols = this.metadata.getColumnCount();
            if (relation.getNumAttributes() != this.numCols) {
                return relation;
            }
            for (int i = 1; i <= this.numCols; ++i) {
                Attribute attribute = relation.getAttribute(i - 1);
                attribute.setScale(this.metadata.getScale(i));
                attribute.setLength(this.metadata.getColumnDisplaySize(i));
                attribute.setType(this.metadata.getColumnType(i));
            }
            this.outputRelation = relation;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return relation;
    }

    public void setResultSet(ResultSet resultSet) {
        this.rs = resultSet;
    }

    @Override
    public String getSource() {
        return this.query.getDatabaseName();
    }

    public String getSQLString() {
        return this.sqlQueryString;
    }

    public void setSQLString(String string) {
        this.sqlQueryString = string;
    }

    public void setDelayedExecution(boolean bl) {
        this.delayedExecution = bl;
    }

    public boolean getDelayedExecution() {
        return this.delayedExecution;
    }

    @Override
    public void init() throws SQLException {
        while (this.rs == null) {
            if (this.query.getExecutionThread() != null) {
                try {
                    this.query.getExecutionThread().join();
                }
                catch (InterruptedException interruptedException) {}
            } else {
                Thread.yield();
            }
            if (this.query == null || !this.query.hasErrorMessage()) continue;
            throw new SQLException(this.query.getErrorMessage());
        }
        if (this.outputRelation == null) {
            System.out.println("Building output relation");
            try {
                this.metadata = this.rs.getMetaData();
                this.numCols = this.metadata.getColumnCount();
                this.obj = new Object[this.numCols];
                Attribute[] attributeArray = new Attribute[this.numCols];
                for (int i = 1; i <= this.numCols; ++i) {
                    attributeArray[i - 1] = new Attribute(this.metadata.getColumnName(i), this.metadata.getColumnType(i), this.metadata.getColumnDisplaySize(i));
                }
                this.outputRelation = new Relation(attributeArray);
            }
            catch (SQLException sQLException) {
                throw new SQLException(sQLException.toString());
            }
        }
        try {
            this.metadata = this.rs.getMetaData();
            this.numCols = this.metadata.getColumnCount();
        }
        catch (Exception exception) {
            throw new SQLException(UnityDriver.i18n.getString("ResultSetScan.ErrorInit") + exception);
        }
    }

    @Override
    public boolean next(Tuple tuple) throws SQLException {
        try {
            if (this.rs == null) {
                throw new SQLException("ERROR: No ResultSet created.");
            }
            try {
                if (this.rs.isClosed()) {
                    return false;
                }
            }
            catch (Exception exception) {
            }
            catch (Error error) {
                // empty catch block
            }
            if (!this.rs.next()) {
                if (this.count == 0) {
                    System.out.println("Zero results for ResultSet: " + this);
                }
                return false;
            }
            ++this.count;
            if (this.metadata == null) {
                throw new SQLException("ERROR: No metadata created.");
            }
            this.numCols = this.metadata.getColumnCount();
            this.obj = new Object[this.numCols];
            for (int i = 1; i <= this.numCols; ++i) {
                this.obj[i - 1] = this.metadata.getColumnType(i) == -3 ? this.rs.getString(i) : this.rs.getObject(i);
            }
            tuple.setValues(this.obj);
            tuple.setRelation(this.outputRelation);
            this.incrementRowsOut();
            return true;
        }
        catch (SQLException sQLException) {
            throw new SQLException(sQLException.toString());
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            if (this.rs != null) {
                if (this.rs.getStatement() != null) {
                    this.rs.getStatement().close();
                } else {
                    this.rs.close();
                }
                this.rs = null;
            }
            if (UnityDriver.DEBUG) {
                System.out.println("Operation: " + this.toString() + " Rows output: " + this.rowsOut + " IO bytes: " + this.IOBytes);
            }
        }
        catch (SQLException sQLException) {
            throw new SQLException(sQLException.toString());
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(250);
        stringBuilder.append(this.getName());
        stringBuilder.append(": Database=");
        if (this.query == null) {
            stringBuilder.append("unknown");
        } else {
            stringBuilder.append(this.query.getDatabaseName());
        }
        if (this.sqlQueryString != null) {
            stringBuilder.append(" ; Query: " + StringFunc.oneLineSQL(this.sqlQueryString));
        }
        return stringBuilder.toString();
    }

    public LocalQuery getQuery() {
        return this.query;
    }

    @Override
    public String getName() {
        return "RESULTSET SCAN";
    }

    @Override
    public String getDescription() {
        return "DATABASE QUERY ON " + this.query.getDatabaseName() + " SQL: " + StringFunc.oneLineSQL(this.query.getSQLQueryString());
    }

    @Override
    public double getCost() {
        double d = this.queryNode.getCost();
        double d2 = this.getIO();
        return (d /= 10.0) + 3000.0 + d2 * 0.4;
    }

    @Override
    public double getIO() {
        long l = this.queryNode.getRows();
        int n = this.queryNode.tupleSize();
        return l * (long)n;
    }

    public ResultSet getResultSet() {
        return this.rs;
    }
}

