/*
 * Decompiled with CFR 0.152.
 */
package unity.predicates;

import java.io.Serializable;
import java.sql.SQLException;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.jdbc.UnityDriver;
import unity.predicates.JoinPredicate;
import unity.predicates.SelectionPredicate;
import unity.util.HashFunc;

public class AttrJoinPredicate
extends JoinPredicate
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int[] attr1Locs;
    private int[] attr2Locs;
    private Object[] vals;

    public AttrJoinPredicate(int[] nArray, int[] nArray2, SelectionPredicate selectionPredicate) {
        this.attr1Locs = nArray;
        this.attr2Locs = nArray2;
        this.filterPredicate = selectionPredicate;
        this.vals = new Object[this.attr1Locs.length];
    }

    public int[] getAttr1Locs() {
        return this.attr1Locs;
    }

    public int[] getAttr2Locs() {
        return this.attr2Locs;
    }

    @Override
    public JoinPredicate inversePredicate() {
        AttrJoinPredicate attrJoinPredicate = new AttrJoinPredicate(this.attr2Locs, this.attr1Locs, this.filterPredicate);
        attrJoinPredicate.queryNode = this.queryNode;
        attrJoinPredicate.inverse = true;
        return attrJoinPredicate;
    }

    @Override
    public boolean isEqual(Tuple tuple, Tuple tuple2) throws SQLException {
        try {
            for (int i = 0; i < this.attr1Locs.length; ++i) {
                Object object = tuple.getObject(this.attr1Locs[i]);
                if (object == null) {
                    return false;
                }
                Object object2 = tuple2.getObject(this.attr2Locs[i]);
                if (object2 == null) {
                    return false;
                }
                if (JoinPredicate.compare(object, object2)) continue;
                return false;
            }
            if (this.filterPredicate == null) {
                return true;
            }
            return this.evaluateFilter(tuple, tuple2);
        }
        catch (Exception exception) {
            throw new SQLException(UnityDriver.i18n.getString("AttrJoinPredicate.JoinError") + exception);
        }
    }

    @Override
    public boolean isLessThan(Tuple tuple, Tuple tuple2) throws SQLException {
        try {
            for (int i = 0; i < this.attr1Locs.length; ++i) {
                Comparable comparable = (Comparable)tuple.getObject(this.attr1Locs[i]);
                Comparable comparable2 = (Comparable)tuple2.getObject(this.attr2Locs[i]);
                if (comparable != null && comparable2 != null) {
                    int n = comparable.compareTo(comparable2);
                    if (n == 0) continue;
                    return n < 0;
                }
                if (comparable == null && comparable2 != null) {
                    return true;
                }
                if (comparable != null && comparable2 == null) {
                    return false;
                }
                if (comparable != null || comparable2 != null || i != this.attr1Locs.length - 1) continue;
                return false;
            }
            return false;
        }
        catch (Exception exception) {
            throw new SQLException(UnityDriver.i18n.getString("AttrJoinPredicate.JoinError") + exception);
        }
    }

    @Override
    public String toString(Relation relation, Relation relation2) {
        StringBuilder stringBuilder = new StringBuilder(250);
        if (this.attr1Locs.length > 0) {
            stringBuilder.append(relation.getAttribute(this.attr1Locs[0]).getName() + " = " + relation2.getAttribute(this.attr2Locs[0]).getName());
            for (int i = 1; i < this.attr1Locs.length; ++i) {
                stringBuilder.append(" AND " + relation.getAttribute(this.attr1Locs[i]).getName() + " = " + relation2.getAttribute(this.attr2Locs[i]).getName());
            }
        }
        if (this.filterPredicate != null) {
            Relation relation3 = new Relation(relation);
            relation3.mergeRelation(relation2);
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" AND ");
            }
            stringBuilder.append(this.filterPredicate.toString(relation3));
        }
        return stringBuilder.toString();
    }

    @Override
    public int getHashKeyInput1(Tuple tuple) throws SQLException {
        return this.getHashKey(tuple, this.attr1Locs);
    }

    @Override
    public int getHashKeyInput2(Tuple tuple) throws SQLException {
        return this.getHashKey(tuple, this.attr2Locs);
    }

    private int getHashKey(Tuple tuple, int[] nArray) throws SQLException {
        for (int i = 0; i < nArray.length; ++i) {
            this.vals[i] = tuple.getObject(nArray[i]);
            if (this.vals[i] != null) continue;
            tuple.setStatus((byte)1);
            return 0;
        }
        tuple.setStatus((byte)0);
        return HashFunc.hash(this.vals);
    }

    @Override
    public boolean isEquiJoin() {
        return true;
    }
}

