/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import unity.engine.Relation;
import unity.operators.Operator;
import unity.query.GQDatabaseRef;
import unity.query.GQFieldRef;
import unity.query.GlobalQuery;
import unity.query.LQExprNode;
import unity.query.LQGroupByNode;
import unity.query.LQProjNode;
import unity.query.LQTreeConstants;
import unity.query.SubQuery;
import unity.util.StringFunc;

public abstract class LQNode
implements LQTreeConstants,
Serializable {
    private static final long serialVersionUID = 1L;
    protected int type;
    protected LQNode parent;
    protected ArrayList<LQNode> children;
    protected Object content;
    protected Object reference;
    protected GQDatabaseRef database;
    protected Relation outputRelation;
    protected long memorySize;
    protected Operator op;
    protected boolean isHGRootCandidate;
    protected long rows;
    protected double cost;
    protected long iobytes;

    public LQNode() {
        this.type = -1;
        this.parent = null;
        this.outputRelation = null;
        this.isHGRootCandidate = false;
    }

    public LQNode(LQNode lQNode) {
        this.type = lQNode.type;
        if (lQNode.children != null) {
            this.children = new ArrayList<LQNode>(lQNode.children);
        }
        this.parent = lQNode.parent;
        this.content = lQNode.content;
        this.reference = lQNode.reference;
        this.database = lQNode.database;
    }

    public void setOperator(Operator operator) {
        this.op = operator;
    }

    public Operator getOperator() {
        return this.op;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }

    public void setMemorySize(long l) {
        this.memorySize = l;
    }

    public long getMemorySize() {
        if (this.memorySize < 1000000L) {
            return 1000000L;
        }
        return this.memorySize;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public LQNode getParent() {
        return this.parent;
    }

    public void setParent(LQNode lQNode) {
        this.parent = lQNode;
    }

    public boolean hasChildren() {
        return this.getNumChildren() != 0;
    }

    public int getNumChildren() {
        return this.children == null ? 0 : this.children.size();
    }

    public LQNode getChild(int n) {
        return n >= this.getNumChildren() || n < 0 ? null : this.children.get(n);
    }

    public LQNode getChild() {
        if (this.children != null) {
            return this.children.get(0);
        }
        return null;
    }

    public ArrayList<LQNode> getChildren() {
        return this.children;
    }

    public int indexOfChild(LQNode lQNode) {
        return this.children == null ? -1 : this.children.indexOf(lQNode);
    }

    public boolean containsChild(LQNode lQNode) {
        return this.children == null ? false : this.children.contains(lQNode);
    }

    public void addChild(LQNode lQNode) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(lQNode);
    }

    public void removeChild(int n) {
        if (this.children != null && n < this.children.size()) {
            this.children.remove(n);
        }
    }

    public Object getContent() {
        return this.content;
    }

    public void setContent(Object object) {
        this.content = object;
    }

    public Object getReference() {
        return this.reference;
    }

    public void setReference(Object object) {
        this.reference = object;
    }

    public void replaceChild(LQNode lQNode, LQNode lQNode2) {
        int n = this.indexOfChild(lQNode);
        if (n == -1) {
            return;
        }
        this.children.set(n, lQNode2);
    }

    public void setChild(int n, LQNode lQNode) {
        this.children.set(n, lQNode);
    }

    public ArrayList<Object> getRequiredFields() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = null;
        for (int i = 0; i < this.children.size(); ++i) {
            arrayList2 = this.children.get(i).getRequiredFields();
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    public int numTuples() {
        return 0;
    }

    public int tupleSize() {
        return 0;
    }

    public Relation getOutputRelation() {
        return this.outputRelation;
    }

    public void setOutputRelation(Relation relation) {
        this.outputRelation = relation;
    }

    public abstract String generateSQL();

    public String generatePig(Relation relation) {
        return "PIG OP NOT TRANSLATED";
    }

    public abstract Operator buildOperator(Operator[] var1, GlobalQuery var2, SubQuery var3) throws SQLException;

    public static ArrayList<LQExprNode> getAllExprNodes(LQNode lQNode) {
        ArrayList<LQExprNode> arrayList = new ArrayList<LQExprNode>();
        if (lQNode != null) {
            if (lQNode instanceof LQGroupByNode) {
                LQGroupByNode lQGroupByNode = (LQGroupByNode)lQNode;
                arrayList.addAll(lQGroupByNode.getExpressions());
                arrayList.addAll(lQGroupByNode.getFunctionList());
            } else if (lQNode instanceof LQProjNode) {
                LQProjNode lQProjNode = (LQProjNode)lQNode;
                arrayList.addAll(lQProjNode.getExpressions());
            } else if (lQNode instanceof LQExprNode && lQNode.type == 100) {
                arrayList.add((LQExprNode)lQNode);
            } else if (lQNode instanceof LQExprNode && lQNode.type == 103) {
                arrayList.addAll(LQNode.getAllExprNodes(lQNode.getChild(0)));
            } else {
                for (int i = 0; i < lQNode.getNumChildren(); ++i) {
                    arrayList.addAll(LQNode.getAllExprNodes(lQNode.getChild(i)));
                }
            }
        }
        return arrayList;
    }

    public void setHGRootCandidate() {
        this.isHGRootCandidate = true;
    }

    public String toString() {
        if (this.database != null) {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append(" (source: ");
            stringBuffer.append(this.database.getName());
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
        return "";
    }

    public static boolean isDescendant(LQNode lQNode, LQNode lQNode2) {
        if (lQNode == lQNode2) {
            return true;
        }
        if (lQNode == null) {
            return false;
        }
        for (int i = 0; i < lQNode.getNumChildren(); ++i) {
            if (!LQNode.isDescendant(lQNode.getChild(i), lQNode2)) continue;
            return true;
        }
        return false;
    }

    public GQDatabaseRef getDatabase() {
        return this.database;
    }

    public void setDatabase(GQDatabaseRef gQDatabaseRef) {
        this.database = gQDatabaseRef;
    }

    public GQDatabaseRef setDatabase(GQDatabaseRef gQDatabaseRef, boolean bl) {
        HashSet<GQDatabaseRef> hashSet = this.getChildDatabaseReferences(gQDatabaseRef, bl);
        this.setDatabaseByRefs(hashSet);
        HashSet<GQDatabaseRef> hashSet2 = this.getDatabaseRefs(gQDatabaseRef, bl);
        for (GQDatabaseRef gQDatabaseRef2 : hashSet2) {
            if (gQDatabaseRef2 == null) continue;
            Iterator<GQDatabaseRef> iterator = hashSet.iterator();
            boolean bl2 = false;
            while (iterator.hasNext()) {
                if (iterator.next().getDatabase() != gQDatabaseRef2.getDatabase()) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            hashSet.add(gQDatabaseRef2);
        }
        this.setDatabaseByRefs(hashSet);
        return this.database;
    }

    private void setDatabaseByRefs(HashSet<GQDatabaseRef> hashSet) {
        if (hashSet.size() > 1) {
            this.database = GQDatabaseRef.UNITYJDBC_DBREF;
        } else if (hashSet.size() == 1) {
            this.database = hashSet.iterator().next();
        }
    }

    public HashSet<GQDatabaseRef> getDatabaseRefs(GQDatabaseRef gQDatabaseRef) {
        return this.getDatabaseRefs(gQDatabaseRef, false);
    }

    protected HashSet<GQDatabaseRef> getDatabaseRefs(GQDatabaseRef gQDatabaseRef, boolean bl) {
        return new HashSet<GQDatabaseRef>(1);
    }

    protected HashSet<GQDatabaseRef> getChildDatabaseReferences(GQDatabaseRef gQDatabaseRef, boolean bl) {
        HashSet<GQDatabaseRef> hashSet = new HashSet<GQDatabaseRef>(5);
        for (int i = 0; i < this.getNumChildren(); ++i) {
            GQDatabaseRef gQDatabaseRef2 = this.getChild(i).setDatabase(gQDatabaseRef, bl);
            if (gQDatabaseRef2 == null) continue;
            boolean bl2 = false;
            Iterator<GQDatabaseRef> iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().getDatabase() != gQDatabaseRef2.getDatabase()) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            hashSet.add(gQDatabaseRef2);
        }
        return hashSet;
    }

    public boolean contains(int n) {
        if (this.getType() == n) {
            return true;
        }
        if (this.getChildren() != null) {
            for (LQNode lQNode : this.getChildren()) {
                if (!lQNode.contains(n)) continue;
                return true;
            }
        }
        return false;
    }

    public String containsEqualAttr(String string) {
        if (this.getType() == 110) {
            return null;
        }
        if (this.getType() == 114 && this.getContent().equals("=")) {
            LQNode lQNode = this.getChild(0);
            LQNode lQNode2 = this.getChild(1);
            if (lQNode.getType() == 100 && ((GQFieldRef)lQNode.getContent()).getName().equals(string)) {
                return StringFunc.removeQuotes(lQNode2.getContent().toString());
            }
            if (lQNode2.getType() == 100 && lQNode2.getContent().toString().equals("attrName")) {
                return StringFunc.removeQuotes(lQNode.getContent().toString());
            }
        }
        if (this.getChildren() != null) {
            for (LQNode lQNode2 : this.getChildren()) {
                String string2 = lQNode2.containsEqualAttr(string);
                if (string2 == null) continue;
                return string2;
            }
        }
        return null;
    }

    public long getRows() {
        return this.rows;
    }

    public void setRows(long l) {
        this.rows = l;
    }

    public double getCost() {
        return this.cost;
    }

    public void setCost(double d) {
        this.cost = d;
    }

    public abstract void computeCost();

    public void calculateCosts() {
        for (int i = 0; i < this.getNumChildren(); ++i) {
            this.getChild(i).calculateCosts();
        }
        this.computeCost();
    }

    public long getIO() {
        return this.iobytes;
    }

    public void setIO(long l) {
        this.iobytes = l;
    }
}

