/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import unity.engine.Attribute;
import unity.engine.Relation;
import unity.functions.Expression;
import unity.mapping.DatabaseMapping;
import unity.operators.MergeSort;
import unity.operators.Operator;
import unity.predicates.ExprSortComparator;
import unity.predicates.SortComparator;
import unity.query.GQDatabaseRef;
import unity.query.GlobalQuery;
import unity.query.LQExprNode;
import unity.query.LQNode;
import unity.query.SubQuery;

public class LQOrderByNode
extends LQNode {
    private static final long serialVersionUID = 1L;
    private ArrayList<LQExprNode> orderList;
    private ArrayList<String> sortOrderList;
    private boolean projectLast;

    public LQOrderByNode() {
        this.type = 4;
        this.orderList = new ArrayList();
        this.sortOrderList = new ArrayList();
        this.projectLast = false;
    }

    public void addExpression(LQExprNode lQExprNode, String string) {
        this.orderList.add(lQExprNode);
        this.sortOrderList.add(string);
    }

    @Override
    public String generateSQL() {
        if (this.orderList == null || this.orderList.size() == 0) {
            return "";
        }
        String string = this.orderList.get(0).generateSQL() + ' ' + this.sortOrderList.get(0);
        for (int i = 1; i < this.orderList.size(); ++i) {
            LQExprNode lQExprNode = this.orderList.get(i);
            string = string + ", " + lQExprNode.generateSQL() + ' ' + this.sortOrderList.get(i);
        }
        return string;
    }

    @Override
    public String generatePig(Relation relation) {
        if (this.orderList == null || this.orderList.size() == 0) {
            return "";
        }
        String string = this.orderList.get(0).generatePig(relation) + ' ' + this.sortOrderList.get(0);
        for (int i = 1; i < this.orderList.size(); ++i) {
            LQExprNode lQExprNode = this.orderList.get(i);
            string = string + ", " + lQExprNode.generatePig(relation) + ' ' + this.sortOrderList.get(i);
        }
        return string;
    }

    @Override
    public String toString() {
        return "ORDER BY: " + this.generateSQL() + super.toString();
    }

    public boolean getProjectLast() {
        return this.projectLast;
    }

    public void setProjectLast(boolean bl) {
        this.projectLast = bl;
    }

    @Override
    public Operator buildOperator(Operator[] operatorArray, GlobalQuery globalQuery, SubQuery subQuery) throws SQLException {
        Object object;
        int[] nArray = new int[this.orderList.size()];
        boolean[] blArray = new boolean[this.orderList.size()];
        boolean bl = true;
        Relation relation = operatorArray[0].getOutputRelation();
        for (int i = 0; i < this.orderList.size(); ++i) {
            object = this.orderList.get(i);
            if (object.getType() != 100) {
                bl = false;
            } else if (bl) {
                nArray[i] = relation.getAttributeIndex(object.getContent());
            }
            String string = this.sortOrderList.get(i);
            blArray[i] = string.equals("ASC");
        }
        SortComparator sortComparator = null;
        if (!bl) {
            object = new Expression[this.orderList.size()];
            for (int i = 0; i < this.orderList.size(); ++i) {
                LQExprNode lQExprNode = this.orderList.get(i);
                object[i] = lQExprNode.buildExpression(relation, new Attribute(), globalQuery, subQuery, null);
            }
            sortComparator = new ExprSortComparator((Expression[])object, blArray);
        } else {
            sortComparator = new SortComparator(nArray, blArray);
        }
        object = new MergeSort(operatorArray[0], this.getMemorySize(), sortComparator, this);
        this.setOperator((Operator)object);
        this.outputRelation = new Relation(relation);
        return object;
    }

    public String getDirection(int n) {
        if (this.sortOrderList != null) {
            return this.sortOrderList.get(n);
        }
        return "ASC";
    }

    public int getOrderNumChildren() {
        return this.orderList.size();
    }

    public LQNode getOrderChild(int n) {
        return n >= this.getOrderNumChildren() || n < 0 ? null : (LQNode)this.orderList.get(n);
    }

    @Override
    public int numTuples() {
        return ((LQNode)this.children.get(0)).numTuples();
    }

    @Override
    protected HashSet<GQDatabaseRef> getDatabaseRefs(GQDatabaseRef gQDatabaseRef, boolean bl) {
        HashSet<GQDatabaseRef> hashSet = new HashSet<GQDatabaseRef>(5);
        if (DatabaseMapping.isSupported("#ORDERBY#", this.database, null) != 1) {
            this.database = GQDatabaseRef.UNITYJDBC_DBREF;
            hashSet.add(this.database);
            return hashSet;
        }
        if (this.orderList != null) {
            for (int i = 0; i < this.orderList.size(); ++i) {
                GQDatabaseRef gQDatabaseRef2 = this.orderList.get(i).setDatabase(this.getDatabase(), bl);
                if (gQDatabaseRef2 == null) continue;
                hashSet.add(gQDatabaseRef2);
            }
        }
        return hashSet;
    }

    @Override
    public void computeCost() {
        long l = this.getChild(0).getRows();
        int n = this.getChild(0).tupleSize();
        this.cost = (double)(3L * l) * (1.0 + 0.005 * (double)n);
        this.rows = l;
    }

    public ArrayList<LQExprNode> getExprList() {
        return this.orderList;
    }
}

