/*
 * Decompiled with CFR 0.152.
 */
package unity.util;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.HashMap;

public final class SecureAuthenticator
extends Authenticator {
    private static SecureAuthenticator instance;
    private HashMap<String, PasswordAuthentication> authInfo = new HashMap();

    public static synchronized SecureAuthenticator getInstance() {
        if (instance == null) {
            instance = new SecureAuthenticator();
            Authenticator.setDefault(instance);
        }
        return instance;
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        String string = this.buildLookupKey(this.getRequestingHost(), this.getRequestingPort());
        PasswordAuthentication passwordAuthentication = this.authInfo.get(string);
        if (passwordAuthentication == null) {
            passwordAuthentication = this.getEmbeddedCredentials(this.getRequestingURL());
        }
        if (passwordAuthentication == null) {
            string = this.buildLookupKey(this.getRequestingHost(), -1);
            passwordAuthentication = this.authInfo.get(string);
        }
        if (passwordAuthentication != null) {
            // empty if block
        }
        return passwordAuthentication;
    }

    public void register(URL uRL, PasswordAuthentication passwordAuthentication) {
        String string = this.buildLookupKey(uRL.getHost(), uRL.getPort());
        this.authInfo.put(string, passwordAuthentication);
    }

    private String buildLookupKey(String string, int n) {
        if (n == -1) {
            return string;
        }
        return string + ':' + n;
    }

    PasswordAuthentication getEmbeddedCredentials(URL uRL) {
        int n;
        if (uRL == null) {
            return null;
        }
        String string = uRL.getUserInfo();
        int n2 = n = string == null ? -1 : string.indexOf(":");
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        return new PasswordAuthentication(string2, string3.toCharArray());
    }
}

