/*
 * Decompiled with CFR 0.152.
 */
package mongodb.conn;

import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import com.mongodb.util.JSON;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.net.ssl.SSLSocketFactory;
import mongodb.conn.MongoExecutor;
import mongodb.jdbc.MongoStatement;
import mongodb.query.MongoBuilder;
import mongodb.query.MongoBuilderUpstreamException;
import mongodb.query.MongoQuery;
import unity.annotation.AnnotatedSourceDatabase;
import unity.annotation.AnnotatedSourceField;
import unity.annotation.AnnotatedSourceKey;
import unity.annotation.AnnotatedSourceTable;
import unity.annotation.GlobalSchema;
import unity.annotation.SourceDatabase;
import unity.annotation.SourceField;
import unity.annotation.SourceTable;
import unity.engine.Attribute;
import unity.engine.IServerConnection;
import unity.engine.Tuple;
import unity.generic.jdbc.StatementImpl;
import unity.io.FileManager;
import unity.jdbc.LocalResultSet;
import unity.jdbc.UnityConnection;
import unity.jdbc.UnityDriver;
import unity.jdbc.UnityStatement;
import unity.parser.GlobalParser;
import unity.query.GQTableRef;
import unity.query.GlobalCommand;
import unity.query.GlobalQuery;
import unity.query.GlobalUpdate;
import unity.query.LQTree;
import unity.util.StringFunc;

public class ServerConnection
implements IServerConnection {
    public static final int MAX_STRING_SIZE = 0x1004000;
    protected static ResourceBundle resources;
    protected static final Locale locale;
    private String url;
    private ArrayList<ServerAddress> servers;
    private int fetchSize;
    private HashMap<Long, MongoExecutor> executors;
    private String userName;
    private String password;
    private Properties properties;
    private MongoClient mongoClient;
    private DB db;
    private String databaseName;
    private UnityConnection uconn;
    private SourceDatabase database;
    private GlobalSchema schema;
    private String validation;
    private String schemaLocation;
    private Connection connection;
    private boolean useSSL;

    public ServerConnection(ArrayList<String> arrayList, ArrayList<Integer> arrayList2, String string, String string2, Connection connection) throws SQLException {
        this.servers = new ArrayList(arrayList.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            try {
                this.servers.add(new ServerAddress(arrayList.get(i), arrayList2.get(i).intValue()));
                continue;
            }
            catch (UnknownHostException unknownHostException) {
                throw new SQLException(unknownHostException.getMessage());
            }
        }
        this.url = string2;
        this.databaseName = string;
        this.uconn = null;
        this.connection = connection;
        this.executors = new HashMap();
    }

    private MongoClient getConnection(String string, boolean bl) throws UnknownHostException {
        if (bl) {
            if (UnityDriver.DEBUG) {
                System.out.println("Connecting with SSL");
            }
            MongoClientOptions mongoClientOptions = new MongoClientOptions.Builder().socketFactory(SSLSocketFactory.getDefault()).build();
            return new MongoClient(string, mongoClientOptions);
        }
        return new MongoClient(string);
    }

    private MongoClient getConnection() throws UnknownHostException {
        if (this.useSSL) {
            UnityDriver.debug("Connecting with SSL");
            MongoClientOptions mongoClientOptions = new MongoClientOptions.Builder().socketFactory(SSLSocketFactory.getDefault()).build();
            return new MongoClient(this.servers, mongoClientOptions);
        }
        return new MongoClient(this.servers);
    }

    @Override
    public void connect(Properties properties) throws SQLException {
        try {
            String string;
            String string2;
            String string3;
            this.properties = properties;
            try {
                string3 = properties.getProperty("ssl");
                this.useSSL = false;
                if (string3 != null && (string3.equals("true") || string3.equals("1"))) {
                    this.useSSL = true;
                }
                this.mongoClient = this.getConnection();
            }
            catch (UnknownHostException unknownHostException) {
                throw new SQLException(unknownHostException);
            }
            this.db = this.mongoClient.getDB(this.databaseName);
            string3 = properties.getProperty("readparam");
            DBObject dBObject = null;
            if (string3 != null) {
                try {
                    dBObject = (DBObject)JSON.parse((String)string3);
                }
                catch (Exception exception) {
                    throw new SQLException("Invalid JSON value for read parameter: " + string3 + " JSON conversion error: " + exception.getMessage());
                }
            }
            if ((string2 = properties.getProperty("readpref")) != null) {
                string = null;
                if (string2.equalsIgnoreCase("0") || string2.equalsIgnoreCase("primary")) {
                    string = ReadPreference.primary();
                } else if (string2.equalsIgnoreCase("1") || string2.equalsIgnoreCase("primarypref")) {
                    string = dBObject == null ? ReadPreference.primaryPreferred() : ReadPreference.primaryPreferred((DBObject)dBObject, (DBObject[])new DBObject[0]);
                } else if (string2.equalsIgnoreCase("2") || string2.equalsIgnoreCase("secondary")) {
                    string = dBObject == null ? ReadPreference.secondary() : ReadPreference.secondary((DBObject)dBObject, (DBObject[])new DBObject[0]);
                } else if (string2.equalsIgnoreCase("3") || string2.equalsIgnoreCase("secondarypref")) {
                    string = dBObject == null ? ReadPreference.secondaryPreferred() : ReadPreference.secondaryPreferred((DBObject)dBObject, (DBObject[])new DBObject[0]);
                } else if (string2.equalsIgnoreCase("4") || string2.equalsIgnoreCase("nearest")) {
                    string = dBObject == null ? ReadPreference.nearest() : ReadPreference.nearest((DBObject)dBObject, (DBObject[])new DBObject[0]);
                }
                if (string != null) {
                    this.db.setReadPreference((ReadPreference)string);
                    if (UnityDriver.DEBUG) {
                        System.out.println("MongoDB read preference: " + this.db.getReadPreference());
                    }
                }
            }
            string = properties.getProperty("writeparam");
            String string4 = properties.getProperty("writeconcern");
            WriteConcern writeConcern = WriteConcern.ACKNOWLEDGED;
            if (string != null) {
                writeConcern = new WriteConcern(string);
            } else if (string4 != null) {
                if (string4.equalsIgnoreCase("0") || string4.equalsIgnoreCase("unack")) {
                    writeConcern = WriteConcern.UNACKNOWLEDGED;
                } else if (string4.equalsIgnoreCase("1") || string4.equalsIgnoreCase("ack")) {
                    writeConcern = WriteConcern.ACKNOWLEDGED;
                } else if (string4.equalsIgnoreCase("2") || string4.equalsIgnoreCase("replicaAck")) {
                    writeConcern = WriteConcern.REPLICA_ACKNOWLEDGED;
                } else if (string4.equalsIgnoreCase("3") || string4.contains("journal")) {
                    writeConcern = WriteConcern.JOURNALED;
                }
            }
            if (writeConcern != null) {
                this.db.setWriteConcern(writeConcern);
                if (UnityDriver.DEBUG) {
                    System.out.println("MongoDB write concern: " + this.db.getWriteConcern());
                }
            }
            this.userName = properties.getProperty("user");
            this.password = properties.getProperty("password");
            if (this.userName != null && this.password != null) {
                if (UnityDriver.DEBUG) {
                    System.out.println("Using MongoDB authentication: userName: " + this.userName + " password: " + this.password);
                }
                this.db.authenticate(this.userName, this.password.toCharArray());
            }
            Object object = this.properties.get("rebuildschema");
            this.schemaLocation = (String)this.properties.get("schema");
            boolean bl = false;
            if (object != null && object.toString().equalsIgnoreCase("true")) {
                this.buildSchema();
                this.saveSchema(this.schemaLocation);
                bl = true;
            }
            Object object2 = this.properties.get("validation");
            this.validation = (String)object2;
            if (object2 != null && !bl) {
                if (object2.toString().equalsIgnoreCase("strict")) {
                    if (!this.loadSchema(this.schemaLocation)) {
                        this.buildSchema();
                        this.saveSchema(this.schemaLocation);
                    }
                } else if (object2.toString().equalsIgnoreCase("flex")) {
                    this.loadSchema(this.schemaLocation);
                }
            }
            if (UnityDriver.DEBUG) {
                System.out.println("Rebuilt schema? " + bl + " Schema location: " + this.schemaLocation + " Current schema: " + this.schema);
            }
        }
        catch (SQLException sQLException) {
            throw new SQLException(sQLException);
        }
    }

    public void saveSchema(String string) throws SQLException {
        if (string.contains("mongo:")) {
            HashMap<String, String> hashMap = this.parseMongoLocation(string);
            String string2 = hashMap.get("url");
            String string3 = hashMap.get("dbname");
            String string4 = hashMap.get("collection");
            MongoClient mongoClient = null;
            try {
                mongoClient = this.getConnection(string2, this.useSSL);
            }
            catch (UnknownHostException unknownHostException) {
                throw new SQLException("Error while saving schema: " + unknownHostException);
            }
            DB dB = mongoClient.getDB(string3);
            if (this.userName != null && this.password != null) {
                dB.authenticate(this.userName, this.password.toCharArray());
            }
            DBCollection dBCollection = dB.getCollection(string4);
            BasicDBObject basicDBObject = new BasicDBObject();
            BasicDBObject basicDBObject2 = new BasicDBObject();
            basicDBObject2.append("schema", (Object)this.database.exportXML());
            dBCollection.update((DBObject)basicDBObject, (DBObject)basicDBObject2, true, false);
        } else {
            try {
                File file = new File(string);
                this.database.exportXML(file);
            }
            catch (IOException iOException) {
                throw new SQLException("Error while saving schema to file: " + iOException);
            }
        }
    }

    private HashMap<String, String> parseMongoLocation(String string) throws SQLException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = string;
        int n = (string2 = string2.substring(6)).indexOf("/");
        if (n < 0) {
            throw new SQLException("Invalid Mongo URL (bad URL): " + string);
        }
        String string3 = string2.substring(0, n);
        hashMap.put("url", string3);
        string2 = string2.substring(n + 1);
        n = string2.indexOf("/");
        if (n < 0) {
            throw new SQLException("Invalid Mongo URL (expecting database name): " + string);
        }
        String string4 = string2.substring(0, n);
        hashMap.put("dbname", string4);
        string2 = string2.substring(n + 1);
        hashMap.put("collection", string2);
        return hashMap;
    }

    public boolean loadSchema(String string) throws SQLException {
        if (string.contains("mongo:")) {
            DBCollection dBCollection;
            DBCursor dBCursor;
            HashMap<String, String> hashMap = this.parseMongoLocation(string);
            String string2 = hashMap.get("url");
            String string3 = hashMap.get("dbname");
            String string4 = hashMap.get("collection");
            MongoClient mongoClient = null;
            try {
                mongoClient = this.getConnection(string2, this.useSSL);
            }
            catch (UnknownHostException unknownHostException) {
                throw new SQLException("Error while saving schema: " + unknownHostException);
            }
            this.db = mongoClient.getDB(string3);
            if (this.userName != null && this.password != null) {
                this.db.authenticate(this.userName, this.password.toCharArray());
            }
            if (!(dBCursor = (dBCollection = this.db.getCollection(string4)).find()).hasNext()) {
                return false;
            }
            DBObject dBObject = dBCursor.next();
            String string5 = (String)dBObject.get("schema");
            if (this.schema == null) {
                this.schema = new GlobalSchema();
            }
            this.database = this.schema.importSchema(new ByteArrayInputStream(string5.getBytes()));
            this.schema.addDatabase(this.database);
            return true;
        }
        try {
            BufferedInputStream bufferedInputStream = FileManager.openInputFile(string);
            if (this.schema == null) {
                this.schema = new GlobalSchema();
            }
            this.database = this.schema.importSchema(bufferedInputStream);
            this.schema.addDatabase(this.database);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public ResultSet getMoreResults(int n, MongoStatement mongoStatement) throws SQLException {
        try {
            return null;
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    private ResultSet processMongoWithUnity(String string, GlobalSchema globalSchema) throws SQLException {
        Serializable serializable;
        if (UnityDriver.DEBUG) {
            System.out.println("Processing query in UnityJDBC not handled by MongoDB.");
        }
        if (this.uconn == null) {
            try {
                Class.forName("unity.jdbc.UnityDriver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SQLException(classNotFoundException);
            }
            serializable = new Properties();
            this.uconn = (UnityConnection)DriverManager.getConnection("jdbc:unity://virtual", (Properties)serializable);
        }
        if (globalSchema == null) {
            throw new SQLException(resources.getString("noSchema"));
        }
        this.uconn.setGlobalSchema(globalSchema);
        serializable = globalSchema.getDB(this.databaseName);
        if (serializable == null) {
            throw new SQLException("ERROR: No database defined: " + this.databaseName);
        }
        ((SourceDatabase)serializable).setProperty("usecatalog", "false");
        ((SourceDatabase)serializable).setProperty("useschema", "false");
        this.uconn.setConnection(this.databaseName, this.connection);
        UnityStatement unityStatement = (UnityStatement)this.uconn.createStatement();
        GlobalQuery globalQuery = unityStatement.parseQuery(string, true);
        return unityStatement.executeQuery(globalQuery);
    }

    public GlobalQuery processMongoWithUnityPrepared(String string, GlobalSchema globalSchema) throws SQLException {
        Serializable serializable;
        if (UnityDriver.DEBUG) {
            System.out.println("Processing PreparedStatement query in UnityJDBC not handled by MongoDB.");
        }
        if (this.uconn == null) {
            try {
                Class.forName("unity.jdbc.UnityDriver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SQLException(classNotFoundException);
            }
            serializable = new Properties();
            this.uconn = (UnityConnection)DriverManager.getConnection("jdbc:unity://virtual", (Properties)serializable);
        }
        if (globalSchema == null) {
            throw new SQLException(resources.getString("noSchema"));
        }
        this.uconn.setGlobalSchema(globalSchema);
        serializable = globalSchema.getDB(this.databaseName);
        if (serializable == null) {
            throw new SQLException("ERROR: No database defined: " + this.databaseName);
        }
        ((SourceDatabase)serializable).setProperty("usecatalog", "false");
        ((SourceDatabase)serializable).setProperty("useschema", "false");
        this.uconn.setConnection(this.databaseName, this.connection);
        UnityStatement unityStatement = (UnityStatement)this.uconn.createStatement();
        GlobalQuery globalQuery = unityStatement.parseQuery(string, true);
        return globalQuery;
    }

    protected synchronized MongoExecutor createExecutor(long l) {
        MongoExecutor mongoExecutor = this.executors.get(l);
        if (mongoExecutor != null) {
            mongoExecutor.close();
            this.removeExecutor(l);
        }
        mongoExecutor = new MongoExecutor(this.db, l);
        this.executors.put(l, mongoExecutor);
        return mongoExecutor;
    }

    protected void removeExecutor(long l) {
        this.executors.remove(l);
    }

    public ResultSet executeQuery(String string, int n, MongoStatement mongoStatement) throws SQLException {
        if (string.trim().equals("SELECT 1")) {
            ArrayList<ArrayList<Object>> arrayList = new ArrayList<ArrayList<Object>>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>(1);
            arrayList2.add(1);
            arrayList.add(arrayList2);
            ArrayList<SourceField> arrayList3 = new ArrayList<SourceField>(1);
            arrayList3.add(new SourceField(null, null, null, "Field1", 4, "INT", 4, 0, 0, 0, "", null, 0, 1, "YES"));
            return new LocalResultSet(arrayList, new String[]{"Field1"}, arrayList3);
        }
        MongoExecutor mongoExecutor = this.createExecutor(mongoStatement.getStatementId());
        boolean bl = true;
        try {
            ResultSet resultSet = mongoExecutor.execute(string, n, mongoStatement, this.schema, this);
            bl = false;
            ResultSet resultSet2 = resultSet;
            return resultSet2;
        }
        catch (MongoBuilderUpstreamException mongoBuilderUpstreamException) {
            if (mongoStatement.getStatus() != StatementImpl.UNITY_PROMOTED_QUERY) {
                ResultSet resultSet = this.processMongoWithUnity(string, this.schema);
                return resultSet;
            }
            throw new SQLException(mongoBuilderUpstreamException.getMessage());
        }
        catch (SQLException sQLException) {
            if (mongoStatement.getStatus() != StatementImpl.UNITY_PROMOTED_QUERY) {
                ResultSet resultSet = this.processMongoWithUnity(string, this.schema);
                return resultSet;
            }
            throw sQLException;
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
        finally {
            if (bl) {
                this.removeExecutor(mongoStatement.getStatementId());
            }
        }
    }

    public ResultSet executeQuery(GlobalQuery globalQuery, int n, MongoStatement mongoStatement) throws SQLException {
        try {
            MongoExecutor mongoExecutor = this.createExecutor(mongoStatement.getStatementId());
            try {
                return mongoExecutor.execute(globalQuery, n, mongoStatement, this.schema, this);
            }
            catch (MongoBuilderUpstreamException mongoBuilderUpstreamException) {
                if (mongoStatement.getStatus() != StatementImpl.UNITY_PROMOTED_QUERY) {
                    return this.processMongoWithUnity(globalQuery.getQueryString(), this.schema);
                }
                throw mongoBuilderUpstreamException;
            }
            catch (SQLException sQLException) {
                if (mongoStatement.getStatus() != StatementImpl.UNITY_PROMOTED_QUERY) {
                    return this.processMongoWithUnity(globalQuery.getQueryString(), this.schema);
                }
                throw sQLException;
            }
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    public ResultSet executePreparedQuery(GlobalQuery globalQuery, int n, MongoStatement mongoStatement, String string) throws SQLException {
        try {
            MongoExecutor mongoExecutor = this.createExecutor(mongoStatement.getStatementId());
            return mongoExecutor.execute(globalQuery, n, mongoStatement, this.schema, this);
        }
        catch (MongoBuilderUpstreamException mongoBuilderUpstreamException) {
            if (mongoStatement.getStatus() != StatementImpl.UNITY_PROMOTED_QUERY) {
                return this.processMongoWithUnity(string, this.schema);
            }
            throw new SQLException(mongoBuilderUpstreamException.getMessage());
        }
        catch (SQLException sQLException) {
            if (mongoStatement.getStatus() != StatementImpl.UNITY_PROMOTED_QUERY) {
                return this.processMongoWithUnity(string, this.schema);
            }
            throw sQLException;
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    public int executeUpdate(String string, MongoStatement mongoStatement) throws SQLException {
        GlobalParser globalParser = new GlobalParser(false, false);
        GlobalUpdate globalUpdate = globalParser.parseUpdate(string, this.schema);
        globalUpdate.setStatement(string);
        return this.executeUpdate(globalUpdate, mongoStatement);
    }

    public int executeUpdate(GlobalUpdate globalUpdate, MongoStatement mongoStatement) throws SQLException {
        try {
            Object object;
            LQTree lQTree = globalUpdate.getPlan().getLogicalQueryTree();
            MongoBuilder mongoBuilder = new MongoBuilder(lQTree.getRoot(), this.schema);
            MongoQuery mongoQuery = mongoBuilder.toMongoQuery();
            mongoStatement.setQuery(mongoQuery);
            if (UnityDriver.DEBUG) {
                System.out.println(mongoQuery);
            }
            if ((object = mongoQuery.run(this.db)) instanceof WriteResult) {
                return ((WriteResult)object).getN();
            }
            if (object instanceof Integer) {
                if (globalUpdate.getType() == 22) {
                    GQTableRef gQTableRef = globalUpdate.getPlan().getFirstTableRef();
                    String string = null;
                    if (gQTableRef != null) {
                        ArrayList<AnnotatedSourceTable> arrayList;
                        String string2 = gQTableRef.getTable().getTableName();
                        if (this.schema != null && ((arrayList = this.schema.findTable(string, string2)) == null || arrayList.size() == 0)) {
                            this.buildSchema();
                        }
                    }
                }
                return (Integer)object;
            }
            return 0;
        }
        catch (Exception exception) {
            String string = exception.getLocalizedMessage();
            if (string != null) {
                if (exception.getLocalizedMessage().contains("Function not supported: CURRENT_TIME") || exception.getLocalizedMessage().contains("Function not supported: CURRENT_TIMESTAMP") || exception.getLocalizedMessage().contains("Function not supported: CURRENT_DATE") || exception.getLocalizedMessage().contains("Invalid reference: current_date") || exception.getLocalizedMessage().contains("Invalid reference: current_time") || exception.getLocalizedMessage().contains("Invalid reference: current_timestamp")) {
                    throw new SQLException("JDBC for MongoDB Driver: Mongo JDBC Driver only supports INSERT with constant values - no expressions or functions allowed.");
                }
                if (exception.getLocalizedMessage().contains("Delete only supports subqueries of the form: attr [not] in (subquery)")) {
                    throw new SQLException("JDBC for MongoDB Driver: FUNCTION in projections is not supported.");
                }
                throw new SQLException(exception.getLocalizedMessage());
            }
            exception.printStackTrace();
            throw new SQLException(exception.getStackTrace().toString());
        }
    }

    @Override
    public boolean next(long l, Tuple tuple) throws SQLException {
        MongoExecutor mongoExecutor = this.executors.get(l);
        if (mongoExecutor == null) {
            return false;
        }
        return mongoExecutor.next(tuple);
    }

    @Override
    public boolean get(long l, int n, Tuple tuple) throws SQLException {
        try {
            return false;
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    @Override
    public int getLast(long l) throws SQLException {
        try {
            return 0;
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    @Override
    public void setFetchSize(int n, int n2) {
        this.fetchSize = n;
    }

    @Override
    public void close() throws SQLException {
        try {
            for (MongoExecutor mongoExecutor : this.executors.values()) {
                mongoExecutor.close();
            }
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    @Override
    public void closeStatement(long l) throws SQLException {
        MongoExecutor mongoExecutor = this.executors.get(l);
        if (mongoExecutor != null) {
            mongoExecutor.close();
            this.removeExecutor(l);
        }
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public SourceDatabase getDatabase() {
        if (this.database == null) {
            this.buildSchema();
        }
        return this.database;
    }

    public GlobalSchema getSchema() {
        if (this.database == null) {
            this.buildSchema();
        }
        return this.schema;
    }

    public void buildSchema() {
        this.database = this.buildSourceDatabase();
        this.schema = new GlobalSchema();
        this.schema.addDatabase(this.database);
        if (this.validation != null && this.validation.equalsIgnoreCase("flex")) {
            try {
                this.saveSchema(this.schemaLocation);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String buildUrlString(ArrayList<ServerAddress> arrayList) {
        StringBuilder stringBuilder = new StringBuilder(100);
        for (ServerAddress serverAddress : arrayList) {
            stringBuilder.append(serverAddress.getHost());
            stringBuilder.append(":");
            stringBuilder.append(serverAddress.getPort());
        }
        return stringBuilder.toString();
    }

    public SourceDatabase buildSourceDatabase() {
        String string = this.db.getName();
        if (StringFunc.delimitedIdentifier(string)) {
            string = StringFunc.delimitName(string, '\"');
        }
        AnnotatedSourceDatabase annotatedSourceDatabase = new AnnotatedSourceDatabase(string, string, "MongoDB", this.db.getMongo().getVersion(), "jdbc:mongo://" + ServerConnection.buildUrlString(this.servers) + "/" + this.databaseName, "mongodb.jdbc.MongoDriver", '\"');
        annotatedSourceDatabase.setJavaDriverClassName("mongodb.jdbc.MongoDriver");
        annotatedSourceDatabase.setDatabaseId(80020202);
        MongoExecutor mongoExecutor = new MongoExecutor(this.db, -1L);
        Object object = this.properties.get("samplesize");
        if (object != null) {
            try {
                double d = Double.parseDouble(object.toString());
                mongoExecutor.setSampleFraction(d);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        LinkedHashMap<String, SourceTable> linkedHashMap = new LinkedHashMap<String, SourceTable>();
        annotatedSourceDatabase.setSourceTables(linkedHashMap);
        String string2 = string;
        for (String string3 : this.db.getCollectionNames()) {
            DBCollection dBCollection = this.db.getCollection(string3);
            String string4 = string3;
            string4 = StringFunc.delimitName(string4);
            HashMap<String, SourceField> hashMap = null;
            AnnotatedSourceTable annotatedSourceTable = new AnnotatedSourceTable(null, string2, string4, null, null, null);
            try {
                hashMap = this.getHashMapFromAttributes(mongoExecutor.getSchema(annotatedSourceDatabase, annotatedSourceTable, dBCollection), string4);
            }
            catch (Exception exception) {
                System.out.println("Error while building schema for collection: " + string3);
                continue;
            }
            annotatedSourceTable.setSourceFields(hashMap);
            ArrayList<SourceField> arrayList = new ArrayList<SourceField>();
            SourceField sourceField = hashMap.get("\"_id\"");
            if (sourceField != null) {
                arrayList.add(sourceField);
                AnnotatedSourceKey annotatedSourceKey = new AnnotatedSourceKey(arrayList, 1, "pk_" + StringFunc.undelimitName(string4, '\"'));
                annotatedSourceTable.setPrimaryKey(annotatedSourceKey);
            }
            annotatedSourceTable.setParentDatabase(annotatedSourceDatabase);
            annotatedSourceTable.setCaseSensitive(true);
            annotatedSourceTable.setNumTuples((int)dBCollection.count());
            linkedHashMap.put(string3, annotatedSourceTable);
        }
        return annotatedSourceDatabase;
    }

    private HashMap<String, SourceField> getHashMapFromAttributes(Attribute[] attributeArray, String string) {
        HashMap<String, SourceField> hashMap = new HashMap<String, SourceField>();
        int n = 1;
        if (attributeArray != null) {
            for (Attribute attribute : attributeArray) {
                if (attribute == null) {
                    System.out.println("Issue with a NULL attribute.");
                    continue;
                }
                AnnotatedSourceField annotatedSourceField = new AnnotatedSourceField();
                annotatedSourceField.setColumnName(StringFunc.delimitName(attribute.getName()));
                annotatedSourceField.setDataTypeName(Attribute.getTypeName(attribute.getType()));
                annotatedSourceField.setTableName(string);
                annotatedSourceField.setDataType(attribute.getType());
                SourceField.setSizeByType(annotatedSourceField, 0x1004000);
                annotatedSourceField.setOrdinalPosition(n++);
                hashMap.put(attribute.getName(), annotatedSourceField);
            }
        }
        return hashMap;
    }

    public String getVersion() {
        CommandResult commandResult = this.db.command("buildInfo");
        return commandResult.getString("version");
    }

    public String getDriverVersion() {
        return this.db.getMongo().getVersion();
    }

    public List<DBObject> getIndexes(String string) throws SQLException {
        try {
            DBCollection dBCollection = this.db.getCollection(string);
            return dBCollection.getIndexInfo();
        }
        catch (Exception exception) {
            throw new SQLException("Collection not found: " + string);
        }
    }

    public DB getDB() {
        return this.db;
    }

    @Override
    public GlobalCommand getCommand(long l) throws SQLException {
        MongoExecutor mongoExecutor = this.executors.get(l);
        if (mongoExecutor == null) {
            return null;
        }
        return null;
    }

    static {
        locale = Locale.getDefault();
        resources = ResourceBundle.getBundle("resources/mongo/ServerConnection", locale);
    }
}

