/*
 * Decompiled with CFR 0.152.
 */
package mongodb.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.ResourceBundle;
import mongodb.conn.ServerConnection;
import mongodb.jdbc.MongoConnection;
import mongodb.jdbc.MongoStatement;
import unity.engine.Attribute;
import unity.engine.IServerConnection;
import unity.query.GlobalCommand;
import unity.query.GlobalQuery;
import unity.query.GlobalUpdate;
import unity.query.Optimizer;
import unity.util.Convert;
import unity.util.StringFunc;

public class MongoPreparedStatement
extends MongoStatement
implements PreparedStatement {
    protected static ResourceBundle resources = ResourceBundle.getBundle("resources/mongo/MongoPreparedStatement", locale);
    protected String originalQueryString;
    protected boolean hasBlob = false;
    protected ArrayList<Object> streams;
    protected GlobalCommand command;

    public MongoPreparedStatement(MongoConnection mongoConnection, IServerConnection iServerConnection, int n, int n2, String string) throws SQLException {
        super(mongoConnection, iServerConnection, n, n2);
        this.originalQueryString = string;
        this.streams = new ArrayList();
        String string2 = string.toLowerCase().trim();
        this.command = string2.startsWith("select") ? this.parseQuery(string, false) : this.parseUpdate(string, false);
    }

    @Override
    public void addBatch() throws SQLException {
        throw new SQLException(resources.getString("notsupportedError"));
    }

    @Override
    public void clearParameters() throws SQLException {
        this.command.clearParameters();
    }

    private String combineString() {
        String string = this.originalQueryString;
        if (this.command != null) {
            if (this.command instanceof GlobalQuery) {
                return Optimizer.buildSQL(((GlobalQuery)this.command).getLogicalQueryTree().getRoot());
            }
            return ((GlobalUpdate)this.command).getStatement();
        }
        return string;
    }

    @Override
    public boolean execute() throws SQLException {
        if (this.command != null) {
            if (this.command instanceof GlobalQuery) {
                this.executeQuery();
                return true;
            }
            this.executeUpdate();
            return false;
        }
        return false;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this._results = ((ServerConnection)this.con).executePreparedQuery((GlobalQuery)this.command, this._resultSetType, this, this.combineString());
        return this._results;
    }

    @Override
    public int executeUpdate() throws SQLException {
        int n = ((ServerConnection)this.con).executeUpdate((GlobalUpdate)this.command, (MongoStatement)this);
        return n;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return null;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return null;
    }

    public String getSQLStatement() throws SQLException {
        return this.combineString();
    }

    public ArrayList<Object> getStreams() {
        return this.streams;
    }

    public boolean isHasBlob() {
        return this.hasBlob;
    }

    @Override
    public void setArray(int n, Array array) throws SQLException {
        throw new SQLException(resources.getString("notsupportedError"));
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        throw new SQLException(resources.getString("notsupportedError"));
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (inputStream == null) {
            this.setNull(n, -3);
            return;
        }
        if (this.command != null) {
            this.command.setParameter(n, inputStream, -3);
        }
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLException(resources.getString("notsupportedError"));
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (this.command != null) {
            this.command.setParameter(n, bigDecimal, 3);
        }
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.setHasBlob(true);
        if (inputStream == null) {
            this.setNull(n, -3);
            return;
        }
        if (this.command != null) {
            this.command.setParameter(n, inputStream, -3);
        }
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (inputStream == null) {
            this.setNull(n, -3);
            return;
        }
        this.hasBlob = true;
        if (this.command != null) {
            this.command.setParameter(n, inputStream, -3);
        }
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLException(resources.getString("notsupportedError"));
    }

    @Override
    public void setBlob(int n, Blob blob) throws SQLException {
        throw new SQLException(resources.getString("notsupportedError"));
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        throw new SQLException(resources.getString("notsupportedError"));
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLException(resources.getString("notsupportedError"));
    }

    @Override
    public void setBoolean(int n, boolean bl) throws SQLException {
        if (this.command != null) {
            this.command.setParameter(n, bl, 16);
        }
    }

    @Override
    public void setByte(int n, byte by) throws SQLException {
        if (this.command != null) {
            this.command.setParameter(n, by, 1002);
        }
    }

    @Override
    public void setBytes(int n, byte[] byArray) throws SQLException {
        if (byArray == null) {
            this.setNull(n, -2);
            return;
        }
        if (this.command != null) {
            this.command.setParameter(n, byArray, -2);
        }
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException {
        throw new SQLException(resources.getString("notsupportedError"));
    }

    @Override
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new SQLException(resources.getString("notsupportedError"));
    }

    @Override
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new SQLException(resources.getString("notsupportedError"));
    }

    @Override
    public void setClob(int n, Clob clob) throws SQLException {
        throw new SQLException(resources.getString("notsupportedError"));
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException {
        throw new SQLException(resources.getString("notsupportedError"));
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException {
        throw new SQLException(resources.getString("notsupportedError"));
    }

    @Override
    public void setDate(int n, Date date) throws SQLException {
        if (date == null) {
            this.setNull(n, 91);
            return;
        }
        if (this.command != null) {
            this.command.setParameter(n, date, 91);
        }
    }

    @Override
    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.setDate(n, date);
    }

    @Override
    public void setDouble(int n, double d) throws SQLException {
        if (this.command != null) {
            this.command.setParameter(n, d, 8);
        }
    }

    @Override
    public void setFloat(int n, float f) throws SQLException {
        if (this.command != null) {
            this.command.setParameter(n, Float.valueOf(f), 6);
        }
    }

    public void setHasBlob(boolean bl) {
        this.hasBlob = bl;
    }

    @Override
    public void setInt(int n, int n2) throws SQLException {
        if (this.command != null) {
            this.command.setParameter(n, n2, 4);
        }
    }

    @Override
    public void setLong(int n, long l) throws SQLException {
        if (this.command != null) {
            this.command.setParameter(n, l, -5);
        }
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        throw new SQLException(resources.getString("notsupportedError"));
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new SQLException(resources.getString("notsupportedError"));
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException {
        throw new SQLException(resources.getString("notsupportedError"));
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException {
        throw new SQLException(resources.getString("notsupportedError"));
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException {
        throw new SQLException(resources.getString("notsupportedError"));
    }

    @Override
    public void setNString(int n, String string) throws SQLException {
        throw new SQLException(resources.getString("notsupportedError"));
    }

    @Override
    public void setNull(int n, int n2) throws SQLException {
        if (this.command != null) {
            this.command.setParameterNull(n, n2);
        }
    }

    @Override
    public void setNull(int n, int n2, String string) throws SQLException {
        this.setNull(n, n2);
    }

    @Override
    public void setObject(int n, Object object) throws SQLException {
        if (object == null) {
            this.setNull(n, 1111);
            return;
        }
        if (object instanceof Boolean) {
            this.setBoolean(n, (Boolean)object);
        } else if (object instanceof Byte) {
            this.setByte(n, (Byte)object);
        } else if (object instanceof Short) {
            this.setShort(n, (Short)object);
        } else if (object instanceof Integer) {
            this.setInt(n, (Integer)object);
        } else if (object instanceof Long) {
            this.setLong(n, (Long)object);
        } else if (object instanceof Float) {
            this.setFloat(n, ((Float)object).floatValue());
        } else if (object instanceof Double) {
            this.setDouble(n, (Double)object);
        } else if (object instanceof BigDecimal) {
            this.setBigDecimal(n, (BigDecimal)object);
        } else if (object instanceof String) {
            this.setString(n, (String)object);
        } else if (object instanceof byte[]) {
            this.setBytes(n, (byte[])object);
        } else if (object instanceof Date) {
            this.setDate(n, (Date)object);
        } else if (object instanceof Time) {
            this.setTime(n, (Time)object);
        } else if (object instanceof Timestamp) {
            this.setTimestamp(n, (Timestamp)object);
        } else if (object instanceof java.util.Date) {
            this.setDate(n, new Date(((java.util.Date)object).getTime()));
        } else if (object instanceof Serializable) {
            this.setSerializableObject(n, object);
        }
    }

    @Override
    public void setObject(int n, Object object, int n2) throws SQLException {
        if (object == null) {
            this.setNull(n, n2);
            return;
        }
        int n3 = Attribute.getType(object);
        if (n3 == n2) {
            this.setObject(n, object);
        } else {
            try {
                Object object2 = Convert.convertObject(object, n2);
                this.setObject(n, object2);
            }
            catch (Exception exception) {
                throw new SQLException(resources.getString("objectConvertError") + " Exception: " + exception);
            }
        }
    }

    @Override
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.setObject(n, object, n2);
    }

    @Override
    public void setRef(int n, Ref ref) throws SQLException {
        throw new SQLException(resources.getString("notsupportedError"));
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException {
        throw new SQLException(resources.getString("notsupportedError"));
    }

    private void setSerializableObject(int n, Object object) throws SQLException {
        throw new SQLException(resources.getString("serializationError"));
    }

    @Override
    public void setShort(int n, short s) throws SQLException {
        if (this.command != null) {
            this.command.setParameter(n, s, 5);
        }
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        throw new SQLException(resources.getString("notsupportedError"));
    }

    @Override
    public void setString(int n, String string) throws SQLException {
        if (string == null) {
            this.setNull(n, 12);
            return;
        }
        String string2 = StringFunc.escapeSQLString(string);
        if (this.command != null) {
            this.command.setParameter(n, string2, 12);
        }
    }

    public void setStringNQ(int n, String string) throws SQLException {
        if (this.command != null) {
            this.command.setParameter(n, string, 1001);
        }
    }

    @Override
    public void setTime(int n, Time time) throws SQLException {
        if (time == null) {
            this.setNull(n, 92);
            return;
        }
        if (this.command != null) {
            this.command.setParameter(n, time, 92);
        }
    }

    @Override
    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.setTime(n, time);
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (timestamp == null) {
            this.setNull(n, 93);
            return;
        }
        if (this.command != null) {
            this.command.setParameter(n, timestamp, 93);
        }
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestamp(n, timestamp);
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (inputStream == null) {
            this.setNull(n, -3);
            return;
        }
        if (this.command != null) {
            this.command.setParameter(n, inputStream, -3);
        }
    }

    @Override
    public void setURL(int n, URL uRL) throws SQLException {
        this.setString(n, uRL.toString());
    }
}

