/*
 * Decompiled with CFR 0.152.
 */
package mongodb.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ResourceBundle;
import mongodb.conn.ServerConnection;
import mongodb.jdbc.MongoConnection;
import mongodb.query.MongoBuilder;
import mongodb.query.MongoBuilderUpstreamException;
import mongodb.query.MongoQuery;
import mongodb.query.MongoSelectQuery;
import unity.annotation.GlobalSchema;
import unity.engine.IServerConnection;
import unity.generic.jdbc.StatementImpl;
import unity.jdbc.UnityDriver;
import unity.parser.GlobalParser;
import unity.query.GlobalQuery;
import unity.query.GlobalUpdate;
import unity.query.LimitInfo;
import unity.util.StringFunc;

public class MongoStatement
extends StatementImpl {
    protected static ResourceBundle resources = ResourceBundle.getBundle("resources/mongo/MongoStatement", locale);
    private MongoQuery query;

    public MongoStatement() {
        super(null, null, 1003, 1007);
    }

    public MongoStatement(MongoConnection mongoConnection, IServerConnection iServerConnection, int n, int n2) {
        super(mongoConnection, iServerConnection, n, n2);
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        if (!string.toLowerCase().trim().startsWith("select")) {
            throw new SQLException(resources.getString("errorExecuteQuery") + string);
        }
        String string2 = string;
        if (this._results != null) {
            this._results.close();
        }
        this.queryActive = false;
        this._results = null;
        this.query = null;
        if (this._maxRows > 0) {
            LimitInfo limitInfo = LimitInfo.parse(string);
            limitInfo.rowCount = limitInfo.hasLimit ? Math.min(limitInfo.rowCount, this._maxRows) : this._maxRows;
            limitInfo.hasLimit = true;
            string2 = StringFunc.replaceLimit(string, limitInfo);
        }
        this._results = ((ServerConnection)this.con).executeQuery(string2, this._resultSetType, this);
        this.queryActive = true;
        return this._results;
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        if (string.toLowerCase().trim().startsWith("select")) {
            throw new SQLException(resources.getString("errorExecuteUpdate") + string);
        }
        String string2 = StringFunc.verifyTerminator(string);
        if (UnityDriver.DEBUG) {
            System.out.println("Executing: " + string2);
        }
        return ((ServerConnection)this.con).executeUpdate(string2, this);
    }

    public String getQueryString() {
        if (this.query == null) {
            return "";
        }
        try {
            return this.query.toMongoString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void setQuery(MongoQuery mongoQuery) {
        this.query = mongoQuery;
    }

    public GlobalQuery parseQuery(String string, boolean bl) throws SQLException {
        if (string == null || string.equals("")) {
            return null;
        }
        String string2 = StringFunc.verifyTerminator(string);
        GlobalSchema globalSchema = ((ServerConnection)this.con).getSchema();
        GlobalParser globalParser = new GlobalParser(false, bl);
        GlobalQuery globalQuery = globalParser.parse(string2, globalSchema);
        globalQuery.setQueryString(string2);
        try {
            MongoBuilder mongoBuilder = new MongoBuilder(globalQuery.getLogicalQueryTree().getRoot());
            this.query = (MongoSelectQuery)mongoBuilder.toMongoQuery();
        }
        catch (MongoBuilderUpstreamException mongoBuilderUpstreamException) {
            return ((ServerConnection)this.con).processMongoWithUnityPrepared(string2, globalSchema);
        }
        catch (Exception exception) {
            return ((ServerConnection)this.con).processMongoWithUnityPrepared(string2, globalSchema);
        }
        return globalQuery;
    }

    public GlobalQuery translateQuery(String string, boolean bl, GlobalSchema globalSchema) throws SQLException {
        if (string == null || string.equals("")) {
            return null;
        }
        String string2 = StringFunc.verifyTerminator(string);
        GlobalParser globalParser = new GlobalParser(false, bl);
        GlobalQuery globalQuery = globalParser.parse(string2, globalSchema);
        globalQuery.setQueryString(string2);
        try {
            MongoBuilder mongoBuilder = new MongoBuilder(globalQuery.getLogicalQueryTree().getRoot());
            this.query = (MongoSelectQuery)mongoBuilder.toMongoQuery();
        }
        catch (MongoBuilderUpstreamException mongoBuilderUpstreamException) {
            return ((ServerConnection)this.con).processMongoWithUnityPrepared(string2, globalSchema);
        }
        catch (Exception exception) {
            return ((ServerConnection)this.con).processMongoWithUnityPrepared(string2, globalSchema);
        }
        return globalQuery;
    }

    public GlobalUpdate parseUpdate(String string, boolean bl) throws SQLException {
        if (string == null || string.equals("")) {
            return null;
        }
        String string2 = StringFunc.verifyTerminator(string);
        GlobalSchema globalSchema = ((ServerConnection)this.con).getSchema();
        GlobalParser globalParser = new GlobalParser(false, bl);
        GlobalUpdate globalUpdate = globalParser.parseUpdate(string2, globalSchema);
        return globalUpdate;
    }
}

