/*
 * Decompiled with CFR 0.152.
 */
package mongodb.query;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBObject;
import com.mongodb.DuplicateKeyException;
import com.mongodb.MongoException;
import java.sql.SQLException;
import mongodb.query.MongoBuilderFatalException;
import mongodb.query.MongoQuery;
import unity.jdbc.UnityDriver;

public class MongoInsertQuery
extends MongoQuery {
    public BasicDBObject insertFields = new BasicDBObject();

    @Override
    public String toMongoString() throws MongoBuilderFatalException {
        return "db." + this.collectionName + ".insert(" + this.insertFields.toString() + ")";
    }

    @Override
    public Object run(DB dB) throws Exception {
        try {
            dB.getCollection(this.collectionName).insert(new DBObject[]{this.insertFields});
            return 1;
        }
        catch (DuplicateKeyException duplicateKeyException) {
            if (UnityDriver.DEBUG) {
                System.out.println("Mongo genererated the following exception: " + (Object)((Object)duplicateKeyException));
            }
            String string = duplicateKeyException.getMessage().substring(duplicateKeyException.getMessage().lastIndexOf("duplicate key error index: ") + "duplicate key error index: ".length());
            String[] stringArray = string.substring(0, string.indexOf(" ")).split("\\.");
            String string2 = "The statement was aborted because it would have caused a duplicate key value in a unique or primary key constraint or unique index identified by '" + stringArray[2] + "' defined on '" + stringArray[0] + "." + stringArray[1] + "'.";
            throw new SQLException(string2);
        }
        catch (MongoException mongoException) {
            if (UnityDriver.DEBUG) {
                System.out.println("Mongo genererated the following exception: " + (Object)((Object)mongoException));
            }
            throw new SQLException(mongoException.getCause());
        }
    }
}

