/*
 * Decompiled with CFR 0.152.
 */
package snow.conn;

import java.sql.ResultSet;
import java.sql.SQLException;
import snow.conn.ServerConnection;
import snow.jdbc.SNowResultSet;
import snow.jdbc.SNowStatement;
import snow.query.SNowBuilder;
import snow.query.SNowQuery;
import unity.annotation.GlobalSchema;
import unity.engine.Relation;
import unity.engine.TableData;
import unity.engine.Tuple;
import unity.jdbc.UnityDriver;
import unity.operators.Operator;
import unity.parser.GlobalParser;
import unity.query.GlobalQuery;
import unity.query.LQTree;
import unity.query.Optimizer;

public class SNowExecutor {
    private boolean resultSetComplete;
    private Operator op;
    private Relation relation;
    private long statementId;
    private String url;
    private GlobalQuery gq;
    private int numOutput;

    public SNowExecutor(String string, long l) {
        this.statementId = l;
        this.url = string;
    }

    public ResultSet execute(String string, int n, SNowStatement sNowStatement, GlobalSchema globalSchema, ServerConnection serverConnection) throws SQLException {
        string = string + ";";
        GlobalParser globalParser = new GlobalParser(false, true);
        this.gq = globalParser.parse(string, globalSchema);
        return this.execute(this.gq, n, sNowStatement, globalSchema, serverConnection);
    }

    public ResultSet execute(GlobalQuery globalQuery, int n, SNowStatement sNowStatement, GlobalSchema globalSchema, ServerConnection serverConnection) throws SQLException {
        this.gq = globalQuery;
        Optimizer.basicOptimization(this.gq);
        LQTree lQTree = this.gq.getLogicalQueryTree();
        if (UnityDriver.DEBUG) {
            System.out.println("Logical query tree: \n");
            lQTree.print();
        }
        SNowBuilder sNowBuilder = new SNowBuilder(this.url, lQTree.getRoot());
        SNowQuery sNowQuery = null;
        sNowQuery = sNowBuilder.toQuery();
        sNowStatement.setQuery(sNowQuery);
        sNowQuery.setProperties(serverConnection.getProperties());
        this.op = sNowQuery.run();
        this.relation = sNowQuery.getRelation();
        this.numOutput = 0;
        TableData tableData = new TableData(serverConnection, n != 1003, this.statementId);
        tableData.setRelation(this.relation);
        return new SNowResultSet(tableData, this.relation, n, sNowStatement);
    }

    public boolean next(Tuple tuple) throws SQLException {
        if (this.resultSetComplete) {
            return false;
        }
        if (UnityDriver.isTrial() && this.numOutput >= UnityDriver.getMaxResults()) {
            System.out.println(UnityDriver.i18n.getString("ResultSet.MaxRows") + UnityDriver.getMaxResults() + UnityDriver.i18n.getString("ResultSet.TrialVersion"));
            return false;
        }
        try {
            if (this.op.next(tuple)) {
                ++this.numOutput;
                return true;
            }
            this.resultSetComplete = true;
            return false;
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    public GlobalQuery getGlobalQuery() {
        return this.gq;
    }

    public String toString() {
        String string = "ID: " + this.statementId;
        if (this.gq != null) {
            string = string + " Query: " + this.gq.getQueryString();
        }
        return string;
    }

    public void close() throws SQLException {
        if (this.op != null) {
            this.op.close();
        }
    }
}

