/*
 * Decompiled with CFR 0.152.
 */
package splunk.conn;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import splunk.conn.SplunkExecutor;
import splunk.jdbc.SplunkPreparedStatement;
import splunk.jdbc.SplunkStatement;
import unity.annotation.AnnotatedSourceDatabase;
import unity.annotation.GlobalSchema;
import unity.annotation.SourceDatabase;
import unity.annotation.SourceField;
import unity.engine.Attribute;
import unity.engine.IServerConnection;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.generic.jdbc.StatementImpl;
import unity.io.FileManager;
import unity.jdbc.LocalResultSet;
import unity.jdbc.UnityConnection;
import unity.jdbc.UnityDriver;
import unity.jdbc.UnityStatement;
import unity.query.GlobalCommand;
import unity.query.GlobalQuery;
import unity.query.Optimizer;

public class ServerConnection
implements IServerConnection {
    private String url;
    private String userName;
    private Properties properties;
    private UnityConnection uconn;
    private SourceDatabase database;
    private GlobalSchema schema;
    private String schemaLocation;
    private Connection connection;
    private long lastStatementId = 0L;
    private HashMap<Long, SplunkExecutor> executors;

    public ServerConnection(String string, Connection connection) {
        this.url = string;
        this.uconn = null;
        this.connection = connection;
        this.executors = new HashMap();
    }

    @Override
    public void connect(Properties properties) throws SQLException {
        try {
            String string;
            this.properties = properties;
            String string2 = properties.getProperty("user");
            if (string2 == null) {
                string2 = "admin";
            }
            if ((string = properties.getProperty("password")) == null) {
                string = "admin";
            }
            Object object = this.properties.get("rebuildschema");
            this.schemaLocation = (String)this.properties.get("schema");
            if (object != null && object.toString().equalsIgnoreCase("true")) {
                this.buildSchema();
            } else if (this.schemaLocation != null) {
                this.schema = new GlobalSchema();
                if (!this.loadSchema(this.schemaLocation)) {
                    this.schema = null;
                }
            }
            if (this.schema == null) {
                this.buildSchema();
            }
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    public ResultSet getMoreResults(int n, SplunkStatement splunkStatement) throws SQLException {
        try {
            return null;
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    private ResultSet processQueryWithUnity(String string, GlobalSchema globalSchema, GlobalQuery globalQuery) throws SQLException {
        Object object;
        if (UnityDriver.DEBUG) {
            System.out.println("Processing query in UnityJDBC not handled by Splunk.");
        }
        if (this.uconn == null) {
            try {
                Class.forName("unity.jdbc.UnityDriver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SQLException(classNotFoundException);
            }
            object = new Properties();
            this.uconn = (UnityConnection)DriverManager.getConnection("jdbc:unity://virtual", (Properties)object);
        }
        this.uconn.setGlobalSchema(globalSchema);
        this.uconn.setConnection("Splunk", this.connection);
        object = (UnityStatement)this.uconn.createStatement();
        if (globalQuery == null) {
            globalQuery = ((UnityStatement)object).parseQuery(string, true);
        } else {
            Optimizer optimizer = new Optimizer(globalQuery, false, (UnityStatement)object);
            globalQuery = optimizer.optimize();
            globalQuery.setQueryString(string);
        }
        return ((UnityStatement)object).executeQuery(globalQuery);
    }

    protected synchronized SplunkExecutor createExecutor() {
        SplunkExecutor splunkExecutor = new SplunkExecutor(this.url, ++this.lastStatementId);
        this.executors.put(this.lastStatementId, splunkExecutor);
        return splunkExecutor;
    }

    public ResultSet executeQuery(String string, int n, SplunkStatement splunkStatement) throws SQLException {
        try {
            if (string.contains("SELECT 1")) {
                ArrayList<ArrayList<Object>> arrayList = new ArrayList<ArrayList<Object>>();
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>(1);
                arrayList2.add(1);
                arrayList.add(arrayList2);
                ArrayList<SourceField> arrayList3 = new ArrayList<SourceField>(1);
                arrayList3.add(new SourceField(null, null, null, "Field1", 4, "INT", 4, 0, 0, 0, "", null, 0, 1, "YES"));
                return new LocalResultSet(arrayList, new String[]{"Field1"}, arrayList3);
            }
            SplunkExecutor splunkExecutor = this.createExecutor();
            try {
                return splunkExecutor.execute(string, n, splunkStatement, this.schema, this);
            }
            catch (SQLException sQLException) {
                if (splunkStatement.getStatus() != StatementImpl.UNITY_PROMOTED_QUERY) {
                    return this.processQueryWithUnity(string, this.schema, splunkExecutor.getGlobalQuery());
                }
                throw sQLException;
            }
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    public ResultSet executePreparedQuery(GlobalQuery globalQuery, int n, SplunkPreparedStatement splunkPreparedStatement, String string) throws SQLException {
        return null;
    }

    @Override
    public boolean next(long l, Tuple tuple) throws SQLException {
        SplunkExecutor splunkExecutor = this.executors.get(l);
        if (splunkExecutor == null) {
            return false;
        }
        return splunkExecutor.next(tuple);
    }

    @Override
    public boolean get(long l, int n, Tuple tuple) throws SQLException {
        try {
            return false;
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    @Override
    public int getLast(long l) throws SQLException {
        try {
            return 0;
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public void closeStatement(long l) throws SQLException {
        SplunkExecutor splunkExecutor = this.executors.get(l);
        if (splunkExecutor != null) {
            this.executors.remove(l);
        }
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public SourceDatabase getDatabase() {
        if (this.database == null) {
            try {
                this.buildSchema();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return this.database;
    }

    public GlobalSchema getSchema() throws SQLException {
        if (this.database == null) {
            this.buildSchema();
        }
        return this.schema;
    }

    public void buildSchema() throws SQLException {
        if (UnityDriver.DEBUG) {
            System.out.println("Building schema");
        }
        this.database = this.buildSourceDatabase();
        if (this.schema == null) {
            this.schema = new GlobalSchema();
        }
        this.schema.addDatabase(this.database);
        this.schema.linkForeignKeysAndJoinsAll();
        this.saveSchema(this.schemaLocation);
    }

    public SourceDatabase buildSourceDatabase() throws SQLException {
        long l = System.currentTimeMillis();
        String string = "splunk";
        AnnotatedSourceDatabase annotatedSourceDatabase = new AnnotatedSourceDatabase(string, string, "Splunk", "", "jdbc:Splunk://" + this.url, "Splunk.jdbc.QuandlDriver", '\"');
        annotatedSourceDatabase.setJavaDriverClassName("splunk.jdbc.QuandlDriver");
        annotatedSourceDatabase.setDatabaseId(82030000);
        Attribute[] attributeArray = new Attribute[]{new Attribute("element", 12, 0), new Attribute("name", 12, 0), new Attribute("internal_type", 12, 0), new Attribute("reference", 12, 0)};
        Relation relation = new Relation(attributeArray);
        if (UnityDriver.DEBUG) {
            System.out.println("Schema extraction time: " + (System.currentTimeMillis() - l));
        }
        return annotatedSourceDatabase;
    }

    @Override
    public void setFetchSize(int n, int n2) {
    }

    public void saveSchema(String string) throws SQLException {
        try {
            File file = new File(string);
            this.database.exportXML(file);
        }
        catch (IOException iOException) {
            throw new SQLException("Error while saving schema to file: " + iOException);
        }
    }

    public boolean loadSchema(String string) throws SQLException {
        try {
            BufferedInputStream bufferedInputStream = FileManager.openInputFile(string);
            this.database = this.schema.importSchema(bufferedInputStream);
            this.schema.addDatabase(this.database);
            this.schema.linkForeignKeysAndJoinsAll();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static ArrayList<Tuple> getRecords(String string, String string2, HashMap<String, String> hashMap, Relation relation, Properties properties) throws SQLException {
        try {
            ArrayList<Tuple> arrayList = new ArrayList<Tuple>();
            System.out.println(relation);
            for (int i = 0; i < 5; ++i) {
                Tuple tuple = new Tuple(relation);
                Object[] objectArray = new Object[]{"Test1", "Test2"};
                tuple.setValues(objectArray);
                arrayList.add(tuple);
            }
            return arrayList;
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
            throw new SQLException("Error with request.  Request URL: " + string + " Error: " + exception);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public GlobalCommand getCommand(long l) throws SQLException {
        SplunkExecutor splunkExecutor = this.executors.get(l);
        if (splunkExecutor == null) {
            return null;
        }
        return splunkExecutor.getGlobalQuery();
    }
}

