/*
 * Decompiled with CFR 0.152.
 */
package splunk.conn;

import java.sql.ResultSet;
import java.sql.SQLException;
import splunk.conn.ServerConnection;
import splunk.jdbc.SplunkResultSet;
import splunk.jdbc.SplunkStatement;
import splunk.query.SplunkBuilder;
import splunk.query.SplunkQuery;
import unity.annotation.GlobalSchema;
import unity.engine.Relation;
import unity.engine.TableData;
import unity.engine.Tuple;
import unity.jdbc.UnityDriver;
import unity.operators.Operator;
import unity.parser.GlobalParser;
import unity.query.GlobalQuery;
import unity.query.LQTree;
import unity.query.Optimizer;

public class SplunkExecutor {
    private boolean resultSetComplete;
    private Operator op;
    private Relation relation;
    private long statementId;
    private String url;
    private GlobalQuery gq;
    private int numOutput = 0;

    public SplunkExecutor(String string, long l) {
        this.statementId = l;
        this.url = string;
    }

    public ResultSet execute(String string, int n, SplunkStatement splunkStatement, GlobalSchema globalSchema, ServerConnection serverConnection) throws SQLException {
        string = string + ";";
        GlobalParser globalParser = new GlobalParser(false, false);
        this.gq = globalParser.parse(string, globalSchema);
        Optimizer.basicOptimization(this.gq);
        LQTree lQTree = this.gq.getLogicalQueryTree();
        if (UnityDriver.DEBUG) {
            System.out.println("Logical query tree: \n");
            lQTree.print();
        }
        SplunkBuilder splunkBuilder = new SplunkBuilder(this.url, lQTree.getRoot());
        SplunkQuery splunkQuery = null;
        splunkQuery = splunkBuilder.toQuery();
        splunkStatement.setQuery(splunkQuery);
        if (UnityDriver.DEBUG) {
            System.out.println("Splunk query executed: " + splunkQuery.toString());
        }
        splunkQuery.setProperties(serverConnection.getProperties());
        this.op = splunkQuery.run();
        this.relation = splunkQuery.getRelation();
        this.numOutput = 0;
        TableData tableData = new TableData(serverConnection, n != 1003, this.statementId);
        tableData.setRelation(this.relation);
        return new SplunkResultSet(tableData, this.relation, n, splunkStatement);
    }

    public boolean next(Tuple tuple) throws SQLException {
        if (this.resultSetComplete) {
            return false;
        }
        try {
            if (this.op.next(tuple)) {
                ++this.numOutput;
                return true;
            }
            this.resultSetComplete = true;
            return false;
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    public GlobalQuery getGlobalQuery() {
        return this.gq;
    }
}

