/*
 * Decompiled with CFR 0.152.
 */
package unity.annotation;

import java.util.ArrayList;
import unity.annotation.CommonMethods;
import unity.annotation.SourceField;
import unity.annotation.SourceTable;

public class SourceKey {
    protected ArrayList<SourceField> key = new ArrayList();
    protected int keyType;
    protected String keyName;
    protected SourceTable table;

    public SourceKey(SourceTable sourceTable) {
        this.table = sourceTable;
    }

    public SourceKey(ArrayList<SourceField> arrayList, int n, String string) {
        this.key = arrayList;
        this.keyType = n;
        this.keyName = string;
    }

    public boolean containsField(SourceField sourceField) {
        return this.key.contains(sourceField);
    }

    public boolean matchKeyFields(ArrayList<SourceField> arrayList) {
        if (this.key.size() != arrayList.size()) {
            return false;
        }
        for (int i = 0; i < this.key.size(); ++i) {
            if (arrayList.indexOf(this.key.get(i)) != -1) continue;
            return false;
        }
        return true;
    }

    public boolean subsetOfKeyFields(ArrayList<SourceField> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            if (this.key.indexOf(arrayList.get(i)) != -1) continue;
            return false;
        }
        return true;
    }

    public SourceKey(SourceTable sourceTable, ArrayList<SourceField> arrayList, int n, String string) {
        this.table = sourceTable;
        this.key = arrayList;
        this.keyType = n;
        this.keyName = string;
    }

    public ArrayList<SourceField> getFields() {
        return this.key;
    }

    public String getName() {
        return this.keyName;
    }

    public void setName(String string) {
        this.keyName = string;
    }

    public int getKeyType() {
        return this.keyType;
    }

    public void setKeyType(int n) {
        this.keyType = n;
    }

    public SourceTable getTable() {
        return this.table;
    }

    public void setTable(SourceTable sourceTable) {
        this.table = sourceTable;
    }

    public void addField(SourceField sourceField) {
        this.key.add(sourceField);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(2000);
        if (this.keyType == 1) {
            stringBuilder.append("    Primary Key\n");
        } else if (this.keyType == 2) {
            stringBuilder.append(" Unused\n");
        } else if (this.keyType == 3) {
            stringBuilder.append("    Candidate Key\n");
        }
        stringBuilder.append(" Key Name: " + this.keyName + "\n");
        stringBuilder.append(" Key Type: " + this.keyType + "\n");
        if (this.key != null) {
            stringBuilder.append(" Fields in Key: ");
            for (int i = 0; i < this.key.size(); ++i) {
                SourceField sourceField = this.key.get(i);
                if (sourceField == null) continue;
                stringBuilder.append("  " + sourceField.getColumnName());
            }
        }
        return stringBuilder.toString();
    }

    public String keyTypeToXML() {
        String string = this.keyType == 1 ? "     <PRIMARYKEY>\n" : (this.keyType == 2 ? "     <FOREIGNKEY>\n" : "     <CANDIDATEKEY>\n");
        return string;
    }

    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder(2000);
        stringBuilder.append("        <keyName>" + CommonMethods.exportString(this.keyName) + "</keyName>\n");
        stringBuilder.append("        <keyType>" + this.keyType + "</keyType>\n");
        stringBuilder.append("        <FIELDS>\n");
        for (int i = 0; i < this.key.size(); ++i) {
            if (this.key.get(i) == null) continue;
            stringBuilder.append("        " + this.key.get(i).toXMLKey() + "\n");
        }
        stringBuilder.append("        </FIELDS>\n");
        if (this.keyType == 1) {
            stringBuilder.append("     </PRIMARYKEY>");
        } else if (this.keyType > 2) {
            stringBuilder.append("     </CANDIDATEKEY>");
        }
        return stringBuilder.toString();
    }

    public String getFieldList() {
        StringBuilder stringBuilder = new StringBuilder(50);
        for (int i = 0; i < this.key.size(); ++i) {
            if (i != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.key.get(i).getColumnName());
        }
        return stringBuilder.toString();
    }
}

