/*
 * Decompiled with CFR 0.152.
 */
package unity.engine;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import unity.functions.Expression;
import unity.functions.ExtractAttribute;
import unity.functions.F_Cast;
import unity.util.Convert;
import unity.util.StringFunc;

public class Attribute
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private int type;
    private int length;
    private Object reference;
    private int scale;
    public static final int TYPE_TINYINT = -6;
    public static final int TYPE_SMALLINT = 5;
    public static final int TYPE_INT = 4;
    public static final int TYPE_REAL = 7;
    public static final int TYPE_LONG = -5;
    public static final int TYPE_FLOAT = 6;
    public static final int TYPE_DECIMAL = 3;
    public static final int TYPE_NUMERIC = 2;
    public static final int TYPE_DOUBLE = 8;
    public static final int TYPE_CHAR = 1;
    public static final int TYPE_STRING = 12;
    public static final int TYPE_BLOB = 2004;
    public static final int TYPE_DATE = 91;
    public static final int TYPE_TIMESTAMP = 93;
    public static final int TYPE_TIME = 92;
    public static final int TYPE_NUMBER = 99999;
    public static final int TYPE_INTERVAL = 99998;
    public static final int TYPE_BOOLEAN = 16;
    public static final int TYPE_ARRAY = 2003;
    public static final int TYPE_NQSTRING = 1001;
    public static final int TYPE_BYTE = 1002;
    public static final int TYPE_COLLAPSE = -1;

    public Attribute() {
        this.name = "";
        this.type = 0;
    }

    public Attribute(Attribute attribute) {
        this.name = attribute.name;
        this.type = attribute.type;
        this.length = attribute.length;
        this.reference = attribute.reference;
    }

    public Attribute(String string, int n, int n2) {
        this.name = string;
        this.type = n;
        this.length = n2;
    }

    public Attribute(String string, int n, int n2, Object object) {
        this.name = string;
        this.type = n;
        this.length = n2;
        this.reference = object;
    }

    public static int convertAttribute(Attribute attribute, byte[] byArray, int n) {
        int n2 = n;
        int n3 = Convert.toInt(byArray, n2);
        attribute.setName(new String(byArray, n2 += 4, n3));
        attribute.setType(Convert.toInt(byArray, n2 += n3));
        attribute.setLength(Convert.toInt(byArray, n2 += 4));
        return n2 += 4;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getLength() {
        return this.length;
    }

    public int getDisplaySize() {
        if (this.type == 4) {
            return 11;
        }
        if (this.type == -5) {
            return 21;
        }
        if (this.type == 3) {
            return 17;
        }
        if (this.type == 8 || this.type == 6) {
            return 21;
        }
        if (this.type == 91 || this.type == 93) {
            return 20;
        }
        return this.length;
    }

    public void setLength(int n) {
        this.length = n;
    }

    public void setReference(Object object) {
        this.reference = object;
    }

    public Object getReference() {
        return this.reference;
    }

    public static Object convertToObject(byte[] byArray, int n, int n2) throws SQLException {
        if (n2 == 4) {
            return new Integer(Convert.toInt(byArray, n));
        }
        if (n2 == -5) {
            return new Long(Convert.toLong(byArray, n));
        }
        if (n2 == 5) {
            return new Short(Convert.toShort(byArray, n));
        }
        if (n2 == 3 || n2 == 2) {
            try {
                return Convert.toBigDecimal(byArray, byArray[n], n + 1);
            }
            catch (Exception exception) {
                return Convert.toStringWithLen(byArray, n);
            }
        }
        if (n2 == 91) {
            return new Date(Convert.toLong(byArray, n));
        }
        if (n2 == 92) {
            return new Time(Convert.toLong(byArray, n));
        }
        if (n2 == 93) {
            Timestamp timestamp = new Timestamp(Convert.toLong(byArray, n));
            timestamp.setNanos(Convert.toInt(byArray, n + 8));
            return timestamp;
        }
        if (n2 == 6 || n2 == 7) {
            return new Float(Convert.toFloat(byArray, n));
        }
        if (n2 == 8) {
            return new Double(Convert.toDouble(byArray, n));
        }
        if (n2 == 2003) {
            short s = Convert.toShort(byArray, n);
            int n3 = Convert.toInt(byArray, n + 2);
            ArrayList<String> arrayList = new ArrayList<String>(n3);
            AtomicInteger atomicInteger = new AtomicInteger(n + 6);
            for (int i = 0; i < n3; ++i) {
                arrayList.add(Convert.toStringWithLen(byArray, atomicInteger));
            }
            return arrayList;
        }
        return Convert.toStringWithLen(byArray, n);
    }

    public static byte[] convertToBytes(int n, Object object) throws SQLException {
        if (n == 4) {
            return Convert.toByte(((Number)object).intValue());
        }
        if (n == -5) {
            return Convert.toByte(((Number)object).longValue());
        }
        if (n == 5) {
            return Convert.toByte(((Number)object).shortValue());
        }
        if (n == 3 || n == 2) {
            return Convert.toByteWithLen(object.toString());
        }
        if (n == 12 || n == 1) {
            return Convert.toByteWithLen(object.toString());
        }
        if (n == 91 || n == 93) {
            if (n == 91) {
                if (object instanceof String) {
                    try {
                        object = StringFunc.convertStringToDate(object.toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (object instanceof java.util.Date) {
                    return Convert.toByte(((java.util.Date)object).getTime());
                }
                return Convert.toByteWithLen(object.toString());
            }
            byte[] byArray = new byte[12];
            Timestamp timestamp = (Timestamp)object;
            Convert.toByte(timestamp.getTime(), byArray, 0);
            Convert.toByte(timestamp.getNanos(), byArray, 8);
            return byArray;
        }
        if (n == 92) {
            return Convert.toByte(((Time)object).getTime());
        }
        if (n == 6 || n == 7) {
            return Convert.toByte(((Number)object).floatValue());
        }
        if (n == 8) {
            return Convert.toByte(((Number)object).doubleValue());
        }
        if (n == 2004) {
            if (object instanceof Blob) {
                Blob blob = (Blob)object;
                return blob.getBytes(1L, (int)blob.length());
            }
            return Convert.toByteWithLen(object.toString());
        }
        if (n == 2003) {
            int n2;
            Object object2;
            int n3 = 0;
            int n4 = 6;
            Object object3 = null;
            if (object instanceof List) {
                object2 = (List)object;
                n3 = object2.size();
                object3 = new byte[n3][];
                for (n2 = 0; n2 < n3; ++n2) {
                    object3[n2] = Convert.toByteWithLen(object2.get(n2).toString());
                    n4 += object3[n2].length;
                }
            }
            object2 = new byte[n4];
            n2 = 0;
            Convert.toByte((short)12, (byte[])object2, n2);
            Convert.toByte(n3, (byte[])object2, n2 += 2);
            n2 += 4;
            for (int i = 0; i < n3; ++i) {
                System.arraycopy(object3[i], 0, object2, n2, object3[i].length);
                n2 += object3[i].length;
            }
            return object2;
        }
        return Convert.toByteWithLen(object.toString());
    }

    public static int getByteSize(int n, Object object) {
        if (n == 4) {
            return 4;
        }
        if (n == 8) {
            return 8;
        }
        if (n == 5) {
            return 2;
        }
        if (n == 3) {
            return ((BigDecimal)object).toString().length() + 1;
        }
        if (n == 12) {
            if (object instanceof String) {
                return ((String)object).length() + 1;
            }
            if (object instanceof Integer) {
                return 4;
            }
            String string = object.toString();
            return string.length() + 1;
        }
        String string = object.toString();
        return string.length() + 1;
    }

    public String toString() {
        return this.name + ":" + this.type + "(" + this.length + ")" + this.reference;
    }

    public String getTypeName() {
        return Attribute.getTypeName(this.type);
    }

    public int getByteSize() {
        if (this.type == 4) {
            return 4;
        }
        if (this.type == 8 || this.type == 6) {
            return 8;
        }
        if (this.type == 91 || this.type == 93) {
            return 8;
        }
        return this.length;
    }

    public int getPrecision() {
        if (this.type == 4) {
            return 10;
        }
        if (this.type == -5) {
            return 20;
        }
        if (this.type == 8 || this.type == 6) {
            return 20;
        }
        if (this.type == 91 || this.type == 93) {
            return 20;
        }
        return this.length;
    }

    public static boolean isStringType(int n) {
        return n == 12 || n == 1;
    }

    public static boolean isStreamType(int n) {
        return n == -3 || n == 2004 || n == 2005 || n == 2011 || n == -16 || n == -4 || n == -1;
    }

    public static boolean isDoubleType(int n) {
        return n == 8 || n == 6;
    }

    public static boolean isNumberType(int n) {
        return n == 4 || n == -5 || n == 7 || n == 8 || n == 6 || n == 99999 || n == -6 || n == 5 || n == 3 || n == 2;
    }

    public static boolean isDateType(int n) {
        return n == 91 || n == 92 || n == 93;
    }

    public static String getTypeName(int n) {
        if (n == 4) {
            return "integer";
        }
        if (n == -5) {
            return "bigint";
        }
        if (n == 12) {
            return "varchar";
        }
        if (n == 6) {
            return "float";
        }
        if (n == 3) {
            return "decimal";
        }
        if (n == 5) {
            return "smallint";
        }
        if (n == 8) {
            return "double";
        }
        if (n == 1) {
            return "char";
        }
        if (n == 2004) {
            return "blob";
        }
        if (n == 91) {
            return "date";
        }
        if (n == 93) {
            return "timestamp";
        }
        if (n == 99998) {
            return "interval";
        }
        if (n == 16) {
            return "boolean";
        }
        if (n == -1) {
            return "hashmap/JSON";
        }
        if (n == 2003) {
            return "arrayList";
        }
        return "(unknown)";
    }

    public static String getTypeClass(int n) {
        if (n == 4) {
            return "java.lang.Integer";
        }
        if (n == -5) {
            return "java.lang.Long";
        }
        if (n == 12) {
            return "java.lang.String";
        }
        if (n == 6) {
            return "java.lang.Float";
        }
        if (n == 3 || n == 2) {
            return "java.math.BigDecimal";
        }
        if (n == 5) {
            return "java.lang.Short";
        }
        if (n == 8) {
            return "java.lang.Double";
        }
        if (n == 1) {
            return "java.lang.String";
        }
        if (n == 2004) {
            return "java.sql.Blob";
        }
        if (n == 91) {
            return "java.sql.Date";
        }
        if (n == 93) {
            return "java.sql.Timestamp";
        }
        if (n == 99998) {
            return "java.sql.Date";
        }
        if (n == 16) {
            return "java.sql.Byte";
        }
        if (n == -1) {
            return "java.util.HashMap";
        }
        if (n == 2003) {
            return "java.util.List";
        }
        return "java.lang.String";
    }

    public static int getTypeBySQLName(String string) {
        String string2 = string.toUpperCase();
        if (string2.indexOf("VARCHAR") >= 0) {
            return 12;
        }
        if (string2.indexOf("CHAR") >= 0) {
            return 12;
        }
        if (string2.indexOf("BIGINT") >= 0) {
            return -5;
        }
        if (string2.indexOf("INT") >= 0) {
            return 4;
        }
        if (string2.indexOf("FLOAT") >= 0 || string2.indexOf("REAL") >= 0) {
            return 6;
        }
        if (string2.indexOf("DOUBLE") >= 0) {
            return 8;
        }
        if (string2.indexOf("DATE") >= 0) {
            return 91;
        }
        if (string2.indexOf("TIMESTAMP") >= 0) {
            return 93;
        }
        if (string2.indexOf("TIME") >= 0) {
            return 92;
        }
        return -1;
    }

    public static int getTypeByXSDType(String string) {
        String string2 = string;
        if (string2.indexOf("string") >= 0) {
            return 12;
        }
        if (string2.indexOf("integer") >= 0 || string2.indexOf("int") >= 0) {
            return 4;
        }
        if (string2.indexOf("long") >= 0) {
            return -5;
        }
        if (string2.indexOf("short") >= 0) {
            return 5;
        }
        if (string2.indexOf("boolean") >= 0) {
            return 16;
        }
        if (string2.indexOf("byte") >= 0) {
            return 1;
        }
        if (string2.indexOf("decimal") >= 0) {
            return 3;
        }
        if (string2.indexOf("float") >= 0 || string2.indexOf("REAL") >= 0) {
            return 6;
        }
        if (string2.indexOf("double") >= 0) {
            return 8;
        }
        if (string2.indexOf("dateTime") >= 0) {
            return 93;
        }
        if (string2.indexOf("date") >= 0) {
            return 91;
        }
        if (string2.indexOf("time") >= 0) {
            return 92;
        }
        return 12;
    }

    public static Attribute unionCompatible(Attribute attribute, Attribute attribute2, boolean[] blArray, Expression[] expressionArray, int n) throws SQLException {
        int n2 = attribute2.getType();
        int n3 = attribute.getType();
        blArray[0] = false;
        blArray[1] = false;
        if (n3 == n2) {
            return attribute;
        }
        if (n3 == 12 || n2 == 12) {
            if (n3 == 12) {
                blArray[1] = true;
                expressionArray[1] = new F_Cast((Expression)new ExtractAttribute(n, n2), n2, 12);
                return attribute;
            }
            blArray[0] = true;
            expressionArray[0] = new F_Cast((Expression)new ExtractAttribute(n, n3), n3, 12);
            return attribute2;
        }
        if (attribute.getType() != attribute2.getType()) {
            throw new SQLException("Relations are not union-compatible because type of left attribute: " + attribute.getName() + " (type: " + attribute.getTypeName() + ") does not match right attribute: " + attribute2.getName() + " (type: " + attribute2.getTypeName() + ")");
        }
        return null;
    }

    public static Attribute generateRandom(Random random, String string) {
        int n = random.nextInt(12);
        int n2 = 4;
        switch (n) {
            case 0: {
                n2 = 5;
                break;
            }
            case 1: {
                n2 = 4;
                break;
            }
            case 2: {
                n2 = 7;
                break;
            }
            case 3: {
                n2 = -5;
                break;
            }
            case 4: {
                n2 = 6;
                break;
            }
            case 5: {
                n2 = 8;
                break;
            }
            case 6: {
                n2 = 1;
                break;
            }
            case 7: {
                n2 = 12;
                break;
            }
            case 8: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 92;
                break;
            }
            case 10: {
                n2 = 91;
                break;
            }
            case 11: {
                n2 = 93;
                break;
            }
            default: {
                n2 = 4;
            }
        }
        return new Attribute(string, n2, 0);
    }

    public static Object generateRandomValue(Random random, int n) {
        switch (n) {
            case 5: {
                return new Short((short)random.nextInt(Short.MAX_VALUE));
            }
            case 4: {
                return random.nextInt();
            }
            case 7: {
                return Float.valueOf(random.nextFloat() * (float)random.nextInt());
            }
            case -5: {
                return random.nextLong();
            }
            case 6: {
                return Float.valueOf(random.nextFloat() * (float)random.nextInt());
            }
            case 8: {
                return random.nextDouble() * (double)random.nextInt();
            }
            case 1: {
                return StringFunc.randomString(256);
            }
            case 12: {
                return StringFunc.randomString(300);
            }
            case 3: {
                return new BigDecimal("" + random.nextInt(99999) + '.' + random.nextInt(99));
            }
            case 92: {
                return new Time(new java.util.Date().getTime() + (long)random.nextInt(1000000));
            }
            case 91: {
                return new Date(new java.util.Date().getTime() + (long)random.nextInt(1000000));
            }
            case 93: {
                return new Timestamp(new java.util.Date().getTime() + (long)random.nextInt(1000000));
            }
        }
        return random.nextInt();
    }

    public static Object generateRandomValueOrNull(Random random, int n) {
        if ((double)random.nextFloat() < 0.15) {
            return null;
        }
        return Attribute.generateRandomValue(random, n);
    }

    public static int getType(Object object) {
        if (object instanceof Number) {
            if (object instanceof Integer) {
                return 4;
            }
            if (object instanceof Float) {
                return 6;
            }
            if (object instanceof Double) {
                return 8;
            }
            if (object instanceof Long) {
                return -5;
            }
            return 99999;
        }
        if (object instanceof ArrayList) {
            return 2003;
        }
        if (object instanceof HashMap) {
            return -1;
        }
        if (object instanceof java.util.Date) {
            return 91;
        }
        if (object instanceof Timestamp) {
            return 93;
        }
        if (object instanceof byte[]) {
            return 1002;
        }
        return 12;
    }

    public static byte[] convertToBytes(Attribute attribute) {
        byte[] byArray = Convert.toByte(attribute.getName());
        int n = byArray.length + 12;
        byte[] byArray2 = new byte[n];
        Convert.toByte(byArray.length, byArray2, 0);
        System.arraycopy(byArray, 0, byArray2, 4, byArray.length);
        Convert.toByte(attribute.getType(), byArray2, byArray.length + 4);
        Convert.toByte(attribute.getLength(), byArray2, byArray.length + 8);
        return byArray2;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int n) {
        this.scale = n;
    }
}

