/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import java.sql.SQLException;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.functions.Expression;
import unity.functions.Function;

public class F_Char
extends Function {
    private static final long serialVersionUID = 1L;
    private Expression expr;

    public F_Char(Expression expression) {
        this.expr = expression;
    }

    @Override
    public Object evaluate(Tuple tuple) throws SQLException {
        int n;
        Object object = this.expr.evaluate(tuple);
        if (object == null) {
            return null;
        }
        if (object instanceof Integer) {
            n = (Integer)object;
        } else if (object instanceof Number) {
            n = ((Number)object).intValue();
        } else {
            try {
                n = Integer.parseInt(object.toString());
            }
            catch (Exception exception) {
                return null;
            }
        }
        return Character.valueOf((char)n);
    }

    @Override
    public int getReturnType() {
        return 1;
    }

    public static int[] getParamListTypes() {
        return new int[]{4};
    }

    public static String getFunctionName() {
        return "CHAR";
    }

    @Override
    public String toString(Relation relation) {
        return "CHAR(" + this.expr.toString(relation) + ")";
    }
}

