/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import java.sql.SQLException;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.functions.Expression;
import unity.functions.Function;

public class F_Degrees
extends Function {
    private static final long serialVersionUID = 1L;
    private Expression expr;

    public F_Degrees(Expression expression) {
        this.expr = expression;
        this.returnType = this.expr.getReturnType();
    }

    @Override
    public Object evaluate(Tuple tuple) throws SQLException {
        Object object = this.expr.evaluate(tuple);
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return new Double(Math.toDegrees(((Number)object).doubleValue()));
        }
        return null;
    }

    @Override
    public int getReturnType() {
        return 8;
    }

    public static int[] getParamListTypes() {
        return new int[]{99999};
    }

    public static String getFunctionName() {
        return "DEGREES";
    }

    @Override
    public String toString(Relation relation) {
        return "DEGREES(" + this.expr.toString(relation) + ")";
    }
}

