/*
 * Decompiled with CFR 0.152.
 */
package unity.generic.query;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import unity.annotation.AnnotatedSourceField;
import unity.annotation.SourceField;
import unity.annotation.SourceTable;
import unity.engine.Attribute;
import unity.engine.Relation;
import unity.generic.query.WebQuery;
import unity.query.GQFieldRef;
import unity.query.GQTableRef;
import unity.query.LQCondNode;
import unity.query.LQDupElimNode;
import unity.query.LQExprNode;
import unity.query.LQGroupByNode;
import unity.query.LQLimitNode;
import unity.query.LQNode;
import unity.query.LQOrderByNode;
import unity.query.LQProjNode;
import unity.query.LQSelNode;
import unity.util.StringFunc;

public abstract class QueryBuilder {
    protected LQNode startNode;
    protected SourceTable table;
    protected LQProjNode firstProj = null;
    protected boolean fromSeen;
    protected String serverURL;

    public QueryBuilder(String string, LQNode lQNode) {
        this.startNode = lQNode;
        this.serverURL = string;
    }

    protected void processNode(WebQuery webQuery, LQNode lQNode) throws SQLException {
        if (lQNode != null) {
            if (lQNode.getType() == 1 && this.firstProj == null) {
                this.firstProj = (LQProjNode)lQNode;
            }
            if (lQNode.getNumChildren() > 1) {
                throw new SQLException("Too many children found at node " + lQNode.toString());
            }
            if (lQNode.getNumChildren() > 0) {
                this.processNode(webQuery, lQNode.getChild());
            }
            switch (lQNode.getType()) {
                case 1: {
                    this.buildProjection((LQProjNode)lQNode, webQuery);
                    break;
                }
                case 2: {
                    this.buildSelection((LQSelNode)lQNode, webQuery);
                    break;
                }
                case 6: 
                case 100: {
                    this.buildFrom(lQNode, webQuery);
                    break;
                }
                case 18: {
                    this.buildLimit((LQLimitNode)lQNode, webQuery);
                    break;
                }
                case 4: {
                    this.buildOrderBy((LQOrderByNode)lQNode, webQuery);
                    break;
                }
                case 5: {
                    this.buildGroupBy((LQGroupByNode)lQNode, webQuery);
                    break;
                }
                case 16: {
                    this.buildDistinct((LQDupElimNode)lQNode, webQuery);
                    break;
                }
                default: {
                    throw new SQLException("Unable to process query operation.  Operation not supported by driver: " + lQNode);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void buildProjection(LQProjNode lQProjNode, WebQuery webQuery) throws SQLException {
        Object object;
        if (lQProjNode != this.firstProj) {
            return;
        }
        webQuery.setProjection(lQProjNode);
        ArrayList<LQExprNode> arrayList = lQProjNode.getExpressions();
        HashMap<Object, void> hashMap = new HashMap<Object, void>();
        for (LQExprNode lQExprNode : arrayList) {
            void object22;
            if (lQExprNode.getType() == 103) {
                LQExprNode lQExprNode2 = (LQExprNode)lQExprNode.getChild(0);
            }
            if (object22.getType() == 126) {
                throw new SQLException("Expressions in projection are not supported.");
            }
            if (object22.getType() == 120) {
                LQExprNode lQExprNode3 = (LQExprNode)object22.getContent();
                throw new SQLException("Expressions in projection are not supported.");
            }
            String[] stringArray = StringFunc.divideId(object22.toString());
            object = stringArray[0];
            if (stringArray.length > 1) {
                object = stringArray[stringArray.length - 1];
            }
            if (((String)object).equals("*")) {
                lQProjNode.setSelectAll(true);
                break;
            }
            hashMap.put(object, object22);
        }
        Iterator<Object> iterator = this.table.fieldIterator();
        Attribute[] attributeArray = new Attribute[arrayList.size()];
        int n = 0;
        while (iterator.hasNext()) {
            object = (SourceField)iterator.next();
            String string = ((SourceField)object).getColumnName();
            LQExprNode lQExprNode = (LQExprNode)hashMap.get(string);
            if (lQExprNode == null) {
                lQExprNode = (LQExprNode)hashMap.get(StringFunc.delimitName(string, '\"'));
            }
            if (lQExprNode == null) continue;
            GQFieldRef gQFieldRef = (GQFieldRef)lQExprNode.getContent();
            attributeArray[n++] = new Attribute(string, ((SourceField)object).getDataType(), ((SourceField)object).getColumnDisplaySize(), gQFieldRef);
        }
        object = new Relation(attributeArray);
        webQuery.setTableRelation((Relation)object);
        ((Relation)object).setProperty("name", this.table.getTableName());
        webQuery.setRelation((Relation)object);
        lQProjNode.getChild(0).setOutputRelation((Relation)object);
    }

    protected void buildCondition(LQCondNode lQCondNode, WebQuery webQuery) throws SQLException {
        int n = lQCondNode.getType();
        switch (n) {
            case 118: {
                throw new SQLException("WHERE filters with XOR are not supported.");
            }
            case 112: {
                throw new SQLException("WHERE filters with NOT are not supported.");
            }
            case 110: {
                throw new SQLException("WHERE filters with OR are not supported.");
            }
            case 111: {
                LQCondNode lQCondNode2 = (LQCondNode)lQCondNode.getChild(0);
                LQCondNode lQCondNode3 = (LQCondNode)lQCondNode.getChild(1);
                this.buildCondition(lQCondNode2, webQuery);
                this.buildCondition(lQCondNode3, webQuery);
                break;
            }
            default: {
                this.buildExpression(lQCondNode, webQuery);
            }
        }
    }

    protected String getFieldName(Object object) {
        if (object != null && object instanceof GQFieldRef) {
            AnnotatedSourceField annotatedSourceField = ((GQFieldRef)object).getField();
            return annotatedSourceField.getColumnName();
        }
        return object.toString();
    }

    protected void buildExpression(LQCondNode lQCondNode, WebQuery webQuery) throws SQLException {
        throw new SQLException("Expression not supported: " + lQCondNode.toString());
    }

    protected void buildSelection(LQSelNode lQSelNode, WebQuery webQuery) throws SQLException {
        LQCondNode lQCondNode = lQSelNode.getCondition();
        this.buildCondition(lQCondNode, webQuery);
    }

    protected void buildGroupBy(LQGroupByNode lQGroupByNode, WebQuery webQuery) throws SQLException {
        throw new SQLException("GROUP BY is not supported.");
    }

    protected void buildOrderBy(LQOrderByNode lQOrderByNode, WebQuery webQuery) throws SQLException {
        throw new SQLException("ORDER BY is not supported.");
    }

    protected void buildFrom(LQNode lQNode, WebQuery webQuery) throws SQLException {
        if (this.fromSeen) {
            throw new SQLException("Two tables were received. The driver only supports single table queries.");
        }
        this.fromSeen = true;
        GQTableRef gQTableRef = (GQTableRef)lQNode.getContent();
        String string = gQTableRef.getTable().getTableName();
        this.table = gQTableRef.getTable();
    }

    protected void buildLimit(LQLimitNode lQLimitNode, WebQuery webQuery) throws SQLException {
        throw new SQLException("LIMIT/OFFSET is not supported.");
    }

    protected void buildDistinct(LQDupElimNode lQDupElimNode, WebQuery webQuery) throws SQLException {
        throw new SQLException("DISTINCT is not supported.");
    }
}

