/*
 * Decompiled with CFR 0.152.
 */
package unity.jdbc;

import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseManager;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import unity.annotation.GlobalSchema;
import unity.cache.Cache;
import unity.io.FileManager;
import unity.jdbc.UnityConnection;
import unity.mapping.DatabaseMapping;
import unity.util.CipherParamImpl;
import unity.util.LicenseParamImpl;
import unity.util.PublicKeyStoreParamImpl;
import unity.util.UsageTracker;

public class UnityDriver
implements Driver {
    public static PrintWriter out;
    public static final Locale locale;
    public static ResourceBundle i18n;
    public static final int _MAJORVERSION = 4;
    public static final int _MINORVERSION = 3;
    public static final int _BUILD = 113;
    public static final boolean NO_TRIAL_EXCEPTION = true;
    private static boolean TRIAL;
    private static boolean CLIENT_VERSION;
    private static final int CONNECTION_LIMIT = 3;
    private static final int MAX_RESULTS = 100;
    public static final String DRIVER_NAME = "UnityJDBC";
    public static boolean DEBUG;
    private static Cache cache;
    private static DatabaseMapping mapper;
    public static final String VIRTUAL_NAME = "virtual";
    public static final String SOURCES_PROPERTY = "sources";
    public static final String JDBC_URL = "jdbc:unity://";
    public static ClassLoader classLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnityDriver() throws SQLException {
        Object object;
        Object object2;
        PublicKeyStoreParamImpl publicKeyStoreParamImpl = new PublicKeyStoreParamImpl();
        CipherParamImpl cipherParamImpl = new CipherParamImpl();
        LicenseParamImpl licenseParamImpl = new LicenseParamImpl(publicKeyStoreParamImpl, cipherParamImpl);
        LicenseManager licenseManager = new LicenseManager(licenseParamImpl);
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("license.lic");
        LicenseContent licenseContent = null;
        String string = "testuser@unityjdbc.com";
        if (inputStream != null) {
            try {
                licenseManager.install(inputStream);
                licenseContent = licenseManager.verify();
                object2 = (Boolean[])licenseContent.getExtra();
                if (object2 != null) {
                    CLIENT_VERSION = object2[1];
                    TRIAL = object2[0];
                    object = licenseContent.getHolder().toString();
                    int n = ((String)object).indexOf("EMAILADDRESS=");
                    if (n > 0) {
                        string = ((String)object).substring(n + 13);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            FileManager.closeStream(inputStream);
        }
        if (mapper == null) {
            object2 = null;
            try {
                object = this.getClass().getClassLoader().getResourceAsStream("unity/mapping/.mapping");
                if (object == null) {
                    throw new SQLException(i18n.getString("UnityDriver.MapFileNotFound"));
                }
                classLoader = this.getClass().getClassLoader();
                object2 = new BufferedReader(new InputStreamReader(FileManager.getDecryptedStream((InputStream)object, "UnityDriver.class", "PBKDF2WithHmacSHA1", "AES", 65536, 128, "AES/CBC/PKCS5Padding"), Charset.forName("UTF-8")));
                mapper = new DatabaseMapping();
                DatabaseMapping.load((BufferedReader)object2);
            }
            catch (IOException iOException) {
                throw new SQLException(i18n.getString("UnityDriver.ErrorLoadMapFile"));
            }
            finally {
                try {
                    if (object2 != null) {
                        ((BufferedReader)object2).close();
                    }
                }
                catch (Exception exception) {}
            }
            object2 = null;
            try {
                object = this.getClass().getClassLoader().getResourceAsStream("mapping.xml");
                if (object != null) {
                    object2 = new BufferedReader(new InputStreamReader((InputStream)object, Charset.forName("UTF-8")));
                    DatabaseMapping.load((BufferedReader)object2);
                    if (DEBUG) {
                        System.out.println(i18n.getString("UnityDriver.ReadUserMapFile"));
                    }
                }
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            finally {
                try {
                    if (object2 != null) {
                        ((BufferedReader)object2).close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        object2 = new UsageTracker(string);
        ((Thread)object2).start();
    }

    @Override
    public boolean acceptsURL(String string) throws SQLException {
        if (string == null) {
            return false;
        }
        int n = string.toLowerCase().indexOf(JDBC_URL);
        return n >= 0 && n <= 0;
    }

    @Override
    public Connection connect(String string, Properties properties) throws SQLException {
        Object object;
        Object object2;
        String string2;
        String string3;
        String string4 = string;
        if (!this.acceptsURL(string4)) {
            return null;
        }
        boolean bl = false;
        int n = string4.indexOf("?");
        if (n > 0) {
            string3 = string4.substring(n + 1);
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "=&;");
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (string2.equalsIgnoreCase("debug")) {
                    if (!stringTokenizer.hasMoreTokens() || !(string2 = stringTokenizer.nextToken()).equalsIgnoreCase("true")) continue;
                    DEBUG = true;
                    continue;
                }
                if (string2.equalsIgnoreCase("cache")) {
                    if (!stringTokenizer.hasMoreTokens()) continue;
                    string2 = stringTokenizer.nextToken();
                    properties.setProperty("cache", string2);
                    continue;
                }
                if (string2.equalsIgnoreCase("new")) {
                    if (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                        properties.setProperty("new", string2);
                    } else {
                        properties.setProperty("new", "true");
                    }
                    bl = true;
                    continue;
                }
                if (string2.equalsIgnoreCase("sort_buffer_size")) {
                    if (!stringTokenizer.hasMoreTokens()) continue;
                    string2 = stringTokenizer.nextToken();
                    properties.setProperty("sort_buffer_size", string2);
                    continue;
                }
                if (string2.equalsIgnoreCase("join_buffer_size")) {
                    if (!stringTokenizer.hasMoreTokens()) continue;
                    string2 = stringTokenizer.nextToken();
                    properties.setProperty("join_buffer_size", string2);
                    continue;
                }
                if (string2.equalsIgnoreCase("log")) {
                    if (!stringTokenizer.hasMoreTokens()) continue;
                    string2 = stringTokenizer.nextToken();
                    properties.setProperty("log", string2);
                    continue;
                }
                object2 = string2;
                if (!stringTokenizer.hasMoreTokens()) continue;
                string2 = stringTokenizer.nextToken();
                properties.setProperty((String)object2, string2);
            }
            string4 = string4.substring(0, n);
        }
        if ((string3 = properties.getProperty("log")) != null && !string3.equals("")) {
            UnityDriver.initializeLog(string3);
        }
        int n2 = string4.toLowerCase().indexOf(JDBC_URL);
        string2 = string4.substring(n2 + 13);
        object2 = null;
        if (DEBUG) {
            System.out.println("UnityJDBC Version " + this.getMajorVersion() + "." + this.getMinorVersion() + "." + 113);
            System.out.println("Sources file: " + string2);
        }
        GlobalSchema globalSchema = new GlobalSchema();
        if (string2.equals(VIRTUAL_NAME)) {
            object = properties.getProperty(SOURCES_PROPERTY);
            globalSchema.parseSources((String)object, properties);
        } else {
            boolean bl2 = false;
            try {
                String string5 = properties.getProperty("password");
                if (string5 != null && !string5.equals("")) {
                    bl2 = true;
                    InputStream inputStream = FileManager.getDecryptedStream(string2, string5, properties);
                    object2 = new BufferedReader(new InputStreamReader(inputStream, Charset.forName("UTF-8")));
                } else {
                    object2 = new BufferedReader(new InputStreamReader(FileManager.getStream(string2), Charset.forName("UTF-8")));
                }
            }
            catch (IOException iOException) {
                if (bl) {
                    try {
                        globalSchema.exportSources(string2);
                        object2 = new BufferedReader(new InputStreamReader(FileManager.getStream(string2), Charset.forName("UTF-8")));
                    }
                    catch (IOException iOException2) {
                        throw new SQLException("Unable to create new connection information at: " + string2);
                    }
                }
                throw new SQLException("Unable to retrieve connection information at: " + string2 + " Encrypted: " + bl2 + " Error: " + iOException);
            }
            globalSchema.parseSourcesFile((BufferedReader)object2, string4, properties);
            try {
                if (object2 != null) {
                    ((BufferedReader)object2).close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        object = new UnityConnection(globalSchema, properties);
        ((UnityConnection)object).initCache(cache);
        return object;
    }

    @Override
    public int getMajorVersion() {
        return 4;
    }

    @Override
    public int getMinorVersion() {
        return 3;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        String[] stringArray = new String[]{"debug", "new", "user", "password", "encoding", "log", "join_buffer_size", "sort_buffer_size"};
        String[] stringArray2 = new String[]{"false", "false", "", "", "utf-8", "", "20000000", "20000000"};
        String[][] stringArrayArray = new String[][]{{"true", "false"}, {"true", "false"}, new String[0], new String[0], {"client", "server"}, {"utf-8"}, {"A positive integer >= 1000000"}, {"A positive integer >= 1000000"}};
        String[] stringArray3 = new String[]{"The debug property will cause the driver to print out debug information to the console during its operation.", "If true, create a new virtual source.", "User name for connection.", "Password for connection.", "For scrollable ResultSets, should the cursor be on the client or server.", "Character encoding used.", "Database name to use.", "Schema validation performed.  Strict validation ensures all identifiers are in schema.  Flex validation will perform best effort validation against a schema (if present) but attempt to execute query in all cases.  None will never generate or use any schema information.", "Location of schema.  Either a file URI or location in MongoDB.", "If true, rebuilds schema for connection.  If false, uses existing cached schema if available.  Uses location provided in schema property.", "Specifies a MongoDB ReadPreference such as primary, secondary, or nearest.", "Used to pass parameters to configure ReadPreference in the form of JSON strings which are converted to DBObjects.", "Write concern controls how writing and updated are handled.  Settings such as unacknowledged or acknowledged are possible.", "Used to configure a write concern based on a tag name.  Calls WriteConcern(String w) constructor with value as w parameter.", "Use SSL connections to Mongo instance.", "When building schemas fraction of collection to sample in the range of 0 to 1.  Default is 0.001.", "File location of log file to store debugging information if debug is true."};
        boolean[] blArray = new boolean[]{false, false, false, false, false, false, false, false};
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            driverPropertyInfoArray[i] = new DriverPropertyInfo(stringArray[i], stringArray2[i]);
            if (properties != null && properties.containsKey(stringArray[i])) {
                driverPropertyInfoArray[i].value = properties.getProperty(stringArray[i]);
            }
            driverPropertyInfoArray[i].description = stringArray3[i];
            driverPropertyInfoArray[i].choices = stringArrayArray[i];
            driverPropertyInfoArray[i].required = blArray[i];
        }
        return driverPropertyInfoArray;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException(i18n.getString("UnityDriver.NoLogging"));
    }

    public static int getConnectionLimit() {
        return 3;
    }

    public static boolean isClientVersion() {
        return CLIENT_VERSION;
    }

    public static int getMaxResults() {
        return 100;
    }

    public static void createCache() {
        if (cache == null) {
            cache = new Cache(1000, 5000);
            if (DEBUG) {
                System.out.println("Created query cache.");
            }
        }
    }

    public static void clearCache() {
        if (cache != null) {
            cache.clear();
        }
    }

    public static void setExpiryTime(int n) {
        cache.setExpiryTime(n);
    }

    public static String getVersion() {
        String string = DRIVER_NAME;
        string = TRIAL ? string + " Trial " : string + " Full ";
        string = CLIENT_VERSION ? string + "Client " : string + "Server ";
        string = string + "4.3.113";
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLicense() {
        String string = "No license";
        PublicKeyStoreParamImpl publicKeyStoreParamImpl = new PublicKeyStoreParamImpl();
        CipherParamImpl cipherParamImpl = new CipherParamImpl();
        LicenseParamImpl licenseParamImpl = new LicenseParamImpl(publicKeyStoreParamImpl, cipherParamImpl);
        LicenseManager licenseManager = new LicenseManager(licenseParamImpl);
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("license.lic");
        LicenseContent licenseContent = null;
        String string2 = "testuser@unityjdbc.com";
        String string3 = "Trial User";
        String string4 = DRIVER_NAME;
        if (inputStream != null) {
            try {
                licenseManager.install(inputStream);
                licenseContent = licenseManager.verify();
                Boolean[] booleanArray = (Boolean[])licenseContent.getExtra();
                if (booleanArray != null) {
                    CLIENT_VERSION = booleanArray[1];
                    TRIAL = booleanArray[0];
                    String string5 = licenseContent.getHolder().toString();
                    StringTokenizer stringTokenizer = new StringTokenizer(string5, ",=");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string6 = stringTokenizer.nextToken().trim();
                        if (string6.equals("EMAILADDRESS")) {
                            string2 = stringTokenizer.nextToken();
                            continue;
                        }
                        if (string6.equals("CN")) {
                            string3 = stringTokenizer.nextToken();
                            continue;
                        }
                        if (!string6.equals("O")) continue;
                        string4 = stringTokenizer.nextToken();
                    }
                    string = "Licensed to: \n" + string3 + "\n" + string4 + "\n" + string2;
                }
            }
            catch (Exception exception) {
            }
            finally {
                FileManager.closeStream(inputStream);
            }
        }
        return string;
    }

    public static ResultSet translate(String string) {
        return null;
    }

    public static String getURLFilePath(String string) {
        int n = string.lastIndexOf(63);
        if (n >= 0) {
            return string.substring(string.toLowerCase().indexOf(JDBC_URL) + 13, n);
        }
        return string.substring(string.toLowerCase().indexOf(JDBC_URL) + 13);
    }

    public static boolean isTrial() {
        return TRIAL;
    }

    public static void initializeLog(String string) {
        try {
            if (out == null) {
                out = new PrintWriter(new FileWriter(string, true));
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    public static void debug(String string) {
        if (DEBUG) {
            try {
                System.out.println(string);
                if (out != null) {
                    out.println(string);
                    out.flush();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        locale = Locale.getDefault();
        i18n = ResourceBundle.getBundle("resources/unity", locale);
        TRIAL = true;
        CLIENT_VERSION = false;
        DEBUG = false;
        cache = null;
        mapper = null;
        try {
            DriverManager.registerDriver(new UnityDriver());
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("Failed to register UnityJDBC Driver: " + sQLException);
        }
    }
}

