/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.sql.SQLException;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.operators.Operator;
import unity.predicates.SortComparator;

public class SetIntersect
extends Operator {
    private static final long serialVersionUID = 1L;
    protected SortComparator sorter;
    private Tuple tupleLeft;
    private Tuple tupleRight;
    private boolean validLeft = false;
    private boolean validRight = false;

    public SetIntersect(Operator[] operatorArray, SortComparator sortComparator, Relation relation) {
        super(operatorArray, 0L);
        this.sorter = sortComparator;
        this.setOutputRelation(relation);
    }

    @Override
    public void init() throws SQLException {
        this.input[0].init();
        this.input[1].init();
        this.tupleLeft = new Tuple(this.input[0].getOutputRelation());
        this.tupleRight = new Tuple(this.input[1].getOutputRelation());
        this.validLeft = this.input[0].next(this.tupleLeft);
        this.validRight = this.input[1].next(this.tupleRight);
    }

    @Override
    public boolean next(Tuple tuple) throws SQLException {
        int n;
        do {
            if (!this.validLeft || !this.validRight) {
                return false;
            }
            n = this.sorter.sqlcompare(this.tupleLeft, this.tupleRight);
            if (n == 0) {
                tuple.copy(this.tupleLeft);
                while (this.validLeft && this.sorter.sqlcompare(tuple, this.tupleLeft) == 0) {
                    this.validLeft = this.input[0].next(this.tupleLeft);
                }
                while (this.validRight && this.sorter.sqlcompare(tuple, this.tupleRight) == 0) {
                    this.validRight = this.input[1].next(this.tupleRight);
                }
            } else if (n > 0) {
                while (this.validRight && this.sorter.sqlcompare(this.tupleLeft, this.tupleRight) > 0) {
                    this.validRight = this.input[1].next(this.tupleRight);
                }
            } else {
                while (this.validLeft && this.sorter.sqlcompare(this.tupleRight, this.tupleLeft) > 0) {
                    this.validLeft = this.input[0].next(this.tupleLeft);
                }
            }
        } while (n != 0);
        this.incrementRowsOut();
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(30);
        stringBuilder.append(this.getName());
        return stringBuilder.toString();
    }

    @Override
    public String getName() {
        return "SET INTERSECT (sort-based)";
    }

    @Override
    public String getDescription() {
        return "";
    }
}

