/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.sql.SQLException;
import unity.engine.Tuple;
import unity.operators.Operator;
import unity.predicates.SortComparator;

public class SortEliminator
extends Operator {
    private static final long serialVersionUID = 1L;
    private Tuple lastTupleRead;
    protected SortComparator sorter;

    public SortEliminator(Operator operator, SortComparator sortComparator) {
        super(new Operator[]{operator}, 0L);
        this.sorter = sortComparator;
        this.setOutputRelation(operator.getOutputRelation());
    }

    @Override
    public void init() throws SQLException {
        this.input[0].init();
        this.lastTupleRead = new Tuple();
    }

    @Override
    public boolean next(Tuple tuple) throws SQLException {
        int n;
        boolean bl = this.input[0].next(tuple);
        while (bl && (n = this.sorter.sqlcompare(tuple, this.lastTupleRead)) <= 0) {
            bl = this.input[0].next(tuple);
        }
        this.lastTupleRead.copy(tuple);
        this.incrementRowsOut();
        return bl;
    }

    public String toString() {
        return "Duplicate Elimination";
    }

    @Override
    public String getName() {
        return "DUPLICATE ELIMINATION";
    }

    @Override
    public String getDescription() {
        return "";
    }
}

